/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPivotedQueryExpressionImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlScopeProcessorBase
implements SqlScopeProcessor {
    private final SqlLanguageDialectEx myDialect;
    private final List<DbDataSource> myDataSources;
    private final String myReferenceName;
    private final PsiElement myPlace;
    private Set<ObjectKind> myExpectedTypes;
    private Set<ObjectKind> myIgnoredTypes;
    private Set<ObjectKind> myEffectiveTypes;
    private Set<ObjectKind> myExpectedParentTypes;
    private boolean myStrict;
    private final Condition<DasObject> myObjectFilter;

    public SqlScopeProcessorBase(@Nullable String referenceName, @NotNull SqlLanguageDialectEx dialect, @NotNull List<DbDataSource> dataSources2, @Nullable PsiElement place) {
        if (dialect == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(0);
        }
        if (dataSources2 == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(1);
        }
        this.myExpectedTypes = Collections.singleton(SqlDbElementType.ANY);
        this.myIgnoredTypes = Collections.emptySet();
        this.myEffectiveTypes = null;
        this.myExpectedParentTypes = null;
        this.myStrict = false;
        this.myDialect = dialect;
        this.myDataSources = dataSources2;
        this.myReferenceName = referenceName;
        this.myPlace = place;
        this.myObjectFilter = dataSources2.isEmpty() ? Conditions.alwaysTrue() : (Condition)JBIterable.from(dataSources2).reduce((Object)Conditions.alwaysFalse(), (cond, ds) -> Conditions.or((Condition)cond, (Condition)((Condition)ObjectUtils.notNull(DatabaseStructure.buildFilter((DasDataSource)ds), (Object)Conditions.alwaysTrue()))));
    }

    public SqlLanguageDialectEx getDialect() {
        return this.myDialect;
    }

    public List<DbDataSource> getDataSources() {
        return this.myDataSources;
    }

    public String getReferenceName() {
        return this.myReferenceName;
    }

    public PsiElement getPlace() {
        return this.myPlace;
    }

    public boolean execute(@NotNull DasSymbol symbol, @NotNull ResolveState state) {
        if (symbol == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(2);
        }
        if (state == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(3);
        }
        if (!this.myObjectFilter.value((Object)symbol.getDasObject())) {
            return true;
        }
        return this.executeTarget(symbol, null, null, state);
    }

    protected boolean checkType(@NotNull DasSymbol symbol, @Nullable SqlType forcedSqlType) {
        if (symbol == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(4);
        }
        return this.checkType(symbol, forcedSqlType, this.getExpectedTypes(), this.myIgnoredTypes, false);
    }

    protected boolean checkType(@NotNull DasSymbol symbol, @Nullable SqlType forcedSqlType, @NotNull Set<ObjectKind> forcedExpectedTypes, @NotNull Set<ObjectKind> forcedIgnoredTypes, boolean acceptUnresolvedSynonyms) {
        if (symbol == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(5);
        }
        if (forcedExpectedTypes == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(6);
        }
        if (forcedIgnoredTypes == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(7);
        }
        if (forcedSqlType instanceof SqlTableType) {
            return true;
        }
        if (SqlType.Category.REFERENCE.is(forcedSqlType)) {
            return true;
        }
        if (forcedSqlType != null) {
            return forcedExpectedTypes.contains(SqlDbElementType.COLUMN) || forcedExpectedTypes.contains(SqlDbElementType.VARIABLE) || forcedExpectedTypes.contains(SqlDbElementType.ANY);
        }
        return this.acceptsElement(symbol, this.myDialect, forcedExpectedTypes, forcedIgnoredTypes, this.myStrict, acceptUnresolvedSynonyms, this.myPlace);
    }

    public void setExpectedKinds(@NotNull Set<ObjectKind> kinds) {
        if (kinds == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(8);
        }
        this.myExpectedTypes = kinds;
        this.myExpectedParentTypes = null;
        this.myEffectiveTypes = null;
    }

    public void addIgnoredKinds(@NotNull Set<ObjectKind> kinds) {
        if (kinds == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(9);
        }
        if (!(this.myIgnoredTypes instanceof ObjectLinkedOpenHashSet)) {
            this.myIgnoredTypes = new ObjectLinkedOpenHashSet(this.myIgnoredTypes);
        }
        this.myIgnoredTypes.addAll(kinds);
        this.myExpectedParentTypes = null;
        this.myEffectiveTypes = null;
    }

    public void setStrict(boolean isStrict) {
        this.myStrict = isStrict;
    }

    public boolean isExpected(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(10);
        }
        if (this.myIgnoredTypes.contains(kind)) {
            return false;
        }
        Set<ObjectKind> expected = this.getExpectedTypes();
        return expected.contains(kind) || expected.contains(SqlDbElementType.ANY);
    }

    @NotNull
    public Set<ObjectKind> getInitialExpectedTypes() {
        Set<ObjectKind> set = this.myExpectedTypes;
        if (set == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    protected Set<ObjectKind> getIgnoredTypes() {
        Set<ObjectKind> set = this.myIgnoredTypes;
        if (set == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public Set<ObjectKind> getExpectedTypes() {
        if (this.myEffectiveTypes == null) {
            if (this.myIgnoredTypes.isEmpty()) {
                this.myEffectiveTypes = this.myExpectedTypes;
            } else {
                this.myEffectiveTypes = new LinkedHashSet<ObjectKind>(this.myExpectedTypes);
                this.myEffectiveTypes.removeAll(this.myIgnoredTypes);
            }
        }
        Set<ObjectKind> set = this.myExpectedTypes;
        if (set == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public Set<ObjectKind> getExpectedParentTypes() {
        if (this.myExpectedParentTypes == null) {
            this.myExpectedParentTypes = new HashSet<ObjectKind>();
            for (ObjectKind kind : this.getExpectedTypes()) {
                SqlImplUtil.getParentTypes(this.myDialect, kind, 1, 1, Collections.emptySet(), this.myExpectedParentTypes);
            }
            for (ObjectKind kind : ObjectKind.ourKinds.values()) {
                if (!this.mayAccept(kind)) continue;
                SqlImplUtil.getParentTypes(this.myDialect, kind, 1, 1, Collections.emptySet(), this.myExpectedParentTypes);
            }
        }
        Set<ObjectKind> set = this.myExpectedParentTypes;
        if (set == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(14);
        }
        return set;
    }

    public static boolean acceptsElement(@NotNull DasSymbol symbol, @NotNull SqlLanguageDialect dialect, @NotNull ObjectKind expectedType, boolean strict, boolean acceptUnresolvedSynonyms, @Nullable PsiElement place) {
        if (symbol == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(15);
        }
        if (dialect == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(16);
        }
        if (expectedType == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(17);
        }
        return SqlScopeProcessorBase.acceptsElement(symbol, symbol.getKind(), dialect, Collections.singleton(expectedType), strict, acceptUnresolvedSynonyms, place, false);
    }

    private boolean acceptsElement(@NotNull DasSymbol symbol, @NotNull SqlLanguageDialect dialect, @NotNull Set<ObjectKind> expectedTypes, @NotNull Set<ObjectKind> ignoredTypes, boolean strict, boolean acceptUnresolvedSynonyms, @Nullable PsiElement place) {
        ObjectKind t;
        if (symbol == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(18);
        }
        if (dialect == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(19);
        }
        if (expectedTypes == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(20);
        }
        if (ignoredTypes == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(21);
        }
        if (ignoredTypes.contains(t = symbol.getKind())) {
            return false;
        }
        return SqlScopeProcessorBase.acceptsElement(symbol, t, dialect, expectedTypes, strict, acceptUnresolvedSynonyms, place, this.myReferenceName == null);
    }

    public boolean mayAccept(@NotNull ObjectKind t) {
        if (t == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(22);
        }
        return SqlScopeProcessorBase.acceptsElement(null, t, this.myDialect, this.getExpectedTypes(), this.myStrict, true, this.myPlace, this.myReferenceName == null);
    }

    public boolean mayAcceptParent(@NotNull ObjectKind t) {
        if (t == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(23);
        }
        return SqlScopeProcessorBase.acceptsElement(null, t, this.myDialect, this.getExpectedParentTypes(), false, true, null, this.myReferenceName == null);
    }

    public static boolean acceptsElement(@Nullable DasSymbol symbol, @NotNull ObjectKind t, @NotNull SqlLanguageDialect dialect, @NotNull Set<ObjectKind> expectedTypes, boolean strict, boolean acceptUnresolvedSynonyms, @Nullable PsiElement place, boolean isCompletion) {
        if (t == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(24);
        }
        if (dialect == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(25);
        }
        if (expectedTypes == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(26);
        }
        if (dialect.isResolveTargetNotAccepted(symbol, t, expectedTypes, place, false, isCompletion)) {
            return false;
        }
        if (expectedTypes.contains(SqlDbElementType.ANY)) {
            return true;
        }
        if (t == SqlDbElementType.SYNONYM && !expectedTypes.contains(t)) {
            if (symbol == null) {
                return true;
            }
            t = SqlImplUtil.getKindSynonymAware(symbol.getDasObject());
            if (t == SqlDbElementType.ANY && acceptUnresolvedSynonyms) {
                return true;
            }
        }
        if (expectedTypes.contains(t)) {
            return true;
        }
        if (t == SqlDbElementType.LOCAL_ALIAS) {
            if (expectedTypes.contains(SqlDbElementType.TABLE) || expectedTypes.contains(SqlDbElementType.VARIABLE)) {
                return true;
            }
            if (expectedTypes.contains(SqlDbElementType.COLUMN)) {
                PsiElement grandParent;
                if (symbol == null) {
                    return true;
                }
                PsiElement parent2 = symbol instanceof PsiElement ? ((PsiElement)symbol).getParent() : null;
                PsiElement psiElement = grandParent = parent2 == null ? null : parent2.getParent();
                if (parent2 instanceof SqlClause && grandParent instanceof SqlPivotedQueryExpressionImpl) {
                    return true;
                }
                if (parent2 instanceof SqlSelectClause || parent2 instanceof SqlReturningClause || symbol instanceof SqlFileImpl.FakeDefinition) {
                    return true;
                }
            }
        }
        if (strict) {
            return dialect.isResolveTargetAccepted(symbol, t, expectedTypes, place, true, isCompletion);
        }
        if ((t == SqlDbElementType.KEY || t == SqlDbElementType.FOREIGN_KEY || t == SqlDbElementType.CHECK) && expectedTypes.contains(SqlDbElementType.CONSTRAINT)) {
            return true;
        }
        if (t == SqlDbElementType.KEY && expectedTypes.contains(SqlDbElementType.INDEX)) {
            IStubElementType elementType;
            if (symbol == null) {
                return true;
            }
            if (symbol instanceof StubBasedPsiElement ? (elementType = ((StubBasedPsiElement)symbol).getElementType()) == SqlCompositeElementTypes.SQL_UNIQUE_CONSTRAINT_DEFINITION || elementType == SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION : symbol instanceof DbTableKey && ((DbTableKey)symbol).isPrimary()) {
                return true;
            }
        }
        if ((t == SqlDbElementType.VARIABLE || t == SqlDbElementType.ARGUMENT || t == SqlDbElementType.OBJECT_ATTRIBUTE) && expectedTypes.contains(SqlDbElementType.COLUMN)) {
            return true;
        }
        if (t == SqlDbElementType.VARIABLE && expectedTypes.contains(SqlDbElementType.ARGUMENT)) {
            return true;
        }
        if (t == SqlDbElementType.ARGUMENT && (expectedTypes.contains(SqlDbElementType.VARIABLE) || expectedTypes.contains(SqlDbElementType.TABLE) || expectedTypes.contains(SqlDbElementType.CURSOR))) {
            return true;
        }
        if (t == SqlDbElementType.VARIABLE && (expectedTypes.contains(SqlDbElementType.COLUMN) || expectedTypes.contains(SqlDbElementType.TABLE) || expectedTypes.contains(SqlDbElementType.CURSOR))) {
            return true;
        }
        if (t == SqlDbElementType.SEQUENCE && expectedTypes.contains(SqlDbElementType.TABLE)) {
            return true;
        }
        if (ModelConsts.TABLE_OR_VIEW_KINDS.contains(t) && expectedTypes.contains(SqlDbElementType.TABLE)) {
            return true;
        }
        if (t == SqlDbElementType.PACKAGE && expectedTypes.contains(SqlDbElementType.SCHEMA)) {
            return true;
        }
        if (t == SqlDbElementType.USER && expectedTypes.contains(SqlDbElementType.ROLE)) {
            return true;
        }
        if (t == SqlDbElementType.AGGREGATE && expectedTypes.contains(SqlDbElementType.ROUTINE)) {
            return true;
        }
        if (dialect.isResolveTargetAccepted(symbol, t, expectedTypes, place, false, isCompletion)) {
            return true;
        }
        return t == SqlDbElementType.CURSOR && expectedTypes.contains(SqlDbElementType.VARIABLE);
    }

    @NotNull
    private static ObjectKind getElementType(@Nullable SqlReferenceExpression o) {
        ObjectKind objectKind = o == null ? SqlDbElementType.ANY : o.getReferenceElementType().getTargetKind();
        if (objectKind == null) {
            SqlScopeProcessorBase.$$$reportNull$$$0(27);
        }
        return objectKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedExpectedTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedIgnoredTypes";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlScopeProcessorBase";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredTypes";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlScopeProcessorBase";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialExpectedTypes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredTypes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedParentTypes";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setExpectedKinds";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredKinds";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isExpected";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 27: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "acceptsElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mayAccept";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "mayAcceptParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

