/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlQueryClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveCache;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveCacheImpl
implements SqlResolveCache {
    private final Map<String, Pair<PsiElement, ResolveResult[]>> myMap = new ConcurrentHashMap<String, Pair<PsiElement, ResolveResult[]>>();

    @Override
    @Nullable
    public ResolveResult[] getResult(@NotNull PsiReference ref) {
        String text2;
        Pair<PsiElement, ResolveResult[]> pair;
        if (ref == null) {
            SqlResolveCacheImpl.$$$reportNull$$$0(0);
        }
        if ((pair = this.myMap.get(text2 = ref.getElement().getText())) != null) {
            PsiElement element2 = SqlResolveCacheImpl.calculateContext(ref);
            if (element2 == null) {
                return null;
            }
            if (element2.isEquivalentTo((PsiElement)pair.first)) {
                return (ResolveResult[])pair.second;
            }
        }
        return null;
    }

    @Override
    public void cacheResult(@NotNull PsiReference ref, @NotNull ResolveResult[] computed) {
        if (ref == null) {
            SqlResolveCacheImpl.$$$reportNull$$$0(1);
        }
        if (computed == null) {
            SqlResolveCacheImpl.$$$reportNull$$$0(2);
        }
        for (ResolveResult result : computed) {
            if (!(result.getElement() instanceof SqlReferenceExpression)) continue;
            return;
        }
        PsiElement element2 = SqlResolveCacheImpl.calculateContext(ref);
        if (element2 != null) {
            String text2 = ref.getElement().getText();
            this.myMap.put(text2, (Pair<PsiElement, ResolveResult[]>)Pair.create((Object)element2, (Object)computed));
        }
    }

    @Nullable
    private static PsiElement calculateContext(PsiReference psiRef) {
        SqlReferenceImpl ref = (SqlReferenceImpl)ObjectUtils.tryCast((Object)psiRef, SqlReferenceImpl.class);
        if (ref == null) {
            return null;
        }
        PsiElement e = ref.getElement();
        PsiElement parent2 = e.getParent();
        if (parent2 instanceof SqlNamedParameterValueExpression && ((SqlNamedParameterValueExpression)parent2).getLOperand() == e) {
            return null;
        }
        SqlQueryClause queryClause = (SqlQueryClause)PsiTreeUtil.getParentOfType((PsiElement)e, SqlQueryClause.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class, SqlJoinExpression.class});
        if (queryClause != null && SqlImplUtil.getSqlDialectSafe((PsiElement)queryClause).getDbms() != Dbms.CLICKHOUSE) {
            return queryClause;
        }
        if (ref.getReferenceElementType().getTargetKind() == ObjectKind.TABLE) {
            SqlDmlInstruction dml = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)e, SqlDmlInstruction.class);
            SqlExpression tgt = dml == null ? null : dml.getTargetExpression();
            SqlFromClause from = (SqlFromClause)PsiTreeUtil.getChildOfType((PsiElement)dml, SqlFromClause.class);
            if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)ObjectUtils.chooseNotNull((Object)from, (Object)tgt)), (PsiElement)e, (boolean)false)) {
                NavigatablePsiElement context = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)dml, (Class[])new Class[]{SqlBlockStatementImpl.class, SqlFile.class});
                if (context instanceof SqlFile) {
                    SqlImportState info = SqlDialectImplUtil.getNearestImportState(e, SqlDialectImplUtil.buildImports((SqlFile)context));
                    return info.element != null ? info.element : context;
                }
                return context;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computed";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/psi/impl/SqlResolveCacheImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cacheResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

