/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.symbols.DasSymbol;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlClauseImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.symbols.DasSymbolUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlOnTargetClauseImpl
extends SqlClauseImpl
implements SqlExtraDeclarationsProvider {
    public SqlOnTargetClauseImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlOnTargetClauseImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    public SqlExpression getTargetExpression() {
        SqlTableColumnsList tableColumnsList = this.findChildByClass(SqlTableColumnsList.class);
        return tableColumnsList != null ? tableColumnsList.getTableExpression() : this.findChildByClass(SqlExpression.class);
    }

    public SqlTableType getTargetType() {
        SqlExpression targetExpression = this.getTargetExpression();
        if (targetExpression == null) {
            return SqlTableTypeBase.EMPTY_TABLE;
        }
        List<SqlReferenceExpression> referenceList = SqlImplUtil.getReferenceList(this.findChildByClass(SqlTableColumnsList.class));
        SqlTableType baseType = SqlTableTypeBase.ensureTableType(targetExpression.getSqlType(), (PsiElement)targetExpression, (PsiElement)this);
        if (referenceList.isEmpty()) {
            return baseType;
        }
        return baseType.alias(null, (PsiElement)this, referenceList);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlClause((SqlClause)this);
    }

    public boolean processExtraDeclarations(SqlScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlExpression targetRoot;
        SqlExpression targetExpression = this.getTargetExpression();
        Object object = targetRoot = targetExpression != null && targetExpression.getParent() instanceof SqlTableColumnsList ? (SqlTableColumnsList)targetExpression.getParent() : targetExpression;
        if (lastParent != targetRoot && targetExpression != null) {
            if (targetExpression instanceof SqlReferenceExpression) {
                if (!SqlImplUtil.processQualifier((SqlReferenceExpression)targetExpression, processor, state, place)) {
                    return false;
                }
            } else {
                DasSymbol targetSymbol = DasSymbolUtil.getSymbolByPsi((PsiElement)targetExpression);
                if (targetSymbol != null && !processor.execute(targetSymbol, state)) {
                    return false;
                }
                if (!SqlImplUtil.processDeclarationsInType(targetExpression, processor, state, place)) {
                    return false;
                }
            }
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/psi/impl/SqlOnTargetClauseImpl", "<init>"));
    }
}

