/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlArrayType;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlNAryExpressionImpl
extends SqlExpressionImpl
implements SqlNAryExpression {
    public SqlNAryExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlNAryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @NotNull
    public List<SqlExpression> getOperands() {
        List list = SqlImplUtil.childrenIt((PsiElement)this).filter(SqlExpression.class).toList();
        if (list == null) {
            SqlNAryExpressionImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public PsiElement getOpSignElement(int i2) {
        SqlExpression op = null;
        if (i2 != 0) {
            List<SqlExpression> operands = this.getOperands();
            if (i2 < operands.size()) {
                op = operands.get(i2);
            }
        } else {
            op = this.getLOperand();
        }
        return SqlNAryExpressionImpl.getOpAfter((PsiElement)op);
    }

    @NotNull
    public SqlExpression getLOperand() {
        SqlExpression sqlExpression = this.findNotNullChildByClass(SqlExpression.class);
        if (sqlExpression == null) {
            SqlNAryExpressionImpl.$$$reportNull$$$0(2);
        }
        return sqlExpression;
    }

    @NotNull
    public IElementType getOpSign() {
        SyntaxTraverser.ApiEx api;
        PsiElement sub;
        PsiElement signElement = this.getOpSignElement();
        IElementType sign = PsiUtilCore.getElementType((PsiElement)signElement);
        if (sign == SqlCompositeElementTypes.SQL_GENERIC_ELEMENT && (sub = (PsiElement)(api = SyntaxTraverser.psiApi()).children((Object)signElement).filter(e -> {
            IElementType type = api.typeOf(e);
            return type != SqlCommonKeywords.SQL_NOT && !SqlTokens.WS_OR_COMMENTS.contains(type);
        }).first()) != null) {
            sign = api.typeOf((Object)sub);
        }
        if (sign == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE) {
            PsiElement nameToken;
            SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getOpSignElement(), SqlReferenceExpression.class);
            SqlIdentifier identifier = ref == null ? null : ref.getIdentifier();
            PsiElement psiElement = nameToken = identifier == null ? null : PsiTreeUtil.getDeepestFirst((PsiElement)identifier);
            if (nameToken != null) {
                sign = PsiUtilCore.getElementType((PsiElement)nameToken);
            }
        }
        IElementType iElementType = sign;
        if (iElementType == null) {
            SqlNAryExpressionImpl.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @NotNull
    public PsiElement getOpSignElement() {
        PsiElement node = SqlNAryExpressionImpl.getOpAfter((PsiElement)this.getLOperand());
        if (node != null) {
            PsiElement psiElement = node;
            if (psiElement == null) {
                SqlNAryExpressionImpl.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        PsiElement parent2 = PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{SqlStatement.class, PsiFile.class});
        throw new AssertionError((Object)(SqlImplUtil.getSqlDialectSafe((PsiElement)this) + ": parent='" + (parent2 == null ? this : this.getParent()).getText() + "'"));
    }

    @Nullable
    private static PsiElement getOpAfter(@Nullable PsiElement el) {
        if (el == null) {
            return null;
        }
        for (ASTNode node = el.getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            IElementType type = node.getElementType();
            if (SqlTokens.WS_OR_COMMENTS.contains(type)) continue;
            if (type instanceof SqlTokenType) {
                return node.getPsi();
            }
            if (type == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE) {
                return node.getPsi();
            }
            if (type == SqlCompositeElementTypes.SQL_GENERIC_ELEMENT) {
                return node.getPsi();
            }
            if (type instanceof SqlCompositeElementType) break;
        }
        return null;
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlType lType = this.getLOperand().getSqlType();
        IElementType sign = this.getOpSign();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        Dbms dbms = dialect.getDbms();
        if (sign == SqlTokens.SQL_OP_EQ || sign == SqlTokens.SQL_OP_NEQ || sign == SqlTokens.SQL_OP_GT || sign == SqlTokens.SQL_OP_LT || sign == SqlTokens.SQL_OP_GE || sign == SqlTokens.SQL_OP_LE || sign == SqlTokens.SQL_OP_LOGICAL_AND || sign == SqlTokens.SQL_OP_NULLSAFE_EQ || sign == SqlTokens.SQL_OP_LOGICAL_OR && (dbms.isTransactSql() || dbms.isMysql()) || sign == SqlTokens.SQL_OP_NEQ2 || sign == SqlTokens.SQL_OP_NEQ3 || sign == SqlTokens.SQL_OP_NEQ_WS || sign == SqlTokens.SQL_OP_NEQ2_WS || sign == SqlTokens.SQL_OP_NEQ3_WS || sign == SqlTokens.SQL_LIKE || sign == SqlTokens.SQL_IS) {
            SqlType sqlType = SqlTypeFactory.defaultType(SqlType.Category.BOOLEAN, dialect);
            if (sqlType == null) {
                SqlNAryExpressionImpl.$$$reportNull$$$0(5);
            }
            return sqlType;
        }
        if (sign == SqlTokens.SQL_OP_PLUS || sign == SqlTokens.SQL_OP_MINUS || sign == SqlTokens.SQL_OP_MUL || sign == SqlTokens.SQL_OP_DIV) {
            if (SqlType.Category.REAL.is(lType) || SqlType.Category.DATE.is(lType) || SqlType.Category.TIME.is(lType) || SqlType.Category.TIMESTAMP.is(lType) || SqlType.Category.DATE_TIME.is(lType) || SqlType.Category.INTEGER.is(lType)) {
                SqlType sqlType = lType;
                if (sqlType == null) {
                    SqlNAryExpressionImpl.$$$reportNull$$$0(6);
                }
                return sqlType;
            }
            SqlType sqlType = SqlTypeFactory.defaultType(SqlType.Category.INTEGER, dialect);
            if (sqlType == null) {
                SqlNAryExpressionImpl.$$$reportNull$$$0(7);
            }
            return sqlType;
        }
        if (sign == SqlTokens.SQL_OP_BITWISE_XOR || sign == SqlTokens.SQL_OP_BITWISE_AND || sign == SqlTokens.SQL_OP_BITWISE_OR || sign == SqlTokens.SQL_OP_INVERT || sign == SqlTokens.SQL_OP_LEFT_SHIFT || sign == SqlTokens.SQL_OP_RIGHT_SHIFT || sign == SqlTokens.SQL_OP_MODULO) {
            SqlType sqlType = SqlTypeFactory.defaultType(SqlType.Category.INTEGER, dialect);
            if (sqlType == null) {
                SqlNAryExpressionImpl.$$$reportNull$$$0(8);
            }
            return sqlType;
        }
        if (sign == SqlTokens.SQL_OP_CONCAT) {
            SqlType sqlType = SqlTypeFactory.defaultType(SqlType.Category.STRING, dialect);
            if (sqlType == null) {
                SqlNAryExpressionImpl.$$$reportNull$$$0(9);
            }
            return sqlType;
        }
        if (sign == SqlTokens.SQL_LEFT_BRACKET && lType instanceof SqlArrayType) {
            SqlType sqlType = ((SqlArrayType)lType).getElementType();
            if (sqlType == null) {
                SqlNAryExpressionImpl.$$$reportNull$$$0(10);
            }
            return sqlType;
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            SqlNAryExpressionImpl.$$$reportNull$$$0(11);
        }
        return sqlPrimitiveType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlNAryExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlNAryExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperands";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLOperand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpSign";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpSignElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

