/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.symbols.DasColumnSymbol;
import com.intellij.database.symbols.DasTableSymbol;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithOrdinalityClause;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlExplicitTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionCallTableExpressionImpl
extends SqlExplicitTableExpressionImpl
implements SqlDefinition {
    private volatile FakeTable myTable;

    public SqlFunctionCallTableExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
        this.myTable = null;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = SqlImplUtil.getSqlDialectDbms((PsiElement)this);
        if (dbms == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    public void clearCaches() {
        this.myTable = null;
        super.clearCaches();
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlTableType sqlType;
        SqlColumnAliasListImpl aliasList = this.findChildByClass(SqlColumnAliasListImpl.class);
        if (aliasList != null && (sqlType = aliasList.getSqlType((PsiElement)this.getTable())) != null) {
            SqlTableType sqlTableType = sqlType;
            if (sqlTableType == null) {
                SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(2);
            }
            return sqlTableType;
        }
        SqlTableType type = this.getFunctionTableType();
        SqlTypedDefinition ordinality = this.getOrdinalityColumn();
        if (ordinality != null) {
            type = type.add(new TableBasedSqlTableTypeImpl<SqlTypedDefinition>(Collections.singletonList(ordinality), (PsiElement)this.getTable()));
        }
        SqlTableType sqlTableType = type;
        if (sqlTableType == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(3);
        }
        return sqlTableType;
    }

    private SqlTableType getFunctionTableType() {
        SqlFunctionCallExpression call = this.getFunctionCall();
        if (call == null) {
            return SqlTableTypeBase.createType((PsiElement)this, new TableBasedSqlTableTypeImpl(ContainerUtil.emptyList(), null), null, false, (PsiElement)this.getTable(), null);
        }
        SqlReferenceExpression name = call.getNameElement();
        SqlType type = call.getSqlType();
        String alias = name == null ? null : name.getName();
        FakeTable table = this.getTable();
        if (type instanceof SqlTableType) {
            SqlTableType tableType = (SqlTableType)type;
            List aliases = Collections.emptyList();
            if (tableType.getColumnCount() == 1 && StringUtil.isEmpty((String)tableType.getColumnName(0))) {
                aliases = ContainerUtil.createMaybeSingletonList((Object)name);
            }
            return tableType.alias(alias, (PsiElement)table, aliases);
        }
        return SqlTableTypeBase.createType((PsiElement)table.myColumn, type, alias, DbSqlUtil.isQuoted((SqlNameElement)name), (PsiElement)table, null);
    }

    @Nullable
    private SqlFunctionCallExpression getFunctionCall() {
        return (SqlFunctionCallExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlFunctionCallExpression.class);
    }

    @Nullable
    private SqlTypedDefinition getOrdinalityColumn() {
        return (SqlTypedDefinition)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcOrdinalityColumn(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private SqlTypedDefinition calcOrdinalityColumn() {
        SqlWithOrdinalityClause ordinality = this.findChildByClass(SqlWithOrdinalityClause.class);
        if (ordinality == null) {
            return null;
        }
        SqlTypedDefinition ordinalityDefinition = ordinality.getOrdinalityDefinition();
        if (ordinalityDefinition != null) {
            return ordinalityDefinition;
        }
        return new OrdinalityColumn(this.getTable(), ordinality);
    }

    @Override
    @NotNull
    public String getName() {
        SqlNameElement nameElement = this.getNameElement();
        String string = nameElement == null ? DasUtil.NO_NAME : nameElement.getName();
        if (string == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        SqlNameElement nameElement;
        if (name == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(5);
        }
        if ((nameElement = this.getNameElement()) != null) {
            nameElement.setName(name);
        }
        return this;
    }

    @Nullable
    public SqlNameElement getNameElement() {
        SqlFunctionCallExpression call = this.getFunctionCall();
        return call == null ? null : call.getNameElement();
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(6);
        }
        return objectKind;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return null;
    }

    public boolean isNameQuoted() {
        return DbSqlUtil.isQuoted(this.getNameElement());
    }

    private FakeTable getTable() {
        return this.myTable == null ? (this.myTable = new FakeTable()) : this.myTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class OrdinalityColumn
    extends FakeDefinition
    implements SqlTypedDefinition {
        private final SqlWithOrdinalityClause myClause;

        protected OrdinalityColumn(PsiTable table, SqlWithOrdinalityClause clause) {
            super((PsiElement)table);
            this.myClause = clause;
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = SqlFunctionCallTableExpressionImpl.this.getDbms();
            if (dbms == null) {
                OrdinalityColumn.$$$reportNull$$$0(0);
            }
            return dbms;
        }

        @Override
        @NotNull
        public String getName() {
            SqlTypedDefinition ordinalityDefinition = this.myClause.getOrdinalityDefinition();
            if (ordinalityDefinition != null) {
                String string = ordinalityDefinition.getName();
                if (string == null) {
                    OrdinalityColumn.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = this.myClause.getLastChild().getText();
            if (string == null) {
                OrdinalityColumn.$$$reportNull$$$0(2);
            }
            return string;
        }

        public DasObject getDasParent() {
            return (PsiTable)this.getParent();
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                OrdinalityColumn.$$$reportNull$$$0(3);
            }
            return objectKind;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.getSqlType().getDataType();
            if (dataType == null) {
                OrdinalityColumn.$$$reportNull$$$0(4);
            }
            return dataType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        @NotNull
        public SqlType getSqlType() {
            SqlType sqlType = SqlFunctionCallTableExpressionImpl.this.getSqlTypeForCategory(SqlType.Category.INTEGER);
            if (sqlType == null) {
                OrdinalityColumn.$$$reportNull$$$0(5);
            }
            return sqlType;
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            SqlWithOrdinalityClause sqlWithOrdinalityClause = this.myClause;
            if (sqlWithOrdinalityClause == null) {
                OrdinalityColumn.$$$reportNull$$$0(6);
            }
            return sqlWithOrdinalityClause;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$OrdinalityColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class FakeTable
    extends FakeDefinition
    implements PsiTable,
    DasTableSymbol {
        private final FakeColumn myColumn;

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = SqlFunctionCallTableExpressionImpl.this.getDbms();
            if (dbms == null) {
                FakeTable.$$$reportNull$$$0(0);
            }
            return dbms;
        }

        @NotNull
        public DasTable getDasObject() {
            FakeTable fakeTable = this;
            if (fakeTable == null) {
                FakeTable.$$$reportNull$$$0(1);
            }
            return fakeTable;
        }

        public boolean isSystem() {
            return false;
        }

        public boolean isTemporary() {
            return false;
        }

        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
            Set<DasColumn.Attribute> set = Collections.emptySet();
            if (set == null) {
                FakeTable.$$$reportNull$$$0(2);
            }
            return set;
        }

        protected FakeTable() {
            super((PsiElement)SqlFunctionCallTableExpressionImpl.this);
            this.myColumn = new FakeColumn();
        }

        @NotNull
        public JBIterable<PsiObject> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = JBIterable.of((Object)((Object)this.myColumn)).filter(DasUtil.byKind((ObjectKind)kind));
            if (jBIterable == null) {
                FakeTable.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                FakeTable.$$$reportNull$$$0(4);
            }
            return objectKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasObject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAttrs";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        private class FakeColumn
        extends FakeDefinition
        implements PsiColumn,
        DasColumnSymbol {
            protected FakeColumn() {
                super((PsiElement)FakeTable.this);
            }

            @NotNull
            public Dbms getDbms() {
                Dbms dbms = SqlFunctionCallTableExpressionImpl.this.getDbms();
                if (dbms == null) {
                    FakeColumn.$$$reportNull$$$0(0);
                }
                return dbms;
            }

            @NotNull
            public DasColumn getDasObject() {
                FakeColumn fakeColumn = this;
                if (fakeColumn == null) {
                    FakeColumn.$$$reportNull$$$0(1);
                }
                return fakeColumn;
            }

            public short getPosition() {
                return 0;
            }

            @Override
            @NotNull
            public String getName() {
                SqlAsExpression asExpr = (SqlAsExpression)ObjectUtils.tryCast((Object)SqlFunctionCallTableExpressionImpl.this.getParent(), SqlAsExpression.class);
                String name = asExpr == null ? null : asExpr.getName();
                String string = name == null ? super.getName() : name;
                if (string == null) {
                    FakeColumn.$$$reportNull$$$0(2);
                }
                return string;
            }

            public DasTable getTable() {
                return FakeTable.this;
            }

            @Nullable
            public DasObject getDasParent() {
                return this.getTable();
            }

            @Override
            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    FakeColumn.$$$reportNull$$$0(3);
                }
                return objectKind;
            }

            @NotNull
            public DataType getDataType() {
                SqlFunctionCallExpression call = SqlFunctionCallTableExpressionImpl.this.getFunctionCall();
                DataType dataType = call == null ? DataType.UNKNOWN : call.getSqlType().getDataType();
                if (dataType == null) {
                    FakeColumn.$$$reportNull$$$0(4);
                }
                return dataType;
            }

            public boolean isNotNull() {
                return false;
            }

            @Nullable
            public String getDefault() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable$FakeColumn";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDbms";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDasObject";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDataType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }

    private abstract class FakeDefinition
    extends RenameableFakePsiElement
    implements SqlDefinition,
    SqlNameElement {
        protected FakeDefinition(PsiElement parent2) {
            super(parent2);
        }

        @NotNull
        private SqlFunctionCallTableExpressionImpl getOuter() {
            SqlFunctionCallTableExpressionImpl sqlFunctionCallTableExpressionImpl = SqlFunctionCallTableExpressionImpl.this;
            if (sqlFunctionCallTableExpressionImpl == null) {
                FakeDefinition.$$$reportNull$$$0(0);
            }
            return sqlFunctionCallTableExpressionImpl;
        }

        public boolean isNameQuoted() {
            return DbSqlUtil.isQuoted(this.getNameElement());
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getNameElement();
        }

        @NotNull
        public String getName() {
            SqlNameElement nameElement = this.getNameElement();
            String string = nameElement == null ? DasUtil.NO_NAME : nameElement.getName();
            if (string == null) {
                FakeDefinition.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String getTypeName() {
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return DbPresentation.getIcon((DasObject)this);
        }

        @Nullable
        public SqlNameElement getNameElement() {
            SqlFunctionCallExpression call = SqlFunctionCallTableExpressionImpl.this.getFunctionCall();
            return call == null ? null : call.getNameElement();
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                FakeDefinition.$$$reportNull$$$0(2);
            }
            return objectKind;
        }

        public boolean isPlainIdentifier() {
            SqlNameElement nameElement = this.getNameElement();
            return nameElement == null || nameElement.isPlainIdentifier();
        }

        public boolean isQuotedIdentifier() {
            SqlNameElement nameElement = this.getNameElement();
            return nameElement != null && nameElement.isQuotedIdentifier();
        }

        public void accept(SqlVisitor visitor2) {
        }

        public void acceptChildren(SqlVisitor visitor2) {
        }

        public FakeDefinition setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            SqlNameElement nameElement;
            if (name == null) {
                FakeDefinition.$$$reportNull$$$0(3);
            }
            if ((nameElement = this.getNameElement()) != null) {
                nameElement.setName(name);
            }
            return this;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            return this.getOuter();
        }

        public boolean isEquivalentTo(PsiElement another) {
            return another != null && another.getClass().equals(((Object)((Object)this)).getClass()) && this.getOuter().equals((Object)((FakeDefinition)another).getOuter());
        }

        public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                FakeDefinition.$$$reportNull$$$0(4);
            }
            if (state == null) {
                FakeDefinition.$$$reportNull$$$0(5);
            }
            if (place == null) {
                FakeDefinition.$$$reportNull$$$0(6);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeDefinition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOuter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeDefinition";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processDeclarations";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

