/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasScopeAware;
import com.intellij.database.model.DasScopeProcessor;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.symbols.DasSymbolObject;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDefinitionHolder;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileAttributes;
import com.intellij.sql.psi.SqlIfStatement;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlResolveCache;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlThenClause;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlAlterInstructionImpl;
import com.intellij.sql.psi.impl.SqlElementDescriptionProvider;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlResolveCacheImpl;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.sql.symbols.virtual.DasVirtualSymbol;
import com.intellij.util.CachedValueBase;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFileImpl
extends PsiFileBase
implements SqlFile {
    private final NamespaceImpl myRootMirror;
    private final ConcurrentMap<Object, GroupImpl> myMirrors;
    private final CachedValue<List<SqlElement>> myDdl;
    private final CachedValue<State> myState;
    private final CachedValue<List<SqlDeclareStatement>> myDeclares;
    private final CachedValue<SqlResolveCacheImpl> myResolveCache;

    public SqlFileImpl(FileViewProvider viewProvider, @NotNull SqlLanguageDialect dialect) {
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(0);
        }
        this(viewProvider, (Language)dialect);
    }

    public SqlFileImpl(FileViewProvider viewProvider) {
        this(viewProvider, (Language)SqlLanguage.INSTANCE);
    }

    private SqlFileImpl(FileViewProvider viewProvider, @NotNull Language language) {
        if (language == null) {
            SqlFileImpl.$$$reportNull$$$0(1);
        }
        super(viewProvider, language);
        this.myRootMirror = new NamespaceImpl(null, DasUtil.NO_NAME, DasUtil.NO_NAME, ObjectKind.ROOT, true);
        this.myMirrors = new ConcurrentHashMap<Object, GroupImpl>();
        Project project = this.getProject();
        this.myDdl = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create(this.calcDdl(), (Object[])new Object[]{this}), false);
        this.myState = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.calcState(), (Object[])new Object[]{this, DbPsiFacade.getInstance((Project)project)}), false);
        this.myDeclares = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create(this.calcDeclares(), (Object[])new Object[]{this}), false);
        this.myResolveCache = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create((Object)new SqlResolveCacheImpl(), (Object[])new Object[]{this, DbPsiFacade.getInstance((Project)project)}), false);
    }

    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = DbImplUtil.getMetaModel(this.getSqlLanguage().getDbms());
        if (basicMetaModel == null) {
            SqlFileImpl.$$$reportNull$$$0(2);
        }
        return basicMetaModel;
    }

    public void clearCaches() {
        ((CachedValueBase)this.myState).clear();
        ((CachedValueBase)this.myDeclares).clear();
        ((CachedValueBase)this.myDdl).clear();
        ((CachedValueBase)this.myResolveCache).clear();
        super.clearCaches();
    }

    @NotNull
    public List<SqlElement> getDdl() {
        List list = (List)this.myDdl.getValue();
        if (list == null) {
            SqlFileImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public <T> T getAttributeAt(@NotNull Key<T> attr, int offset) {
        if (attr == null) {
            SqlFileImpl.$$$reportNull$$$0(4);
        }
        if (attr == SqlFileAttributes.DELIMITER) {
            return (T)this.getSqlLanguage().getDelimiterAt(this, offset);
        }
        return null;
    }

    @NotNull
    public JBIterable<? extends DasObject> getModelRoots() {
        JBIterable<DasSymbolObject> jBIterable = this.myRootMirror.children();
        if (jBIterable == null) {
            SqlFileImpl.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            SqlFileImpl.$$$reportNull$$$0(6);
        }
        Casing casing = ((State)this.myState.getValue()).casingProvider.getCasing(kind, context);
        if (casing == null) {
            SqlFileImpl.$$$reportNull$$$0(7);
        }
        return casing;
    }

    @NotNull
    public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots(this.getModelRoots());
        if (jBTreeTraverser == null) {
            SqlFileImpl.$$$reportNull$$$0(8);
        }
        return jBTreeTraverser;
    }

    public boolean contains(@Nullable DasObject o) {
        return o instanceof SqlElement && ((SqlElement)o).getContainingFile() == this;
    }

    @Nullable
    public DasNamespace getCurrentRootNamespace() {
        return null;
    }

    @Nullable
    public DasObject findDbParent(SqlDefinition o) {
        return (DasObject)((State)this.myState.getValue()).children.get(o);
    }

    private List<SqlElement> calcDdl() {
        StubElement stub = this.getStub();
        if (stub != null) {
            return (List)JBIterable.from((Iterable)stub.getChildrenStubs()).transform(SqlImplUtil.STUB_TO_PSI).filter(SqlCompositeElement.class).addAllTo(new ArrayList());
        }
        return (List)((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)this).expand(Conditions.instanceOf((Class[])new Class[]{SqlBatchBlock.class, SqlIfStatement.class, SqlThenClause.class, SqlSelectStatement.class, SqlExpression.class, SqlDefinitionHolder.class}))).traverse().filter(element2 -> element2 instanceof StubBasedPsiElement && !(element2 instanceof SqlLocalDefinition)).filter(SqlCompositeElement.class).addAllTo(new ArrayList());
    }

    @NotNull
    private State calcState() {
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        final CasingProvider delegateCasing = SqlImplUtil.getCasingProvider(dialect, SqlImplUtil.getDataSources((PsiElement)this));
        CasingProvider casingProvider = new CasingProvider(){

            @NotNull
            public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
                if (kind == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context instanceof DbElement) {
                    Casing casing = ((DbElement)context).getDataSource().getModel().getCasing(kind, context);
                    if (casing == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return casing;
                }
                Casing casing = delegateCasing.getCasing(kind, context);
                if (casing == null) {
                    1.$$$reportNull$$$0(2);
                }
                return casing;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "kind";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/psi/impl/SqlFileImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/psi/impl/SqlFileImpl$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCasing";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCasing";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        State state = new State(casingProvider);
        SqlAlterInstruction[] recentUseRef = null;
        SqlDialectImplUtil.ObjectTracer<?> currentContext = this.getInitialContext();
        List<SqlElement> ddlList = this.getDdl();
        for (SqlElement ddl : ddlList) {
            if (ddl instanceof SqlUseDatabaseStatement) {
                SqlAlterInstruction[] useRef = (SqlAlterInstruction[])ContainerUtil.getFirstItem((List)((SqlUseDatabaseStatement)ddl).getUseReferences());
                if (useRef != recentUseRef) {
                    recentUseRef = useRef;
                    currentContext = SqlFileImpl.trace((SqlNameElement)recentUseRef, null, dialect);
                }
                this.addDefinitionToMap(null, state, currentContext);
            }
            if (ddl instanceof SqlDefinition) {
                this.addDefinitionToMap((SqlDefinition)ddl, state, currentContext);
                continue;
            }
            if (ddl instanceof SqlAlterStatement) {
                for (SqlAlterInstruction i2 : ((SqlAlterStatement)ddl).getAlterInstructions()) {
                    if (i2.getInstructionType() != SqlCompositeElementTypes.SQL_RENAME_TO_CLAUSE && i2.getInstructionType() != SqlCommonKeywords.SQL_ADD) continue;
                    for (SqlDefinition def : ((SqlAlterInstructionImpl)i2).getDefinitions()) {
                        if (def.getKind() == ObjectKind.COLUMN) continue;
                        this.addDefinitionToMap(def, state, currentContext);
                    }
                }
                List renames = PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)ddl, SqlRenameToClause.class);
                for (SqlRenameToClause rename2 : renames) {
                    this.addDefinitionToMap((SqlDefinition)rename2, state, currentContext);
                }
                continue;
            }
            for (SqlRenameToClause renamed : SqlImplUtil.childrenIt((PsiElement)ddl).filter(SqlRenameToClause.class)) {
                this.addDefinitionToMap((SqlDefinition)renamed, state, currentContext);
            }
        }
        state.seal(this.myMirrors);
        State state2 = state;
        if (state2 == null) {
            SqlFileImpl.$$$reportNull$$$0(9);
        }
        return state2;
    }

    @Nullable
    private SqlDialectImplUtil.ObjectTracer<?> getInitialContext() {
        VirtualFile vFile = SqlImplUtil.getTopLevelSqlFile(this.getOriginalFile()).getVirtualFile();
        List<DbDataSource> dss = SqlImplUtil.getDataSources((PsiElement)this);
        if (ContainerUtil.find(dss, ds -> ds.getDelegate() instanceof SqlDataSource && ((SqlDataSource)ds.getDelegate()).containsFile(vFile)) == null) {
            return null;
        }
        TreePattern initial = SqlDialectImplUtil.getImportCheckerAt((SqlFile)this, null).state;
        ObjectPath path = this.extractInitialContext(initial);
        if (path == null) {
            return null;
        }
        return new PathTracer(path);
    }

    @Nullable
    private ObjectPath extractInitialContext(@NotNull TreePattern initial) {
        TreePatternNode<TreePatternNode.PositiveNaming> dsNode;
        if (initial == null) {
            SqlFileImpl.$$$reportNull$$$0(10);
        }
        if ((dsNode = SqlFileImpl.singlePositiveNode(initial.root.getGroup(ObjectKind.ROOT))) == null) {
            return null;
        }
        TreePattern applied = this.getSqlLanguage().applyImplicitImports(((TreePatternNode.PositiveNaming)dsNode.naming).names, TreePattern.EMPTY);
        TreePattern implicit = TreePatternUtils.minus(initial, applied);
        return SqlFileImpl.extractInitialContext(null, SqlFileImpl.singlePositiveNode(implicit.root.getGroup(ObjectKind.ROOT)));
    }

    @Nullable
    private static TreePatternNode<TreePatternNode.PositiveNaming> singlePositiveNode(@Nullable TreePatternNode.Group g) {
        if (g == null || g.negativeChild != null || g.positiveChildren == null || g.positiveChildren.length > 2) {
            return null;
        }
        TreePatternNode<TreePatternNode.PositiveNaming> n = g.positiveChildren[0];
        if (SqlFileImpl.isFake(n)) {
            if (g.positiveChildren.length < 2) {
                return null;
            }
            n = g.positiveChildren[1];
        } else if (g.positiveChildren.length > 1 && !SqlFileImpl.isFake(g.positiveChildren[1])) {
            return null;
        }
        return ((TreePatternNode.PositiveNaming)n.naming).names.length == 1 ? n : null;
    }

    private static boolean isFake(@NotNull TreePatternNode<TreePatternNode.PositiveNaming> n) {
        if (n == null) {
            SqlFileImpl.$$$reportNull$$$0(11);
        }
        return ((TreePatternNode.PositiveNaming)n.naming).matches(SqlImportUtil.NON_MATCHING_NAME, null);
    }

    @Nullable
    private static ObjectPath extractInitialContext(@Nullable ObjectPath p2, @Nullable TreePatternNode<TreePatternNode.PositiveNaming> n) {
        if (n == null || n.groups.length != 1) {
            return p2;
        }
        TreePatternNode.Group g = n.groups[0];
        TreePatternNode<TreePatternNode.PositiveNaming> c2 = SqlFileImpl.singlePositiveNode(g);
        if (c2 == null) {
            return p2;
        }
        ObjectName name = ((TreePatternNode.PositiveNaming)c2.naming).names[0];
        return SqlFileImpl.extractInitialContext(ObjectPath.create((String)name.name, (ObjectKind)g.kind, (boolean)name.quoted, null, (ObjectPath)p2), c2);
    }

    private void addDefinitionToMap(@Nullable SqlDefinition o, @NotNull State newState, @Nullable SqlDialectImplUtil.ObjectTracer<?> context) {
        if (newState == null) {
            SqlFileImpl.$$$reportNull$$$0(12);
        }
        if (o == null && context == null) {
            return;
        }
        SqlLanguageDialectEx dialect = this.getSqlLanguage();
        List<Trinity<ObjectKind, Boolean, String>> parts = this.getParts(o, context);
        if (parts == null) {
            return;
        }
        this.addDefinitionToMap(o, parts, newState, dialect);
    }

    private List<Trinity<ObjectKind, Boolean, String>> getParts(@Nullable SqlDefinition o, @Nullable SqlDialectImplUtil.ObjectTracer<?> context) {
        ArrayList<Trinity<ObjectKind, Boolean, String>> parts;
        SqlLanguageDialectEx dialect = this.getSqlLanguage();
        ObjectKind curKind = SqlFileImpl.splitRef(dialect, o, context, parts = new ArrayList<Trinity<ObjectKind, Boolean, String>>(4));
        if (curKind == ObjectKind.NONE) {
            return null;
        }
        List<ObjectKind> path = SqlFileImpl.chooseShortestPath(o, curKind, dialect);
        if (path.isEmpty()) {
            return parts.isEmpty() ? null : parts;
        }
        SqlFileImpl.addSkippedParts(parts, path, ObjectKind.ROOT);
        return parts;
    }

    private void addDefinitionToMap(@Nullable SqlDefinition o, @NotNull List<Trinity<ObjectKind, Boolean, String>> parts, @NotNull State newState, @NotNull SqlLanguageDialectEx dialect) {
        if (parts == null) {
            SqlFileImpl.$$$reportNull$$$0(13);
        }
        if (newState == null) {
            SqlFileImpl.$$$reportNull$$$0(14);
        }
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(15);
        }
        BasicMetaModel metaModel = DbImplUtil.getMetaModel(dialect.getDbms());
        GroupImpl parent2 = this.myRootMirror;
        Trinity<ObjectKind, String, ?> parentKey = null;
        for (int i2 = parts.size() - 1; i2 >= 0; --i2) {
            boolean wrap2;
            Trinity<ObjectKind, Boolean, String> part = parts.get(i2);
            parentKey = SqlFileImpl.createKey(part, newState.casingProvider, parentKey);
            String name = (String)parentKey.second;
            ObjectKind kind = (ObjectKind)part.first;
            Boolean quoted = (Boolean)part.second;
            String uncased = (String)part.third;
            boolean isNamespace = metaModel.getNamespaces().contains(kind);
            GroupImpl mirror = (GroupImpl)((Object)this.myMirrors.get(parentKey));
            boolean bl = isNamespace || dialect.shouldWrap((SqlDefinition)(i2 == 0 ? o : null), kind) ? true : (wrap2 = false);
            if (mirror == null && wrap2) {
                mirror = isNamespace ? new NamespaceImpl(parent2, name, uncased, kind, quoted) : new GroupImpl(parent2, name, uncased, kind, quoted);
                mirror = (GroupImpl)((Object)ConcurrencyUtil.cacheOrGet(this.myMirrors, parentKey, (Object)((Object)mirror)));
            }
            if (mirror == null && o == null) {
                throw new AssertionError((Object)("Unable to add " + parentKey.toString()));
            }
            newState.children.put(mirror != null ? mirror : o, parent2);
            if (i2 == 0 && o != null && mirror != null) {
                newState.delegates.put(o, mirror);
            }
            parent2 = mirror != null ? mirror : parent2;
        }
    }

    @NotNull
    private static Trinity<ObjectKind, String, ?> createKey(@NotNull Trinity<ObjectKind, Boolean, String> part, @NotNull CasingProvider casingProvider, @Nullable Trinity<ObjectKind, String, ?> parent2) {
        if (part == null) {
            SqlFileImpl.$$$reportNull$$$0(16);
        }
        if (casingProvider == null) {
            SqlFileImpl.$$$reportNull$$$0(17);
        }
        Trinity trinity = Trinity.create((Object)((ObjectKind)part.first), (Object)SqlFileImpl.getCasedName(part, casingProvider), parent2);
        if (trinity == null) {
            SqlFileImpl.$$$reportNull$$$0(18);
        }
        return trinity;
    }

    private static String getCasedName(Trinity<ObjectKind, Boolean, String> part, @NotNull CasingProvider casingProvider) {
        if (casingProvider == null) {
            SqlFileImpl.$$$reportNull$$$0(19);
        }
        ObjectKind kind = (ObjectKind)part.first;
        Boolean quoted = (Boolean)part.second;
        String uncased = (String)part.third;
        Case aCase = casingProvider.getCasing(kind, null).choose(quoted == false);
        String name = aCase.apply(uncased);
        return name;
    }

    static void splitRef(@NotNull SqlLanguageDialectEx dialect, @Nullable SqlReferenceExpression useRef, @NotNull List<Trinity<ObjectKind, Boolean, String>> parts) {
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(20);
        }
        if (parts == null) {
            SqlFileImpl.$$$reportNull$$$0(21);
        }
        SqlFileImpl.splitRef(dialect, null, SqlFileImpl.trace((SqlNameElement)useRef, null, dialect), parts);
    }

    @NotNull
    private static ObjectKind fillParts(@NotNull SqlDialectImplUtil.ObjectTracer<?> tracer, @NotNull List<Trinity<ObjectKind, Boolean, String>> parts) {
        if (tracer == null) {
            SqlFileImpl.$$$reportNull$$$0(22);
        }
        if (parts == null) {
            SqlFileImpl.$$$reportNull$$$0(23);
        }
        ObjectKind curKind = tracer.getKind();
        SqlDialectImplUtil.ObjectTracer.ObjectTraceIt<?> it2 = tracer.trace();
        while (it2.hasNext()) {
            it2.next();
            ObjectKind kind = it2.getKind();
            if (kind == ObjectKind.NONE || kind == ObjectKind.ROOT) break;
            curKind = kind;
            parts.add((Trinity<ObjectKind, Boolean, String>)Trinity.create((Object)kind, (Object)it2.isQuoted(), (Object)it2.getName()));
        }
        ObjectKind objectKind = curKind;
        if (objectKind == null) {
            SqlFileImpl.$$$reportNull$$$0(24);
        }
        return objectKind;
    }

    @NotNull
    static ObjectKind splitRef(@NotNull SqlLanguageDialectEx dialect, @Nullable SqlDefinition o, @Nullable SqlDialectImplUtil.ObjectTracer<?> useTracer, @NotNull List<Trinity<ObjectKind, Boolean, String>> parts) {
        ObjectKind curKind;
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(25);
        }
        if (parts == null) {
            SqlFileImpl.$$$reportNull$$$0(26);
        }
        if (o == null && useTracer == null) {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                SqlFileImpl.$$$reportNull$$$0(27);
            }
            return objectKind;
        }
        SqlNameElement nameElement = o != null ? o.getNameElement() : null;
        ObjectKind kind = null;
        if (o != null) {
            kind = o.getKind();
        }
        if (o != null) {
            if (nameElement != null) {
                SqlDialectImplUtil.ObjectTracer<?> tracer = SqlFileImpl.trace(nameElement, o, dialect);
                curKind = SqlFileImpl.fillParts(tracer, parts);
            } else {
                curKind = o.getKind();
                parts.add((Trinity<ObjectKind, Boolean, String>)Trinity.create((Object)curKind, (Object)true, (Object)""));
            }
            if (useTracer == null || useTracer.getKind() == ObjectKind.NONE || useTracer.getKind() == curKind) {
                ObjectKind objectKind = curKind;
                if (objectKind == null) {
                    SqlFileImpl.$$$reportNull$$$0(28);
                }
                return objectKind;
            }
            SmartList parentTypes = new SmartList();
            DbImplUtil.getMetaModel(dialect.getDbms()).getParentKinds(dialect.unaliased(curKind)).addAllTo((Collection)parentTypes);
            if (!parentTypes.contains(useTracer.getKind())) {
                List<ObjectKind> path = SqlFileImpl.chooseShortestPath(o, kind, dialect);
                if (!path.contains(useTracer.getKind())) {
                    ObjectKind objectKind = curKind;
                    if (objectKind == null) {
                        SqlFileImpl.$$$reportNull$$$0(29);
                    }
                    return objectKind;
                }
                SqlFileImpl.addSkippedParts(parts, path, useTracer.getKind());
            }
        }
        ObjectKind objectKind = curKind = SqlFileImpl.fillParts(useTracer, parts);
        if (objectKind == null) {
            SqlFileImpl.$$$reportNull$$$0(30);
        }
        return objectKind;
    }

    private static List<ObjectKind> chooseShortestPath(@Nullable SqlDefinition o, @NotNull ObjectKind kind, @NotNull SqlLanguageDialectEx dialect) {
        ObjectKind expectedParent;
        JBIterable<List<ObjectKind>> allPaths;
        List list;
        if (kind == null) {
            SqlFileImpl.$$$reportNull$$$0(31);
        }
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(32);
        }
        if ((list = (List)(allPaths = DbImplUtil.getMetaModel(dialect.getDbms()).getPathsToRoot(dialect.unaliased(kind))).first()) == null) {
            return Collections.emptyList();
        }
        if (kind == ObjectKind.BODY) {
            expectedParent = SqlImplUtil.getBodyParentKind(o);
        } else {
            SqlStubbedDefinitionImpl def = (SqlStubbedDefinitionImpl)((Object)ObjectUtils.tryCast((Object)o, SqlStubbedDefinitionImpl.class));
            SqlReferenceElementType expectedParentType = def == null ? null : def.getExpectedParentType();
            ObjectKind objectKind = expectedParent = expectedParentType == null ? null : expectedParentType.getTargetKind();
            if (expectedParent == null) {
                expectedParent = SqlDbElementType.ANY;
            }
        }
        if (expectedParent != SqlDbElementType.ANY) {
            for (List path : allPaths) {
                if (!path.contains(expectedParent)) continue;
                list = path;
                break;
            }
        }
        return list.subList(1, list.size());
    }

    private static void addSkippedParts(List<Trinity<ObjectKind, Boolean, String>> parts, Iterable<ObjectKind> path, ObjectKind upToKind) {
        for (ObjectKind kind : path) {
            if (kind == upToKind) break;
            parts.add((Trinity<ObjectKind, Boolean, String>)Trinity.create((Object)kind, (Object)true, (Object)""));
        }
    }

    @NotNull
    private List<SqlDeclareStatement> calcDeclares() {
        List list = SqlImplUtil.sqlChildren((PsiElement)this).filter(SqlDeclareStatement.class).toList();
        if (list == null) {
            SqlFileImpl.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    public FileType getFileType() {
        SqlFileType sqlFileType = SqlFileType.INSTANCE;
        if (sqlFileType == null) {
            SqlFileImpl.$$$reportNull$$$0(34);
        }
        return sqlFileType;
    }

    public String toString() {
        return "SqlFile:" + this.getName();
    }

    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlFile((SqlFile)this);
    }

    public void acceptChildren(SqlVisitor visitor2) {
        SqlImplUtil.acceptChildren((SqlElement)this, visitor2);
    }

    @NotNull
    public SqlLanguageDialectEx getSqlLanguage() {
        Language language = this.getLanguage();
        if (language instanceof SqlLanguageDialectEx) {
            SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)language;
            if (sqlLanguageDialectEx == null) {
                SqlFileImpl.$$$reportNull$$$0(35);
            }
            return sqlLanguageDialectEx;
        }
        SqlDialectMappings dialectMappings = SqlDialectMappings.getInstance(this.getProject());
        FileViewProvider viewProvider = this.getOriginalFile().getViewProvider();
        SqlLanguageDialect dialect = dialectMappings != null ? dialectMappings.getMapping(viewProvider.isPhysical() ? viewProvider.getVirtualFile() : null) : SqlDialectMappings.getDefaultSqlDialect();
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)dialect;
        if (sqlLanguageDialectEx == null) {
            SqlFileImpl.$$$reportNull$$$0(36);
        }
        return sqlLanguageDialectEx;
    }

    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        PsiFile file;
        if (processor == null) {
            SqlFileImpl.$$$reportNull$$$0(37);
        }
        if (state == null) {
            SqlFileImpl.$$$reportNull$$$0(38);
        }
        if (place == null) {
            SqlFileImpl.$$$reportNull$$$0(39);
        }
        if ((file = this.getOriginalFile()) != this) {
            return !(file instanceof SqlFile) || ((SqlFile)file).processDeclarations(processor, state, lastParent, place);
        }
        SqlImportState importState = SqlDialectImplUtil.getImportCheckerAt(this, place);
        Condition<DasObject> importedCondition = SqlFileImpl.importedCondition(importState, null);
        for (DasSymbol symbol : ((State)this.myState.getValue()).children(this.myRootMirror)) {
            if (!(symbol instanceof DasNamespace ? !SqlFileImpl.processDeclarationsImpl(processor, state, symbol, importedCondition, true) : !processor.execute(symbol, state))) continue;
            return false;
        }
        if (this.getStub() == null && this == place.getContainingFile().getOriginalFile()) {
            for (SqlDeclareStatement o : (List)this.myDeclares.getValue()) {
                if (o.processDeclarations(processor, state, lastParent, place)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean processCandidateObjects(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull JBIterable<DasObject> objects2, @Nullable Function<? super DasObject, ? extends DasSymbol> mapper) {
        if (processor == null) {
            SqlFileImpl.$$$reportNull$$$0(40);
        }
        if (state == null) {
            SqlFileImpl.$$$reportNull$$$0(41);
        }
        if (objects2 == null) {
            SqlFileImpl.$$$reportNull$$$0(42);
        }
        SqlLanguageDialect dialect = processor.getDialect();
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected(processor);
        for (DasObject object : objects2) {
            ProgressManager.checkCanceled();
            DasSymbol symbol = mapper != null ? (DasSymbol)mapper.fun((Object)object) : (DasSymbol)ObjectUtils.tryCast((Object)object, DasSymbol.class);
            if (symbol == null) continue;
            if (!processor.execute(symbol, state)) {
                return false;
            }
            if (!majorChildExpected || !dialect.shouldSkipFromQualification(object.getKind())) continue;
            for (ObjectKind majorKind : dialect.getMajorChildKinds()) {
                for (DasObject major : object.getDasChildren(majorKind)) {
                    DasSymbol majorSymbol = mapper != null ? (DasSymbol)mapper.fun((Object)major) : (DasSymbol)ObjectUtils.tryCast((Object)major, DasSymbol.class);
                    if (majorSymbol == null || processor.execute(majorSymbol, state)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    static boolean processDeclarationsImpl(@NotNull SqlScopeProcessor processor, ResolveState state, DasSymbol symbol, Condition<? super DasObject> expandCondition, boolean processElement) {
        Function mapper;
        DasObject element2;
        if (processor == null) {
            SqlFileImpl.$$$reportNull$$$0(43);
        }
        if (!((element2 = symbol.getDasObject()) instanceof DasDataSource) && !expandCondition.value((Object)element2)) {
            return !processElement || processor.execute(symbol, state);
        }
        DbDataSourceImpl ds = (DbDataSourceImpl)((Object)ObjectUtils.tryCast((Object)element2, DbDataSourceImpl.class));
        if (ds != null) {
            TreePattern scope = DbImplUtil.getIntrospectionScope((DasDataSource)ds);
            expandCondition = Conditions.and(expandCondition, o -> DbImplUtil.isExpandable(o, scope));
        }
        Function function2 = mapper = ds != null ? ds.mapper() : null;
        if (processor.getReferenceName() != null && ds != null) {
            return SqlFileImpl.processNameIndex(processor, state, ds.getNameIndex(), (Condition<? super DasObject>)expandCondition, mapper);
        }
        JBTreeTraverser traverser = ds != null ? ds.getModel().traverser() : (JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)element2);
        JBIterable objects2 = ((JBTreeTraverser)traverser.expand(expandCondition)).bfsTraversal();
        if (!processElement) {
            objects2 = objects2.filter(o -> o != element2);
        }
        return SqlFileImpl.processCandidateObjects(processor, state, (JBIterable<DasObject>)objects2, mapper);
    }

    public static boolean processNameIndex(SqlScopeProcessor processor, ResolveState state, ModelNameIndex nameIndex, Condition<? super DasObject> expandCondition, @Nullable Function<? super DasObject, ? extends DasSymbol> mapper) {
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected(processor);
        HashMap<DasObject, Boolean> cache = new HashMap<DasObject, Boolean>();
        for (DasObject object : nameIndex.getObjectsByNameInsensitive(processor.getReferenceName())) {
            DasSymbol symbol;
            ProgressManager.checkCanceled();
            if (!processor.mayAccept(object.getKind()) || !SqlFileImpl.isChildrenAccessible(object.getDasParent(), object, cache, expandCondition, majorChildExpected, processor.getDialect()) || (symbol = mapper != null ? (DasSymbol)mapper.fun((Object)object) : (DasSymbol)ObjectUtils.tryCast((Object)object, DasSymbol.class)) == null || processor.execute(symbol, state)) continue;
            return false;
        }
        return true;
    }

    private static boolean isChildrenAccessible(@Nullable DasObject parent2, @NotNull DasObject child, Map<DasObject, Boolean> cache, Condition<? super DasObject> expandCondition, boolean majorChildExpected, SqlLanguageDialect dialect) {
        if (child == null) {
            SqlFileImpl.$$$reportNull$$$0(44);
        }
        if (parent2 == null || parent2.getKind() == ObjectKind.ROOT) {
            return true;
        }
        Boolean res2 = cache.get(parent2);
        if (res2 != null) {
            return res2;
        }
        res2 = SqlFileImpl.isChildrenAccessible(parent2.getDasParent(), parent2, cache, expandCondition, majorChildExpected, dialect);
        if (res2.booleanValue() && !(res2 = Boolean.valueOf(expandCondition.value((Object)parent2))).booleanValue() && majorChildExpected && dialect.shouldSkipFromQualification(parent2.getKind()) && dialect.getMajorChildKinds().contains(child.getKind())) {
            res2 = true;
        }
        cache.put(parent2, res2);
        return res2;
    }

    @NotNull
    public static Condition<DasObject> importedCondition(@NotNull SqlImportState checker, @Nullable DasDataSource dataSource2) {
        if (checker == null) {
            SqlFileImpl.$$$reportNull$$$0(45);
        }
        return SqlFileImpl.importedCondition(checker, dataSource2, false);
    }

    @NotNull
    public static Condition<DasObject> importedCondition(@NotNull SqlImportState checker, @Nullable DasDataSource dataSource2, boolean includeAllTopLevelNamespaces) {
        if (checker == null) {
            SqlFileImpl.$$$reportNull$$$0(46);
        }
        DasDataSource ds = dataSource2 instanceof DbDataSource ? ((DbDataSource)dataSource2).getDelegate() : dataSource2;
        Condition condition = element2 -> {
            if (element2.getKind() == ObjectKind.ROOT) {
                return true;
            }
            if (!SqlFileImpl.hasChildren(element2)) {
                return false;
            }
            if (includeAllTopLevelNamespaces && (element2.getKind() == ObjectKind.DATABASE || element2.getKind() == ObjectKind.SCHEMA)) {
                return true;
            }
            return element2 instanceof DasNamespace && SqlDialectImplUtil.checkImports(checker, ds, element2);
        };
        if (condition == null) {
            SqlFileImpl.$$$reportNull$$$0(47);
        }
        return condition;
    }

    private static boolean hasChildren(DasObject e) {
        BasicElement unwrapped = (BasicElement)ObjectUtils.tryCast((Object)DbImplUtil.unwrap(e), BasicElement.class);
        return unwrapped == null || unwrapped.hasChildren();
    }

    public static boolean isEmptyFakeNamespace(@Nullable DasObject target) {
        return target instanceof NamespaceImpl && ((NamespaceImpl)target).delegates().isEmpty() && ((NamespaceImpl)target).children().isEmpty();
    }

    @NotNull
    public SqlResolveCache getResolveCache() {
        SqlResolveCache sqlResolveCache = (SqlResolveCache)this.myResolveCache.getValue();
        if (sqlResolveCache == null) {
            SqlFileImpl.$$$reportNull$$$0(48);
        }
        return sqlResolveCache;
    }

    @NotNull
    Couple<GroupImpl> getMirror(@NotNull SqlDefinition o) {
        if (o == null) {
            SqlFileImpl.$$$reportNull$$$0(49);
        }
        GroupImpl parent2 = ((State)this.myState.getValue()).children.get(o);
        GroupImpl delegate = ((State)this.myState.getValue()).delegates.get(o);
        if (parent2 == null && delegate == null) {
            Couple couple = Couple.getEmpty();
            if (couple == null) {
                SqlFileImpl.$$$reportNull$$$0(50);
            }
            return couple;
        }
        Couple couple = Couple.of((Object)((Object)parent2), (Object)((Object)delegate));
        if (couple == null) {
            SqlFileImpl.$$$reportNull$$$0(51);
        }
        return couple;
    }

    public static boolean isUnresolved(PsiElement target) {
        return SqlFileImpl.isFakeGroup(target) && target instanceof GroupImpl && !SqlFileImpl.isResolvedGrouping((GroupImpl)target);
    }

    private static boolean isResolvedGrouping(GroupImpl target) {
        return target instanceof NamespaceImpl || SqlImplUtil.getSqlDialectSafe((PsiElement)target.getContextElement()).shouldWrap(null, target.getKind());
    }

    public static boolean isFakeGroup(@Nullable PsiElement e) {
        return e instanceof GroupImpl && ((GroupImpl)e).delegates().isEmpty();
    }

    @Nullable
    private static SqlDialectImplUtil.ObjectTracer<?> trace(@Nullable SqlNameElement ref, @Nullable SqlDefinition def, @NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(52);
        }
        return ref == null ? null : new SqlObjectTracer(ref, def, dialect);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 47: 
            case 48: 
            case 50: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 47: 
            case 48: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 47: 
            case 48: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlFileImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 6: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 13: 
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracer";
                break;
            }
            case 37: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "traverser";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcState";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createKey";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fillParts";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "splitRef";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDeclares";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlLanguage";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "importedCondition";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveCache";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirror";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 47: 
            case 48: 
            case 50: 
            case 51: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeAt";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractInitialContext";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFake";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addDefinitionToMap";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCasedName";
                break;
            }
            case 20: 
            case 21: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "splitRef";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fillParts";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "chooseShortestPath";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processCandidateObjects";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsImpl";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isChildrenAccessible";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "importedCondition";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getMirror";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "trace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 47: 
            case 48: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PathTracer
    extends SqlDialectImplUtil.ObjectTracer<ObjectPath> {
        private final ObjectPath myPath;

        PathTracer(@NotNull ObjectPath path) {
            if (path == null) {
                PathTracer.$$$reportNull$$$0(0);
            }
            this.myPath = path;
        }

        @Override
        public SqlDialectImplUtil.ObjectTracer.ObjectTraceIt<ObjectPath> trace() {
            return new SqlDialectImplUtil.ObjectTracer.ObjectTraceIt<ObjectPath>(JBIterable.generate((Object)this.myPath, p2 -> p2.parent).iterator()){
                private ObjectPath myCurrent;

                @Override
                public ObjectPath next() {
                    this.myCurrent = (ObjectPath)super.next();
                    return this.myCurrent;
                }

                @Override
                public ObjectKind getKind() {
                    return this.myCurrent.kind;
                }

                @Override
                public String getName() {
                    return this.myCurrent.name;
                }

                @Override
                public boolean isQuoted() {
                    return this.myCurrent.isQuoted();
                }
            };
        }

        @Override
        public ObjectKind getKind() {
            return this.myPath.kind;
        }

        @Override
        public String getName() {
            return this.myPath.name;
        }

        @Override
        @Nullable
        public SqlDialectImplUtil.ObjectTracer<ObjectPath> getParent(int steps) {
            ObjectPath p2 = this.myPath.getParent(steps);
            return p2 == null ? null : new PathTracer(p2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/psi/impl/SqlFileImpl$PathTracer", "<init>"));
        }
    }

    private static class SqlObjectTracer
    extends SqlDialectImplUtil.ObjectTracer<SqlNameElement> {
        private final SqlNameElement myRef;
        private final SqlReferenceExpression myParentRef;
        private final SqlLanguageDialectEx myDialect;
        @NotNull
        private final ObjectKind myBaseKind;

        SqlObjectTracer(@NotNull SqlNameElement ref, @Nullable SqlDefinition def, @NotNull SqlLanguageDialectEx dialect) {
            if (ref == null) {
                SqlObjectTracer.$$$reportNull$$$0(0);
            }
            if (dialect == null) {
                SqlObjectTracer.$$$reportNull$$$0(1);
            }
            this.myRef = ref;
            this.myDialect = dialect;
            if (def != null) {
                this.myBaseKind = def.getKind();
                this.myParentRef = def.getParentRef();
            } else if (ref instanceof SqlReferenceExpression) {
                ObjectKind kind = ((SqlReferenceExpression)ref).getReferenceElementType().getTargetKind();
                this.myBaseKind = kind == SqlDbElementType.ANY ? ObjectKind.SCHEMA : kind;
                this.myParentRef = null;
            } else if (ref.getParent() instanceof SqlDefinition) {
                this.myBaseKind = ((SqlDefinition)ref.getParent()).getKind();
                this.myParentRef = null;
            } else {
                this.myBaseKind = ref instanceof DasObject ? ((DasObject)ref).getKind() : ObjectKind.NONE;
                this.myParentRef = null;
            }
        }

        @Override
        public SqlDialectImplUtil.ObjectTracer.ObjectTraceIt<SqlNameElement> trace() {
            return new SqlDialectImplUtil.ObjectTracer.ObjectTraceIt<SqlNameElement>((this.myParentRef != null ? JBIterable.of((Object)this.myRef).append((Iterable)((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)this.myParentRef)).filter(SqlReferenceExpression.class)) : (this.myRef instanceof SqlReferenceExpression ? ((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)this.myRef)).filter(SqlReferenceExpression.class) : JBIterable.of((Object)this.myRef))).iterator()){
                private int myLevel;
                private final List<ObjectKind> myParentTypes;
                private ObjectKind myKind;
                private String myName;
                private boolean myQuoted;
                {
                    super(it2);
                    this.myParentTypes = new SmartList();
                    this.myLevel = myRef.getLastChild() instanceof PsiErrorElement ? 1 : 0;
                    this.myKind = myBaseKind;
                    myDialect.getParentDbTypes(this.myParentTypes, this.myKind);
                }

                @Override
                public SqlNameElement next() {
                    SqlNameElement item = (SqlNameElement)super.next();
                    if (this.myLevel++ > 0) {
                        SqlReferenceExpression current = (SqlReferenceExpression)ObjectUtils.tryCast((Object)item, SqlReferenceExpression.class);
                        ObjectKind k = current != null ? current.getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
                        ObjectKind objectKind = this.myKind = k != SqlDbElementType.ANY && k != SqlDbElementType.QUERY_PARAMETER && k != ObjectKind.VARIABLE ? k : (ObjectKind)ContainerUtil.getFirstItem(this.myParentTypes, (Object)ObjectKind.NONE);
                        if (this.myKind != ObjectKind.NONE) {
                            this.myParentTypes.clear();
                            myDialect.getParentDbTypes(this.myParentTypes, this.myKind);
                        }
                    }
                    this.myName = this.myKind == ObjectKind.BODY ? "" : item.getName();
                    this.myQuoted = DbSqlUtil.isQuoted(item);
                    return item;
                }

                @Override
                public ObjectKind getKind() {
                    return this.myKind;
                }

                @Override
                public String getName() {
                    return this.myName;
                }

                @Override
                public boolean isQuoted() {
                    return this.myQuoted;
                }
            };
        }

        @Override
        public ObjectKind getKind() {
            return this.myBaseKind;
        }

        @Override
        public String getName() {
            return this.myRef.getName();
        }

        @Override
        @Nullable
        public SqlDialectImplUtil.ObjectTracer<SqlNameElement> getParent(int steps) {
            throw new UnsupportedOperationException("not implemented");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialect";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/psi/impl/SqlFileImpl$SqlObjectTracer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class State {
        final Map<DasSymbolObject, GroupImpl> children = new LinkedHashMap<DasSymbolObject, GroupImpl>();
        final Map<SqlDefinition, GroupImpl> delegates = new LinkedHashMap<SqlDefinition, GroupImpl>();
        final CasingProvider casingProvider;

        State(CasingProvider provider) {
            this.casingProvider = provider;
        }

        void seal(Map<Object, GroupImpl> mirrors) {
            Set used = JBIterable.from(this.delegates.values()).append(this.children.values()).toSet();
            Iterator<GroupImpl> it2 = mirrors.values().iterator();
            while (it2.hasNext()) {
                GroupImpl next = it2.next();
                if (next instanceof DasNamespace || used.contains((Object)next)) continue;
                it2.remove();
            }
        }

        JBIterable<DasSymbolObject> children(GroupImpl o) {
            return this.forMirror(o, this.children);
        }

        JBIterable<SqlDefinition> delegates(GroupImpl o) {
            return this.forMirror(o, this.delegates);
        }

        <T> JBIterable<T> forMirror(GroupImpl group, Map<T, GroupImpl> map2) {
            return JBIterable.from(map2.entrySet()).filter(entry -> entry.getValue() == group).transform(Map.Entry::getKey);
        }
    }

    private class NamespaceImpl
    extends GroupImpl
    implements DasNamespace {
        NamespaceImpl(@NotNull GroupImpl parent2, @Nullable String name, @NotNull String originalName, ObjectKind kind, boolean quoted) {
            if (name == null) {
                NamespaceImpl.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                NamespaceImpl.$$$reportNull$$$0(1);
            }
            super(parent2, name, originalName, kind, quoted);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/psi/impl/SqlFileImpl$NamespaceImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class GroupImpl
    extends DasVirtualSymbol
    implements DasScopeAware {
        @NotNull
        private final ObjectKind myKind;
        @Nullable
        private final GroupImpl myParent;
        private final boolean myQuoted;
        @Nullable
        private final String myOriginalName;

        GroupImpl(@NotNull GroupImpl parent2, @Nullable String name, @NotNull String originalName, ObjectKind kind, boolean quoted) {
            if (name == null) {
                GroupImpl.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                GroupImpl.$$$reportNull$$$0(1);
            }
            super(name, (SqlElement)SqlFileImpl.this);
            this.myParent = parent2;
            this.myKind = kind;
            this.myQuoted = quoted;
            this.myOriginalName = originalName;
        }

        @Override
        @NotNull
        public JBIterable<? extends PsiElement> getPsiDeclarations() {
            JBIterable<SqlDefinition> jBIterable = this.delegates();
            if (jBIterable == null) {
                GroupImpl.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        @Nullable
        public DasObject getDasParent() {
            return this.myParent;
        }

        @NotNull
        public JBIterable<DasObject> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = JBIterable.empty().append(this.children()).append(this.delegates(), o -> o.getDasChildren(null).filter(PsiObject.class)).filter(DasUtil.byKind((ObjectKind)kind));
            if (jBIterable == null) {
                GroupImpl.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        public String getOriginalName() {
            SqlDefinition o = (SqlDefinition)this.delegates().first();
            return o != null ? o.getName() : this.myOriginalName;
        }

        @Override
        public boolean isQuoted() {
            return this.myQuoted;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = this.myKind;
            if (objectKind == null) {
                GroupImpl.$$$reportNull$$$0(4);
            }
            return objectKind;
        }

        @Override
        @Nullable
        public PsiElement getNavigationElement() {
            PsiElement element2 = super.getNavigationElement();
            if (element2 != null) {
                return element2;
            }
            PsiElement child = DasSymbolUtil.getSinglePsiSource((DasSymbol)this.children().first());
            return child != null ? child.getNavigationElement() : null;
        }

        public boolean processDeclarations(@NotNull DasScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                GroupImpl.$$$reportNull$$$0(5);
            }
            if (state == null) {
                GroupImpl.$$$reportNull$$$0(6);
            }
            if (place == null) {
                GroupImpl.$$$reportNull$$$0(7);
            }
            if (!(processor instanceof SqlScopeProcessor)) {
                return true;
            }
            Condition<DasObject> importedCondition = SqlFileImpl.importedCondition(SqlDialectImplUtil.getImportCheckerAt(SqlFileImpl.this, place), null);
            return SqlFileImpl.processDeclarationsImpl((SqlScopeProcessor)processor, state, (DasSymbol)this, (Condition<? super DasObject>)((Condition)o -> o == this || importedCondition.value(o)), false);
        }

        public JBIterable<SqlDefinition> delegates() {
            SqlFileImpl file = (SqlFileImpl)((Object)ObjectUtils.tryCast((Object)SqlFileImpl.this.getContainingFile(), SqlFileImpl.class));
            return file == null ? JBIterable.empty() : ((State)file.myState.getValue()).delegates(this);
        }

        public JBIterable<DasSymbolObject> children() {
            SqlFileImpl file = (SqlFileImpl)((Object)ObjectUtils.tryCast((Object)SqlFileImpl.this.getContainingFile(), SqlFileImpl.class));
            return file == null ? JBIterable.empty() : ((State)file.myState.getValue()).children(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiDeclarations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processDeclarations";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class FakeDefinition
    extends RenameableFakePsiElement
    implements SqlDefinition,
    SqlNameElement {
        private String myName;

        protected FakeDefinition(@NotNull PsiElement parent2, @NotNull String name) {
            if (parent2 == null) {
                FakeDefinition.$$$reportNull$$$0(0);
            }
            if (name == null) {
                FakeDefinition.$$$reportNull$$$0(1);
            }
            super(parent2);
            this.myName = name;
        }

        public boolean isPlainIdentifier() {
            return !this.isQuotedIdentifier();
        }

        public boolean isQuotedIdentifier() {
            return this.isNameQuoted();
        }

        public SqlFile getContainingFile() {
            return (SqlFile)super.getContainingFile();
        }

        @Nullable
        public TextRange getTextRange() {
            PsiElement element2 = this.getNavigationElement();
            return element2 != this ? element2.getTextRange() : super.getTextRange();
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                FakeDefinition.$$$reportNull$$$0(2);
            }
            return string;
        }

        public FakeDefinition setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                FakeDefinition.$$$reportNull$$$0(3);
            }
            this.myName = name;
            return this;
        }

        public String getTypeName() {
            return SqlElementDescriptionProvider.getKindName(this);
        }

        public Icon getIcon() {
            return DbPresentation.getIcon((DasObject)this);
        }

        public void accept(SqlVisitor visitor2) {
            visitor2.visitSqlElement((SqlElement)this);
        }

        public void acceptChildren(SqlVisitor visitor2) {
            SqlImplUtil.acceptChildren((SqlElement)this, visitor2);
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return this;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getNameElement();
        }

        @Nullable
        public DasObject getDasParent() {
            PsiElement parent2 = this.getParent();
            return parent2 instanceof DasObject ? (DasObject)parent2 : null;
        }

        public boolean isEquivalentTo(PsiElement another) {
            return this.equals(another);
        }

        public boolean equals(Object another) {
            return ((Object)((Object)this)).getClass() == another.getClass() && this.myName.equals(((FakeDefinition)((Object)another)).myName) && this.getParent().equals(((PsiElement)another).getParent());
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = result * 31 + this.getParent().hashCode();
            return result;
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = SqlImplUtil.getSqlDialectDbms(this.getParent());
            if (dbms == null) {
                FakeDefinition.$$$reportNull$$$0(4);
            }
            return dbms;
        }

        public String toString() {
            return this.getKind() + ":" + this.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

