/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.psi.stubs.SqlLazyParseablePsiElement;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlColumnAliasListImpl
extends SqlLazyParseablePsiElement
implements SqlCompositeElement {
    public SqlColumnAliasListImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlColumnAliasListImpl.$$$reportNull$$$0(0);
        }
        super(elementType, null);
    }

    public SqlColumnAliasListImpl(@NotNull IElementType elementType, @Nullable CharSequence buffer) {
        if (elementType == null) {
            SqlColumnAliasListImpl.$$$reportNull$$$0(1);
        }
        super(elementType, buffer);
    }

    @NotNull
    public List<SqlDefinition> getColumnAliasList() {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, SqlTypedDefinition.class);
        if (list == null) {
            SqlColumnAliasListImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public SqlType getAliasedSqlType(@NotNull SqlDefinition alias) {
        int aliasIndex;
        if (alias == null) {
            SqlColumnAliasListImpl.$$$reportNull$$$0(3);
        }
        if ((aliasIndex = this.getColumnAliasList().indexOf(alias)) == -1) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlColumnAliasListImpl.$$$reportNull$$$0(4);
            }
            return sqlPrimitiveType;
        }
        PsiElement parent2 = this.getParent();
        SqlExpression expression = null;
        if (parent2 instanceof SqlTableDefinition) {
            expression = ((SqlTableDefinition)parent2).getQueryExpression();
        } else if (parent2 instanceof SqlAsExpression) {
            expression = ((SqlAsExpression)parent2).getExpression();
        }
        Object object = expression == null ? SqlType.UNKNOWN : this.getColumnType(expression, aliasIndex);
        if (object == null) {
            SqlColumnAliasListImpl.$$$reportNull$$$0(5);
        }
        return object;
    }

    @NotNull
    public SqlType getColumnType(@Nullable SqlExpression expression, int columnIndex) {
        if (expression == null) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlColumnAliasListImpl.$$$reportNull$$$0(6);
            }
            return sqlPrimitiveType;
        }
        SqlType type = expression.getSqlType();
        SqlTableType tableType = (SqlTableType)ObjectUtils.tryCast((Object)type, SqlTableType.class);
        if (tableType != null) {
            Object object = columnIndex < tableType.getColumnCount() ? tableType.getColumnType(columnIndex) : SqlType.UNKNOWN;
            if (object == null) {
                SqlColumnAliasListImpl.$$$reportNull$$$0(7);
            }
            return object;
        }
        Object object = columnIndex == 0 ? type : SqlType.UNKNOWN;
        if (object == null) {
            SqlColumnAliasListImpl.$$$reportNull$$$0(8);
        }
        return object;
    }

    @Nullable
    public SqlTableType getSqlType(@NotNull PsiElement qualifier) {
        ArrayList columns;
        if (qualifier == null) {
            SqlColumnAliasListImpl.$$$reportNull$$$0(9);
        }
        if (SqlFunctionCallExpressionImpl.collectColumnDefs(columns = new ArrayList(), (PsiElement)this, SqlColumnAliasDefinition.class)) {
            return new TableBasedSqlTableTypeImpl(columns, qualifier);
        }
        return null;
    }

    public String toString() {
        return this.getElementType().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlColumnAliasListImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlColumnAliasListImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAliasList";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasedSqlType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAliasedSqlType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

