/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlArrayType
extends SqlType {
    @NotNull
    private final SqlType myInnerType;
    private final int myDepth;

    private SqlArrayType(@NotNull SqlType type, int depth) {
        if (type == null) {
            SqlArrayType.$$$reportNull$$$0(0);
        }
        this.myInnerType = type;
        this.myDepth = depth;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myInnerType.getDisplayName() + StringUtil.repeat((String)"[]", (int)this.myDepth);
        if (string == null) {
            SqlArrayType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public SqlType.Category getCategory() {
        SqlType.Category category = SqlType.Category.ARRAY;
        if (category == null) {
            SqlArrayType.$$$reportNull$$$0(2);
        }
        return category;
    }

    @NotNull
    public DataType getDataType() {
        DataType dataType = SqlImplUtil.getArrayTypeOf(this.myInnerType.getDataType());
        if (dataType == null) {
            SqlArrayType.$$$reportNull$$$0(3);
        }
        return dataType;
    }

    @NotNull
    public SqlType getElementType() {
        SqlArrayType sqlArrayType = this.myDepth > 1 ? new SqlArrayType(this.myInnerType, this.myDepth - 1) : this.myInnerType;
        if (sqlArrayType == null) {
            SqlArrayType.$$$reportNull$$$0(4);
        }
        return sqlArrayType;
    }

    @NotNull
    public SqlType getInnerType() {
        SqlType sqlType = this.myInnerType;
        if (sqlType == null) {
            SqlArrayType.$$$reportNull$$$0(5);
        }
        return sqlType;
    }

    public int getDepth() {
        return this.myDepth;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static SqlArrayType of(@Nullable SqlType elementType) {
        return SqlArrayType.of(elementType, 1);
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static SqlArrayType of(@Nullable SqlType elementType, int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException("Invalid array depth: " + depth);
        }
        if (elementType == null) {
            return null;
        }
        if (elementType instanceof SqlArrayType) {
            SqlArrayType arrayType = (SqlArrayType)elementType;
            return new SqlArrayType(arrayType.myInnerType, arrayType.myDepth + depth);
        }
        return new SqlArrayType(elementType, depth);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlArrayType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlArrayType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

