/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.FileIntPropertyPusher;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlDialectPusher
implements FileIntPropertyPusher<SqlLanguageDialect> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("sql_dialect", 2, true);

    @NotNull
    public Key<SqlLanguageDialect> getFileDataKey() {
        Key<SqlLanguageDialect> key = SqlDialectMappings.SQL_DIALECT_KEY;
        if (key == null) {
            SqlDialectPusher.$$$reportNull$$$0(0);
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    private static FileType getFileType(VirtualFile file) {
        return FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence());
    }

    @NotNull
    public SqlLanguageDialect getDefaultValue() {
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getDefaultSqlDialect();
        if (sqlLanguageDialect == null) {
            SqlDialectPusher.$$$reportNull$$$0(1);
        }
        return sqlLanguageDialect;
    }

    public SqlLanguageDialect getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        LocalDataSource source;
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(2);
        }
        if (DbSrcUtils.isDbSrcFile(file) && (source = DbSrcUtils.findDataSource(file)) != null) {
            return DbSqlUtil.getSqlDialect(source);
        }
        return (SqlLanguageDialect)SqlDialectMappings.getInstance(project).getImmediateMapping(file);
    }

    public SqlLanguageDialect getImmediateValue(@NotNull Module module) {
        if (module == null) {
            SqlDialectPusher.$$$reportNull$$$0(3);
        }
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SqlDialectPusher.$$$reportNull$$$0(4);
        }
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(5);
        }
        return SqlFileType.INSTANCE.equals(SqlDialectPusher.getFileType(file));
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SqlDialectPusher.$$$reportNull$$$0(6);
        }
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(7);
        }
        return true;
    }

    @NotNull
    public FileAttribute getAttribute() {
        FileAttribute fileAttribute = PERSISTENCE;
        if (fileAttribute == null) {
            SqlDialectPusher.$$$reportNull$$$0(8);
        }
        return fileAttribute;
    }

    public int toInt(@NotNull SqlLanguageDialect property) throws IOException {
        if (property == null) {
            SqlDialectPusher.$$$reportNull$$$0(9);
        }
        return DbImplUtil.enumerateDialectName(property.getID());
    }

    @NotNull
    public SqlLanguageDialect fromInt(int val) throws IOException {
        SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)SqlLanguageDialect.findLanguageByID((String)DbImplUtil.getDialectName(val));
        if (sqlLanguageDialect == null) {
            SqlDialectPusher.$$$reportNull$$$0(10);
        }
        return sqlLanguageDialect;
    }

    public void propertyChanged(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull SqlLanguageDialect actualProperty) {
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(11);
        }
        if (fileOrDir == null) {
            SqlDialectPusher.$$$reportNull$$$0(12);
        }
        if (actualProperty == null) {
            SqlDialectPusher.$$$reportNull$$$0(13);
        }
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, file -> this.acceptsFile((VirtualFile)file, project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/SqlDialectPusher";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/SqlDialectPusher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttribute";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fromInt";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toInt";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

