/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.Query;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u000eH\u0002J\u0012\u0010\u0014\u001a\f0\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u0017H\u0017J!\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u000eH\u0096\u0002J \u0010\u001a\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u000eH\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/sql/intentions/SqlIntroduceTableAliasIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "collectItemsToQualify", "", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "element", "Lcom/intellij/database/model/PsiTable;", "searchScope", "Lcom/intellij/psi/search/LocalSearchScope;", "topSqlExpression", "Lcom/intellij/sql/psi/SqlResultSetExpression;", "doInvoke", "", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "findReference", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "isAvailable", "startInWriteAction", "Companion", "intellij.database.sql.impl"})
public final class SqlIntroduceTableAliasIntention
extends SqlBaseElementAtCaretIntentionAction {
    public static final Companion Companion = new Companion(null);

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("introduce.table.alias", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"introduce.table.alias\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.findReference(element2) != null;
    }

    private final SqlReferenceExpression findReference(PsiElement element2) {
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlReferenceExpression.class);
        if (sqlReferenceExpression == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceExpression, (String)"PsiTreeUtil.getParentOfT\u2026lass.java) ?: return null");
        SqlReferenceExpression reference = sqlReferenceExpression;
        if (reference.getReferenceElementType() != SqlCompositeElementTypes.SQL_TABLE_REFERENCE) {
            return null;
        }
        if (!(reference.resolve() instanceof DasTable)) {
            return null;
        }
        PsiElement parent2 = reference.getParent();
        if (parent2 instanceof SqlReferenceExpression || parent2 instanceof SqlAsExpression || parent2 instanceof SqlTableColumnsList) {
            return null;
        }
        return reference;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            PsiFile file = element2.getContainingFile();
            if (!((Boolean)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Boolean>(this, element2, editor, project){
                final /* synthetic */ SqlIntroduceTableAliasIntention this$0;
                final /* synthetic */ PsiElement $element;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ Project $project;

                public final Boolean compute() {
                    return SqlIntroduceTableAliasIntention.access$doInvoke(this.this$0, this.$element, this.$editor, this.$project);
                }
                {
                    this.this$0 = sqlIntroduceTableAliasIntention;
                    this.$element = psiElement;
                    this.$editor = editor;
                    this.$project = project;
                }
            })).booleanValue()) {
                return;
            }
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance(\u2026Context(editor.component)");
            DataContext dataContext2 = dataContext;
            RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext2);
            if (renameHandler == null) break block1;
            renameHandler.invoke(project, editor, file, dataContext2);
        }
    }

    private final boolean doInvoke(PsiElement element2, Editor editor, Project project) {
        SqlReferenceExpression reference = this.findReference(element2);
        if (reference == null) {
            return false;
        }
        PsiElement psiElement = reference.resolve();
        if (!(psiElement instanceof PsiTable)) {
            psiElement = null;
        }
        PsiTable psiTable = (PsiTable)psiElement;
        if (psiTable == null) {
            return false;
        }
        PsiTable target = psiTable;
        SqlResultSetExpression topSqlExpression = Companion.getTopExpression((SqlExpression)reference, (PsiElement)target);
        if (topSqlExpression == null) {
            return false;
        }
        String string = SqlNamesGenerator.suggestAliasName(reference.getName(), (PsiElement)reference);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlNamesGenerator.sugges\u2026eference.name, reference)");
        String aliasName = string;
        ArrayList<PsiElement> toReplace = new ArrayList<PsiElement>();
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)topSqlExpression);
        Query query = ReferencesSearch.search((PsiElement)((PsiElement)target), (SearchScope)((SearchScope)searchScope));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ReferencesSearch.search(target, searchScope)");
        Iterable $this$forEach$iv = (Iterable)query;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement psiElement2;
            PsiReference psiReference = (PsiReference)element$iv;
            boolean bl = false;
            PsiReference psiReference2 = psiReference;
            Intrinsics.checkNotNullExpressionValue((Object)psiReference2, (String)"it");
            Intrinsics.checkNotNullExpressionValue((Object)psiReference2.getElement(), (String)"it.element");
            if (Intrinsics.areEqual((Object)psiElement2, (Object)reference)) continue;
            if (!(psiElement2 instanceof SqlReferenceExpression)) {
                return false;
            }
            if (Companion.getTopExpression((SqlExpression)psiElement2, (PsiElement)target) != topSqlExpression) continue;
            toReplace.add(psiElement2);
        }
        List<SqlReferenceExpression> toQualify = this.collectItemsToQualify(target, searchScope, topSqlExpression);
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)reference);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(reference)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        SqlExpression sqlExpression = SqlPsiElementFactory.createTableAliasFromText(reference.getText() + " " + aliasName, dialect, (PsiElement)reference);
        Intrinsics.checkNotNull((Object)sqlExpression);
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"SqlPsiElementFactory.cre\u2026me, dialect, reference)!!");
        SqlExpression expression = sqlExpression;
        PsiElement newExpression = reference.replace((PsiElement)expression);
        for (SqlReferenceExpression sqlReferenceExpression : toReplace) {
            SqlLanguageDialect sqlLanguageDialect = dialect;
            SqlReferenceExpression sqlReferenceExpression2 = sqlReferenceExpression;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceExpression2, (String)"referenceExpression");
            SqlReferenceExpression sqlReferenceExpression3 = SqlPsiElementFactory.createReferenceFromText(aliasName, sqlLanguageDialect, sqlReferenceExpression2.getReferenceElementType(), (PsiElement)sqlReferenceExpression);
            Intrinsics.checkNotNull((Object)sqlReferenceExpression3);
            sqlReferenceExpression.replace((PsiElement)sqlReferenceExpression3);
        }
        for (SqlReferenceExpression sqlReferenceExpression : toQualify) {
            SqlReferenceExpression sqlReferenceExpression4 = SqlPsiElementFactory.createReferenceFromText(aliasName + "." + sqlReferenceExpression.getText(), dialect, sqlReferenceExpression.getReferenceElementType(), (PsiElement)sqlReferenceExpression);
            Intrinsics.checkNotNull((Object)sqlReferenceExpression4);
            sqlReferenceExpression.replace((PsiElement)sqlReferenceExpression4);
        }
        CaretModel caretModel = editor.getCaretModel();
        PsiElement psiElement2 = newExpression;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"newExpression");
        TextRange textRange = psiElement2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"newExpression.textRange");
        caretModel.moveToOffset(textRange.getEndOffset());
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(editor.getDocument());
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(editor.getDocument());
        return true;
    }

    private final List<SqlReferenceExpression> collectItemsToQualify(PsiTable element2, LocalSearchScope searchScope, SqlResultSetExpression topSqlExpression) {
        SqlEditorOptions sqlEditorOptions = SqlEditorOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)sqlEditorOptions, (String)"SqlEditorOptions.getInstance()");
        SqlEditorOptions.QualificationType qualificationType = sqlEditorOptions.getAliasQualification();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)qualificationType), (String)"SqlEditorOptions.getInstance().aliasQualification");
        SqlEditorOptions.QualificationType aliasQualification = qualificationType;
        if (aliasQualification != SqlEditorOptions.QualificationType.ALWAYS) {
            return CollectionsKt.emptyList();
        }
        ArrayList<PsiElement> toQualify = new ArrayList<PsiElement>();
        PsiTable psiTable = element2;
        if (!(psiTable instanceof DbTable)) {
            psiTable = null;
        }
        DbTable dbTable = (DbTable)psiTable;
        Object object = dbTable != null ? dbTable.getDataSource() : null;
        if (!(object instanceof DbDataSourceImpl)) {
            object = null;
        }
        DbDataSourceImpl dataSourceImpl = (DbDataSourceImpl)((Object)object);
        for (DasColumn column2 : DasUtil.getColumns((DasObject)((DasObject)element2))) {
            PsiObject col;
            PsiObject psiObject;
            DasColumn dasColumn = column2;
            if (!(dasColumn instanceof PsiColumn)) {
                dasColumn = null;
            }
            PsiColumn psiColumn = (PsiColumn)dasColumn;
            if (psiColumn != null) {
                psiObject = (PsiObject)psiColumn;
            } else {
                DbDataSourceImpl dbDataSourceImpl = dataSourceImpl;
                psiObject = col = (PsiObject)(dbDataSourceImpl != null ? dbDataSourceImpl.findElement((DasObject)column2) : null);
            }
            if (col == null) continue;
            Query query = ReferencesSearch.search((PsiElement)((PsiElement)col), (SearchScope)((SearchScope)searchScope));
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ReferencesSearch.search(col, searchScope)");
            Iterable $this$forEach$iv = (Iterable)query;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement psiElement;
                PsiReference it2 = (PsiReference)element$iv;
                boolean bl = false;
                PsiReference psiReference = it2;
                Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"it");
                Intrinsics.checkNotNullExpressionValue((Object)psiReference.getElement(), (String)"it.element");
                if (!(psiElement instanceof SqlReferenceExpression) || ((SqlReferenceExpression)psiElement).getQualifierExpression() != null || ((SqlReferenceExpression)psiElement).getReferenceElementType() != SqlCompositeElementTypes.SQL_COLUMN_REFERENCE || Companion.getTopExpression((SqlExpression)psiElement, (PsiElement)element2) != topSqlExpression) continue;
                toQualify.add(psiElement);
            }
        }
        return toQualify;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static final /* synthetic */ boolean access$doInvoke(SqlIntroduceTableAliasIntention $this, PsiElement element2, Editor editor, Project project) {
        return $this.doInvoke(element2, editor, project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/intentions/SqlIntroduceTableAliasIntention$Companion;", "", "()V", "getTopExpression", "Lcom/intellij/sql/psi/SqlResultSetExpression;", "reference", "Lcom/intellij/sql/psi/SqlExpression;", "table", "Lcom/intellij/psi/PsiElement;", "isCorrelatedQuery", "", "expression", "resolveTable", "tableExpression", "Lcom/intellij/sql/psi/SqlTableExpression;", "intellij.database.sql.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final SqlResultSetExpression getTopExpression(@Nullable SqlExpression reference, @Nullable PsiElement table) {
            void sqlExpression;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = (SqlResultSetExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)reference), SqlResultSetExpression.class);
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            objectRef2.element = null;
            if ((SqlResultSetExpression)sqlExpression.element != null && (!(((SqlResultSetExpression)sqlExpression.element).getParent() instanceof SqlParenthesizedExpression) || this.isCorrelatedQuery((SqlResultSetExpression)sqlExpression.element, table))) {
                void parentParent;
                while (((Function0)new Function0<SqlResultSetExpression>((Ref.ObjectRef)parentParent, (Ref.ObjectRef)sqlExpression){
                    final /* synthetic */ Ref.ObjectRef $parentParent;
                    final /* synthetic */ Ref.ObjectRef $sqlExpression;

                    @Nullable
                    public final SqlResultSetExpression invoke() {
                        this.$parentParent.element = (SqlResultSetExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)((SqlResultSetExpression)this.$sqlExpression.element)), SqlResultSetExpression.class);
                        return (SqlResultSetExpression)this.$parentParent.element;
                    }
                    {
                        this.$parentParent = objectRef;
                        this.$sqlExpression = objectRef2;
                        super(0);
                    }
                }).invoke() != null && !((SqlResultSetExpression)parentParent.element instanceof SqlNAryExpression)) {
                    sqlExpression.element = (SqlResultSetExpression)parentParent.element;
                    if ((SqlResultSetExpression)parentParent.element == null) break;
                    SqlResultSetExpression sqlResultSetExpression = (SqlResultSetExpression)parentParent.element;
                    Intrinsics.checkNotNull((Object)sqlResultSetExpression);
                    if (this.isCorrelatedQuery(sqlResultSetExpression, table)) continue;
                    SqlResultSetExpression sqlResultSetExpression2 = (SqlResultSetExpression)parentParent.element;
                    if (!((sqlResultSetExpression2 != null ? sqlResultSetExpression2.getParent() : null) instanceof SqlParenthesizedExpression)) continue;
                    break;
                }
            }
            return (SqlResultSetExpression)sqlExpression.element;
        }

        public final boolean isCorrelatedQuery(@NotNull SqlResultSetExpression expression, @Nullable PsiElement table) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (!(expression instanceof SqlQueryExpression)) {
                return false;
            }
            PsiElement queryTable = this.resolveTable(((SqlQueryExpression)expression).getTableExpression());
            return queryTable == null || Intrinsics.areEqual((Object)table, (Object)queryTable) ^ true;
        }

        @Nullable
        public final PsiElement resolveTable(@Nullable SqlTableExpression tableExpression) {
            SqlExpression fromExpression;
            SqlTableExpression sqlTableExpression = tableExpression;
            SqlExpression sqlExpression = sqlTableExpression != null && (sqlTableExpression = sqlTableExpression.getFromClause()) != null ? sqlTableExpression.getFromExpression() : (fromExpression = null);
            if (fromExpression == null) {
                return null;
            }
            if (fromExpression instanceof SqlAsExpression) {
                fromExpression = ((SqlAsExpression)fromExpression).getExpression();
            }
            if (!(fromExpression instanceof SqlReferenceExpression)) {
                return null;
            }
            PsiElement possiblyTable = ((SqlReferenceExpression)fromExpression).resolve();
            return possiblyTable;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

