/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.model.PsiTable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.SqlIntroduceTableAliasIntention;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.Query;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0017J!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/intentions/SqlInlineTableAliasIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "findAsExpression", "Lcom/intellij/sql/psi/SqlAsExpression;", "element", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "asExpression", "isAvailable", "", "isSuitable", "intellij.database.sql.impl"})
public final class SqlInlineTableAliasIntention
extends SqlBaseElementAtCaretIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("inline.table.alias", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inline.table.alias\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.isSuitable(this.findAsExpression(element2));
    }

    public final boolean isSuitable(@Nullable SqlAsExpression asExpression) {
        if (asExpression == null || !(asExpression.getExpression() instanceof SqlReferenceExpression)) {
            return false;
        }
        SqlExpression sqlExpression = asExpression.getExpression();
        if (sqlExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        }
        PsiElement element2 = ((SqlReferenceExpression)sqlExpression).resolve();
        if (!(element2 instanceof PsiTable)) {
            return false;
        }
        SqlResultSetExpression topExpression = SqlIntroduceTableAliasIntention.Companion.getTopExpression((SqlExpression)asExpression, element2);
        if (topExpression == null) {
            return false;
        }
        SqlExpression sqlExpression2 = asExpression.getExpression();
        if (sqlExpression2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        }
        return !SqlNamesGenerator.collectExistingNames((PsiElement)topExpression, (Condition<? super PsiElement>)((Condition)new Condition<PsiElement>(asExpression){
            final /* synthetic */ SqlAsExpression $asExpression;

            public final boolean value(PsiElement it2) {
                if (Intrinsics.areEqual((Object)it2, (Object)this.$asExpression)) {
                    return true;
                }
                if (it2 instanceof SqlNameElement && Intrinsics.areEqual((Object)((SqlDefinition)PsiTreeUtil.getParentOfType((PsiElement)it2, SqlDefinition.class)), (Object)this.$asExpression)) {
                    return true;
                }
                return it2 instanceof SqlReferenceExpression;
            }
            {
                this.$asExpression = sqlAsExpression;
            }
        })).contains(((SqlReferenceExpression)sqlExpression2).getName());
    }

    private final SqlAsExpression findAsExpression(PsiElement element2) {
        Object object;
        SqlAsExpression sqlAsExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlAsExpression.class);
        if (sqlAsExpression != null) {
            SqlAsExpression sqlAsExpression2 = sqlAsExpression;
            boolean bl = false;
            boolean bl2 = false;
            SqlAsExpression it2 = sqlAsExpression2;
            boolean bl3 = false;
            SqlAsExpression sqlAsExpression3 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)sqlAsExpression3, (String)"it");
            object = PsiTreeUtil.isAncestor((PsiElement)((PsiElement)sqlAsExpression3.getNameElement()), (PsiElement)element2, (boolean)false) ? sqlAsExpression2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlAsExpression sqlAsExpression = this.findAsExpression(element2);
        Intrinsics.checkNotNull((Object)sqlAsExpression);
        this.invoke(sqlAsExpression);
    }

    public final void invoke(@NotNull SqlAsExpression asExpression) {
        Intrinsics.checkNotNullParameter((Object)asExpression, (String)"asExpression");
        SqlExpression sqlExpression = asExpression.getExpression();
        if (sqlExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        }
        PsiElement psiElement = ((SqlReferenceExpression)sqlExpression).resolve();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.model.PsiTable");
        }
        PsiTable psiTable = (PsiTable)psiElement;
        SqlResultSetExpression sqlResultSetExpression = SqlIntroduceTableAliasIntention.Companion.getTopExpression((SqlExpression)asExpression, (PsiElement)psiTable);
        Intrinsics.checkNotNull((Object)sqlResultSetExpression);
        SqlResultSetExpression topExpression = sqlResultSetExpression;
        SqlExpression sqlExpression2 = asExpression.getExpression();
        if (sqlExpression2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        }
        SqlReferenceExpression expression = (SqlReferenceExpression)sqlExpression2;
        String text2 = expression.getText();
        SqlEditorOptions sqlEditorOptions = SqlEditorOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)sqlEditorOptions, (String)"SqlEditorOptions.getInstance()");
        SqlEditorOptions.QualificationType qualificationType = sqlEditorOptions.getTableQualification();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)qualificationType), (String)"SqlEditorOptions.getInstance().tableQualification");
        SqlEditorOptions.QualificationType tableQualification = qualificationType;
        Query query = ReferencesSearch.search((PsiElement)((PsiElement)asExpression), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)topExpression)));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ReferencesSearch.search(\u2026archScope(topExpression))");
        Iterable $this$forEach$iv = (Iterable)query;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlReferenceExpression referenceFromText;
            PsiElement psiElement2;
            PsiReference it2 = (PsiReference)element$iv;
            boolean bl = false;
            PsiReference psiReference = it2;
            Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"it");
            Intrinsics.checkNotNullExpressionValue((Object)psiReference.getElement(), (String)"it.element");
            if (!(psiElement2 instanceof SqlReferenceExpression)) continue;
            PsiElement parent2 = ((SqlReferenceExpression)psiElement2).getParent();
            if (parent2 instanceof SqlReferenceExpression && Intrinsics.areEqual((Object)((SqlReferenceExpression)parent2).getQualifierExpression(), (Object)psiElement2) && tableQualification != SqlEditorOptions.QualificationType.ALWAYS) {
                SqlIdentifier sqlIdentifier = ((SqlReferenceExpression)parent2).getIdentifier();
                String name = sqlIdentifier != null ? sqlIdentifier.getText() : null;
                SqlResultSetExpression top = SqlIntroduceTableAliasIntention.Companion.getTopExpression((SqlExpression)parent2, (PsiElement)psiTable);
                if (name != null && top != null && !SqlNamesGenerator.collectExistingNames((PsiElement)top, (Condition<? super PsiElement>)((Condition)new Condition<PsiElement>(tableQualification, psiTable, asExpression, text2){
                    final /* synthetic */ SqlEditorOptions.QualificationType $tableQualification$inlined;
                    final /* synthetic */ PsiTable $psiTable$inlined;
                    final /* synthetic */ SqlAsExpression $asExpression$inlined;
                    final /* synthetic */ String $text$inlined;
                    {
                        this.$tableQualification$inlined = qualificationType;
                        this.$psiTable$inlined = psiTable;
                        this.$asExpression$inlined = sqlAsExpression;
                        this.$text$inlined = string;
                    }

                    public final boolean value(PsiElement node) {
                        PsiElement resolved;
                        SqlExpression qualifierExpression;
                        return node instanceof SqlReferenceExpression && (qualifierExpression = ((SqlReferenceExpression)node).getQualifierExpression()) instanceof SqlReferenceExpression && Intrinsics.areEqual((Object)(resolved = ((SqlReferenceExpression)qualifierExpression).resolve()), (Object)this.$asExpression$inlined);
                    }
                })).contains(name)) {
                    SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText(name, SqlImplUtil.getSqlDialectSafe(psiElement2), ((SqlReferenceExpression)psiElement2).getReferenceElementType(), psiElement2);
                    Intrinsics.checkNotNull((Object)sqlReferenceExpression);
                    parent2.replace((PsiElement)sqlReferenceExpression);
                    continue;
                }
            }
            Intrinsics.checkNotNull((Object)SqlPsiElementFactory.createReferenceFromText(text2, SqlImplUtil.getSqlDialectSafe(psiElement2), ((SqlReferenceExpression)psiElement2).getReferenceElementType(), psiElement2));
            Intrinsics.checkNotNullExpressionValue((Object)referenceFromText, (String)"SqlPsiElementFactory.cre\u2026lementType, psiElement)!!");
            psiElement2.replace((PsiElement)referenceFromText);
        }
        SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText(text2, SqlImplUtil.getSqlDialectSafe((PsiElement)asExpression), expression.getReferenceElementType(), (PsiElement)asExpression);
        Intrinsics.checkNotNull((Object)sqlReferenceExpression);
        asExpression.replace((PsiElement)sqlReferenceExpression);
    }
}

