/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u0006\u001a\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J#\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0014\u001a\u00020\u00132\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/intentions/SqlFlipExpressionIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getCommutingOperator", "Lcom/intellij/psi/tree/IElementType;", "opType", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "isCommutative", "left", "Lcom/intellij/sql/psi/SqlExpression;", "right", "Companion", "intellij.database.sql.impl"})
public final class SqlFlipExpressionIntention
extends SqlBaseElementAtCaretIntentionAction {
    private static final TokenSet COMMUTATIVE_OPERATOR_TYPES;
    public static final Companion Companion;

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.flip.expression.operands", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026lip.expression.operands\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlBinaryExpression sqlBinaryExpression = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlBinaryExpression.class);
        if (sqlBinaryExpression == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlBinaryExpression, (String)"PsiTreeUtil.getParentOfT\u2026ass.java) ?: return false");
        SqlBinaryExpression expression = sqlBinaryExpression;
        SqlExpression sqlExpression = expression.getLOperand();
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"expression.lOperand");
        SqlExpression left = sqlExpression;
        SqlExpression sqlExpression2 = expression.getROperand();
        if (sqlExpression2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression2, (String)"expression.rOperand ?: return false");
        SqlExpression right = sqlExpression2;
        PsiElement psiElement = expression.getOpSignElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.opSignElement");
        PsiElement opElement = psiElement;
        IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)opElement);
        if (iElementType == null) {
            return false;
        }
        IElementType op = iElementType;
        this.setText(SqlBundle.message("flip.0.1.choice.0.may.change.semantics.1", opElement.getText(), !this.isCommutative(op, left, right) && this.getCommutingOperator(op) == null ? 0 : 1));
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlBinaryExpression sqlBinaryExpression = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlBinaryExpression.class);
        if (sqlBinaryExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlBinaryExpression, (String)"PsiTreeUtil.getParentOfT\u2026on::class.java) ?: return");
        SqlBinaryExpression expression = sqlBinaryExpression;
        SqlExpression sqlExpression = expression.getLOperand();
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"expression.lOperand");
        SqlExpression left = sqlExpression;
        SqlExpression sqlExpression2 = expression.getROperand();
        if (sqlExpression2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression2, (String)"expression.rOperand ?: return");
        SqlExpression right = sqlExpression2;
        PsiElement psiElement = expression.getOpSignElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.opSignElement");
        PsiElement op = psiElement;
        IElementType dualOp = this.getCommutingOperator(PsiTreeUtilKt.getElementType((PsiElement)op));
        if (dualOp != null) {
            SqlBinaryExpression dummyExpression;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)expression);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(expression)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            String dummyText = "foo " + dualOp + " bar";
            SqlExpression sqlExpression3 = SqlPsiElementFactory.createExpressionFromText(dummyText, dialect, (PsiElement)expression);
            if (!(sqlExpression3 instanceof SqlBinaryExpression)) {
                sqlExpression3 = null;
            }
            if ((dummyExpression = (SqlBinaryExpression)sqlExpression3) != null) {
                op.replace(dummyExpression.getOpSignElement());
            }
        }
        expression.addAfter((PsiElement)right, (PsiElement)left);
        expression.addBefore((PsiElement)left, (PsiElement)right);
        left.delete();
        right.delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCommutative(IElementType opType, SqlExpression left, SqlExpression right) {
        if (!COMMUTATIVE_OPERATOR_TYPES.contains(opType)) return false;
        SqlType sqlType = left.getSqlType();
        Intrinsics.checkNotNullExpressionValue((Object)sqlType, (String)"left.sqlType");
        SqlType.Category category = sqlType.getCategory();
        SqlType sqlType2 = right.getSqlType();
        Intrinsics.checkNotNullExpressionValue((Object)sqlType2, (String)"right.sqlType");
        if (category != sqlType2.getCategory()) return false;
        return true;
    }

    private final IElementType getCommutingOperator(IElementType opType) {
        IElementType iElementType = opType;
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_GT) ? (IElementType)SqlCommonTokens.SQL_OP_LT : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_LT) ? (IElementType)SqlCommonTokens.SQL_OP_GT : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_GE) ? (IElementType)SqlCommonTokens.SQL_OP_LE : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_LE) ? (IElementType)SqlCommonTokens.SQL_OP_GE : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_LE_WS) ? (IElementType)SqlCommonTokens.SQL_OP_GE_WS : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_GE_WS) ? (IElementType)SqlCommonTokens.SQL_OP_LE_WS : null)))));
    }

    static {
        Companion = new Companion(null);
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{(IElementType)SqlCommonTokens.SQL_OP_EQ, (IElementType)SqlCommonTokens.SQL_OP_NULLSAFE_EQ, (IElementType)SqlCommonTokens.SQL_OP_EQEQ, (IElementType)SqlCommonTokens.SQL_OP_NEQ, (IElementType)SqlCommonTokens.SQL_OP_NEQ2, (IElementType)SqlCommonTokens.SQL_OP_NEQ3, (IElementType)SqlCommonTokens.SQL_OP_NEQ4, (IElementType)SqlCommonTokens.SQL_OP_NEQ_WS, (IElementType)SqlCommonTokens.SQL_OP_NEQ2_WS, (IElementType)SqlCommonTokens.SQL_OP_NEQ3_WS, (IElementType)SqlCommonTokens.SQL_OP_NEQ4_WS, (IElementType)SqlCommonTokens.SQL_OP_PLUS, (IElementType)SqlCommonTokens.SQL_OP_MUL, (IElementType)SqlCommonTokens.SQL_OP_BITWISE_AND, (IElementType)SqlCommonTokens.SQL_OP_BITWISE_OR, (IElementType)SqlCommonTokens.SQL_OP_BITWISE_XOR, (IElementType)SqlCommonTokens.PG_OP_BITWISE_XOR, (IElementType)SqlCommonTokens.SQL_OP_LOGICAL_AND, (IElementType)SqlCommonKeywords.SQL_AND, (IElementType)SqlCommonTokens.SQL_OP_LOGICAL_OR, (IElementType)SqlCommonKeywords.SQL_OR, (IElementType)SqlCommonTokens.SQL_OP_CONCAT});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(\n      S\u2026      SQL_OP_CONCAT\n    )");
        COMMUTATIVE_OPERATOR_TYPES = tokenSet;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/intentions/SqlFlipExpressionIntention$Companion;", "", "()V", "COMMUTATIVE_OPERATOR_TYPES", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.sql.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

