/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.refactoring.SqlSubqueryUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J#\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/intentions/SqlExtractNamedQueryIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlExtractNamedQueryIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.extract.named.query", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026ily.extract.named.query\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!SqlSubqueryUtils.isCTESupported(element2.getContainingFile())) {
            return false;
        }
        SqlExpression sqlExpression = SqlSubqueryUtils.findCteAbleParent(element2, false);
        if (sqlExpression == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"findCteAbleParent(element, false) ?: return false");
        SqlExpression subquery = sqlExpression;
        SqlExpression sqlExpression2 = SqlSubqueryUtils.findEnclosingQueryWithContext((PsiElement)subquery);
        if (sqlExpression2 == null) {
            return false;
        }
        SqlExpression query = sqlExpression2;
        return SqlSubqueryUtils.isSubquery(query, subquery) && SqlSubqueryUtils.canExtractWithoutContextLoss(subquery);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlExpression sqlExpression = SqlSubqueryUtils.findCteAbleParent(element2, false);
        if (sqlExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"findCteAbleParent(element, false) ?: return");
        SqlExpression subquery = sqlExpression;
        SqlExpression sqlExpression2 = SqlSubqueryUtils.findEnclosingQueryWithContext((PsiElement)subquery);
        if (sqlExpression2 == null) {
            return;
        }
        SqlExpression query = sqlExpression2;
        SqlSubqueryUtils.extractCte(project, editor, element2.getContainingFile(), subquery, query);
    }
}

