/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.TrigEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlTriggerTransitionInspection$WhenMappings;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlAlterTriggerStatementWithFakeTables;
import com.intellij.sql.psi.impl.SqlCreateTriggerStatementWithFakeTables;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.TriggerCorrelationKind;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlTriggerTransitionInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "problems", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlTriggerTransitionInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> problems, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, problems, manager, dialect, problems){
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $problems;

            private final SqlCreateTriggerStatementWithFakeTables.FakeSynonym resolveCorrelation(SqlReferenceExpression ref) {
                SqlCreateTriggerStatementWithFakeTables.FakeSynonym fakeSynonym;
                PsiElement refTarget = ref.resolve();
                PsiElement psiElement = refTarget;
                if (psiElement instanceof SqlCreateTriggerStatementWithFakeTables.FakeSynonym) {
                    fakeSynonym = (SqlCreateTriggerStatementWithFakeTables.FakeSynonym)refTarget;
                } else if (psiElement instanceof SqlAsExpression) {
                    SqlExpression sqlExpression = ((SqlAsExpression)refTarget).getExpression();
                    if (!(sqlExpression instanceof SqlReferenceExpression)) {
                        sqlExpression = null;
                    }
                    SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)sqlExpression;
                    Object object = sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null;
                    if (!(object instanceof SqlCreateTriggerStatementWithFakeTables.FakeSynonym)) {
                        object = null;
                    }
                    fakeSynonym = (SqlCreateTriggerStatementWithFakeTables.FakeSynonym)((Object)object);
                } else {
                    fakeSynonym = null;
                }
                return fakeSynonym;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression o) {
                TrigEvent trigEvent;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlReferenceExpression(o);
                SqlElement sqlElement = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), (Class[])new Class[]{SqlCreateTriggerStatement.class, SqlAlterTriggerStatementWithFakeTables.class});
                if (sqlElement == null) {
                    return;
                }
                SqlElement triggerStatement = sqlElement;
                SqlCreateTriggerStatementWithFakeTables.FakeSynonym fakeSynonym = this.resolveCorrelation(o);
                if (fakeSynonym == null) {
                    return;
                }
                SqlCreateTriggerStatementWithFakeTables.FakeSynonym correlation = fakeSynonym;
                TriggerCorrelationKind triggerCorrelationKind = correlation.getCorrelationKind();
                if (triggerCorrelationKind == null) return;
                switch (SqlTriggerTransitionInspection$WhenMappings.$EnumSwitchMapping$0[triggerCorrelationKind.ordinal()]) {
                    case 1: {
                        trigEvent = TrigEvent.INSERT;
                        break;
                    }
                    case 2: {
                        trigEvent = TrigEvent.DELETE;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                TrigEvent contradictoryEvent = trigEvent;
                Set<TrigEvent> set = SqlImplUtil.getTriggerEvents(triggerStatement);
                Intrinsics.checkNotNullExpressionValue(set, (String)"SqlImplUtil.getTriggerEvents(triggerStatement)");
                if ((TrigEvent)CollectionsKt.singleOrNull((Iterable)set) != contradictoryEvent) return;
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, SqlBundle.message("inspection.message.will.always.be.empty", o.getName()), false, new LocalQuickFix[0], ProblemHighlightType.WARNING));
            }
            {
                this.$manager = $captured_local_variable$0;
                this.$dialect = $captured_local_variable$1;
                this.$problems = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
    }
}

