/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlShadowingAliasInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "AddAsFix", "AddCommaFix", "intellij.database.sql.impl"})
public final class SqlShadowingAliasInspection
extends SqlInspectionBase {
    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(onTheFly, dialect, manager, result, manager, dialect, result){
            private final Casing casing;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ List $result;

            private final String getEffectiveName(String name, boolean isQuoted) {
                Case case_ = this.casing.choose(!isQuoted);
                Intrinsics.checkNotNullExpressionValue((Object)case_, (String)"casing.choose(!isQuoted)");
                Case case_2 = case_;
                if (case_2 == Case.MIXED) {
                    case_2 = Case.LOWER;
                }
                String string = case_2.apply(name);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"case.apply(name)");
                return string;
            }

            public void visitSqlQueryExpression(@NotNull SqlQueryExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                SqlSelectClause sqlSelectClause = o.getSelectClause();
                if (sqlSelectClause == null) {
                    return;
                }
                SqlSelectClause selectClause = sqlSelectClause;
                SqlTableExpression sqlTableExpression = o.getTableExpression();
                if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getSqlType()) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)sqlTableExpression, (String)"o.tableExpression?.sqlType ?: return");
                SqlTableExpression originalType = sqlTableExpression;
                HashSet<E> columnNames = new HashSet<E>();
                for (int i2 = 0; i2 < originalType.getColumnCount(); ++i2) {
                    Collection collection = columnNames;
                    String string = originalType.getColumnName(i2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"originalType.getColumnName(i)");
                    String string2 = this.getEffectiveName(string, originalType.isColumnQuoted(i2));
                    boolean bl = false;
                    collection.add(string2);
                }
                for (SqlExpression expression : selectClause.getExpressions()) {
                    SqlIdentifier nameElement;
                    if (!(expression instanceof SqlAsExpression)) continue;
                    if (((SqlAsExpression)expression).getNameElement() == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)nameElement, (String)"expression.nameElement ?: continue");
                    if (!(PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)((PsiElement)nameElement)) instanceof SqlExpression)) continue;
                    String string = nameElement.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameElement.name");
                    String effectiveName = this.getEffectiveName(string, nameElement.isQuotedIdentifier());
                    if (!columnNames.contains(effectiveName)) continue;
                    this.reportProblem(nameElement);
                }
            }

            private final void reportProblem(SqlIdentifier anchor) {
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)anchor, (PsiElement)anchor, SqlBundle.message("inspection.message.shadowing.alias", anchor.getName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[]{AddCommaFix.INSTANCE, AddAsFix.INSTANCE}));
            }
            {
                this.$onTheFly = $captured_local_variable$0;
                this.$dialect = $captured_local_variable$1;
                this.$manager = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                Casing casing = $captured_local_variable$1.getCasing(ObjectKind.COLUMN, null);
                Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"dialect.getCasing(ObjectKind.COLUMN, null)");
                this.casing = casing;
            }
        };
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/inspections/SqlShadowingAliasInspection$AddAsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.database.sql.impl"})
    private static final class AddAsFix
    implements LocalQuickFix {
        public static final AddAsFix INSTANCE;

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("quickfix.name.add.as", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"quickfix.name.add.as\")");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getStartElement();
            if (!(psiElement instanceof SqlIdentifier)) {
                psiElement = null;
            }
            SqlIdentifier sqlIdentifier = (SqlIdentifier)psiElement;
            if (sqlIdentifier == null) {
                return;
            }
            SqlIdentifier id = sqlIdentifier;
            PsiElement psiElement2 = id.getParent();
            if (!(psiElement2 instanceof SqlAsExpression)) {
                psiElement2 = null;
            }
            SqlAsExpression sqlAsExpression = (SqlAsExpression)psiElement2;
            if (sqlAsExpression == null) {
                return;
            }
            SqlAsExpression alias = sqlAsExpression;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)id);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(id)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            DdlBuilder ddlBuilder = new DdlBuilder().applyCodeStyle(project, dialect).withDialect(dialect.getDatabaseDialect()).keyword("as");
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"DdlBuilder()\n        .ap\u2026t)\n        .keyword(\"as\")");
            String string = ddlBuilder.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DdlBuilder()\n        .ap\u2026(\"as\")\n        .statement");
            String keywordText = string;
            PsiElement psiElement3 = SqlPsiElementFactory.createKeyword(dialect, alias.getProject(), (IElementType)SqlCommonKeywords.SQL_AS, keywordText);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"SqlPsiElementFactory.cre\u2026ect, SQL_AS, keywordText)");
            PsiElement keyword = psiElement3;
            PsiElement keywordInPlace = alias.addBefore(keyword, (PsiElement)id);
            CodeStyleManager.getInstance((Project)project).reformat(keywordInPlace);
        }

        private AddAsFix() {
        }

        static {
            AddAsFix addAsFix;
            INSTANCE = addAsFix = new AddAsFix();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlShadowingAliasInspection$AddCommaFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.database.sql.impl"})
    private static final class AddCommaFix
    implements LocalQuickFix,
    HighPriorityAction {
        public static final AddCommaFix INSTANCE;

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("quickfix.name.add.comma", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"quickfix.name.add.comma\")");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getStartElement();
            if (!(psiElement instanceof SqlIdentifier)) {
                psiElement = null;
            }
            SqlIdentifier sqlIdentifier = (SqlIdentifier)psiElement;
            if (sqlIdentifier == null) {
                return;
            }
            SqlIdentifier id = sqlIdentifier;
            PsiElement psiElement2 = id.getParent();
            if (!(psiElement2 instanceof SqlAsExpression)) {
                psiElement2 = null;
            }
            SqlAsExpression sqlAsExpression = (SqlAsExpression)psiElement2;
            if (sqlAsExpression == null) {
                return;
            }
            SqlAsExpression alias = sqlAsExpression;
            PsiElement parent2 = alias.getParent();
            SqlExpression sqlExpression = alias.getExpression();
            if (sqlExpression == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"alias.expression ?: return");
            SqlExpression expression = sqlExpression;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)id);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(id)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            PsiElement psiElement3 = parent2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"parent");
            PsiElement psiElement4 = SqlPsiElementFactory.createLeafFromText(psiElement3.getProject(), dialect, ",");
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"SqlPsiElementFactory.cre\u2026nt.project, dialect, \",\")");
            PsiElement comma = psiElement4;
            SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText(id.getText(), dialect, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, parent2);
            if (sqlReferenceExpression == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceExpression, (String)"SqlPsiElementFactory.cre\u2026ERENCE, parent) ?: return");
            SqlReferenceExpression newRef = sqlReferenceExpression;
            PsiElement commaInPlace = parent2.addAfter(comma, (PsiElement)alias);
            PsiElement refInPlace = parent2.addAfter((PsiElement)newRef, commaInPlace);
            alias.replace((PsiElement)expression);
            CodeStyleManager.getInstance((Project)project).reformat(refInPlace);
        }

        private AddCommaFix() {
        }

        static {
            AddCommaFix addCommaFix;
            INSTANCE = addCommaFix = new AddCommaFix();
        }
    }
}

