/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.AliasedSqlTableType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantAliasInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "QuickFix", "intellij.database.sql.impl"})
public final class SqlRedundantAliasInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result, manager, dialect, result){
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlAsExpression(@NotNull SqlAsExpression asExpression) {
                boolean bl;
                block13: {
                    Intrinsics.checkNotNullParameter((Object)asExpression, (String)"asExpression");
                    SqlExpression sqlExpression = asExpression.getExpression();
                    if (!(sqlExpression instanceof SqlReferenceExpression)) {
                        sqlExpression = null;
                    }
                    SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)sqlExpression;
                    if (sqlReferenceExpression == null) {
                        return;
                    }
                    SqlReferenceExpression aliasedRef = sqlReferenceExpression;
                    if (aliasedRef.getQualifierExpression() != null) {
                        return;
                    }
                    SqlIdentifier sqlIdentifier = asExpression.getNameElement();
                    if (Intrinsics.areEqual((Object)aliasedRef.getName(), (Object)(sqlIdentifier != null ? sqlIdentifier.getName() : null)) ^ true) {
                        return;
                    }
                    SqlType sqlType = asExpression.getSqlType();
                    if (!(sqlType instanceof AliasedSqlTableType)) {
                        sqlType = null;
                    }
                    AliasedSqlTableType aliasedSqlTableType = (AliasedSqlTableType)sqlType;
                    if (aliasedSqlTableType == null) {
                        return;
                    }
                    AliasedSqlTableType aliasType = aliasedSqlTableType;
                    SqlType sqlType2 = aliasedRef.getSqlType();
                    if (!(sqlType2 instanceof SqlTableType)) {
                        sqlType2 = null;
                    }
                    SqlTableType sqlTableType = (SqlTableType)sqlType2;
                    if (sqlTableType == null) {
                        return;
                    }
                    SqlTableType originalType = sqlTableType;
                    if (aliasType.getColumnCount() != originalType.getColumnCount()) {
                        return;
                    }
                    Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)aliasType.getColumnCount());
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator<T> iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            int element$iv;
                            int it2 = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual((Object)aliasType.getColumnName(it2), (Object)originalType.getColumnName(it2)) ^ true)) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                SqlIdentifier sqlIdentifier = asExpression.getNameElement();
                Intrinsics.checkNotNull((Object)sqlIdentifier);
                Intrinsics.checkNotNullExpressionValue((Object)sqlIdentifier, (String)"asExpression.nameElement!!");
                ProblemDescriptor problemDescriptor = this.myManager.createProblemDescriptor(sqlIdentifier.getOriginalElement(), SqlBundle.message("inspection.message.remove.alias", new Object[0]), (LocalQuickFix[])new QuickFix[]{new QuickFix(asExpression)}, ProblemHighlightType.WARNING, false, false);
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"myManager.createProblemD\u2026          false\n        )");
                ProblemDescriptor problem = problemDescriptor;
                this.addDescriptor(problem);
            }
            {
                this.$manager = $captured_local_variable$0;
                this.$dialect = $captured_local_variable$1;
                this.$result = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0012\u0010\t\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantAliasInspection$QuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "asExpression", "Lcom/intellij/sql/psi/SqlAsExpression;", "(Lcom/intellij/sql/psi/SqlAsExpression;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    private static final class QuickFix
    extends LocalQuickFixOnPsiElement {
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.remove.alias", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026amily.name.remove.alias\")");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            PsiElement psiElement = startElement;
            if (!(psiElement instanceof SqlAsExpression)) {
                psiElement = null;
            }
            SqlAsExpression sqlAsExpression = (SqlAsExpression)psiElement;
            if (sqlAsExpression == null) {
                return;
            }
            SqlAsExpression sqlAsExpression2 = sqlAsExpression;
            SqlExpression sqlExpression = sqlAsExpression2.getExpression();
            if (sqlExpression == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"sqlAsExpression.expression ?: return");
            SqlExpression aliasedExpression = sqlExpression;
            sqlAsExpression2.replace((PsiElement)aliasedExpression);
        }

        public QuickFix(@NotNull SqlAsExpression asExpression) {
            Intrinsics.checkNotNullParameter((Object)asExpression, (String)"asExpression");
            super((PsiElement)asExpression);
        }
    }
}

