/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlNullComparisonInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        Dbms dbms;
        if (dialect == null) {
            SqlNullComparisonInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlNullComparisonInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlNullComparisonInspection.$$$reportNull$$$0(2);
        }
        if ((dbms = dialect.getDbms()).isSybase()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlBinaryExpression(@NotNull SqlBinaryExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PsiTreeUtil.getParentOfType((PsiElement)o, SqlFunctionCallExpression.class) != null) {
                    return;
                }
                if (!this.process(o, true)) {
                    this.process(o, false);
                }
                super.visitSqlBinaryExpression(o);
            }

            public boolean process(@NotNull SqlBinaryExpression o, boolean left) {
                boolean neq;
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                IElementType sign = o.getOpSign();
                SqlExpression r = o.getROperand();
                SqlExpression l = o.getLOperand();
                SqlExpression operand = left ? l : r;
                SqlExpression opposite = left ? r : l;
                boolean eq = sign == SqlTokens.SQL_OP_EQ;
                boolean bl = neq = sign == SqlTokens.SQL_OP_NEQ || sign == SqlTokens.SQL_OP_NEQ2 || sign == SqlTokens.SQL_OP_NEQ3 || sign == SqlTokens.SQL_OP_NEQ_WS || sign == SqlTokens.SQL_OP_NEQ2_WS || sign == SqlTokens.SQL_OP_NEQ3_WS;
                if (operand != null && opposite != null && operand.getNode().getElementType() == SqlCompositeElementTypes.SQL_SPECIAL_LITERAL && StringUtil.equalsIgnoreCase((CharSequence)"null", (CharSequence)operand.getText()) && (eq || neq)) {
                    if (dbms.isTransactSql() && opposite instanceof SqlReferenceExpression && ((SqlReferenceExpression)opposite).getReferenceElementType().getTargetKind() == ObjectKind.VARIABLE) {
                        SqlSelectClause selectClause;
                        SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlQueryExpression.class);
                        SqlSelectClause sqlSelectClause = selectClause = query == null ? null : query.getSelectClause();
                        if (PsiTreeUtil.isAncestor((PsiElement)selectClause, (PsiElement)o, (boolean)true)) {
                            return false;
                        }
                    }
                    DdlBuilder builder = new DdlBuilder().applyCodeStyle(o.getProject(), SqlImplUtil.getSqlDialectSafe((PsiElement)o)).keyword("IS");
                    if (neq) {
                        builder.space().keyword("NOT");
                    }
                    String what = builder.space().keyword("NULL").getStatement();
                    String text2 = SqlBundle.message("inspection.message.suspicious.comparison.with.null.probably.operator.should.be.used", what);
                    String title = SqlBundle.message("intention.family.name.use.operator", StringUtil.toUpperCase((String)what));
                    String replacement = opposite.getText() + " " + what;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, text2, (LocalQuickFix)new MyConvertFix(title, replacement), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/intellij/sql/inspections/SqlNullComparisonInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSqlBinaryExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlNullComparisonInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyConvertFix
    implements LocalQuickFix {
        @IntentionFamilyName
        private final String myTitle;
        @NotNull
        private final String myReplacement;

        protected MyConvertFix(@IntentionFamilyName @NotNull String title, @NotNull String replacement) {
            if (title == null) {
                MyConvertFix.$$$reportNull$$$0(0);
            }
            if (replacement == null) {
                MyConvertFix.$$$reportNull$$$0(1);
            }
            this.myTitle = title;
            this.myReplacement = replacement;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.myTitle;
            if (string == null) {
                MyConvertFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiFile file;
            if (project == null) {
                MyConvertFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                MyConvertFix.$$$reportNull$$$0(4);
            }
            PsiElement element2 = descriptor2.getPsiElement();
            PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
            Document document = instance.getDocument(file = element2.getContainingFile());
            if (document != null) {
                TextRange range = element2.getTextRange();
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)this.myReplacement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlNullComparisonInspection$MyConvertFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlNullComparisonInspection$MyConvertFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

