/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlHighlightUsagesFactory;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInsertNullIntoNotNullInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSpecialLiteralExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlInsertNullIntoNotNullInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlInsertNullIntoNotNullInspection
extends SqlInspectionBase {
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<? extends ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(dialect, onTheFly, manager, result, manager, dialect, result){
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ List $result;

            public void visitSqlSpecialLiteralExpression(@NotNull SqlSpecialLiteralExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (!o.isNull()) {
                    return;
                }
                SqlExpression expr = this.ascend((SqlExpression)o);
                IntRange intRange = SqlImplUtil.getImmediateColumnSourceIndices((PsiElement)expr, null, true);
                if (intRange == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)intRange, (String)"SqlImplUtil.getImmediate\u2026pr, null, true) ?: return");
                IntRange indices = intRange;
                SqlHighlightUsagesFactory.processColumnElements((PsiElement)expr, indices.getFirst(), indices.getLast() + 1, (BiConsumer<? super PsiElement, ? super String>)new BiConsumer<PsiElement, String>(this, o){
                    final /* synthetic */ createAnnotationVisitor.1 this$0;
                    final /* synthetic */ SqlSpecialLiteralExpression $o;

                    public final void accept(PsiElement e, @Nullable String $noName_1) {
                        PsiElement psiElement = e instanceof SqlReferenceExpression ? ((SqlReferenceExpression)e).resolve() : e;
                        if (!(psiElement instanceof DasColumn)) {
                            psiElement = null;
                        }
                        DasColumn dasColumn = (DasColumn)psiElement;
                        if (dasColumn == null) {
                            return;
                        }
                        DasColumn column2 = dasColumn;
                        if (!column2.isNotNull()) {
                            return;
                        }
                        Dbms dbms = this.this$0.$dialect.getDbms();
                        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
                        if (dbms.isMysql() && SqlImplUtil.isAutoVal(column2)) {
                            return;
                        }
                        String string = column2.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"column.name");
                        createAnnotationVisitor.1.access$reportProblem(this.this$0, this.$o, string);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$o = sqlSpecialLiteralExpression;
                    }
                });
            }

            private final SqlExpression ascend(SqlExpression $this$ascend) {
                SqlExpression sqlExpression;
                block3: {
                    while (true) {
                        PsiElement parent2;
                        if ((parent2 = $this$ascend.getParent()) instanceof SqlParenthesizedExpression) {
                            if (((SqlParenthesizedExpression)parent2).getExpressionList().size() == 1) {
                                $this$ascend = (SqlExpression)parent2;
                                continue;
                            }
                            sqlExpression = $this$ascend;
                            break block3;
                        }
                        if (!(parent2 instanceof SqlAsExpression)) break;
                        $this$ascend = (SqlExpression)parent2;
                    }
                    sqlExpression = $this$ascend;
                }
                return sqlExpression;
            }

            private final void reportProblem(SqlSpecialLiteralExpression o, String columnName) {
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, (PsiElement)o, SqlBundle.message("inspection.message.column.not.null", columnName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }
            {
                this.$dialect = $captured_local_variable$0;
                this.$onTheFly = $captured_local_variable$1;
                this.$manager = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public static final /* synthetic */ void access$reportProblem(createAnnotationVisitor.1 $this, SqlSpecialLiteralExpression o, String columnName) {
                $this.reportProblem(o, columnName);
            }
        };
    }
}

