/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dataFlow.CursorState;
import com.intellij.sql.dataFlow.FlowUtilKt;
import com.intellij.sql.dataFlow.instructions.SqlCursorInstruction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlIllegalCursorStateInspection;
import com.intellij.sql.inspections.SqlIllegalCursorStateInspection$WhenMappings;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlIllegalCursorStateInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlIllegalCursorStateInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(onTheFly, manager, dialect, result, manager, dialect, result){
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlCreateProcedureStatement(@NotNull SqlCreateProcedureStatement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                this.visitSqlRoutineDefinition((SqlRoutineDefinition)o);
            }

            public void visitSqlRoutineDefinition(@NotNull SqlRoutineDefinition o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                FlowUtilKt.computeCursorStates(FlowUtilKt.buildFlowGraph(o)).forEach((BiConsumer<SqlCursorInstruction, Set<CursorState>>)new BiConsumer<SqlCursorInstruction, Set<? extends CursorState>>(this){
                    final /* synthetic */ createAnnotationVisitor.1 this$0;

                    public final void accept(@NotNull SqlCursorInstruction instruction2, @NotNull Set<? extends CursorState> states) {
                        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
                        Intrinsics.checkNotNullParameter(states, (String)"states");
                        ProgressManager.checkCanceled();
                        SqlReferenceExpression sqlReferenceExpression = instruction2.getReference();
                        if (sqlReferenceExpression == null) {
                            return;
                        }
                        SqlReferenceExpression source = sqlReferenceExpression;
                        String problem = null;
                        switch (SqlIllegalCursorStateInspection$WhenMappings.$EnumSwitchMapping$0[instruction2.getOp().ordinal()]) {
                            case 1: {
                                if (!states.contains((Object)((Object)CursorState.OPEN))) break;
                                problem = SqlBundle.message("inspection.message.cursor.might.not.have.been.closed", new Object[0]);
                                break;
                            }
                            case 2: {
                                if (!states.contains((Object)((Object)CursorState.CLOSE))) break;
                                problem = SqlBundle.message("inspection.message.cursor.might.not.have.been.open", new Object[0]);
                                break;
                            }
                            case 3: {
                                if (!states.contains((Object)((Object)CursorState.CLOSE))) break;
                                problem = SqlBundle.message("inspection.message.cursor.might.not.have.been.open", new Object[0]);
                                break;
                            }
                        }
                        if (problem != null) {
                            this.this$0.addDescriptor(this.this$0.myManager.createProblemDescriptor((PsiElement)source, problem, true, ProblemHighlightType.WARNING, this.this$0.$onTheFly, new LocalQuickFix[0]));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$onTheFly = $captured_local_variable$0;
                this.$manager = $captured_local_variable$1;
                this.$dialect = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
    }
}

