/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlSelectClause;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlDuplicateColumnInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlDuplicateColumnInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        if (!dbms.isSybase()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, onTheFly, dialect, result, manager, dialect, result){
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            /*
             * WARNING - void declaration
             */
            public void visitSqlSelectClause(@NotNull SqlSelectClause o) {
                void $this$groupByTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                List list = o.getExpressions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"o.expressions");
                Iterable $this$groupBy$iv = list;
                boolean $i$f$groupBy = false;
                Object object = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    String string;
                    Object object3;
                    SqlExpression it2 = (SqlExpression)element$iv$iv;
                    boolean bl = false;
                    SqlExpression sqlExpression = it2;
                    if (!(sqlExpression instanceof SqlAsExpression)) {
                        sqlExpression = null;
                    }
                    if ((object3 = (SqlAsExpression)sqlExpression) != null && (object3 = object3.getName()) != null) {
                        Object object4 = object3;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Object it3 = object4;
                        boolean bl4 = false;
                        string = StringUtil.toLowerCase((String)it3);
                    } else {
                        string = null;
                    }
                    String key$iv$iv = string;
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl5 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                Map $this$forEach$iv = destination$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    void name;
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> $dstr$name$columns = element$iv = iterator.next();
                    boolean bl6 = false;
                    Map.Entry<K, V> entry = $dstr$name$columns;
                    boolean bl7 = false;
                    String string = (String)entry.getKey();
                    entry = $dstr$name$columns;
                    bl7 = false;
                    List columns = (List)entry.getValue();
                    if (name == null || !this.hasUnmatchedReferences(columns)) continue;
                    this.reportError((String)name, columns);
                }
            }

            private final boolean hasUnmatchedReferences(List<? extends SqlExpression> columns) {
                if (columns.size() <= 1) {
                    return false;
                }
                PsiElement lastTarget = null;
                PsiElement lastQualifier = null;
                for (SqlExpression sqlExpression : columns) {
                    SqlResolveResult resolveResult;
                    SqlReferenceExpression ref;
                    SqlExpression sqlExpression2 = sqlExpression;
                    if (!(sqlExpression2 instanceof SqlAsExpression)) {
                        sqlExpression2 = null;
                    }
                    SqlAsExpression sqlAsExpression = (SqlAsExpression)sqlExpression2;
                    Object object = sqlAsExpression != null ? sqlAsExpression.getExpression() : null;
                    if (!(object instanceof SqlReferenceExpression)) {
                        object = null;
                    }
                    if ((SqlReferenceExpression)object == null) {
                        continue;
                    }
                    ResolveResult resolveResult2 = ref.getReference().resolveSingle();
                    if (!(resolveResult2 instanceof SqlResolveResult)) {
                        resolveResult2 = null;
                    }
                    if ((SqlResolveResult)resolveResult2 == null) {
                        continue;
                    }
                    PsiElement currentTarget = resolveResult.getElement();
                    PsiElement currentQualifier = resolveResult.getQualifier();
                    if (lastTarget != null && Intrinsics.areEqual((Object)currentTarget, (Object)lastTarget) ^ true || lastQualifier != null && Intrinsics.areEqual((Object)currentQualifier, (Object)lastQualifier) ^ true) {
                        return true;
                    }
                    lastTarget = currentTarget;
                    lastQualifier = currentQualifier;
                }
                return false;
            }

            private final void reportError(String name, List<? extends SqlExpression> columns) {
                String string = SqlBundle.message("inspection.message.column.name.specified.more.than.once", name);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026ed.more.than.once\", name)");
                String message2 = string;
                for (SqlExpression sqlExpression : columns) {
                    this.addDescriptor(this.$manager.createProblemDescriptor((PsiElement)sqlExpression, message2, true, ProblemHighlightType.GENERIC_ERROR, this.$onTheFly, new LocalQuickFix[0]));
                }
            }
            {
                this.$manager = $captured_local_variable$0;
                this.$onTheFly = $captured_local_variable$1;
                this.$dialect = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
    }
}

