/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.DataType;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SqlDeprecateTypeInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlFile sqlFile, @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        Map<String, SqlTypeSystem.DeprecatedTypeInfo> deprecatedTypes;
        if (sqlFile == null) {
            SqlDeprecateTypeInspection.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            SqlDeprecateTypeInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlDeprecateTypeInspection.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SqlDeprecateTypeInspection.$$$reportNull$$$0(3);
        }
        if ((deprecatedTypes = dialect.getTypeSystem().getDeprecatedTypes((PsiFile)sqlFile)).isEmpty()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlTypeElement(SqlTypeElement o) {
                DataType dataType = o.getDataType();
                String spec = dataType.getSpecification();
                SqlTypeSystem.DeprecatedTypeInfo typeInfo = (SqlTypeSystem.DeprecatedTypeInfo)deprecatedTypes.get(StringUtil.toLowerCase((String)spec));
                if (typeInfo == null) {
                    return;
                }
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, DatabaseBundle.message((String)typeInfo.getDescriptionKey(), (Object[])new Object[0]), (LocalQuickFix)new ReplaceTypeFix(typeInfo.getReplacements()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sqlFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlDeprecateTypeInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReplaceTypeFix
    implements LocalQuickFix {
        private final List<String> replacements;

        private ReplaceTypeFix(List<String> replacements) {
            this.replacements = replacements;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("quickfix.name.replace.deprecated.type", new Object[0]);
            if (string == null) {
                ReplaceTypeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                ReplaceTypeFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceTypeFix.$$$reportNull$$$0(2);
            }
            PsiElement startElement = descriptor2.getStartElement();
            PsiElement parent2 = startElement.getParent();
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(startElement);
            DdlBuilder builder = new DdlBuilder().applyCodeStyle(project, dialect).withDialect(dialect.getDatabaseDialect());
            List variants = ContainerUtil.map(this.replacements, s2 -> {
                builder.clear();
                builder.type((String)s2);
                return builder.getStatement();
            });
            SqlTypeElement newTypeElement = SqlPsiElementFactory.createDataTypeFromText((String)variants.get(0), dialect, parent2);
            if (newTypeElement == null) {
                return;
            }
            PsiElement typeInPlace = startElement.replace((PsiElement)newTypeElement);
            if (variants.size() > 1) {
                Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(parent2.getContainingFile());
                if (doc == null) {
                    return;
                }
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(doc);
                Editor editor = EditorFactory.getInstance().editors(doc).findFirst().orElse(null);
                if (editor == null) {
                    return;
                }
                TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl(typeInPlace);
                templateBuilder.replaceElement(typeInPlace, (Expression)new ConstantNode(typeInPlace.getText()).withLookupStrings((Collection)variants));
                Template template = templateBuilder.buildInlineTemplate();
                editor.getCaretModel().moveToOffset(typeInPlace.getTextRange().getStartOffset());
                TemplateManager.getInstance((Project)project).startTemplate(editor, template);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlDeprecateTypeInspection$ReplaceTypeFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlDeprecateTypeInspection$ReplaceTypeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

