/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSpecialLiteralExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlConstantConditionInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            SqlConstantConditionInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlConstantConditionInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlConstantConditionInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){
            int inQuery;
            int inConditionClause;

            public void visitSqlStatement(SqlStatement o) {
                super.visitSqlStatement(o);
                this.inQuery = 0;
            }

            public void visitSqlQueryExpression(SqlQueryExpression o) {
                super.visitSqlElement((SqlElement)o);
                ++this.inQuery;
            }

            private void inConditionClause(SqlElement o) {
                super.visitSqlElement(o);
                if (this.inQuery == 0) {
                    ++this.inQuery;
                }
                ++this.inConditionClause;
            }

            public void visitSqlWhereClause(SqlWhereClause o) {
                this.inConditionClause((SqlElement)o);
            }

            public void visitSqlHavingClause(SqlHavingClause o) {
                this.inConditionClause((SqlElement)o);
            }

            public void visitSqlJoinExpression(SqlJoinExpression o) {
                this.inConditionClause((SqlElement)o);
            }

            @Override
            public void elementFinished(PsiElement element2) {
                if (element2 instanceof SqlQueryExpression) {
                    --this.inQuery;
                } else if (element2 instanceof SqlWhereClause || element2 instanceof SqlHavingClause || element2 instanceof SqlJoinExpression) {
                    --this.inConditionClause;
                }
            }

            public void visitSqlBinaryExpression(SqlBinaryExpression o) {
                super.visitSqlElement((SqlElement)o);
                if (this.inConditionClause == 0) {
                    return;
                }
                if (this.inConditionClause % 2 != this.inQuery % 2) {
                    return;
                }
                SqlExpression left = o.getLOperand();
                SqlExpression right = o.getROperand();
                IElementType sign = o.getOpSign();
                if (left instanceof SqlSpecialLiteralExpression || right instanceof SqlSpecialLiteralExpression) {
                    return;
                }
                if (left instanceof SqlLiteralExpression && right instanceof SqlLiteralExpression && SqlConstantConditionInspection.isComparisonOperator(sign) && StringUtil.equals((CharSequence)left.getText(), (CharSequence)right.getText())) {
                    this.reportProblem(o);
                    return;
                }
                if (!(left instanceof SqlReferenceExpression) || !(right instanceof SqlReferenceExpression)) {
                    return;
                }
                SqlReferenceExpression lRef = (SqlReferenceExpression)left;
                SqlReferenceExpression rRef = (SqlReferenceExpression)right;
                if (lRef.getReferenceElementType().getTargetKind() == ObjectKind.COLUMN && rRef.getReferenceElementType().getTargetKind() == ObjectKind.COLUMN && SqlConstantConditionInspection.isComparisonOperator(sign)) {
                    if (!SqlConstantConditionInspection.sameTargets((PsiElement)lRef, (PsiElement)rRef)) {
                        return;
                    }
                    PsiElement leftTarget = lRef.resolve();
                    if (leftTarget instanceof DasColumn && !((DasColumn)leftTarget).isNotNull()) {
                        return;
                    }
                    this.reportProblem(o);
                }
            }

            private void reportProblem(SqlBinaryExpression expression) {
                IElementType sign = expression.getOpSign();
                boolean messageTrue = sign == SqlTokens.SQL_OP_EQ || sign == SqlTokens.SQL_OP_LE || sign == SqlTokens.SQL_OP_GE;
                String message2 = SqlBundle.message(messageTrue ? "condition.always.true" : "condition.always.false", expression.getText());
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, message2, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
            }
        };
    }

    private static boolean sameTargets(@Nullable PsiElement left, @Nullable PsiElement right) {
        List<Pair<PsiElement, PsiElement>> leftResolve = SqlImplUtil.resolveQualified((SqlReferenceExpression)ObjectUtils.tryCast((Object)left, SqlReferenceExpression.class));
        List<Pair<PsiElement, PsiElement>> rightResolve = SqlImplUtil.resolveQualified((SqlReferenceExpression)ObjectUtils.tryCast((Object)right, SqlReferenceExpression.class));
        return leftResolve.size() == 1 && rightResolve.size() == 1 && Comparing.equal(leftResolve.get(0), rightResolve.get(0));
    }

    private static boolean isComparisonOperator(IElementType sign) {
        return sign == SqlTokens.SQL_OP_EQ || sign == SqlTokens.SQL_OP_LE || sign == SqlTokens.SQL_OP_GE || sign == SqlTokens.SQL_OP_LT || sign == SqlTokens.SQL_OP_GT || sign == SqlTokens.SQL_OP_NEQ || sign == SqlTokens.SQL_OP_NEQ2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlConstantConditionInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

