/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.inspections.SqlCaseVsIfInspection$Companion$WhenMappings;
import com.intellij.sql.inspections.SqlCaseVsIfInspection$WhenMappings;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCaseExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElseClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlThenClause;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhenThenClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00142\u00020\u0001:\u0005\u0013\u0014\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "preferCase", "", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "file", "Lcom/intellij/sql/psi/SqlFile;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "problems", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "createOptionsPanel", "Lcom/intellij/codeInspection/ui/SingleCheckboxOptionsPanel;", "BranchingInfo", "Companion", "ConvertToCaseFix", "ConvertToIfFix", "FunctionKind", "intellij.database.sql.impl"})
public final class SqlCaseVsIfInspection
extends SqlInspectionBase {
    @JvmField
    public boolean preferCase;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlFile file, @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> problems, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        Map map2 = SqlCaseVsIfInspection.Companion.getIfCaps(dialect, file);
        boolean bl = false;
        if (map2.isEmpty()) {
            boolean bl2 = false;
            return null;
        }
        Map caps = map2;
        return new SqlInspectionBase.SqlAnnotationVisitor(this, caps, onTheFly, manager, dialect, problems, manager, dialect, problems){
            final /* synthetic */ SqlCaseVsIfInspection this$0;
            final /* synthetic */ Map $caps;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $problems;

            /*
             * WARNING - void declaration
             */
            public void visitSqlCaseExpression(@NotNull SqlCaseExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                BranchingInfo branchingInfo = com.intellij.sql.inspections.SqlCaseVsIfInspection$Companion.access$getBranchingInfo(SqlCaseVsIfInspection.Companion, o, this.$caps);
                if (branchingInfo != null) {
                    BranchingInfo branchingInfo2 = branchingInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    BranchingInfo info = branchingInfo2;
                    boolean bl3 = false;
                    PsiElement psiElement = PsiTreeUtil.findSiblingForward((PsiElement)o.getFirstChild(), (IElementType)((IElementType)SqlCommonKeywords.SQL_CASE), (boolean)false, null);
                    if (psiElement == null) {
                        psiElement = (PsiElement)o;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiTreeUtil.findSiblingF\u2026L_CASE, false, null) ?: o");
                    PsiElement anchor = psiElement;
                    Object object = this.$caps;
                    boolean bl4 = false;
                    Iterator<Map.Entry<K, V>> iterator = object.entrySet().iterator();
                    while (iterator.hasNext()) {
                        boolean bl5;
                        void kind;
                        Map.Entry<K, V> entry;
                        Map.Entry<K, V> entry2 = entry = iterator.next();
                        boolean bl6 = false;
                        object = (FunctionKind)((Object)entry2.getKey());
                        entry2 = entry;
                        bl6 = false;
                        String name = (String)entry2.getValue();
                        switch (SqlCaseVsIfInspection$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                            case 1: {
                                if (info.getConditionalBranches().size() == 1) {
                                    bl5 = true;
                                    break;
                                }
                                bl5 = false;
                                break;
                            }
                            case 2: {
                                bl5 = true;
                                break;
                            }
                            case 3: {
                                if (info.getSubject() != null) {
                                    bl5 = true;
                                    break;
                                }
                                bl5 = false;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        boolean isApplicable = bl5;
                        if (!isApplicable) continue;
                        String string = SqlBundle.message("inspection.message.case.can.be.replaced.with.call", name);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026eplaced.with.call\", name)");
                        this.report(anchor, string, !this.this$0.preferCase, (LocalQuickFix)new ConvertToIfFix((FunctionKind)kind, name, o));
                    }
                }
                super.visitSqlCaseExpression(o);
            }

            public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (com.intellij.sql.inspections.SqlCaseVsIfInspection$Companion.access$getBranchingInfo(SqlCaseVsIfInspection.Companion, o, this.$caps) != null) {
                    SqlReferenceExpression sqlReferenceExpression = o.getNameElement();
                    SqlExpression anchor = sqlReferenceExpression != null ? (SqlExpression)sqlReferenceExpression : (SqlExpression)o;
                    PsiElement psiElement = (PsiElement)anchor;
                    String string = SqlBundle.message("inspection.message.call.can.be.replaced.with.case.expression", anchor.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026expression\", anchor.name)");
                    this.report(psiElement, string, this.this$0.preferCase, (LocalQuickFix)new ConvertToCaseFix(o));
                }
                super.visitSqlFunctionCallExpression(o);
            }

            private final void report(PsiElement elementToHighlight, @InspectionMessage String message2, boolean isWarning, LocalQuickFix fix) {
                if (!isWarning && !this.$onTheFly) {
                    return;
                }
                PsiElement psiElement = elementToHighlight;
                if (psiElement == null) {
                    return;
                }
                ProblemDescriptor problemDescriptor = this.myManager.createProblemDescriptor(psiElement, message2, true, isWarning ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION, false, new LocalQuickFix[]{fix});
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"myManager.createProblemD\u2026,\n          fix\n        )");
                ProblemDescriptor problem = problemDescriptor;
                this.addDescriptor(problem);
            }
            {
                this.this$0 = this$0;
                this.$caps = $captured_local_variable$1;
                this.$onTheFly = $captured_local_variable$2;
                this.$manager = $captured_local_variable$3;
                this.$dialect = $captured_local_variable$4;
                this.$problems = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        };
    }

    @NotNull
    public SingleCheckboxOptionsPanel createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(SqlBundle.message("checkbox.prefer.case.expressions.over.if.functions", new Object[0]), (InspectionProfileEntry)this, "preferCase");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$FunctionKind;", "", "(Ljava/lang/String;I)V", "IF", "MULTI_IF", "DECODE", "intellij.database.sql.impl"})
    private static final class FunctionKind
    extends Enum<FunctionKind> {
        public static final /* enum */ FunctionKind IF;
        public static final /* enum */ FunctionKind MULTI_IF;
        public static final /* enum */ FunctionKind DECODE;
        private static final /* synthetic */ FunctionKind[] $VALUES;

        static {
            FunctionKind[] functionKindArray = new FunctionKind[3];
            FunctionKind[] functionKindArray2 = functionKindArray;
            functionKindArray[0] = IF = new FunctionKind();
            functionKindArray[1] = MULTI_IF = new FunctionKind();
            functionKindArray[2] = DECODE = new FunctionKind();
            $VALUES = functionKindArray;
        }

        public static FunctionKind[] values() {
            return (FunctionKind[])$VALUES.clone();
        }

        public static FunctionKind valueOf(String string) {
            return Enum.valueOf(FunctionKind.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$BranchingInfo;", "", "subject", "Lcom/intellij/sql/psi/SqlExpression;", "conditionalBranches", "", "Lkotlin/Pair;", "elseExpression", "(Lcom/intellij/sql/psi/SqlExpression;Ljava/util/List;Lcom/intellij/sql/psi/SqlExpression;)V", "getConditionalBranches", "()Ljava/util/List;", "getElseExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "getSubject", "intellij.database.sql.impl"})
    private static final class BranchingInfo {
        @Nullable
        private final SqlExpression subject;
        @NotNull
        private final List<Pair<SqlExpression, SqlExpression>> conditionalBranches;
        @NotNull
        private final SqlExpression elseExpression;

        @Nullable
        public final SqlExpression getSubject() {
            return this.subject;
        }

        @NotNull
        public final List<Pair<SqlExpression, SqlExpression>> getConditionalBranches() {
            return this.conditionalBranches;
        }

        @NotNull
        public final SqlExpression getElseExpression() {
            return this.elseExpression;
        }

        public BranchingInfo(@Nullable SqlExpression subject, @NotNull List<? extends Pair<? extends SqlExpression, ? extends SqlExpression>> conditionalBranches, @NotNull SqlExpression elseExpression) {
            Intrinsics.checkNotNullParameter(conditionalBranches, (String)"conditionalBranches");
            Intrinsics.checkNotNullParameter((Object)elseExpression, (String)"elseExpression");
            this.subject = subject;
            this.conditionalBranches = conditionalBranches;
            this.elseExpression = elseExpression;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\f0\u0005\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bH\u0016J\u0012\u0010\f\u001a\f0\u0005\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bH\u0016J)\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$ConvertToIfFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "functionKind", "Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$FunctionKind;", "functionName", "", "caseExpression", "Lcom/intellij/sql/psi/SqlCaseExpression;", "(Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$FunctionKind;Ljava/lang/String;Lcom/intellij/sql/psi/SqlCaseExpression;)V", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    private static final class ConvertToIfFix
    extends LocalQuickFixOnPsiElement {
        private final FunctionKind functionKind;
        private final String functionName;

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.replace.with.call", this.functionName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026with.call\", functionName)");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        /*
         * WARNING - void declaration
         */
        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            PsiElement psiElement = startElement;
            if (!(psiElement instanceof SqlCaseExpression)) {
                psiElement = null;
            }
            SqlCaseExpression sqlCaseExpression = (SqlCaseExpression)psiElement;
            if (sqlCaseExpression == null) {
                return;
            }
            SqlCaseExpression caseExpression = sqlCaseExpression;
            BranchingInfo branchingInfo = Companion.getBranchingInfo(caseExpression, (Map<FunctionKind, String>)MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)this.functionKind), (Object)this.functionName)));
            if (branchingInfo == null) {
                return;
            }
            BranchingInfo info = branchingInfo;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(file)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            SqlFunctionDefinition sqlFunctionDefinition = dialect.getSupportedFunctions().get(this.functionName);
            if (sqlFunctionDefinition == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlFunctionDefinition), (String)"dialect.supportedFunctions[functionName] ?: return");
            SqlFunctionDefinition ifFunction = sqlFunctionDefinition;
            DdlBuilder ddlBuilder = new DdlBuilder();
            boolean bl = false;
            boolean bl2 = false;
            DdlBuilder $this$with = ddlBuilder;
            boolean bl3 = false;
            SqlExpression sqlExpression = info.getSubject();
            String subjectText = sqlExpression != null ? sqlExpression.getText() : null;
            $this$with.applyCodeStyle(project, dialect);
            $this$with.withDialect(dialect.getDatabaseDialect());
            $this$with.quoteIdentifiers(false);
            $this$with.ref((DasObject)ifFunction, ifFunction.getName());
            $this$with.plain("(");
            if (this.functionKind == FunctionKind.DECODE) {
                String string = subjectText;
                if (string == null) {
                    return;
                }
                $this$with.plain(string).plain(", ");
            }
            for (Pair<SqlExpression, SqlExpression> pair : info.getConditionalBranches()) {
                void condition;
                SqlExpression sqlExpression2 = (SqlExpression)pair.component1();
                SqlExpression expression = (SqlExpression)pair.component2();
                if (this.functionKind != FunctionKind.DECODE && subjectText != null) {
                    $this$with.plain(subjectText + " = " + condition.getText());
                } else {
                    $this$with.plain(condition.getText());
                }
                $this$with.plain(", ");
                $this$with.plain(expression.getText());
                $this$with.plain(", ");
            }
            $this$with.plain(info.getElseExpression().getText());
            $this$with.plain(")");
            String string = $this$with.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(DdlBuilder()) {\n   \u2026        statement\n      }");
            String callText2 = string;
            SqlExpression sqlExpression3 = SqlPsiElementFactory.createExpressionFromText(callText2, dialect, (PsiElement)caseExpression);
            if (!(sqlExpression3 instanceof SqlFunctionCallExpression)) {
                sqlExpression3 = null;
            }
            SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)sqlExpression3;
            if (sqlFunctionCallExpression == null) {
                return;
            }
            SqlFunctionCallExpression callExpression = sqlFunctionCallExpression;
            PsiElement newElement = caseExpression.replace((PsiElement)callExpression);
            CodeStyleManager.getInstance((Project)project).reformat(newElement);
        }

        public ConvertToIfFix(@NotNull FunctionKind functionKind, @NotNull String functionName, @NotNull SqlCaseExpression caseExpression) {
            Intrinsics.checkNotNullParameter((Object)((Object)functionKind), (String)"functionKind");
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)caseExpression, (String)"caseExpression");
            super((PsiElement)caseExpression);
            this.functionKind = functionKind;
            this.functionName = functionName;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0012\u0010\t\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$ConvertToCaseFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "callExpression", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "(Lcom/intellij/sql/psi/SqlFunctionCallExpression;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    private static final class ConvertToCaseFix
    extends LocalQuickFixOnPsiElement {
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.replace.with.case.expression", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026ce.with.case.expression\")");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        /*
         * WARNING - void declaration
         */
        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            PsiElement psiElement = startElement;
            if (!(psiElement instanceof SqlFunctionCallExpression)) {
                psiElement = null;
            }
            SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)psiElement;
            if (sqlFunctionCallExpression == null) {
                return;
            }
            SqlFunctionCallExpression callExpression = sqlFunctionCallExpression;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(file)");
            BranchingInfo branchingInfo = Companion.getBranchingInfo(callExpression, (Map<FunctionKind, String>)Companion.getIfCaps(sqlLanguageDialectEx, (SqlFile)file));
            if (branchingInfo == null) {
                return;
            }
            BranchingInfo info = branchingInfo;
            SqlLanguageDialectEx sqlLanguageDialectEx2 = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx2), (String)"SqlImplUtil.getSqlDialectSafe(file)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx2;
            DdlBuilder ddlBuilder = new DdlBuilder();
            boolean bl = false;
            boolean bl2 = false;
            DdlBuilder $this$with = ddlBuilder;
            boolean bl3 = false;
            $this$with.applyCodeStyle(project, dialect);
            $this$with.withDialect(dialect.getDatabaseDialect());
            $this$with.keyword("CASE");
            Pair<SqlExpression, SqlExpression> pair = info.getSubject();
            if (pair != null) {
                Pair<SqlExpression, SqlExpression> pair2 = pair;
                boolean bl4 = false;
                boolean bl5 = false;
                Pair<SqlExpression, SqlExpression> it2 = pair2;
                boolean bl6 = false;
                $this$with.space().plain(it2.getText());
            }
            $this$with.newLine();
            for (Pair<SqlExpression, SqlExpression> pair2 : info.getConditionalBranches()) {
                void condition;
                SqlExpression sqlExpression = (SqlExpression)pair2.component1();
                SqlExpression expression = (SqlExpression)pair2.component2();
                $this$with.keyword("WHEN ").plain(condition.getText()).space().keyword("THEN ").plain(expression.getText());
                $this$with.newLine();
            }
            $this$with.keyword("ELSE ").plain(info.getElseExpression().getText());
            $this$with.newLine();
            $this$with.keyword("END");
            String string = $this$with.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(DdlBuilder()) {\n   \u2026        statement\n      }");
            String caseText = string;
            SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(caseText, dialect, (PsiElement)callExpression);
            if (sqlExpression == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"SqlPsiElementFactory.cre\u2026callExpression) ?: return");
            SqlExpression caseExpression = sqlExpression;
            PsiElement newElement = callExpression.replace((PsiElement)caseExpression);
            CodeStyleManager.getInstance((Project)project).reformat(newElement);
        }

        public ConvertToCaseFix(@NotNull SqlFunctionCallExpression callExpression) {
            Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
            super((PsiElement)callExpression);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\n2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$Companion;", "", "()V", "getBranchingInfo", "Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$BranchingInfo;", "Lcom/intellij/sql/psi/SqlCaseExpression;", "caps", "", "Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$FunctionKind;", "", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "getIfCaps", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "file", "Lcom/intellij/sql/psi/SqlFile;", "intellij.database.sql.impl"})
    public static final class Companion {
        private final Map<FunctionKind, String> getIfCaps(SqlLanguageDialectEx $this$getIfCaps, SqlFile file) {
            Map map2;
            Dbms dbms = $this$getIfCaps.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dbms");
            Dbms dbms2 = dbms;
            if (dbms2.isMicrosoft()) {
                Version version = SqlImplUtil.getMinDbmsVersion((PsiElement)file);
                if (version != null && version.compareTo(new int[]{11}) < 0) {
                    return MapsKt.emptyMap();
                }
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"IIF"));
            } else if (dbms2.isMysql()) {
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"IF"));
            } else if (Intrinsics.areEqual((Object)dbms2, (Object)Dbms.SNOWFLAKE)) {
                map2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"IFF"), TuplesKt.to((Object)((Object)FunctionKind.DECODE), (Object)"DECODE")});
            } else if (dbms2.isHive() || dbms2.isSpark()) {
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"if"));
            } else if (dbms2.isClickHouse()) {
                map2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"if"), TuplesKt.to((Object)((Object)FunctionKind.MULTI_IF), (Object)"multiIf")});
            } else if (dbms2.isRedshift()) {
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.DECODE), (Object)"decode"));
            } else if (dbms2.isDb2() || dbms2.isExasol() || dbms2.isHsqldb() || dbms2.isOracle() || dbms2.isVertica()) {
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.DECODE), (Object)"DECODE"));
            } else {
                return MapsKt.emptyMap();
            }
            return map2;
        }

        private final BranchingInfo getBranchingInfo(SqlCaseExpression $this$getBranchingInfo, Map<FunctionKind, String> caps) {
            SqlExpression subject = $this$getBranchingInfo.getExpression();
            boolean isSimpleSubject = subject == null || subject instanceof SqlLiteralExpression || subject instanceof SqlReferenceExpression;
            boolean supportsMulti = caps.get((Object)FunctionKind.MULTI_IF) != null && isSimpleSubject || caps.get((Object)FunctionKind.DECODE) != null;
            List list = $this$getBranchingInfo.getBranches();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"branches");
            List branches = list;
            ArrayList conditionalBranches = new ArrayList(branches.size());
            SqlExpression elseExpression = null;
            for (SqlClause branch : branches) {
                SqlClause sqlClause = branch;
                if (sqlClause instanceof SqlWhenThenClause) {
                    SqlExpression expression;
                    SqlElement sqlElement;
                    SqlWhenClause sqlWhenClause;
                    if (!supportsMulti) {
                        Collection collection = conditionalBranches;
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            return null;
                        }
                    }
                    if ((sqlWhenClause = ((SqlWhenThenClause)branch).getWhenClause()) == null || (sqlWhenClause = sqlWhenClause.getExpression()) == null) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)sqlWhenClause, (String)"branch.whenClause?.expression ?: return null");
                    SqlWhenClause condition = sqlWhenClause;
                    SqlThenClause sqlThenClause = ((SqlWhenThenClause)branch).getThenClause();
                    if (!((sqlThenClause != null && (sqlThenClause = sqlThenClause.getBody()) != null ? (SqlElement)CollectionsKt.singleOrNull((Iterable)((Iterable)sqlThenClause)) : (sqlElement = null)) instanceof SqlExpression)) {
                        sqlElement = null;
                    }
                    if ((SqlExpression)sqlElement == null) {
                        return null;
                    }
                    Collection collection = conditionalBranches;
                    Pair pair = TuplesKt.to((Object)condition, (Object)expression);
                    boolean bl = false;
                    collection.add(pair);
                    continue;
                }
                if (!(sqlClause instanceof SqlElseClause)) continue;
                if (elseExpression != null) {
                    return null;
                }
                JBIterable jBIterable = ((SqlElseClause)branch).getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"branch.body");
                Object object = CollectionsKt.singleOrNull((Iterable)((Iterable)jBIterable));
                if (!(object instanceof SqlExpression)) {
                    object = null;
                }
                if ((SqlExpression)object != null) continue;
                return null;
            }
            SqlExpression sqlExpression = elseExpression;
            if (sqlExpression == null) {
                return null;
            }
            return new BranchingInfo(subject, conditionalBranches, sqlExpression);
        }

        /*
         * WARNING - void declaration
         */
        private final BranchingInfo getBranchingInfo(SqlFunctionCallExpression $this$getBranchingInfo, Map<FunctionKind, String> caps) {
            BranchingInfo branchingInfo;
            Object v1;
            block14: {
                Object object = $this$getBranchingInfo.getFunctionDefinition();
                if (object == null || (object = object.getName()) == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"functionDefinition?.name ?: return null");
                Object functionName = object;
                Iterable $this$firstOrNull$iv = caps.keySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FunctionKind it2 = (FunctionKind)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)caps.get((Object)it2), (Object)functionName)) continue;
                    v1 = element$iv;
                    break block14;
                }
                v1 = null;
            }
            FunctionKind functionKind = v1;
            if (functionKind == null) {
                return null;
            }
            FunctionKind kind = functionKind;
            Object object = $this$getBranchingInfo.getParameterList();
            if (object == null || (object = object.getExpressionList()) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameterList?.expressionList ?: return null");
            Object arguments = object;
            int n = arguments.size();
            switch (SqlCaseVsIfInspection$Companion$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: 
                case 2: {
                    if (n < 3 || n % 2 != 1) {
                        return null;
                    }
                    int conditionCount = n / 2;
                    ArrayList conditionalBranches = new ArrayList(conditionCount);
                    IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(n - 1))), (int)2);
                    int it2 = intProgression.getFirst();
                    int n2 = intProgression.getLast();
                    int n3 = intProgression.getStep();
                    int n4 = it2;
                    int n5 = n2;
                    if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
                        while (true) {
                            void i2;
                            Collection collection = conditionalBranches;
                            Pair pair = TuplesKt.to(arguments.get((int)i2), arguments.get((int)(i2 + true)));
                            boolean bl = false;
                            collection.add(pair);
                            if (i2 == n2) break;
                            i2 += n3;
                        }
                    }
                    List list = conditionalBranches;
                    Object object2 = CollectionsKt.last((List)arguments);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"arguments.last()");
                    branchingInfo = new BranchingInfo(null, list, (SqlExpression)object2);
                    break;
                }
                case 3: {
                    if (n < 4 || n % 2 != 0) {
                        return null;
                    }
                    int conditionCount = n / 2 - 1;
                    ArrayList conditionalBranches = new ArrayList(conditionCount);
                    IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)1, (int)(n - 1))), (int)2);
                    int i2 = intProgression.getFirst();
                    int n2 = intProgression.getLast();
                    int n6 = intProgression.getStep();
                    int n7 = i2;
                    int n8 = n2;
                    if (n6 >= 0 ? n7 <= n8 : n7 >= n8) {
                        while (true) {
                            Collection collection = conditionalBranches;
                            Pair pair = TuplesKt.to(arguments.get(i2), arguments.get(i2 + 1));
                            boolean bl = false;
                            collection.add(pair);
                            if (i2 == n2) break;
                            i2 += n6;
                        }
                    }
                    SqlExpression sqlExpression = (SqlExpression)CollectionsKt.first((List)arguments);
                    List list = conditionalBranches;
                    Object object3 = CollectionsKt.last((List)arguments);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"arguments.last()");
                    branchingInfo = new BranchingInfo(sqlExpression, list, (SqlExpression)object3);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return branchingInfo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

