/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlCallNotationInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlCallNotationInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        if (!(dbms2.isOracle() || dbms2.isPostgres() || dbms2.isDb2())) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(onTheFly, manager, dialect, result, manager, dialect, result){
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                this.processCall(o);
                super.visitSqlFunctionCallExpression(o);
            }

            /*
             * WARNING - void declaration
             */
            private final void processCall(SqlFunctionCallExpression o) {
                int namedArgStart;
                Object arguments;
                block6: {
                    int n;
                    Object object = o.getParameterList();
                    if (object == null || (object = object.getExpressionList()) == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"o.parameterList?.expressionList ?: return");
                    Object $this$indexOfFirst$iv = arguments = object;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<E> iterator = $this$indexOfFirst$iv.iterator();
                    while (iterator.hasNext()) {
                        E item$iv = iterator.next();
                        SqlExpression it2 = (SqlExpression)item$iv;
                        boolean bl = false;
                        if (it2 instanceof SqlNamedParameterValueExpression) {
                            n = index$iv;
                            break block6;
                        }
                        ++index$iv;
                    }
                    n = namedArgStart = -1;
                }
                if (namedArgStart < 0) {
                    return;
                }
                int $this$indexOfFirst$iv = namedArgStart + 1;
                int n = arguments.size();
                while ($this$indexOfFirst$iv < n) {
                    void i2;
                    SqlExpression argument = (SqlExpression)arguments.get((int)i2);
                    if (!(argument instanceof SqlNamedParameterValueExpression)) {
                        SqlExpression sqlExpression = argument;
                        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"argument");
                        this.reportProblem((PsiElement)sqlExpression);
                    }
                    ++i2;
                }
            }

            private final void reportProblem(PsiElement anchor) {
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor, SqlBundle.message("inspection.message.positional.argument.after.named", new Object[0]), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
            }
            {
                this.$onTheFly = $captured_local_variable$0;
                this.$manager = $captured_local_variable$1;
                this.$dialect = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
    }
}

