/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.Casing;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlAmbiguousColumnInspection
extends SqlInspectionBase {
    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(final @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                ObjectKind type = o.getReferenceElementType().getTargetKind();
                SqlExpression qualifier = o.getQualifierExpression();
                if (type == ObjectKind.COLUMN && qualifier != null) {
                    SqlTableType qualifierType = (SqlTableType)ObjectUtils.tryCast((Object)qualifier.getSqlType(), SqlTableType.class);
                    if (qualifierType == null) {
                        return;
                    }
                    Casing casing = dialect.getCasing(type, null);
                    String effectiveRefName = SqlImplUtil.getEffectiveName(o.getName(), o.isQuoted(), casing);
                    int matches = 0;
                    for (int i2 = 0; i2 < qualifierType.getColumnCount() && matches <= 1; ++i2) {
                        String effectiveColName = SqlImplUtil.getEffectiveName(qualifierType.getColumnName(i2), qualifierType.isColumnQuoted(i2), casing);
                        if (!effectiveColName.equals(effectiveRefName)) continue;
                        ++matches;
                    }
                    if (matches > 1) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, SqlBundle.message("ambiguous.column.short.reference", o.getName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                }
                if ((type == SqlDbElementType.ANY || type == ObjectKind.COLUMN) && qualifier == null) {
                    SqlJoinExpression joinExpression;
                    SqlFromClause fromClause;
                    PsiElement clause = (PsiElement)SyntaxTraverser.psiApi().parents((Object)o).filter(e -> e instanceof SqlUsingClause || e.getParent() instanceof SqlQueryExpression || e.getParent() instanceof SqlTableExpression).first();
                    if (clause instanceof SqlUsingClause || clause == null) {
                        return;
                    }
                    SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlQueryExpression.class, (boolean)true);
                    SqlTableExpression tableExpression = queryExpression == null ? null : queryExpression.getTableExpression();
                    SqlType queryExpressionType = queryExpression != null ? queryExpression.getSqlType() : null;
                    SqlFromClause sqlFromClause = fromClause = tableExpression == null ? null : tableExpression.getFromClause();
                    if (fromClause == null) {
                        return;
                    }
                    Dbms dbms = this.myDialect.getDbms();
                    SqlTableType tableType = clause instanceof SqlFromClause ? ((joinExpression = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlJoinExpression.class, (boolean)true)) == null ? tableExpression.getSqlType() : joinExpression.getSqlType()) : (clause instanceof SqlOrderByClause || clause instanceof SqlGroupByClause && dbms.isMysql() ? (queryExpressionType instanceof SqlTableType ? (SqlTableType)queryExpressionType : SqlTableTypeBase.EMPTY_TABLE) : tableExpression.getSqlType());
                    String columnName = o.getName();
                    int matchedAliases = 0;
                    int matchedColumns = 0;
                    int count2 = tableType.getColumnCount();
                    for (int i3 = 0; i3 < count2; ++i3) {
                        if (!Comparing.strEqual((String)columnName, (String)tableType.getColumnName(i3), (boolean)false)) continue;
                        if (tableType.getColumnElement(i3) instanceof SqlAsExpression) {
                            ++matchedAliases;
                            continue;
                        }
                        ++matchedColumns;
                    }
                    if (matchedAliases + matchedColumns <= 1) {
                        return;
                    }
                    if (clause instanceof SqlOrderByClause) {
                        if (dbms.isDb2() && matchedColumns == 1 && matchedAliases == 1) {
                            return;
                        }
                        if (dbms.isSybase() && matchedAliases == 0) {
                            return;
                        }
                    }
                    ArrayList<Object> names = new ArrayList<Object>(matchedAliases + matchedColumns);
                    int count3 = tableType.getColumnCount();
                    for (int i4 = 0; i4 < count3; ++i4) {
                        if (!Comparing.strEqual((String)columnName, (String)tableType.getColumnName(i4), (boolean)false)) continue;
                        String tableAlias = tableType.getColumnTypeAlias(i4);
                        if (tableAlias != null) {
                            names.add(tableAlias + "." + columnName);
                            continue;
                        }
                        PsiElement c2 = tableType.getSourceColumnElement(i4);
                        names.add(c2 == null ? columnName : SqlAmbiguousColumnInspection.getQualifiedName(c2));
                    }
                    Collections.sort(names);
                    for (SqlUsingClause usingClause : SqlAmbiguousColumnInspection.getAllUsingClauses(tableExpression)) {
                        List<SqlReferenceExpression> referenceList = SqlImplUtil.getReferenceList(usingClause.getReferenceList());
                        if (referenceList.isEmpty()) continue;
                        if (names.isEmpty()) break;
                        for (SqlAsExpression expression : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)usingClause.getParent(), SqlAsExpression.class)) {
                            names.remove(expression.getName() + "." + columnName);
                        }
                        for (SqlReferenceExpression reference : referenceList) {
                            for (ResolveResult resolveResult : reference.multiResolve(false)) {
                                names.remove(SqlAmbiguousColumnInspection.getQualifiedName(resolveResult.getElement()));
                            }
                        }
                    }
                    if (names.size() > 1) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, SqlBundle.message("ambiguous.column.short.reference", StringUtil.join((String[])ArrayUtilRt.toStringArray(names), (String)",\n")), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection$1", "visitSqlReferenceExpression"));
            }
        };
    }

    @NotNull
    private static Collection<SqlUsingClause> getAllUsingClauses(@NotNull SqlTableExpression tableExpression) {
        SqlFromClause fromClause;
        if (tableExpression == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(3);
        }
        if ((fromClause = tableExpression.getFromClause()) == null) {
            List<SqlUsingClause> list = Collections.emptyList();
            if (list == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(4);
            }
            return list;
        }
        final ArrayList<SqlUsingClause> result = new ArrayList<SqlUsingClause>();
        fromClause.acceptChildren(new SqlVisitor(){

            public void visitSqlJoinExpression(@NotNull SqlJoinExpression o) {
                if (o == null) {
                    2.$$$reportNull$$$0(0);
                }
                o.acceptChildren((SqlVisitor)this);
            }

            public void visitSqlUsingClause(SqlUsingClause o) {
                result.add(o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection$2", "visitSqlJoinExpression"));
            }
        });
        ArrayList<SqlUsingClause> arrayList = result;
        if (arrayList == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    protected boolean isDialectIgnored(SqlLanguageDialectEx dialect) {
        return super.isDialectIgnored(dialect) || dialect.getDbms() == Dbms.CLICKHOUSE;
    }

    @NotNull
    public static String getQualifiedName(@Nullable PsiElement element2) {
        if (element2 == null) {
            return "";
        }
        if (element2 instanceof DbElement) {
            String string = QNameUtil.getQualifiedName((DbElement)element2);
            if (string == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (element2 instanceof SqlDefinition) {
            String string = QNameUtil.getQualifiedName((DasObject)((SqlDefinition)element2));
            if (string == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (element2 instanceof PsiNamedElement) {
            String string = StringUtil.notNullize((String)((PsiNamedElement)element2).getName());
            if (string == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)element2.getText());
        if (string == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableExpression";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlAmbiguousColumnInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlAmbiguousColumnInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUsingClauses";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllUsingClauses";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

