/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.sql.SqlBundle;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/RenamePsiFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.database.sql.impl"})
public final class RenamePsiFix
implements LocalQuickFix {
    public static final RenamePsiFix INSTANCE;

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.rename.element", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026ily.name.rename.element\")");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getStartElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"descriptor.startElement");
        this.applyFix(psiElement);
    }

    public final void applyFix(@NotNull PsiElement element2) {
        block2: {
            PsiFile file;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            PsiFile psiFile = file = element2.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file");
            Project project = psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
            Project project2 = project;
            Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file);
            if (document == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026tDocument(file) ?: return");
            Document doc = document;
            Editor editor = EditorFactory.getInstance().editors(doc).findFirst().orElse(null);
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            editor2.getCaretModel().moveToOffset(element2.getTextOffset());
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor2.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance(\u2026Context(editor.component)");
            DataContext dataContext2 = dataContext;
            RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext2);
            if (renameHandler == null) break block2;
            renameHandler.invoke(project2, editor2, file, dataContext2);
        }
    }

    private RenamePsiFix() {
    }

    static {
        RenamePsiFix renamePsiFix;
        INSTANCE = renamePsiFix = new RenamePsiFix();
    }
}

