/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.DropPsiFix;
import com.intellij.sql.inspections.QuickFixWithExplicitWrite;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ThrowableRunnable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0012\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/inspections/DropPsiFix;", "Lcom/intellij/sql/inspections/QuickFixWithExplicitWrite;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "dropRange", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "recreateCallArguments", "argumentList", "Lcom/intellij/sql/psi/SqlExpressionList;", "intellij.database.sql.impl"})
public final class DropPsiFix
extends QuickFixWithExplicitWrite {
    public static final DropPsiFix INSTANCE;

    private final void recreateCallArguments(SqlExpressionList argumentList) {
        PsiElement psiElement = argumentList.getParent();
        if (!(psiElement instanceof SqlFunctionCallExpression)) {
            psiElement = null;
        }
        SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)psiElement;
        if (sqlFunctionCallExpression == null) {
            return;
        }
        SqlFunctionCallExpression call = sqlFunctionCallExpression;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)call);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(call)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Project project = call.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"call.project");
        Project project2 = project;
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(call.getText(), dialect, project2, null);
        if (sqlExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"SqlPsiElementFactory.cre\u2026 project, null) ?: return");
        SqlExpression callCopy = sqlExpression;
        call.replace((PsiElement)callCopy);
    }

    public final void dropRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PsiElement parent2 = startElement.getParent();
        if (Intrinsics.areEqual((Object)endElement.getParent(), (Object)parent2) ^ true) {
            return;
        }
        Runnable action2 = new Runnable(parent2, startElement, endElement){
            final /* synthetic */ PsiElement $parent;
            final /* synthetic */ PsiElement $startElement;
            final /* synthetic */ PsiElement $endElement;

            public final void run() {
                WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<Throwable>(this){
                    final /* synthetic */ dropRange.action.1 this$0;

                    public final void run() {
                        block1: {
                            this.this$0.$parent.deleteChildRange(this.this$0.$startElement, this.this$0.$endElement);
                            PsiElement psiElement = this.this$0.$parent;
                            if (!(psiElement instanceof SqlExpressionList)) {
                                psiElement = null;
                            }
                            SqlExpressionList sqlExpressionList = (SqlExpressionList)psiElement;
                            if (sqlExpressionList == null) break block1;
                            SqlExpressionList sqlExpressionList2 = sqlExpressionList;
                            DropPsiFix dropPsiFix = DropPsiFix.INSTANCE;
                            boolean bl = false;
                            boolean bl2 = false;
                            SqlExpressionList p1 = sqlExpressionList2;
                            boolean bl3 = false;
                            DropPsiFix.access$recreateCallArguments(dropPsiFix, p1);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.$parent = psiElement;
                this.$startElement = psiElement2;
                this.$endElement = psiElement3;
            }
        };
        if (parent2 instanceof SqlExpressionList) {
            PostprocessReformattingAspect.getInstance((Project)((SqlExpressionList)parent2).getProject()).disablePostprocessFormattingInside(action2);
        } else {
            action2.run();
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.delete.element", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026ily.name.delete.element\")");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getStartElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"descriptor.startElement");
        PsiElement psiElement2 = descriptor2.getEndElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"descriptor.endElement");
        this.dropRange(psiElement, psiElement2);
    }

    private DropPsiFix() {
    }

    static {
        DropPsiFix dropPsiFix;
        INSTANCE = dropPsiFix = new DropPsiFix();
    }

    public static final /* synthetic */ void access$recreateCallArguments(DropPsiFix $this, SqlExpressionList argumentList) {
        $this.recreateCallArguments(argumentList);
    }
}

