/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsDefault;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/formatter/settings/SqlPredefinedCodeStyle;", "Lcom/intellij/psi/codeStyle/PredefinedCodeStyle;", "originalName", "", "displayName", "(Ljava/lang/String;Ljava/lang/String;)V", "getOriginalName", "()Ljava/lang/String;", "apply", "", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "language", "Lcom/intellij/lang/Language;", "getDefaultStyle", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettingsDefault;", "isApplicableToLanguage", "", "setup", "sql", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "Companion", "intellij.database.sql.impl"})
public abstract class SqlPredefinedCodeStyle
extends PredefinedCodeStyle {
    @NotNull
    private final String originalName;
    private static final Logger log;
    public static final Companion Companion;

    @Nullable
    protected SqlCodeStyleSettingsDefault getDefaultStyle() {
        return null;
    }

    public boolean isApplicableToLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language, (Object)SqlLanguage.INSTANCE) || language instanceof SqlLanguageDialect;
    }

    public void apply(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        log.info("Applying pre-defined code style: " + this.originalName);
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings((CodeStyleSettings)settings, (Language)language);
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeStyleSettings, (String)"SqlCodeStyles.getSqlSettings(settings, language)");
        SqlCodeStyleSettings sql = sqlCodeStyleSettings;
        SqlCodeStyleSettingsDefault ds = this.getDefaultStyle();
        if (ds != null) {
            sql.assignDefaults(ds);
        }
        this.setup(sql);
    }

    protected void setup(@NotNull SqlCodeStyleSettings sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
    }

    @NotNull
    public final String getOriginalName() {
        return this.originalName;
    }

    public SqlPredefinedCodeStyle(@NlsSafe @NotNull String originalName, @NlsContexts.ListItem @NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        super(displayName, (Language)SqlLanguage.INSTANCE);
        this.originalName = originalName;
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(SqlPredefinedCodeStyle.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(SqlPr\u2026nedCodeStyle::class.java)");
        log = logger2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/settings/SqlPredefinedCodeStyle$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.sql.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

