/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.Dbms;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.ElementTypeSetContinuePattern;
import com.intellij.sql.formatter.model.EndExcElementContinuePattern;
import com.intellij.sql.formatter.model.EndIncElementContinuePattern;
import com.intellij.sql.formatter.model.FlowContinuePatternKt;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.RowPattern;
import com.intellij.sql.formatter.model.SimplePattern;
import com.intellij.sql.formatter.model.SingletonExpandPattern;
import com.intellij.sql.formatter.model.SingletonPattern;
import com.intellij.sql.formatter.model.SqlAliasBlock;
import com.intellij.sql.formatter.model.SqlBatchBlock;
import com.intellij.sql.formatter.model.SqlBinaryExpressionBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlCodeFlowBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlLineCommentBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedListBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedSubqueryBlock;
import com.intellij.sql.formatter.model.SqlPhraseBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock$SecondaryTableElement$WhenMappings;
import com.intellij.sql.formatter.model.SqlQueryBlock$WordAndListSection$WhenMappings;
import com.intellij.sql.formatter.model.SqlQueryBlock$sam$com_intellij_openapi_util_Condition$0;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlSingleNodeBlock;
import com.intellij.sql.formatter.model.StartStopPattern;
import com.intellij.sql.formatter.model.StartUntilPattern;
import com.intellij.sql.formatter.model.TypePattern;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b!\u0018\u0000 +2\u00020\u0001: *+,-./0123456789:;<=>?@ABCDEFGHIB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\nH\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0010H\u0002J\b\u0010#\u001a\u00020\u0010H\u0002J\b\u0010$\u001a\u00020\u0010H\u0014J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0014R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "commonFirstWordRightAlign", "Lcom/intellij/formatting/Alignment;", "getCommonFirstWordRightAlign", "()Lcom/intellij/formatting/Alignment;", "setCommonFirstWordRightAlign", "(Lcom/intellij/formatting/Alignment;)V", "isAllowedToCollapse", "", "isInsert", "isSubQuery", "isUnion", "checkIsSubquery", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "detectWhetherIntoSeparated", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getDebugName", "", "getNewLineIndent", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "handleWhetherIsInsert", "handleWhetherIsSubquery", "tuneNestedNodesAfterAnalysis", "userWrapSetting", "", "whetherToFlatten", "node", "Lcom/intellij/lang/ASTNode;", "CTE", "Companion", "DeleteSection", "FromSection", "GroupOrderSection", "InsertSection", "JoinCondition", "JoinPhrase", "LimitSection", "OnSection", "OneLineSection", "OutputSection", "PredicateElement", "PrimaryTableElement", "QuerySection", "ReturningSection", "SecondaryTableElement", "SectionElement", "SelectElement", "SelectElementEssence", "SelectSection", "SelectSeparatedPrefix", "SetAssignment", "SetSection", "SqlCortegeLikeParenthesizedListBlock", "UnionSection", "UnknownSection", "UpdateSection", "ValuesSection", "WhereSection", "WithSection", "WordAndListSection", "intellij.database.sql.impl"})
public final class SqlQueryBlock
extends SqlNodeBlock {
    private boolean isSubQuery;
    private boolean isInsert;
    private boolean isUnion;
    private boolean isAllowedToCollapse;
    @Nullable
    private Alignment commonFirstWordRightAlign;
    private static final Set<IElementType> nodesToFlatten;
    private static final Set<String> nodeNamesToFlatten;
    private static final Set<IElementType> sectionMakers;
    private static final Set<IElementType> tableJoinWords;
    private static final Set<IElementType> unionStartWords;
    private static final Set<IElementType> unionGluedWords;
    private static final Set<IElementType> limitStopMartker;
    private static final List<FlowPattern> commonPatterns;
    private static final List<FlowPattern> insertIntoTogetherPatterns;
    private static final List<FlowPattern> insertIntoSeparatedPatterns;
    private static final List<FlowPattern> postgresQueryPatterns;
    public static final Companion Companion;

    @Nullable
    public final Alignment getCommonFirstWordRightAlign() {
        return this.commonFirstWordRightAlign;
    }

    public final void setCommonFirstWordRightAlign(@Nullable Alignment alignment) {
        this.commonFirstWordRightAlign = alignment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
        IElementType type = iElementType;
        if (nodesToFlatten.contains(type)) return true;
        if (nodeNamesToFlatten.contains(type.toString())) return true;
        if (!Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION)) return false;
        SqlTokenType sqlTokenType = SqlCommonTokens.SQL_COMMA;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_COMMA");
        if (!SqlUtilFun.hasChildNode(node, (IElementType)sqlTokenType)) return false;
        return true;
    }

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        List<FlowPattern> list;
        this.handleWhetherIsSubquery();
        this.handleWhetherIsInsert();
        boolean bl = this.isInsert;
        if (!bl) {
            Dbms dbms = this.getContext().getDialect().getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"context.dialect.dbms");
            list = dbms.isPostgres() ? postgresQueryPatterns : commonPatterns;
        } else if (bl) {
            boolean separate;
            switch (this.getContext().getSql().INSERT_INTO_NL) {
                case 1: {
                    boolean bl2 = true;
                    break;
                }
                case 2: {
                    boolean bl2 = false;
                    break;
                }
                default: {
                    boolean bl2 = separate = this.detectWhetherIntoSeparated();
                }
            }
            list = separate ? insertIntoSeparatedPatterns : insertIntoTogetherPatterns;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final void handleWhetherIsSubquery() {
        boolean bl;
        this.isSubQuery = this.checkIsSubquery();
        switch (this.getContext().getSql().QUERY_IN_ONE_STRING) {
            case 0: {
                if (!this.contains('\n')) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 2: {
                bl = this.isSubQuery;
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        this.isAllowedToCollapse = bl;
    }

    private final void handleWhetherIsInsert() {
        IElementType iElementType = SqlUtilFun.firstLeaf(this.getBlockNode()).getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"blockNode.firstLeaf().elementType");
        IElementType firstType = iElementType;
        this.isInsert = Intrinsics.areEqual((Object)firstType, (Object)SqlCommonKeywords.SQL_INSERT) || Intrinsics.areEqual((Object)firstType, (Object)SqlCommonKeywords.SQL_REPLACE);
    }

    private final boolean detectWhetherIntoSeparated() {
        Object v3;
        ASTNode insertNode;
        block4: {
            Object v1;
            JBIterable<ASTNode> children2;
            block3: {
                children2 = SqlUtilFun.children(this.getBlockNode());
                Iterable $this$firstOrNull$iv = (Iterable)children2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ASTNode it2 = (ASTNode)element$iv;
                    boolean bl = false;
                    ASTNode aSTNode = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it");
                    if (!(aSTNode.getElementType() == SqlCommonKeywords.SQL_INSERT)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            insertNode = v1;
            Iterable $this$firstOrNull$iv = (Iterable)children2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it3 = (ASTNode)element$iv;
                boolean bl = false;
                ASTNode aSTNode = it3;
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it");
                if (!(aSTNode.getElementType() == SqlCompositeElementTypes.SQL_INSERT_DML_INSTRUCTION || it3.getElementType() == SqlCommonKeywords.SQL_INTO)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        ASTNode intoNode = v3;
        if (insertNode == null || intoNode == null) {
            return false;
        }
        SqlFormattingContext sqlFormattingContext = this.getContext();
        TextRange textRange = insertNode.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"insertNode.textRange");
        return sqlFormattingContext.textContains(textRange.getEndOffset(), intoNode.getStartOffset(), '\n');
    }

    private final boolean checkIsSubquery() {
        for (SqlBlock p2 = this.getParent(); p2 != null; p2 = p2.getParent()) {
            if (p2 instanceof SqlQueryBlock) {
                return true;
            }
            if (!(p2 instanceof SqlCodeFlowBlock) || p2 instanceof SqlBatchBlock) continue;
            return true;
        }
        return false;
    }

    @Override
    public int userWrapSetting() {
        int n;
        switch (this.getContext().getSql().QUERY_IN_ONE_STRING) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                if (this.isSubQuery) {
                    n = 2;
                    break;
                }
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Override
    protected void tuneNestedNodesAfterAnalysis() {
        super.tuneNestedNodesAfterAnalysis();
        if (this.getShape().compareTo((Enum)BlockShape.DECIDE_LATER) >= 0) {
            for (SqlBlock b2 : this.getNestedBlocks()) {
                boolean toExpand;
                if (b2 instanceof UnionSection) {
                    this.isUnion = true;
                }
                if (!(b2 instanceof WordAndListSection) || !(toExpand = ((WordAndListSection)b2).userWrapSetting() == 1 && (((WordAndListSection)b2).getCountOfElements() > ((WordAndListSection)b2).userNumberOfElementsToKeepCollapsed() || ((WordAndListSection)b2).userElementsLineSetting() == 101)) || b2.getShape().compareTo((Enum)this.getShape()) >= 0) continue;
                b2.setShape(this.getShape());
            }
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        Wrap w = SqlFlowBlock.makeWrap$default(this, this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
        for (SqlBlock b2 : this.nestedBlocksIter().skip(1)) {
            b2.setMyWrap(w);
        }
        switch (this.getContext().getSql().QUERY_SECTION_1ST_WORD_ALIGN) {
            case 2: {
                Indent i2 = Indent.getNormalIndent((boolean)true);
                for (SqlBlock b3 : this.getNestedBlocks()) {
                    if (!(b3 instanceof QuerySection) || !((QuerySection)b3).whetherSectionToIndent()) continue;
                    b3.setMyIndent(i2);
                }
                break;
            }
            case 8: {
                QuerySection it2;
                int thePrefixLength = 6;
                Iterable $this$filter$iv = this.getNestedBlocks();
                boolean $i$f$filter = false;
                Object $this$jbi$iv$iv = $this$filter$iv;
                boolean $i$f$getJbi = false;
                JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
                JBIterable jBIterable2 = jBIterable.filter(QuerySection.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
                Iterable $this$forEach$iv = (Iterable)jBIterable2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it2 = (QuerySection)element$iv;
                    boolean bl = false;
                    if (it2.getFirstWordLength$intellij_database_sql_impl() <= thePrefixLength) continue;
                    thePrefixLength = it2.getFirstWordLength$intellij_database_sql_impl();
                }
                $this$filter$iv = this.getNestedBlocks();
                $i$f$filter = false;
                $this$jbi$iv$iv = $this$filter$iv;
                $i$f$getJbi = false;
                JBIterable jBIterable3 = JBIterable.from((Iterable)$this$jbi$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"JBIterable.from(this)");
                JBIterable jBIterable4 = jBIterable3.filter(QuerySection.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"this.jbi.filter(B::class.java)");
                $this$forEach$iv = (Iterable)jBIterable4;
                $i$f$forEach = false;
                for (SqlBlock element$iv : $this$forEach$iv) {
                    it2 = (QuerySection)element$iv;
                    boolean bl = false;
                    if (it2.getFirstWordLength$intellij_database_sql_impl() >= thePrefixLength) continue;
                    it2.setMyIndent(Indent.getSpaceIndent((int)(thePrefixLength - it2.getFirstWordLength$intellij_database_sql_impl())));
                }
                break;
            }
        }
        switch (this.getContext().getSql().QUERY_SECTION_1ST_WORD_ALIGN) {
            case 1: {
                Alignment a = SqlFormattingModelFunKt.makeLeftAlignment();
                for (SqlBlock b3 : this.getNestedBlocks()) {
                    b3.setMyAlign(a);
                }
                break;
            }
            case 2: {
                Alignment a1 = SqlFormattingModelFunKt.makeLeftAlignment();
                Alignment a2 = SqlFormattingModelFunKt.makeLeftAlignment();
                for (SqlBlock b4 : this.getNestedBlocks()) {
                    b4.setMyAlign(b4 instanceof QuerySection && ((QuerySection)b4).whetherSectionToIndent() ? a2 : a1);
                }
                break;
            }
            case 8: {
                this.commonFirstWordRightAlign = SqlFormattingModelFunKt.makeRightAlignment();
                for (SqlBlock b5 : this.getNestedBlocks()) {
                    SqlLeafBlock sqlLeafBlock = b5.getFirstLeafBlock();
                    if (sqlLeafBlock == null) continue;
                    sqlLeafBlock.setMyAlign(this.commonFirstWordRightAlign);
                }
                break;
            }
        }
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        if (block1 instanceof InsertSection && block2 instanceof InsertSection) {
            switch (this.getContext().getSql().INSERT_INTO_NL) {
                case 1: {
                    spacing = SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                    break;
                }
                case 2: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null);
                    break;
                }
                default: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, true, 1, null);
                    break;
                }
            }
        } else {
            spacing = super.decideSpacing(block1, block2);
        }
        return spacing;
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        SqlBlock block1;
        block0: {
            Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
            SqlBlock sqlBlock = block1 = blocks.getBlock1();
            if (sqlBlock == null) break block0;
            sqlBlock.grow();
        }
        return block1 instanceof QuerySection && block1.incomplete() ? block1.getNewLineIndent(new AdjacentBlocks(block1.getLastNestedSqlBlock(), null)) : SqlFormattingContext.currIndentOf$default(this.getContext(), (Block)this, false, false, 6, null);
    }

    @Override
    @NotNull
    public String getDebugName() {
        return super.getDebugName() + (this.isSubQuery ? "(sub)" : "");
    }

    static {
        Companion = new Companion(null);
        nodesToFlatten = SetsKt.setOf((Object[])new IElementType[]{(IElementType)SqlCompositeElementTypes.SQL_INSERT_DML_INSTRUCTION, (IElementType)SqlCompositeElementTypes.SQL_UPDATE_DML_INSTRUCTION, (IElementType)SqlCompositeElementTypes.SQL_DELETE_DML_INSTRUCTION, (IElementType)SqlCompositeElementTypes.SQL_DML_INSTRUCTION, (IElementType)SqlCompositeElementTypes.SQL_VALUES_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_SET_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_WITH_QUERY_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_WITH_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_SELECT_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_SELECT_INTO_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_SELECT_INTO_NEW_TABLE_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_TABLE_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_TABLE_COLUMNS_LIST, (IElementType)SqlCompositeElementTypes.SQL_REFERENCE_LIST, (IElementType)SqlCompositeElementTypes.SQL_FROM_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_WHERE_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_HIERARCHICAL_QUERY_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_GROUP_BY_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_HAVING_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_UNION_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_ORDER_BY_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_OFFSET_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_LIMIT_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_CLAUSE});
        nodeNamesToFlatten = SetsKt.setOf((Object)"PG_CONFLICT_ACTION_CLAUSE");
        sectionMakers = SetsKt.setOf((Object[])new IElementType[]{(IElementType)SqlCommonKeywords.SQL_INSERT, (IElementType)SqlCommonKeywords.SQL_REPLACE, (IElementType)SqlCommonKeywords.SQL_INTO, (IElementType)SqlCommonKeywords.SQL_ON, (IElementType)SqlCommonKeywords.SQL_UPDATE, (IElementType)SqlCommonKeywords.SQL_DELETE, (IElementType)SqlCommonKeywords.SQL_SET, (IElementType)SqlCommonKeywords.SQL_VALUES, (IElementType)SqlCommonKeywords.SQL_WITH, (IElementType)SqlCommonKeywords.SQL_SELECT, (IElementType)SqlCommonKeywords.SQL_FROM, (IElementType)SqlCommonKeywords.SQL_WHERE, (IElementType)SqlCommonKeywords.SQL_START, (IElementType)SqlCommonKeywords.SQL_CONNECT, (IElementType)SqlCommonKeywords.SQL_GROUP, (IElementType)SqlCommonKeywords.SQL_HAVING, (IElementType)SqlCommonKeywords.SQL_UNION, (IElementType)SqlCommonKeywords.SQL_INTERSECT, (IElementType)SqlCommonKeywords.SQL_MINUS, (IElementType)SqlCommonKeywords.SQL_ORDER, (IElementType)SqlCommonKeywords.SQL_OPTION, (IElementType)SqlCompositeElementTypes.SQL_RETURNING_CLAUSE, (IElementType)SqlCommonKeywords.SQL_OFFSET, (IElementType)SqlCompositeElementTypes.SQL_OFFSET_CLAUSE, (IElementType)SqlCommonKeywords.SQL_LIMIT, (IElementType)SqlCompositeElementTypes.SQL_LIMIT_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_LIMIT_OFFSET_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_QUERY_FLATTEN_CLAUSE});
        tableJoinWords = SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_NATURAL, SqlCommonKeywords.SQL_LEFT, SqlCommonKeywords.SQL_RIGHT, SqlCommonKeywords.SQL_FULL, SqlCommonKeywords.SQL_INNER, SqlCommonKeywords.SQL_OUTER, SqlCommonKeywords.SQL_CROSS, SqlCommonKeywords.SQL_LOOP, SqlCommonKeywords.SQL_HASH, SqlCommonKeywords.SQL_MERGE, SqlCommonKeywords.SQL_REMOTE, SqlCommonKeywords.SQL_LOOP, SqlCommonKeywords.SQL_REDUCE, SqlCommonKeywords.SQL_REPLICATE, SqlCommonKeywords.SQL_REDISTRIBUTE, SqlCommonKeywords.SQL_ARRAY, SqlCommonKeywords.SQL_APPLY, SqlCommonKeywords.SQL_JOIN, SqlCommonKeywords.SQL_LATERAL});
        unionStartWords = SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_UNION, SqlCommonKeywords.SQL_INTERSECT, SqlCommonKeywords.SQL_MINUS});
        unionGluedWords = SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_UNION, SqlCommonKeywords.SQL_INTERSECT, SqlCommonKeywords.SQL_MINUS, SqlCommonKeywords.SQL_ALL});
        limitStopMartker = SetsKt.minus(sectionMakers, (Iterable)SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_OFFSET, SqlCommonKeywords.SQL_LIMIT}));
        Object[] objectArray = new FlowPattern[20];
        SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_INTO;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_INTO");
        objectArray[0] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.1.INSTANCE));
        SqlTokenType sqlTokenType2 = SqlCommonKeywords.SQL_ON;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_ON");
        objectArray[1] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType2), NodeMatcherKt.matchType(SetsKt.minus(sectionMakers, (Iterable)SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_ON, SqlCommonKeywords.SQL_UPDATE, SqlCommonKeywords.SQL_SET}))), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.2.INSTANCE));
        SqlTokenType sqlTokenType3 = SqlCommonKeywords.SQL_UPDATE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_UPDATE");
        objectArray[2] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType3), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.3.INSTANCE));
        SqlTokenType sqlTokenType4 = SqlCommonKeywords.SQL_DELETE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_DELETE");
        objectArray[3] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType4), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.4.INSTANCE));
        SqlTokenType sqlTokenType5 = SqlCommonKeywords.SQL_SET;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType5, (String)"SQL_SET");
        objectArray[4] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType5), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.5.INSTANCE));
        SqlTokenType sqlTokenType6 = SqlCommonKeywords.SQL_VALUES;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType6, (String)"SQL_VALUES");
        objectArray[5] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType6), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.6.INSTANCE));
        SqlTokenType sqlTokenType7 = SqlCommonKeywords.SQL_WITH;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType7, (String)"SQL_WITH");
        objectArray[6] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType7), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.7.INSTANCE));
        SqlTokenType sqlTokenType8 = SqlCommonKeywords.SQL_SELECT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType8, (String)"SQL_SELECT");
        objectArray[7] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType8), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.8.INSTANCE));
        SqlTokenType sqlTokenType9 = SqlCommonKeywords.SQL_FROM;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType9, (String)"SQL_FROM");
        objectArray[8] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType9), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.9.INSTANCE));
        IElementType[] iElementTypeArray = new IElementType[3];
        SqlTokenType sqlTokenType10 = SqlCommonKeywords.SQL_WHERE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType10, (String)"SQL_WHERE");
        iElementTypeArray[0] = (IElementType)sqlTokenType10;
        SqlTokenType sqlTokenType11 = SqlCommonKeywords.SQL_HAVING;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType11, (String)"SQL_HAVING");
        iElementTypeArray[1] = (IElementType)sqlTokenType11;
        SqlTokenType sqlTokenType12 = SqlCommonKeywords.SQL_CONNECT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType12, (String)"SQL_CONNECT");
        iElementTypeArray[2] = (IElementType)sqlTokenType12;
        objectArray[9] = new StartUntilPattern(null, null, NodeMatcherKt.matchType(iElementTypeArray), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.10.INSTANCE));
        SqlTokenType sqlTokenType13 = SqlCommonKeywords.SQL_START;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType13, (String)"SQL_START");
        objectArray[10] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType13), NodeMatcherKt.matchType(SetsKt.minus(sectionMakers, (Object)SqlCommonKeywords.SQL_WITH)), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.11.INSTANCE));
        IElementType[] iElementTypeArray2 = new IElementType[2];
        SqlTokenType sqlTokenType14 = SqlCommonKeywords.SQL_GROUP;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType14, (String)"SQL_GROUP");
        iElementTypeArray2[0] = (IElementType)sqlTokenType14;
        SqlTokenType sqlTokenType15 = SqlCommonKeywords.SQL_ORDER;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType15, (String)"SQL_ORDER");
        iElementTypeArray2[1] = (IElementType)sqlTokenType15;
        objectArray[11] = new StartUntilPattern(null, null, NodeMatcherKt.matchType(iElementTypeArray2), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.12.INSTANCE));
        IElementType[] iElementTypeArray3 = new IElementType[2];
        SqlTokenType sqlTokenType16 = SqlCommonKeywords.SQL_OFFSET;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType16, (String)"SQL_OFFSET");
        iElementTypeArray3[0] = (IElementType)sqlTokenType16;
        SqlTokenType sqlTokenType17 = SqlCommonKeywords.SQL_LIMIT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType17, (String)"SQL_LIMIT");
        iElementTypeArray3[1] = (IElementType)sqlTokenType17;
        objectArray[12] = new StartUntilPattern(null, null, NodeMatcherKt.matchType(iElementTypeArray3), NodeMatcherKt.matchType(limitStopMartker), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.13.INSTANCE));
        objectArray[13] = new SimplePattern(null, null, NodeMatcherKt.matchType(unionStartWords), NodeMatcherKt.matchType(unionGluedWords), false, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.14.INSTANCE));
        SqlTokenType sqlTokenType18 = SqlCommonKeywords.SQL_OPTION;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType18, (String)"SQL_OPTION");
        objectArray[14] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType18), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.15.INSTANCE));
        IElementType[] iElementTypeArray4 = new IElementType[3];
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_OFFSET_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_OFFSET_CLAUSE");
        iElementTypeArray4[0] = (IElementType)sqlCompositeElementType;
        SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_LIMIT_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType2, (String)"SQL_LIMIT_CLAUSE");
        iElementTypeArray4[1] = (IElementType)sqlCompositeElementType2;
        SqlCompositeElementType sqlCompositeElementType3 = SqlCompositeElementTypes.SQL_LIMIT_OFFSET_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType3, (String)"SQL_LIMIT_OFFSET_CLAUSE");
        iElementTypeArray4[2] = (IElementType)sqlCompositeElementType3;
        objectArray[15] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchType(iElementTypeArray4), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.16.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType4 = SqlCompositeElementTypes.SQL_RETURNING_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType4, (String)"SQL_RETURNING_CLAUSE");
        objectArray[16] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchTypeWhen((IElementType)sqlCompositeElementType4, (Function1<? super ASTNode, Boolean>)((Function1)Companion.commonPatterns.17.INSTANCE)), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.18.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType5 = SqlCompositeElementTypes.SQL_RETURNING_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType5, (String)"SQL_RETURNING_CLAUSE");
        objectArray[17] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchTypeWhen((IElementType)sqlCompositeElementType5, (Function1<? super ASTNode, Boolean>)((Function1)Companion.commonPatterns.19.INSTANCE)), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.20.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType6 = SqlCompositeElementTypes.SQL_RETURNING_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType6, (String)"SQL_RETURNING_CLAUSE");
        objectArray[18] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType6), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.21.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType7 = SqlCompositeElementTypes.SQL_QUERY_FLATTEN_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType7, (String)"SQL_QUERY_FLATTEN_CLAUSE");
        objectArray[19] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType7), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.22.INSTANCE));
        commonPatterns = CollectionsKt.listOf((Object[])objectArray);
        Collection collection = commonPatterns;
        IElementType[] iElementTypeArray5 = new IElementType[2];
        SqlTokenType sqlTokenType19 = SqlCommonKeywords.SQL_INSERT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType19, (String)"SQL_INSERT");
        iElementTypeArray5[0] = (IElementType)sqlTokenType19;
        SqlTokenType sqlTokenType20 = SqlCommonKeywords.SQL_REPLACE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType20, (String)"SQL_REPLACE");
        iElementTypeArray5[1] = (IElementType)sqlTokenType20;
        insertIntoTogetherPatterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object)new StartUntilPattern(null, null, NodeMatcherKt.matchType(iElementTypeArray5), NodeMatcherKt.matchType(SetsKt.minus(sectionMakers, (Object)SqlCommonKeywords.SQL_INTO)), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.insertIntoTogetherPatterns.1.INSTANCE))));
        Collection collection2 = commonPatterns;
        IElementType[] iElementTypeArray6 = new IElementType[2];
        SqlTokenType sqlTokenType21 = SqlCommonKeywords.SQL_INSERT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType21, (String)"SQL_INSERT");
        iElementTypeArray6[0] = (IElementType)sqlTokenType21;
        SqlTokenType sqlTokenType22 = SqlCommonKeywords.SQL_REPLACE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType22, (String)"SQL_REPLACE");
        iElementTypeArray6[1] = (IElementType)sqlTokenType22;
        insertIntoSeparatedPatterns = CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOf((Object)new StartUntilPattern(null, null, NodeMatcherKt.matchType(iElementTypeArray6), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.insertIntoSeparatedPatterns.1.INSTANCE))));
        Collection collection3 = commonPatterns;
        SqlTokenType sqlTokenType23 = SqlCommonKeywords.SQL_PERFORM;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType23, (String)"SQL_PERFORM");
        postgresQueryPatterns = CollectionsKt.plus((Collection)collection3, (Iterable)CollectionsKt.listOf((Object)new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType23), NodeMatcherKt.matchType(sectionMakers), true, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.postgresQueryPatterns.1.INSTANCE))));
    }

    public static final /* synthetic */ void access$setAllowedToCollapse$p(SqlQueryBlock $this, boolean bl) {
        $this.isAllowedToCollapse = bl;
    }

    public static final /* synthetic */ void access$setUnion$p(SqlQueryBlock $this, boolean bl) {
        $this.isUnion = bl;
    }

    public static final /* synthetic */ Set access$getTableJoinWords$cp() {
        return tableJoinWords;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\nH&J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "firstWord", "Lcom/intellij/psi/tree/IElementType;", "getFirstWord$intellij_database_sql_impl", "()Lcom/intellij/psi/tree/IElementType;", "setFirstWord$intellij_database_sql_impl", "(Lcom/intellij/psi/tree/IElementType;)V", "firstWordLength", "", "getFirstWordLength$intellij_database_sql_impl", "()I", "setFirstWordLength$intellij_database_sql_impl", "(I)V", "prefixLength", "getPrefixLength$intellij_database_sql_impl", "setPrefixLength$intellij_database_sql_impl", "prefixSize", "getPrefixSize$intellij_database_sql_impl", "setPrefixSize$intellij_database_sql_impl", "thisQuery", "Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "getThisQuery$intellij_database_sql_impl", "()Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "adjustNestedNodes", "", "userElementsLineSetting", "userRequiresExpand", "", "whetherSectionToIndent", "intellij.database.sql.impl"})
    private static abstract class QuerySection
    extends SqlRangeBlock {
        private int prefixSize;
        private int prefixLength;
        @Nullable
        private IElementType firstWord;
        private int firstWordLength;

        @NotNull
        public final SqlQueryBlock getThisQuery$intellij_database_sql_impl() {
            SqlQueryBlock sqlQueryBlock;
            SqlBlock p2 = this.getParent();
            if (p2 instanceof SqlQueryBlock) {
                sqlQueryBlock = (SqlQueryBlock)p2;
            } else if (p2 instanceof QuerySection) {
                sqlQueryBlock = ((QuerySection)p2).getThisQuery$intellij_database_sql_impl();
            } else {
                throw (Throwable)new IllegalStateException("The parent of QuerySection must be Query or QuerySection, but it is " + p2);
            }
            return sqlQueryBlock;
        }

        public final int getPrefixSize$intellij_database_sql_impl() {
            return this.prefixSize;
        }

        public final void setPrefixSize$intellij_database_sql_impl(int n) {
            this.prefixSize = n;
        }

        public final int getPrefixLength$intellij_database_sql_impl() {
            return this.prefixLength;
        }

        public final void setPrefixLength$intellij_database_sql_impl(int n) {
            this.prefixLength = n;
        }

        @Nullable
        public final IElementType getFirstWord$intellij_database_sql_impl() {
            return this.firstWord;
        }

        public final void setFirstWord$intellij_database_sql_impl(@Nullable IElementType iElementType) {
            this.firstWord = iElementType;
        }

        public final int getFirstWordLength$intellij_database_sql_impl() {
            return this.firstWordLength;
        }

        public final void setFirstWordLength$intellij_database_sql_impl(int n) {
            this.firstWordLength = n;
        }

        @Override
        protected void adjustNestedNodes() {
            super.adjustNestedNodes();
            ASTNode firstNode = (ASTNode)CollectionsKt.firstOrNull(this.getNestedNodes());
            if (firstNode != null) {
                this.firstWord = firstNode.getElementType();
                this.firstWordLength = firstNode.getTextLength();
            }
        }

        public boolean whetherSectionToIndent() {
            return false;
        }

        @Override
        public abstract int userElementsLineSetting();

        @Override
        public boolean userRequiresExpand() {
            return (this.userElementsLineSetting() == 101 || this.userWrapSetting() == 1) && !this.getThisQuery$intellij_database_sql_impl().isAllowedToCollapse;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\"\u0018\u0000 >2\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020&H\u0014J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020 H\u0014J\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020 H\u0016J\b\u0010.\u001a\u00020\u0004H\u0014J\u0010\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u000100H$J\b\u00102\u001a\u00020\u0004H\u0014J\b\u00103\u001a\u000204H\u0016J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020&H\u0014J\b\u0010:\u001a\u00020\u0004H\u0014J\b\u0010;\u001a\u00020\nH\u0015J\b\u0010<\u001a\u00020\nH\u0016J\b\u0010=\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R$\u0010\t\u001a\u00020\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u0014\u0010\u0019\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u0014\u0010\u001b\u001a\u00020\u001c8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006?"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "comma1st", "", "getComma1st", "()Z", "commaLast", "getCommaLast", "commaPlace", "", "getCommaPlace$annotations", "getCommaPlace", "()I", "setCommaPlace", "(I)V", "countOfDelimiters", "getCountOfDelimiters", "setCountOfDelimiters", "countOfElements", "getCountOfElements", "setCountOfElements", "countOfLineComments", "getCountOfLineComments", "setCountOfLineComments", "delimiterLength", "getDelimiterLength", "delimiterType", "Lcom/intellij/sql/psi/SqlTokenType;", "getDelimiterType", "()Lcom/intellij/sql/psi/SqlTokenType;", "prefix", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getPrefix", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setPrefix", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "analyseOriginalCodeStyle", "", "configureFormattingAttributes", "considerBlock", "block", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "determineWrapFirstElement", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "flowToProduceCommentsFlowBlocks", "getChildAttributesForNewElementAtTheEnd", "Lcom/intellij/formatting/ChildAttributes;", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "tabifyContent", "toAlignElements", "userCommaSetting", "userNumberOfElementsToKeepCollapsed", "userRequiresExpand", "Companion", "intellij.database.sql.impl"})
    private static abstract class WordAndListSection
    extends QuerySection {
        @Nullable
        private SqlBlock prefix;
        private int countOfElements;
        private int countOfDelimiters;
        private int countOfLineComments;
        private int commaPlace;
        @NotNull
        private static final List<FlowPattern> commonPatterns;
        protected static final Companion Companion;

        @Nullable
        public final SqlBlock getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(@Nullable SqlBlock sqlBlock) {
            this.prefix = sqlBlock;
        }

        public final int getCountOfElements() {
            return this.countOfElements;
        }

        public final void setCountOfElements(int n) {
            this.countOfElements = n;
        }

        public final int getCountOfDelimiters() {
            return this.countOfDelimiters;
        }

        public final void setCountOfDelimiters(int n) {
            this.countOfDelimiters = n;
        }

        public final int getCountOfLineComments() {
            return this.countOfLineComments;
        }

        public final void setCountOfLineComments(int n) {
            this.countOfLineComments = n;
        }

        @NotNull
        protected SqlTokenType getDelimiterType() {
            SqlTokenType sqlTokenType = SqlCommonTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_COMMA");
            return sqlTokenType;
        }

        protected int getDelimiterLength() {
            return 1;
        }

        @Override
        @Nullable
        protected abstract List<FlowPattern> flowPatterns();

        @Override
        protected boolean flowToProduceCommentsFlowBlocks() {
            return false;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            super.considerBlock(block);
            switch (SqlQueryBlock$WordAndListSection$WhenMappings.$EnumSwitchMapping$0[block.getRole().ordinal()]) {
                case 1: {
                    this.prefix = block;
                    break;
                }
                case 2: {
                    int n = this.countOfElements;
                    this.countOfElements = n + 1;
                    break;
                }
                case 3: {
                    int n = this.countOfDelimiters;
                    this.countOfDelimiters = n + 1;
                    break;
                }
                case 4: {
                    int n = this.countOfLineComments;
                    this.countOfLineComments = n + 1;
                    break;
                }
            }
        }

        @SqlCodeStyleConst.CommaPlusMagicValues
        protected int userCommaSetting() {
            return 0;
        }

        @SqlCodeStyleConst.CommaPlusMagicValues
        protected static /* synthetic */ void getCommaPlace$annotations() {
        }

        protected final int getCommaPlace() {
            return this.commaPlace;
        }

        protected final void setCommaPlace(int n) {
            this.commaPlace = n;
        }

        protected boolean getComma1st() {
            return this.commaPlace == 1;
        }

        protected boolean getCommaLast() {
            return this.commaPlace == 2;
        }

        @Override
        protected void analyseOriginalCodeStyle() {
            super.analyseOriginalCodeStyle();
            SqlBlock p2 = this.prefix;
            if (p2 != null) {
                p2.analyze();
                this.setPrefixLength$intellij_database_sql_impl(p2.getMinLength());
                if (p2 instanceof SqlSingleNodeBlock) {
                    this.setPrefixSize$intellij_database_sql_impl(1);
                    this.setFirstWord$intellij_database_sql_impl(SqlFormattingModelFunKt.primaryElementType(p2));
                    this.setFirstWordLength$intellij_database_sql_impl(this.getPrefixLength$intellij_database_sql_impl());
                } else {
                    SqlBlock firstWordBlock;
                    List<SqlBlock> pBlocks = p2.getNestedBlocks();
                    this.setPrefixSize$intellij_database_sql_impl(pBlocks.size());
                    SqlBlock sqlBlock = firstWordBlock = (SqlBlock)CollectionsKt.firstOrNull(pBlocks);
                    this.setFirstWord$intellij_database_sql_impl((IElementType)(sqlBlock != null ? SqlFormattingModelFunKt.primaryElementType(sqlBlock) : null));
                    this.setFirstWordLength$intellij_database_sql_impl(firstWordBlock != null ? firstWordBlock.getRange().getLength() : 0);
                }
            }
            if (this.countOfDelimiters > 0) {
                this.commaPlace = this.userCommaSetting();
                if (this.commaPlace == -1) {
                    this.commaPlace = this.getContext().getSql().QUERY_EL_COMMA;
                }
                if (this.commaPlace == 0) {
                    this.commaPlace = SqlCommonHandlersKt.autodetectDelimiter(this.getContext(), (Iterable<? extends SqlBlock>)this.getNestedBlocks());
                }
                if (this.commaPlace == -1 || this.commaPlace == 0) {
                    this.commaPlace = 2;
                }
            } else {
                this.commaPlace = 0;
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            SqlBlock it2;
            SqlCodeStyleSettings s2 = this.getContext().getSql();
            boolean firstIsAllOrDistinct = false;
            boolean wrapFirst = this.determineWrapFirstElement();
            if (this.commaPlace != 4) {
                WrapType wrapType;
                block0 : switch (SqlQueryBlock$WordAndListSection$WhenMappings.$EnumSwitchMapping$1[this.getShape().ordinal()]) {
                    case 1: {
                        switch (this.userWrapSetting()) {
                            case 1: 
                            case 2: {
                                wrapType = WrapType.CHOP_DOWN_IF_LONG;
                                break block0;
                            }
                            case 3: {
                                wrapType = WrapType.NORMAL;
                                break block0;
                            }
                        }
                        if (this.countOfElements <= this.userNumberOfElementsToKeepCollapsed()) {
                            wrapType = null;
                            break;
                        }
                        wrapType = WrapType.NORMAL;
                        break;
                    }
                    case 2: {
                        switch (this.userWrapSetting()) {
                            case 1: 
                            case 2: {
                                wrapType = WrapType.ALWAYS;
                                break block0;
                            }
                        }
                        wrapType = WrapType.NORMAL;
                        break;
                    }
                    default: {
                        wrapType = null;
                    }
                }
                WrapType wt = wrapType;
                Wrap w = SqlFlowBlock.makeWrap$default(this, wt, false, 2, null);
                Wrap wrap2 = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                Intrinsics.checkNotNull((Object)wrap2);
                Wrap dontWrap = wrap2;
                int k = 0;
                for (SqlBlock b2 : this.getNestedBlocks()) {
                    block11 : switch (SqlQueryBlock$WordAndListSection$WhenMappings.$EnumSwitchMapping$2[b2.getRole().ordinal()]) {
                        case 1: {
                            switch (++k) {
                                case 1: {
                                    b2.setMyWrap(wrapFirst ? w : dontWrap);
                                    if (SqlFormattingModelFunKt.primaryElementType(b2) != SqlCompositeElementTypes.SQL_SELECT_OPTION) break block11;
                                    firstIsAllOrDistinct = true;
                                    break block11;
                                }
                                case 2: {
                                    if (firstIsAllOrDistinct && this.getContext().getSql().SELECT_NEW_LINE_AFTER_ALL_DISTINCT) {
                                        b2.setMyWrap(w);
                                        break block11;
                                    }
                                    b2.setMyWrap(this.getCommaLast() ? w : dontWrap);
                                    break block11;
                                }
                            }
                            b2.setMyWrap(this.getCommaLast() ? w : dontWrap);
                            break;
                        }
                        case 2: {
                            b2.setMyWrap(this.getComma1st() ? w : dontWrap);
                            break;
                        }
                    }
                }
            }
            switch (this.commaPlace) {
                case 1: {
                    Iterable $this$forEach$iv;
                    Indent i2;
                    if (wrapFirst) {
                        if (s2.QUERY_ALIGN_ELEMENTS) {
                            int indentSize = this.getContext().getIndentSize();
                            Indent iE = Indent.getNormalIndent((boolean)s2.QUERY_TRUE_INDENT);
                            Indent iD = indentSize >= 2 ? Indent.getSpaceIndent((int)(indentSize - 2), (boolean)s2.QUERY_TRUE_INDENT) : SqlFormattingFunKt.getNONE_INDENT();
                            SqlBlock sqlBlock = SqlFormattingModelFunKt.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                            if (sqlBlock != null) {
                                SqlBlock k = sqlBlock;
                                boolean b2 = false;
                                boolean bl = false;
                                SqlBlock it3 = k;
                                boolean bl2 = false;
                                it3.setMyIndent(iE);
                            }
                            Iterable $this$forEach$iv2 = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER, BlockRole.LINE_COMMENT);
                            boolean $i$f$forEach = false;
                            Iterator<SqlBlock> iterator = $this$forEach$iv2.iterator();
                            while (iterator.hasNext()) {
                                SqlBlock element$iv;
                                SqlBlock it4 = element$iv = iterator.next();
                                boolean bl = false;
                                it4.setMyIndent(iD);
                            }
                        } else {
                            Iterable $this$forEach$iv3 = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT, BlockRole.DELIMITER, BlockRole.LINE_COMMENT);
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv3) {
                                SqlBlock it5 = (SqlBlock)element$iv;
                                boolean bl = false;
                                it5.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                            }
                        }
                    } else {
                        Indent indent;
                        switch (this.userElementsLineSetting()) {
                            case 1: {
                                indent = Indent.getSpaceIndent((int)(this.getPrefixLength$intellij_database_sql_impl() - this.getDelimiterLength()), (boolean)true);
                                break;
                            }
                            default: {
                                indent = Indent.getNormalIndent((boolean)true);
                            }
                        }
                        i2 = indent;
                        $this$forEach$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER, BlockRole.LINE_COMMENT);
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it2 = (SqlBlock)element$iv;
                            boolean bl = false;
                            it2.setMyIndent(i2);
                        }
                    }
                    break;
                }
                default: {
                    Indent i2 = Indent.getNormalIndent((s2.QUERY_TRUE_INDENT && this.countOfElements + this.countOfDelimiters > 1 ? 1 : 0) != 0);
                    Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT, BlockRole.LINE_COMMENT);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it2 = (SqlBlock)element$iv;
                        boolean bl = false;
                        it2.setMyIndent(i2);
                    }
                    Indent i22 = Indent.getContinuationIndent();
                    Iterable $this$forEach$iv4 = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv4) {
                        SqlBlock it6 = (SqlBlock)element$iv;
                        boolean bl = false;
                        it6.setMyIndent(i22);
                    }
                }
            }
            if (this.toAlignElements()) {
                if (this.getComma1st()) {
                    if (wrapFirst || firstIsAllOrDistinct) {
                        Alignment alignForDelimiter = SqlFormattingModelFunKt.makeRightAlignment();
                        Alignment alignForElements = SqlFormattingModelFunKt.makeLeftAlignmentBS();
                        block35: for (SqlBlock b3 : this.getNestedBlocks()) {
                            switch (SqlQueryBlock$WordAndListSection$WhenMappings.$EnumSwitchMapping$3[b3.getRole().ordinal()]) {
                                case 1: {
                                    SqlLeafBlock sqlLeafBlock = b3.getLastLeafBlock();
                                    if (sqlLeafBlock == null) continue block35;
                                    sqlLeafBlock.setMyAlign(alignForDelimiter);
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    b3.setMyAlign(alignForElements);
                                    break;
                                }
                            }
                        }
                    } else {
                        Alignment alignment;
                        if (this.getPrefixSize$intellij_database_sql_impl() == 1) {
                            alignment = this.getThisQuery$intellij_database_sql_impl().getCommonFirstWordRightAlign();
                            if (alignment == null) {
                                alignment = SqlFormattingModelFunKt.makeRightAlignment();
                            }
                        } else {
                            alignment = SqlFormattingModelFunKt.makeRightAlignment();
                        }
                        Alignment alignForDelimiter = alignment;
                        Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.PREFIX, BlockRole.DELIMITER);
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it2 = (SqlBlock)element$iv;
                            boolean bl = false;
                            SqlLeafBlock sqlLeafBlock = it2.getLastLeafBlock();
                            if (sqlLeafBlock == null) continue;
                            sqlLeafBlock.setMyAlign(alignForDelimiter);
                        }
                    }
                } else {
                    SqlBlock b4;
                    Alignment a = SqlFormattingModelFunKt.makeLeftAlignment();
                    if (this.countOfLineComments > 0 && this.countOfElements > 0 && this.getNestedBlocks().size() >= 3 && (b4 = this.getNestedBlocks().get(1)) instanceof SqlLineCommentBlock) {
                        a = SqlFormattingModelFunKt.makeLeftAlignmentBS();
                        b4.setMyAlign(a);
                    }
                    Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it2 = (SqlBlock)element$iv;
                        boolean bl = false;
                        it2.setMyAlign(a);
                    }
                    Iterable $this$filter$iv = this.getNestedBlocks();
                    boolean $i$f$filter = false;
                    Iterable $this$jbi$iv$iv = $this$filter$iv;
                    boolean $i$f$getJbi = false;
                    JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
                    JBIterable jBIterable2 = jBIterable.filter(SqlLineCommentBlock.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
                    Object object = configureFormattingAttributes.9.INSTANCE;
                    if (object != null) {
                        $this$filter$iv = object;
                        object = new SqlQueryBlock$sam$com_intellij_openapi_util_Condition$0((Function1)$this$filter$iv);
                    }
                    JBIterable jBIterable3 = jBIterable2.filter((Condition)object);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"nestedBlocks.filter<SqlL\u2026mentBlock::isWholeString)");
                    $this$forEach$iv = (Iterable)jBIterable3;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it2 = (SqlLineCommentBlock)element$iv;
                        boolean bl = false;
                        it2.setMyAlign(a);
                    }
                }
            }
            this.tabifyContent();
            if (s2.QUERY_ALIGN_LINE_COMMENTS) {
                Alignment a = SqlFormattingModelFunKt.makeLeftAlignmentBS();
                Iterable $this$filter$iv = this.getNestedBlocks();
                boolean $i$f$filter = false;
                Iterable $this$jbi$iv$iv = $this$filter$iv;
                boolean $i$f$getJbi = false;
                JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
                JBIterable jBIterable4 = jBIterable.filter(SqlLineCommentBlock.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"this.jbi.filter(B::class.java)");
                JBIterable jBIterable5 = jBIterable4.filter((Condition)configureFormattingAttributes.11.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable5, (String)"nestedBlocks\n          .\u2026r { !it.isWholeString() }");
                Iterable $this$forEach$iv = (Iterable)jBIterable5;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it2 = (SqlLineCommentBlock)element$iv;
                    boolean bl = false;
                    if (it2.getMyAlign() != null) continue;
                    it2.setMyAlign(a);
                }
            }
        }

        protected boolean determineWrapFirstElement() {
            return this.userElementsLineSetting() == 101;
        }

        protected boolean toAlignElements() {
            return this.getContext().getSql().QUERY_ALIGN_ELEMENTS;
        }

        protected void tabifyContent() {
        }

        public int userNumberOfElementsToKeepCollapsed() {
            return this.userElementsLineSetting() >= 101 ? 0 : 1;
        }

        @Override
        public boolean userRequiresExpand() {
            if (this.getThisQuery$intellij_database_sql_impl().isAllowedToCollapse) {
                return false;
            }
            return this.countOfElements > this.userNumberOfElementsToKeepCollapsed() && this.userWrapSetting() == 1 || this.countOfElements >= 1 && this.userElementsLineSetting() >= 101;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            BlockRole r1 = block1.getRole();
            BlockRole r2 = block2.getRole();
            boolean y1 = block1 instanceof SectionElement && ((SectionElement)((Object)block1)).isEgyptian();
            boolean y2 = block2 instanceof SectionElement && ((SectionElement)((Object)block2)).isEgyptian();
            if (r1 == BlockRole.PREFIX && this.determineWrapFirstElement() && this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS) {
                SqlLeafBlock sqlLeafBlock = block2.getFirstLeafBlock();
                if (Intrinsics.areEqual((Object)(sqlLeafBlock != null ? sqlLeafBlock.getElementType() : null), (Object)SqlCommonTokens.SQL_ASTERISK) ^ true && !y2) {
                    return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                }
            }
            if (r1 == BlockRole.ELEMENT && block1.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS && !y1 && this.getComma1st()) {
                return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
            }
            if (r2 == BlockRole.ELEMENT && block2.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS && !y2 && this.getCommaLast() && r1 != BlockRole.PREFIX) {
                return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
            }
            if (block1 instanceof SqlComma) {
                return this.getComma1st() ? SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null) : (this.getCommaLast() ? SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null) : SqlFormattingContext.makeSafeSpacing$default(this.getContext(), false, 1, null));
            }
            if (block2 instanceof SqlComma) {
                if (this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS && this.getComma1st() && SqlFormattingModelFunKt.isAlways(block2.getMyWrap())) {
                    return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                }
                return SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null);
            }
            return super.decideSpacing(block1, block2);
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributesForNewElementAtTheEnd() {
            Object newIndent = SqlFormattingFunKt.getNONE_INDENT();
            Alignment newAlignment = null;
            if (this.countOfElements + this.countOfDelimiters == 0 && this.userBreakFirstElement()) {
                newIndent = SqlFormattingFunKt.getNORMAL_INDENT();
            } else if (this.countOfDelimiters >= this.countOfElements && this.countOfElements > 1) {
                SqlBlock b2;
                SqlBlock sqlBlock;
                SqlBlock sqlBlock2;
                block5: {
                    List<SqlBlock> list = this.getNestedBlocks();
                    boolean bl = false;
                    List<SqlBlock> list2 = list;
                    boolean bl2 = false;
                    ListIterator<SqlBlock> listIterator = list2.listIterator(list2.size());
                    while (listIterator.hasPrevious()) {
                        SqlBlock sqlBlock3;
                        SqlBlock it2 = sqlBlock3 = listIterator.previous();
                        boolean bl3 = false;
                        if (!(it2.getRole() == BlockRole.ELEMENT)) continue;
                        sqlBlock2 = sqlBlock3;
                        break block5;
                    }
                    sqlBlock2 = null;
                }
                if ((sqlBlock = (b2 = (SqlBlock)sqlBlock2)) == null || (sqlBlock = sqlBlock.getIndent()) == null) {
                    sqlBlock = SqlFormattingFunKt.getNONE_INDENT();
                }
                newIndent = sqlBlock;
                SqlBlock sqlBlock4 = b2;
                newAlignment = sqlBlock4 != null ? sqlBlock4.getAlignment() : null;
            }
            return new ChildAttributes(newIndent, newAlignment);
        }

        @Override
        @Nullable
        public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
            String string;
            Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
            this.analyze();
            BlockRole r1 = blocks.getRole1();
            BlockRole r2 = blocks.getRole2();
            boolean trueIndent = this.getContext().getSql().QUERY_TRUE_INDENT;
            if (r2 == BlockRole.ELEMENT || r1 == BlockRole.DELIMITER) {
                switch (this.userElementsLineSetting()) {
                    case 1: {
                        string = this.getContext().currIndentOf((Block)this, trueIndent, this.getPrefixLength$intellij_database_sql_impl() + 1);
                        break;
                    }
                    default: {
                        string = this.getContext().currIndentOf((Block)this, trueIndent, true);
                        break;
                    }
                }
            } else if (r2 == BlockRole.DELIMITER) {
                if (this.getComma1st()) {
                    int n = this.getPrefixLength$intellij_database_sql_impl() - this.getDelimiterLength();
                    int n2 = 0;
                    boolean bl = false;
                    int plusSpaces = Math.max(n, n2);
                    string = this.getContext().currIndentOf((Block)this, trueIndent, plusSpaces);
                } else {
                    string = this.userElementsLineSetting() == 1 ? this.getContext().currIndentOf((Block)this, trueIndent, this.getPrefixLength$intellij_database_sql_impl() + 1) : this.getContext().currIndentOf((Block)this, trueIndent, true);
                }
            } else {
                string = null;
            }
            return string;
        }

        static {
            Companion = new Companion(null);
            Object[] objectArray = new FlowPattern[4];
            SqlTokenType sqlTokenType = SqlTokens.SQL_LINE_COMMENT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LINE_COMMENT");
            objectArray[0] = new SingletonPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.LINE_COMMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.1.INSTANCE));
            Byte by = 0;
            Byte by2 = 1;
            Object[] objectArray2 = new NodeMatcher[2];
            objectArray2[0] = NodeMatcherKt.matchAnyKeyword();
            IElementType[] iElementTypeArray = new IElementType[2];
            SqlTokenType sqlTokenType2 = SqlCommonKeywords.SQL_BY;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_BY");
            iElementTypeArray[0] = (IElementType)sqlTokenType2;
            SqlTokenType sqlTokenType3 = SqlCommonKeywords.SQL_WITH;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_WITH");
            iElementTypeArray[1] = (IElementType)sqlTokenType3;
            objectArray2[1] = NodeMatcherKt.matchType(iElementTypeArray);
            objectArray[1] = new RowPattern(by, by2, CollectionsKt.listOf((Object[])objectArray2), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.2.INSTANCE));
            objectArray[2] = new SingletonPattern((byte)0, (byte)1, NodeMatcherKt.matchAnyKeyword(), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.3.INSTANCE));
            Byte by3 = 1;
            SqlTokenType sqlTokenType4 = SqlCommonTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_COMMA");
            objectArray[3] = new SingletonPattern(by3, null, NodeMatcherKt.matchType((IElementType)sqlTokenType4), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.4.INSTANCE));
            commonPatterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection$Companion;", "", "()V", "commonPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getCommonPatterns", "()Ljava/util/List;", "intellij.database.sql.impl"})
        protected static final class Companion {
            @NotNull
            public final List<FlowPattern> getCommonPatterns() {
                return commonPatterns;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "configureFormattingAttributes", "", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userElementsLineSetting", "", "whetherSectionToIndent", "", "Companion", "intellij.database.sql.impl"})
    private static final class InsertSection
    extends QuerySection {
        @NotNull
        private static final List<FlowPattern> patterns;
        private static final Companion Companion;

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().INSERT_TABLE_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return this.getFirstWord$intellij_database_sql_impl() == SqlCommonKeywords.SQL_INTO;
        }

        @Override
        protected void configureFormattingAttributes() {
            block4: {
                Wrap wrap2;
                SqlBlock sqlBlock = SqlFormattingModelFunKt.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ALIAS1);
                if (sqlBlock == null) break block4;
                SqlBlock sqlBlock2 = sqlBlock;
                boolean bl = false;
                boolean bl2 = false;
                SqlBlock it2 = sqlBlock2;
                boolean bl3 = false;
                switch (this.userElementsLineSetting()) {
                    case 1: {
                        wrap2 = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                        break;
                    }
                    case 101: {
                        wrap2 = this.makeWrap(WrapType.ALWAYS, true);
                        break;
                    }
                    default: {
                        wrap2 = null;
                    }
                }
                it2.setMyWrap(wrap2);
            }
        }

        static {
            Companion = new Companion(null);
            Object[] objectArray = new FlowPattern[3];
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_TABLE_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_TABLE_REFERENCE");
            objectArray[0] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.ALIAS1, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            SqlTokenType sqlTokenType = SqlCommonTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
            objectArray[1] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType), new EndIncElementContinuePattern(SetsKt.setOf((Object)SqlCommonTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.2.INSTANCE)));
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_HINT_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_HINT_CLAUSE");
            objectArray[2] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.impl"})
        private static final class Companion {
            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "incomplete", "", "tabifyContent", "", "userCommaSetting", "", "userElementsLineSetting", "userNumberOfElementsToKeepCollapsed", "userWrapSetting", "whetherSectionToIndent", "Companion", "intellij.database.sql.impl"})
    private static final class ValuesSection
    extends WordAndListSection {
        private static final List<FlowPattern> patterns;
        private static final Companion Companion;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        protected void tabifyContent() {
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        @Override
        public int userNumberOfElementsToKeepCollapsed() {
            return this.getContext().getSql().INSERT_COLLAPSE_MULTI_ROW_VALUES ? (this.getContext().getLengthThresholdMax() - 7) / 4 : 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().INSERT_VALUES_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getCountOfElements() <= this.userNumberOfElementsToKeepCollapsed() ? 2 : 1;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().INSERT_CLOSING >= 3 && this.getContext().getSql().INSERT_OPENING == 1 ? 4 : this.getContext().getSql().INSERT_EL_COMMA;
        }

        @Override
        public boolean incomplete() {
            this.grow();
            SqlBlock sqlBlock = this.getLastNestedSqlBlock();
            if (sqlBlock == null) {
                return true;
            }
            SqlBlock last = sqlBlock;
            return Intrinsics.areEqual((Object)SqlFormattingModelFunKt.primaryElementType(last), (Object)SqlCommonTokens.SQL_COMMA) || last.incomplete();
        }

        static {
            Companion = new Companion(null);
            Collection collection = WordAndListSection.Companion.getCommonPatterns();
            Byte by = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_PARENTHESIZED_EXPRESSION");
            patterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object)new SingletonExpandPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;", "Lcom/intellij/sql/formatter/model/SqlParenthesizedListBlock;", "()V", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "userClosingSetting", "", "userContentSetting", "userDelimiterSetting", "userOpeningSetting", "userSpaceWithinParentheses", "", "userWrapSetting", "intellij.database.sql.impl"})
    private static final class SqlCortegeLikeParenthesizedListBlock
    extends SqlParenthesizedListBlock {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BlockRole determineRole(@NotNull ASTNode node) {
            void what$iv;
            void $this$change$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            BlockRole blockRole = super.determineRole(node);
            BlockRole blockRole2 = BlockRole.NOTHING;
            BlockRole with$iv = BlockRole.ELEMENT;
            boolean $i$f$change = false;
            return Intrinsics.areEqual((Object)$this$change$iv, (Object)what$iv) ? with$iv : blockRole;
        }

        @Override
        protected int userOpeningSetting() {
            return this.getContext().getSql().INSERT_OPENING;
        }

        @Override
        protected int userContentSetting() {
            return this.getContext().getSql().INSERT_CONTENT;
        }

        @Override
        protected int userClosingSetting() {
            return this.getContext().getSql().INSERT_CLOSING;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().INSERT_EL_WRAP;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userDelimiterSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().INSERT_EL_COMMA;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_COMMA;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public boolean userSpaceWithinParentheses() {
            return this.getContext().getSql().INSERT_SPACE_WITHIN_PARENTHESES;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$UpdateSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "userElementsLineSetting", "", "intellij.database.sql.impl"})
    private static final class UpdateSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 1;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$DeleteSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "userElementsLineSetting", "", "intellij.database.sql.impl"})
    private static final class DeleteSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 1;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OnSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userElementsLineSetting", "", "Companion", "intellij.database.sql.impl"})
    private static final class OnSection
    extends QuerySection {
        @NotNull
        private static final List<FlowPattern> patterns;
        private static final Companion Companion;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public int userElementsLineSetting() {
            return 1;
        }

        static {
            Companion = new Companion(null);
            Object[] objectArray = new FlowPattern[5];
            SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_ON;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_ON");
            objectArray[0] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType), new ElementTypeSetContinuePattern(SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_DUPLICATE, SqlCommonKeywords.SQL_KEY, SqlCommonKeywords.SQL_CONFLICT, SqlCommonKeywords.SQL_CONSTRAINT}), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.1.INSTANCE)));
            SqlTokenType sqlTokenType2 = SqlCommonKeywords.SQL_DO;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_DO");
            objectArray[1] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType2), new ElementTypeSetContinuePattern(SetsKt.setOf((Object)SqlCommonKeywords.SQL_UPDATE), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.2.INSTANCE)));
            SqlTokenType sqlTokenType3 = SqlCommonKeywords.SQL_UPDATE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_UPDATE");
            objectArray[2] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType3), new EndExcElementContinuePattern(SetsKt.emptySet(), SetsKt.setOf((Object)SqlCommonKeywords.SQL_ON), BlockRole.NOTHING, (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.3.INSTANCE)));
            SqlTokenType sqlTokenType4 = SqlCommonKeywords.SQL_SET;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_SET");
            objectArray[3] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType4), new EndExcElementContinuePattern(SetsKt.emptySet(), SetsKt.setOf((Object)SqlCommonKeywords.SQL_ON), BlockRole.NOTHING, (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.4.INSTANCE)));
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_SET_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_SET_CLAUSE");
            objectArray[4] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OnSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.impl"})
        private static final class Companion {
            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "tabifyContent", "", "userCommaSetting", "", "userElementsLineSetting", "userWrapSetting", "Companion", "intellij.database.sql.impl"})
    private static final class SetSection
    extends WordAndListSection {
        private static final Set<SqlTokenType> additionalPrefixWords;
        private static final List<FlowPattern> patterns;
        private static final Companion Companion;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        protected void tabifyContent() {
            if (this.getContext().getSql().SET_ALIGN_EQUAL_SIGN) {
                this.tabifyInner(BlockRole.ELEMENT, BlockRole.EQ);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().SET_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().SET_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().SET_EL_COMMA;
        }

        static {
            Companion = new Companion(null);
            additionalPrefixWords = SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_ON, SqlCommonKeywords.SQL_DUPLICATE, SqlCommonKeywords.SQL_KEY, SqlCommonKeywords.SQL_UPDATE});
            Collection collection = WordAndListSection.Companion.getCommonPatterns();
            Object[] objectArray = new FlowPattern[2];
            objectArray[0] = new RowPattern((byte)0, (byte)1, CollectionsKt.listOf((Object[])new NodeMatcher[]{NodeMatcherKt.matchAnyKeyword(), NodeMatcherKt.matchType(additionalPrefixWords)}), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_SET_ASSIGNMENT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_SET_ASSIGNMENT");
            objectArray[1] = new SingletonPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            patterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetSection$Companion;", "", "()V", "additionalPrefixWords", "", "Lcom/intellij/sql/psi/SqlTokenType;", "kotlin.jvm.PlatformType", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WithSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "tabifyContent", "", "userCommaSetting", "", "userElementsLineSetting", "userWrapSetting", "Companion", "intellij.database.sql.impl"})
    private static final class WithSection
    extends WordAndListSection {
        private static final List<FlowPattern> patterns;
        private static final Companion Companion;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        protected void tabifyContent() {
            if (this.getContext().getSql().WITH_ALIGN_AS) {
                this.tabifyInner(BlockRole.ELEMENT, BlockRole.AS);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().WITH_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().WITH_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().WITH_EL_COMMA;
        }

        static {
            Companion = new Companion(null);
            Collection collection = WordAndListSection.Companion.getCommonPatterns();
            Byte by = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NAMED_QUERY_DEFINITION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_NAMED_QUERY_DEFINITION");
            patterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object)new SingletonPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WithSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u0004H\u0014J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "firstIsAsterisk", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "determineWrapFirstElement", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "produceNestedBlocks", "", "tabifyContent", "userCommaSetting", "", "userElementsLineSetting", "userNumberOfElementsToKeepCollapsed", "userRequiresExpand", "userWrapSetting", "Companion", "intellij.database.sql.impl"})
    private static final class SelectSection
    extends WordAndListSection {
        private boolean firstIsAsterisk;
        @NotNull
        private static final List<FlowPattern> patterns1;
        @NotNull
        private static final List<FlowPattern> patterns2;
        private static final Companion Companion;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return this.userElementsLineSetting() == 101 || !this.getContext().getSql().SELECT_NEW_LINE_AFTER_ALL_DISTINCT ? patterns1 : patterns2;
        }

        @Override
        protected void produceNestedBlocks() {
            super.produceNestedBlocks();
            SqlBlock b1e = (SqlBlock)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).first();
            if (b1e instanceof SelectElement) {
                b1e.grow();
                this.firstIsAsterisk = ((SelectElement)b1e).isAsterisk$intellij_database_sql_impl();
            }
        }

        @Override
        protected boolean determineWrapFirstElement() {
            return !this.firstIsAsterisk && super.determineWrapFirstElement();
        }

        @Override
        protected void tabifyContent() {
            if (this.getContext().getSql().SELECT_ALIGN_AS && this.getContext().getSql().SELECT_EL_WRAP != 3) {
                boolean hasAliases1 = false;
                boolean hasAliases2 = false;
                JBIterable jBIterable = SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).filter(SqlFlowBlock.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"nestedBlocks.filter(ELEM\u2026SqlFlowBlock::class.java)");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlFlowBlock it2 = (SqlFlowBlock)element$iv;
                    boolean bl = false;
                    hasAliases1 = hasAliases1 || SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)it2.getNestedBlocks(), BlockRole.ALIAS1).isNotEmpty();
                    hasAliases2 = hasAliases2 || SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)it2.getNestedBlocks(), BlockRole.ALIAS2).isNotEmpty();
                }
                if (hasAliases1) {
                    if (!this.getContext().getSql().QUERY_ALIGN_ELEMENTS) {
                        this.tabifyInner(BlockRole.ELEMENT, BlockRole.ALIAS1);
                    }
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.EQ);
                }
                if (hasAliases1 && hasAliases2) {
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.BODY);
                }
                if (hasAliases2) {
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.AS);
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.ALIAS2);
                }
                for (SqlBlock b2 : this.getNestedBlocks()) {
                    SqlBlock inn;
                    if (b2.getMyAlign() == null || b2.isLeaf()) continue;
                    if (b2.getFirstNestedSqlBlock() == null) {
                        continue;
                    }
                    if (inn.getMyAlign() == null) continue;
                    b2.setMyAlign(null);
                }
            }
        }

        @Override
        public boolean userRequiresExpand() {
            if (this.getThisQuery$intellij_database_sql_impl().isAllowedToCollapse && this.getMinLength() < this.getContext().getLengthThresholdMin()) {
                return false;
            }
            return this.getContext().getSql().SELECT_EL_WRAP == 1 && this.getCountOfElements() > this.getContext().getSql().SELECT_KEEP_N_ITEMS_IN_LINE;
        }

        @Override
        public int userNumberOfElementsToKeepCollapsed() {
            int n = this.getContext().getSql().SELECT_KEEP_N_ITEMS_IN_LINE;
            int n2 = this.userElementsLineSetting() == 101 ? SqlUtilFun.toInt(this.firstIsAsterisk) : 1;
            boolean bl = false;
            return Math.max(n, n2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().SELECT_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().SELECT_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().SELECT_EL_COMMA;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return block1 instanceof SelectSeparatedPrefix ? (this.getContext().getSql().SELECT_NEW_LINE_AFTER_ALL_DISTINCT && this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null)) : super.decideSpacing(block1, block2);
        }

        static {
            Companion = new Companion(null);
            Object[] objectArray = new FlowPattern[5];
            SqlTokenType sqlTokenType = SqlTokens.SQL_LINE_COMMENT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LINE_COMMENT");
            objectArray[0] = new SingletonPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.LINE_COMMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns1.1.INSTANCE));
            Byte by = 0;
            Byte by2 = 1;
            IElementType[] iElementTypeArray = new IElementType[3];
            SqlTokenType sqlTokenType2 = SqlCommonKeywords.SQL_SELECT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_SELECT");
            iElementTypeArray[0] = (IElementType)sqlTokenType2;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_SELECT_OPTION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_SELECT_OPTION");
            iElementTypeArray[1] = (IElementType)sqlCompositeElementType;
            SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_TOP_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType2, (String)"SQL_TOP_CLAUSE");
            iElementTypeArray[2] = (IElementType)sqlCompositeElementType2;
            objectArray[1] = new TypePattern(by, by2, NodeMatcherKt.matchType(iElementTypeArray), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns1.2.INSTANCE));
            Byte by3 = 1;
            SqlCompositeElementType sqlCompositeElementType3 = SqlCompositeElementTypes.SQL_AS_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType3, (String)"SQL_AS_EXPRESSION");
            objectArray[2] = new SingletonExpandPattern(by3, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType3), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns1.3.INSTANCE));
            boolean $i$f$matchElementClass = false;
            objectArray[3] = new SingletonPattern((byte)1, null, NodeMatcherKt.matchElementClass(SqlExpression.class), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns1.4.INSTANCE));
            Byte by4 = 1;
            SqlTokenType sqlTokenType3 = SqlCommonTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_COMMA");
            objectArray[4] = new SingletonPattern(by4, null, NodeMatcherKt.matchType((IElementType)sqlTokenType3), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.patterns1.5.INSTANCE));
            patterns1 = CollectionsKt.listOf((Object[])objectArray);
            Object[] objectArray2 = new FlowPattern[6];
            SqlTokenType sqlTokenType4 = SqlTokens.SQL_LINE_COMMENT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_LINE_COMMENT");
            objectArray2[0] = new SingletonPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType4), BlockRole.LINE_COMMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns2.1.INSTANCE));
            Byte by5 = 0;
            Byte by6 = 1;
            SqlTokenType sqlTokenType5 = SqlCommonKeywords.SQL_SELECT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType5, (String)"SQL_SELECT");
            objectArray2[1] = new TypePattern(by5, by6, NodeMatcherKt.matchType((IElementType)sqlTokenType5), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns2.2.INSTANCE));
            Byte by7 = 1;
            Byte by8 = 1;
            IElementType[] iElementTypeArray2 = new IElementType[2];
            SqlCompositeElementType sqlCompositeElementType4 = SqlCompositeElementTypes.SQL_SELECT_OPTION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType4, (String)"SQL_SELECT_OPTION");
            iElementTypeArray2[0] = (IElementType)sqlCompositeElementType4;
            SqlCompositeElementType sqlCompositeElementType5 = SqlCompositeElementTypes.SQL_TOP_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType5, (String)"SQL_TOP_CLAUSE");
            iElementTypeArray2[1] = (IElementType)sqlCompositeElementType5;
            objectArray2[2] = new TypePattern(by7, by8, NodeMatcherKt.matchType(iElementTypeArray2), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns2.3.INSTANCE));
            Byte by9 = 1;
            SqlCompositeElementType sqlCompositeElementType6 = SqlCompositeElementTypes.SQL_AS_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType6, (String)"SQL_AS_EXPRESSION");
            objectArray2[3] = new SingletonExpandPattern(by9, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType6), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns2.4.INSTANCE));
            $i$f$matchElementClass = false;
            objectArray2[4] = new SingletonPattern((byte)1, null, NodeMatcherKt.matchElementClass(SqlExpression.class), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns2.5.INSTANCE));
            Byte by10 = 1;
            SqlTokenType sqlTokenType6 = SqlCommonTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType6, (String)"SQL_COMMA");
            objectArray2[5] = new SingletonPattern(by10, null, NodeMatcherKt.matchType((IElementType)sqlTokenType6), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.patterns2.6.INSTANCE));
            patterns2 = CollectionsKt.listOf((Object[])objectArray2);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectSection$Companion;", "", "()V", "patterns1", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns1", "()Ljava/util/List;", "patterns2", "getPatterns2", "intellij.database.sql.impl"})
        private static final class Companion {
            @NotNull
            public final List<FlowPattern> getPatterns1() {
                return patterns1;
            }

            @NotNull
            public final List<FlowPattern> getPatterns2() {
                return patterns2;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\b\u0010\u000e\u001a\u00020\u0004H\u0014J\b\u0010\u000f\u001a\u00020\nH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "hasJoins", "", "getHasJoins", "()Z", "setHasJoins", "(Z)V", "configureFormattingAttributes", "", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "toAlignElements", "tuneNestedNodesAfterAnalysis", "userCommaSetting", "", "userElementsLineSetting", "userRequiresExpand", "userWrapSetting", "whetherSectionToIndent", "Companion", "intellij.database.sql.impl"})
    private static final class FromSection
    extends WordAndListSection {
        private boolean hasJoins;
        private static final Set<SqlCompositeElementType> elementTypes;
        private static final List<FlowPattern> patterns;
        private static final Companion Companion;

        public final boolean getHasJoins() {
            return this.hasJoins;
        }

        public final void setHasJoins(boolean bl) {
            this.hasJoins = bl;
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().FROM_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().FROM_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().FROM_EL_COMMA;
        }

        @Override
        protected void tuneNestedNodesAfterAnalysis() {
            super.tuneNestedNodesAfterAnalysis();
            Iterable $this$filter$iv = this.getNestedBlocks();
            boolean $i$f$filter = false;
            Iterable $this$jbi$iv$iv = $this$filter$iv;
            boolean $i$f$getJbi = false;
            JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
            JBIterable jBIterable2 = jBIterable.filter(PrimaryTableElement.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
            Iterable $this$forEach$iv = (Iterable)jBIterable2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PrimaryTableElement it2 = (PrimaryTableElement)element$iv;
                boolean bl = false;
                this.hasJoins = this.hasJoins || it2.getCountOfJoins() > 0;
            }
            if (this.getCountOfElements() > 1 && this.hasJoins) {
                this.setShape(BlockShape.DECIDED_TO_MULTI_ROWS);
            }
        }

        @Override
        protected boolean toAlignElements() {
            return this.getContext().getSql().FROM_ONLY_JOIN_INDENT > -1 && this.getCountOfElements() + this.getCountOfDelimiters() <= 1 ? false : super.toAlignElements();
        }

        @Override
        protected void configureFormattingAttributes() {
            super.configureFormattingAttributes();
            if (this.getContext().getSql().FROM_ALIGN_ALIASES) {
                Alignment a1 = SqlFormattingModelFunKt.makeLeftAlignmentBS();
                Alignment a2 = SqlFormattingModelFunKt.makeLeftAlignmentBS();
                Iterable $this$filter$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                boolean $i$f$filter = false;
                Iterable $this$jbi$iv$iv = $this$filter$iv;
                boolean $i$f$getJbi = false;
                JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
                JBIterable jBIterable2 = jBIterable.filter(PrimaryTableElement.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
                JBIterable jBIterable3 = jBIterable2.flatten((Function)configureFormattingAttributes.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"nestedBlocks\n          .\u2026atten { it.nestedBlocks }");
                $this$filter$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)((Iterable)jBIterable3), BlockRole.ELEMENT);
                $i$f$filter = false;
                $this$jbi$iv$iv = $this$filter$iv;
                $i$f$getJbi = false;
                JBIterable jBIterable4 = JBIterable.from((Iterable)$this$jbi$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"JBIterable.from(this)");
                JBIterable jBIterable5 = jBIterable4.filter(SecondaryTableElement.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable5, (String)"this.jbi.filter(B::class.java)");
                JBIterable jBIterable6 = jBIterable5.flatten((Function)configureFormattingAttributes.2.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable6, (String)"nestedBlocks\n          .\u2026atten { it.nestedBlocks }");
                Iterable $this$forEach$iv = (Iterable)jBIterable6;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlBlock it2 = (SqlBlock)element$iv;
                    boolean bl = false;
                    if (it2.getRole() == BlockRole.AS) {
                        it2.setMyAlign(a1);
                    }
                    if (it2.getRole() != BlockRole.ALIAS2) continue;
                    it2.setMyAlign(a2);
                }
            }
        }

        @Override
        public boolean userRequiresExpand() {
            return this.getCountOfElements() >= 2 && (this.hasJoins || this.userWrapSetting() == 1);
        }

        static {
            Companion = new Companion(null);
            elementTypes = SetsKt.setOf((Object[])new SqlCompositeElementType[]{(SqlCompositeElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, SqlCompositeElementTypes.SQL_AS_EXPRESSION, SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION, SqlCompositeElementTypes.SQL_JOIN_EXPRESSION, SqlCompositeElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION});
            patterns = CollectionsKt.plus((Collection)WordAndListSection.Companion.getCommonPatterns(), (Iterable)CollectionsKt.listOf((Object)new SingletonPattern((byte)1, null, NodeMatcherKt.matchType(elementTypes), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection$Companion;", "", "()V", "elementTypes", "", "Lcom/intellij/sql/psi/SqlCompositeElementType;", "kotlin.jvm.PlatformType", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u0004H\u0014J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@VX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WhereSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "delimiterLength", "", "getDelimiterLength", "()I", "<set-?>", "Lcom/intellij/sql/psi/SqlTokenType;", "delimiterType", "getDelimiterType", "()Lcom/intellij/sql/psi/SqlTokenType;", "setDelimiterType", "(Lcom/intellij/sql/psi/SqlTokenType;)V", "adjustNestedNodes", "", "determinePrimaryDelimiter", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userCommaSetting", "userElementsLineSetting", "userWrapSetting", "whetherSectionToIndent", "", "Companion", "intellij.database.sql.impl"})
    private static final class WhereSection
    extends WordAndListSection {
        @NotNull
        private SqlTokenType delimiterType;
        private static final List<FlowPattern> patterns;
        private static final Companion Companion;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        @Override
        @NotNull
        protected SqlTokenType getDelimiterType() {
            return this.delimiterType;
        }

        public void setDelimiterType(@NotNull SqlTokenType sqlTokenType) {
            Intrinsics.checkNotNullParameter((Object)sqlTokenType, (String)"<set-?>");
            this.delimiterType = sqlTokenType;
        }

        @Override
        protected int getDelimiterLength() {
            SqlTokenType sqlTokenType = this.getDelimiterType();
            return Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlCommonKeywords.SQL_OR) ? 2 : (Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlCommonKeywords.SQL_AND) ? 3 : 1);
        }

        @Override
        protected void adjustNestedNodes() {
            super.adjustNestedNodes();
            this.determinePrimaryDelimiter();
            if (this.getDelimiterType() != SqlCommonKeywords.SQL_NO) {
                this.flattenNestedNodes((Function1<? super ASTNode, Boolean>)((Function1)new Function1<ASTNode, Boolean>(this){
                    final /* synthetic */ WhereSection this$0;

                    public final boolean invoke(@NotNull ASTNode it2) {
                        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                        return it2.getElementType() == SqlCompositeElementTypes.SQL_BINARY_EXPRESSION && SqlUtilFun.hasChildNode(it2, (IElementType)this.this$0.getDelimiterType());
                    }
                    {
                        this.this$0 = whereSection;
                        super(1);
                    }
                }));
            }
        }

        private final void determinePrimaryDelimiter() {
            Object v0;
            block3: {
                Iterable iterable = this.getNestedNodes();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ASTNode it2 = (ASTNode)t;
                    boolean bl3 = false;
                    if (!(it2.getElementType() == SqlCompositeElementTypes.SQL_BINARY_EXPRESSION)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            ASTNode aSTNode = v0;
            if (aSTNode == null) {
                return;
            }
            ASTNode conditionNode = aSTNode;
            Iterator iterator = SqlUtilFun.children(conditionNode).iterator();
            while (iterator.hasNext()) {
                IElementType type;
                ASTNode child;
                ASTNode aSTNode2 = child = (ASTNode)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"child");
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2.getElementType(), (String)"child.elementType");
                if (type != SqlCommonKeywords.SQL_OR && type != SqlCommonKeywords.SQL_AND) continue;
                this.setDelimiterType((SqlTokenType)type);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().WHERE_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().WHERE_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().WHERE_EL_BOUND;
        }

        public WhereSection() {
            SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_NO;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_NO");
            this.delimiterType = sqlTokenType;
        }

        static {
            Companion = new Companion(null);
            Collection collection = WordAndListSection.Companion.getCommonPatterns();
            Object[] objectArray = new SingletonPattern[2];
            boolean $i$f$matchElementClass = false;
            objectArray[0] = new SingletonPattern((byte)1, null, NodeMatcherKt.matchElementClass(SqlExpression.class), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by = 1;
            IElementType[] iElementTypeArray = new IElementType[2];
            SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_OR;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_OR");
            iElementTypeArray[0] = (IElementType)sqlTokenType;
            SqlTokenType sqlTokenType2 = SqlCommonKeywords.SQL_AND;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_AND");
            iElementTypeArray[1] = (IElementType)sqlTokenType2;
            objectArray[1] = new SingletonPattern(by, null, NodeMatcherKt.matchType(iElementTypeArray), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            patterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WhereSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$GroupOrderSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "tabifyContent", "", "userCommaSetting", "", "userElementsLineSetting", "userWrapSetting", "whetherSectionToIndent", "", "Companion", "intellij.database.sql.impl"})
    private static final class GroupOrderSection
    extends WordAndListSection {
        private static final List<FlowPattern> patterns;
        private static final Companion Companion;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean whetherSectionToIndent() {
            if (!this.getThisQuery$intellij_database_sql_impl().isUnion) return true;
            ASTNode aSTNode = (ASTNode)CollectionsKt.firstOrNull(this.getNestedNodes());
            if ((aSTNode != null ? aSTNode.getElementType() : null) == SqlCommonKeywords.SQL_ORDER) return false;
            return true;
        }

        @Override
        @NotNull
        public BlockRole determineRole(@NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            IElementType iElementType = node.getElementType();
            return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_ASC) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_DESC) ? BlockRole.AMENDMENT : super.determineRole(node);
        }

        @Override
        protected void tabifyContent() {
            if (this.getContext().getSql().ORDER_ALIGN_ASC_DESC) {
                this.tabify(BlockRole.AMENDMENT);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().ORDER_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().ORDER_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().ORDER_EL_COMMA;
        }

        static {
            Companion = new Companion(null);
            boolean $i$f$matchElementClass = false;
            patterns = CollectionsKt.plus((Collection)WordAndListSection.Companion.getCommonPatterns(), (Iterable)CollectionsKt.listOf((Object)new SingletonPattern((byte)1, null, NodeMatcherKt.matchElementClass(SqlExpression.class), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$GroupOrderSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OneLineSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "preserveUserLineBreaks", "", "userElementsLineSetting", "", "userRequiresExpand", "whetherSectionToIndent", "intellij.database.sql.impl"})
    private static class OneLineSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 1;
        }

        @Override
        public boolean userRequiresExpand() {
            return false;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        @Override
        protected boolean preserveUserLineBreaks() {
            return false;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            decideSpacing.1 $fun$preserve$1 = decideSpacing.1.INSTANCE;
            return $fun$preserve$1.invoke(block1) ? super.decideSpacing(block1, block2) : ($fun$preserve$1.invoke(block2) ? super.decideSpacing(block1, block2) : this.getContext().makeSafeSpacing(false));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ReturningSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$OneLineSection;", "()V", "theIntoBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "configureFormattingAttributes", "", "considerBlock", "block", "intellij.database.sql.impl"})
    private static final class ReturningSection
    extends OneLineSection {
        private SqlBlock theIntoBlock;

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (SqlFormattingModelFunKt.primaryElementType(block) == SqlCommonKeywords.SQL_INTO && this.theIntoBlock == null) {
                this.theIntoBlock = block;
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            block0: {
                super.configureFormattingAttributes();
                SqlBlock sqlBlock = this.theIntoBlock;
                if (sqlBlock == null) break block0;
                sqlBlock.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OutputSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userCommaSetting", "", "userElementsLineSetting", "userWrapSetting", "Companion", "intellij.database.sql.impl"})
    private static final class OutputSection
    extends WordAndListSection {
        private static final List<FlowPattern> patterns;
        private static final Companion Companion;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().SET_EL_LINE;
            int n2 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().SET_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().SET_EL_COMMA;
        }

        static {
            Companion = new Companion(null);
            Collection collection = WordAndListSection.Companion.getCommonPatterns();
            Object[] objectArray = new FlowPattern[2];
            objectArray[0] = new SimplePattern((byte)0, (byte)1, NodeMatcherKt.matchAnyKeyword(), NodeMatcherKt.matchAnyKeyword(), false, BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by = 1;
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_COLUMN_REFERENCE");
            objectArray[1] = new SingletonPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            patterns = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OutputSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$LimitSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$OneLineSection;", "()V", "intellij.database.sql.impl"})
    private static final class LimitSection
    extends OneLineSection {
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$UnionSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "userElementsLineSetting", "", "intellij.database.sql.impl"})
    private static final class UnionSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 0;
        }

        @Override
        @NotNull
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$UnknownSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "userElementsLineSetting", "", "whetherSectionToIndent", "", "intellij.database.sql.impl"})
    private static final class UnknownSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 0;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "", "isEgyptian", "", "intellij.database.sql.impl"})
    private static interface SectionElement {
        public boolean isEgyptian();

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static boolean isEgyptian(@NotNull SectionElement $this) {
                return false;
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetAssignment;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "intellij.database.sql.impl"})
    private static final class SetAssignment
    extends SqlNodeBlock {
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$CTE;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "configureFormattingAttributes", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "Companion", "intellij.database.sql.impl"})
    private static final class CTE
    extends SqlNodeBlock {
        @NotNull
        private static final List<FlowPattern> patterns;
        public static final Companion Companion;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
                SqlBlock sqlBlock = this.getParent();
                if (!(sqlBlock instanceof SqlFlowBlock)) {
                    sqlBlock = null;
                }
                SqlFlowBlock sqlFlowBlock = (SqlFlowBlock)sqlBlock;
                if (sqlFlowBlock == null) break block1;
                sqlFlowBlock.countRole$intellij_database_sql_impl(role);
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            block0: {
                Iterable iterable = this.getNestedBlocks();
                SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_AS;
                Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_AS");
                SqlBlock sqlBlock = SqlFormattingModelFunKt.find((Iterable<? extends SqlBlock>)iterable, (IElementType)sqlTokenType);
                if (sqlBlock == null) break block0;
                SqlBlock sqlBlock2 = sqlBlock;
                boolean bl = false;
                boolean bl2 = false;
                SqlBlock it2 = sqlBlock2;
                boolean bl3 = false;
                it2.setMyWrap(SqlFlowBlock.makeWrap$default(this, WrapType.NORMAL, false, 2, null));
            }
        }

        static {
            Companion = new Companion(null);
            Object[] objectArray = new FlowPattern[3];
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_IDENTIFIER;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_IDENTIFIER");
            objectArray[0] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ALIAS1, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_AS;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_AS");
            objectArray[1] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.AS, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            SqlTokenType sqlTokenType2 = SqlCommonTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_LEFT_PAREN");
            objectArray[2] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType2), new EndIncElementContinuePattern(SetsKt.setOf((Object)SqlCommonTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), BlockRole.BODY, (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.3.INSTANCE)));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$CTE$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.impl"})
        public static final class Companion {
            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectSeparatedPrefix;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "intellij.database.sql.impl"})
    private static final class SelectSeparatedPrefix
    extends SqlRangeBlock {
        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return this.getContext().makeSafeSpacing(false);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0014J\u0015\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "()V", "essence", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getEssence$intellij_database_sql_impl", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setEssence$intellij_database_sql_impl", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "isAsterisk", "", "isAsterisk$intellij_database_sql_impl", "()Z", "setAsterisk$intellij_database_sql_impl", "(Z)V", "considerBlock", "", "block", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getDebugNameSuffix", "", "isEgyptian", "makeBlock", "node", "Lcom/intellij/lang/ASTNode;", "Companion", "intellij.database.sql.impl"})
    private static final class SelectElement
    extends SqlRangeBlock
    implements SectionElement {
        @Nullable
        private SqlBlock essence;
        private boolean isAsterisk;
        @NotNull
        private static final List<FlowPattern> patterns;
        private static final Companion Companion;

        @Nullable
        public final SqlBlock getEssence$intellij_database_sql_impl() {
            return this.essence;
        }

        public final void setEssence$intellij_database_sql_impl(@Nullable SqlBlock sqlBlock) {
            this.essence = sqlBlock;
        }

        public final boolean isAsterisk$intellij_database_sql_impl() {
            return this.isAsterisk;
        }

        public final void setAsterisk$intellij_database_sql_impl(boolean bl) {
            this.isAsterisk = bl;
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SqlBlock makeBlock(@NotNull ASTNode node) {
            SqlBlock sqlBlock;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ASTNode aSTNode = node;
            if (aSTNode instanceof SqlExpression) {
                void $this$withSetup$iv;
                SqlNodeBlock sqlNodeBlock = new SelectElementEssence();
                SqlBlock parent$iv = this;
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup$intellij_database_sql_impl(parent$iv, node);
                sqlBlock = SqlBlockKt.withRole((SqlBlock)sqlNodeBlock, BlockRole.BODY);
            } else {
                sqlBlock = super.makeBlock(node);
            }
            return sqlBlock;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            block1: {
                SqlBlock sqlBlock;
                block0: {
                    Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                    super.considerBlock(block);
                    sqlBlock = block;
                    if (!(sqlBlock instanceof SelectElementEssence)) break block0;
                    this.essence = block;
                    this.isAsterisk = this.isAsterisk || ((SelectElementEssence)block).isAsterisk$intellij_database_sql_impl();
                    break block1;
                }
                if (!(sqlBlock instanceof SqlAliasBlock)) break block1;
                block.setRole(this.essence == null ? BlockRole.ALIAS1 : BlockRole.ALIAS2);
            }
        }

        @Override
        public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
                SqlBlock sqlBlock = this.getParent();
                if (!(sqlBlock instanceof SqlFlowBlock)) {
                    sqlBlock = null;
                }
                SqlFlowBlock sqlFlowBlock = (SqlFlowBlock)sqlBlock;
                if (sqlFlowBlock == null) break block1;
                sqlFlowBlock.countRole$intellij_database_sql_impl(role);
            }
        }

        @Override
        public boolean isEgyptian() {
            SqlBlock sqlBlock = this.essence;
            IElementType t = sqlBlock != null ? SqlFormattingModelFunKt.primaryElementType(sqlBlock) : null;
            return Intrinsics.areEqual((Object)t, (Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION) && this.getContext().getSql().SUBQUERY_CONTENT == 2;
        }

        @Override
        @Nullable
        protected String getDebugNameSuffix() {
            return this.isAsterisk ? "*" : null;
        }

        static {
            Companion = new Companion(null);
            Object[] objectArray = new SingletonPattern[6];
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_IDENTIFIER;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_IDENTIFIER");
            objectArray[0] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            SqlTokenType sqlTokenType = SqlCommonTokens.SQL_OP_EQ;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_OP_EQ");
            objectArray[1] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.EQ, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            SqlTokenType sqlTokenType2 = SqlCommonKeywords.SQL_AS;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_AS");
            objectArray[2] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.AS, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_COLUMN_REFERENCE");
            objectArray[3] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.BODY, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
            SqlReferenceElementType sqlReferenceElementType2 = SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType2, (String)"SQL_COLUMN_SHORT_REFERENCE");
            objectArray[4] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlReferenceElementType2), BlockRole.BODY, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE));
            SqlTokenType sqlTokenType3 = SqlCommonTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_COMMA");
            objectArray[5] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlTokenType3), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.6.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.impl"})
        private static final class Companion {
            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElementEssence;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "isAsterisk", "", "isAsterisk$intellij_database_sql_impl", "()Z", "incomplete", "listTheChildren", "", "Lcom/intellij/lang/ASTNode;", "intellij.database.sql.impl"})
    private static final class SelectElementEssence
    extends SqlNodeBlock {
        public final boolean isAsterisk$intellij_database_sql_impl() {
            return SqlUtilFun.isSymbol(this.getBlockNode(), '*');
        }

        @Override
        @NotNull
        protected List<ASTNode> listTheChildren() {
            return this.isAsterisk$intellij_database_sql_impl() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)this.getBlockNode());
        }

        @Override
        public boolean incomplete() {
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0010\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u000bH\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0014J\u0016\u0010(\u001a\u00020\u001b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020'0&H\u0014J\b\u0010*\u001a\u00020\u000bH\u0016J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020'H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$PrimaryTableElement;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "()V", "countOfJoins", "", "getCountOfJoins", "()I", "setCountOfJoins", "(I)V", "forceWrap1", "", "getForceWrap1", "()Z", "forceWrap2", "getForceWrap2", "joinAlign", "Lcom/intellij/formatting/Alignment;", "getJoinAlign", "()Lcom/intellij/formatting/Alignment;", "setJoinAlign", "(Lcom/intellij/formatting/Alignment;)V", "parentSection", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection;", "getParentSection", "()Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection;", "configureFormattingAttributes", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "isEgyptian", "listTheChildren", "", "Lcom/intellij/lang/ASTNode;", "produceNestedBlocks", "nodes", "userRequiresExpand", "whetherToFlatten", "node", "intellij.database.sql.impl"})
    private static final class PrimaryTableElement
    extends SqlNodeBlock
    implements SectionElement {
        private int countOfJoins;
        @Nullable
        private Alignment joinAlign;

        @NotNull
        public final FromSection getParentSection() {
            SqlBlock sqlBlock = this.getParent();
            if (sqlBlock == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.formatter.model.SqlQueryBlock.FromSection");
            }
            return (FromSection)sqlBlock;
        }

        public final int getCountOfJoins() {
            return this.countOfJoins;
        }

        public final void setCountOfJoins(int n) {
            this.countOfJoins = n;
        }

        @Nullable
        public final Alignment getJoinAlign() {
            return this.joinAlign;
        }

        public final void setJoinAlign(@Nullable Alignment alignment) {
            this.joinAlign = alignment;
        }

        public final boolean getForceWrap1() {
            return this.getContext().getSql().FROM_WRAP_JOIN_1 && this.countOfJoins >= 1;
        }

        public final boolean getForceWrap2() {
            return this.getContext().getSql().FROM_WRAP_JOIN_2 && this.countOfJoins >= 2;
        }

        @Override
        @NotNull
        protected List<ASTNode> listTheChildren() {
            return this.getBlockNode().getElementType() == SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION ? CollectionsKt.listOf((Object)this.getBlockNode()) : super.listTheChildren();
        }

        @Override
        protected boolean whetherToFlatten(@NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return node.getElementType() == SqlCompositeElementTypes.SQL_JOIN_EXPRESSION;
        }

        @Override
        protected void produceNestedBlocks(@NotNull List<? extends ASTNode> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            int n = nodes.size();
            int p2 = 0;
            while (p2 < n) {
                int e;
                IntRange join2;
                IntRange intRange = join2 = SqlFormattingModelFunKt.findConsequence(nodes, p2, (Function1<? super ASTNode, Boolean>)((Function1)produceNestedBlocks.join.1.INSTANCE));
                int n2 = e = intRange != null ? intRange.getStart() : n;
                if (p2 < e) {
                    List<? extends ASTNode> subList = nodes.subList(p2, e);
                    SecondaryTableElement elementBlock = new SecondaryTableElement();
                    elementBlock.setup(this, subList);
                    elementBlock.setRole(BlockRole.ELEMENT);
                    this.addNestedBlock$intellij_database_sql_impl(elementBlock);
                }
                if (join2 == null) break;
                JoinPhrase joinBlock = new JoinPhrase();
                IntRange $this$finish$iv = join2;
                boolean $i$f$getFinish = false;
                joinBlock.setup(this, nodes.subList(join2.getFirst(), $this$finish$iv.getEndInclusive() + 1));
                joinBlock.setRole(BlockRole.DELIMITER);
                this.addNestedBlock$intellij_database_sql_impl(joinBlock);
                $this$finish$iv = join2;
                $i$f$getFinish = false;
                p2 = $this$finish$iv.getEndInclusive() + 1;
            }
        }

        @Override
        public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
            Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
            if (role == BlockRole.DELIMITER) {
                int n = this.countOfJoins;
                this.countOfJoins = n + 1;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Indent defaultChildIndent(@NotNull SqlBlock block) {
            Indent indent;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (block.getRole() == BlockRole.ELEMENT) {
                void what$iv;
                void $this$change$iv;
                int n = this.getContext().getSql().FROM_EL_LINE;
                int n2 = -1;
                int with$iv = this.getContext().getSql().QUERY_EL_LINE;
                boolean $i$f$change = false;
                if (($this$change$iv == what$iv ? with$iv : n) == 1) {
                    indent = SqlFormattingFunKt.getNONE_INDENT();
                    return indent;
                }
            }
            indent = super.defaultChildIndent(block);
            return indent;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void configureFormattingAttributes() {
            if (this.countOfJoins == 0) {
                return;
            }
            SqlCodeStyleSettings s2 = this.getContext().getSql();
            Wrap w1 = null;
            Wrap w2 = null;
            if (this.getForceWrap1() == this.getForceWrap2()) {
                Wrap wrap2 = SqlFlowBlock.makeWrap$default(this, this.getForceWrap1() ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
                Intrinsics.checkNotNull((Object)wrap2);
                w2 = w1 = wrap2;
            } else {
                Wrap wrap3 = SqlFlowBlock.makeWrap$default(this, this.getForceWrap1() ? WrapType.ALWAYS : WrapType.NORMAL, false, 2, null);
                Intrinsics.checkNotNull((Object)wrap3);
                w1 = wrap3;
                Wrap wrap4 = SqlFlowBlock.makeWrap$default(this, this.getForceWrap2() ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
                Intrinsics.checkNotNull((Object)wrap4);
                w2 = wrap4;
            }
            boolean unindentJoins = s2.FROM_ONLY_JOIN_INDENT > -1 && this.getParentSection().getCountOfElements() == 1;
            Indent i2 = unindentJoins && s2.FROM_ONLY_JOIN_INDENT == 1 ? SqlFormattingFunKt.getNORMAL_INDENT() : (unindentJoins && s2.FROM_ONLY_JOIN_INDENT == 2 ? SqlFormattingFunKt.getNONE_INDENT() : (s2.FROM_INDENT_JOIN ? Indent.getNormalIndent((boolean)true) : Indent.getSpaceIndent((int)0, (boolean)true)));
            this.joinAlign = s2.QUERY_ALIGN_ELEMENTS && !unindentJoins ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
            JBIterable<SqlBlock> joinWords = SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER);
            boolean bl = false;
            for (SqlBlock jw : (Iterable)joinWords) {
                void index2;
                if (index2 == false) {
                    jw.setMyWrap(w1);
                }
                if (index2 >= true) {
                    jw.setMyWrap(w2);
                }
                jw.setMyIndent(i2);
                jw.setMyAlign(this.joinAlign);
                ++index2;
            }
            if (s2.FROM_ALIGN_JOIN_TABLES) {
                Alignment a2 = SqlFormattingModelFunKt.makeLeftAlignmentBS();
                JBIterable jBIterable = SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).skip(1);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"nestedBlocks.filter(ELEMENT).skip(1)");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlBlock it2 = (SqlBlock)element$iv;
                    boolean bl2 = false;
                    it2.setMyAlign(a2);
                }
            }
        }

        @Override
        public boolean userRequiresExpand() {
            return this.getForceWrap1() || this.getForceWrap2();
        }

        @Override
        public boolean isEgyptian() {
            if (this.getContext().getSql().SUBQUERY_CONTENT != 2) {
                return false;
            }
            SqlBlock b1 = (SqlBlock)CollectionsKt.firstOrNull(this.getNestedBlocks());
            SqlBlock b2 = (SqlBlock)CollectionsKt.lastOrNull(this.getNestedBlocks());
            if (b1 instanceof SecondaryTableElement && ((SecondaryTableElement)b1).isEgyptian$intellij_database_sql_impl()) {
                return true;
            }
            return b2 instanceof SecondaryTableElement && ((SecondaryTableElement)b2).isEgyptian$intellij_database_sql_impl();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004H\u0014J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014J\r\u0010\u001f\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\nH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SecondaryTableElement;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "body", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getBody", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setBody", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "hasCondition", "", "getHasCondition", "()Z", "setHasCondition", "(Z)V", "adjustNestedNodes", "", "configureFormattingAttributes", "considerBlock", "block", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "isEgyptian", "isEgyptian$intellij_database_sql_impl", "userRequiresExpand", "Companion", "intellij.database.sql.impl"})
    private static final class SecondaryTableElement
    extends SqlRangeBlock {
        @Nullable
        private SqlBlock body;
        private boolean hasCondition;
        @NotNull
        private static final List<FlowPattern> patterns;
        private static final Companion Companion;

        @Nullable
        public final SqlBlock getBody() {
            return this.body;
        }

        public final void setBody(@Nullable SqlBlock sqlBlock) {
            this.body = sqlBlock;
        }

        public final boolean getHasCondition() {
            return this.hasCondition;
        }

        public final void setHasCondition(boolean bl) {
            this.hasCondition = bl;
        }

        @Override
        protected void adjustNestedNodes() {
            this.flattenNestedNodes((Function1<? super ASTNode, Boolean>)((Function1)adjustNestedNodes.1.INSTANCE));
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BlockRole determineRole(@NotNull ASTNode node) {
            BlockRole blockRole;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            IElementType iElementType = node.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_AS)) {
                blockRole = BlockRole.AS;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER)) {
                blockRole = BlockRole.ALIAS2;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_USING_CLAUSE)) {
                blockRole = BlockRole.AMENDMENT;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_PERIOD)) {
                blockRole = BlockRole.NOTHING;
            } else {
                void var3_3;
                BlockRole r = super.determineRole(node);
                if (r == BlockRole.NOTHING || r == BlockRole.ELEMENT) {
                    r = BlockRole.BODY;
                }
                blockRole = var3_3;
            }
            return blockRole;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            super.considerBlock(block);
            switch (SqlQueryBlock$SecondaryTableElement$WhenMappings.$EnumSwitchMapping$0[block.getRole().ordinal()]) {
                case 1: {
                    this.body = block;
                    break;
                }
                case 2: {
                    this.hasCondition = true;
                    break;
                }
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            SqlCodeStyleSettings s2 = this.getContext().getSql();
            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.AMENDMENT);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                Indent indent;
                SqlBlock it2 = (SqlBlock)element$iv;
                boolean bl = false;
                it2.setMyWrap(SqlFlowBlock.makeWrap$default(this, s2.FROM_WRAP_ON ? WrapType.ALWAYS : WrapType.NORMAL, false, 2, null));
                switch (s2.FROM_PLACE_ON) {
                    case 10: {
                        if (s2.FROM_ONLY_JOIN_INDENT == 1) {
                            indent = SqlFormattingFunKt.getNORMAL_INDENT();
                            break;
                        }
                        indent = SqlFormattingFunKt.getNONE_INDENT();
                        break;
                    }
                    case 11: {
                        indent = SqlFormattingFunKt.getNORMAL_INDENT();
                        break;
                    }
                    case 12: {
                        indent = Indent.getContinuationIndent();
                        break;
                    }
                    case 20: {
                        indent = Indent.getSpaceIndent((int)0, (boolean)true);
                        break;
                    }
                    case 21: {
                        indent = Indent.getNormalIndent((boolean)true);
                        break;
                    }
                    default: {
                        indent = this.getMyIndent();
                    }
                }
                it2.setMyIndent(indent);
                if (s2.FROM_PLACE_ON == 10) {
                    SqlBlock sqlBlock = this.getParent();
                    if (!(sqlBlock instanceof PrimaryTableElement)) {
                        sqlBlock = null;
                    }
                    PrimaryTableElement primaryTableElement = (PrimaryTableElement)sqlBlock;
                    object = primaryTableElement != null ? primaryTableElement.getJoinAlign() : null;
                } else {
                    object = null;
                }
                it2.setMyAlign((Alignment)object);
            }
        }

        @Override
        public boolean userRequiresExpand() {
            return this.hasCondition && this.getContext().getSql().FROM_WRAP_ON;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            BlockRole r1 = block1.getRole();
            BlockRole r2 = block2.getRole();
            return (r1 == BlockRole.BODY || r1 == BlockRole.AS) && r2 == BlockRole.ALIAS2 ? SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null) : super.decideSpacing(block1, block2);
        }

        public final boolean isEgyptian$intellij_database_sql_impl() {
            return this.body instanceof SqlParenthesizedSubqueryBlock && this.getContext().getSql().SUBQUERY_CONTENT == 2;
        }

        static {
            Companion = new Companion(null);
            Object[] objectArray = new FlowPattern[3];
            SqlTokenType sqlTokenType = SqlCommonTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
            objectArray[0] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType), new EndIncElementContinuePattern(SetsKt.setOf((Object)SqlCommonTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.1.INSTANCE)));
            objectArray[1] = new StartStopPattern(null, null, NodeMatcherKt.matchTypeName("BQ_DELIMITED_TOKEN_START"), NodeMatcherKt.matchTypeName("BQ_DELIMITED_TOKEN_END"), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            IElementType[] iElementTypeArray = new IElementType[2];
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_JOIN_CONDITION_CLAUSE");
            iElementTypeArray[0] = (IElementType)sqlCompositeElementType;
            SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_USING_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType2, (String)"SQL_USING_CLAUSE");
            iElementTypeArray[1] = (IElementType)sqlCompositeElementType2;
            objectArray[2] = new SingletonPattern(null, null, NodeMatcherKt.matchType(iElementTypeArray), BlockRole.AMENDMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SecondaryTableElement$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.impl"})
        private static final class Companion {
            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$JoinPhrase;", "Lcom/intellij/sql/formatter/model/SqlPhraseBlock;", "()V", "intellij.database.sql.impl"})
    private static final class JoinPhrase
    extends SqlPhraseBlock {
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$JoinCondition;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "intellij.database.sql.impl"})
    private static final class JoinCondition
    extends SqlNodeBlock {
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$PredicateElement;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "()V", "blockIsEgyptian", "", "b", "Lcom/intellij/sql/formatter/model/SqlBlock;", "isEgyptian", "intellij.database.sql.impl"})
    private static final class PredicateElement
    extends SqlRangeBlock
    implements SectionElement {
        @Override
        public boolean isEgyptian() {
            if (this.getContext().getSql().SUBQUERY_CONTENT != 2) {
                return false;
            }
            SqlBlock b1 = (SqlBlock)CollectionsKt.firstOrNull(this.getNestedBlocks());
            SqlBlock b2 = (SqlBlock)CollectionsKt.lastOrNull(this.getNestedBlocks());
            if (this.blockIsEgyptian(b1)) {
                return true;
            }
            return b1 != b2 && this.blockIsEgyptian(b2);
        }

        private final boolean blockIsEgyptian(SqlBlock b2) {
            if (b2 == null) {
                return false;
            }
            return b2 instanceof SqlParenthesizedSubqueryBlock || b2 instanceof SqlBinaryExpressionBlock && (this.blockIsEgyptian(b2.getFirstNestedSqlBlock()) || this.blockIsEgyptian(b2.getLastNestedSqlBlock()));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$Companion;", "", "()V", "commonPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "insertIntoSeparatedPatterns", "insertIntoTogetherPatterns", "limitStopMartker", "", "Lcom/intellij/psi/tree/IElementType;", "nodeNamesToFlatten", "", "nodesToFlatten", "postgresQueryPatterns", "sectionMakers", "tableJoinWords", "unionGluedWords", "unionStartWords", "intellij.database.sql.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

