/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.DefaultInjectedLanguageBlockBuilder;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelMaker;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J<\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/intellij/sql/formatter/model/SqlInjectedLanguageBlockBuilder;", "Lcom/intellij/psi/formatter/common/DefaultInjectedLanguageBlockBuilder;", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "hostBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "(Lcom/intellij/sql/formatter/model/SqlFormattingContext;Lcom/intellij/sql/formatter/model/SqlBlock;)V", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "getHostBlock", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "addInjectedLanguageBlockWrapper", "", "result", "", "Lcom/intellij/formatting/Block;", "injectedNode", "Lcom/intellij/lang/ASTNode;", "indent", "Lcom/intellij/formatting/Indent;", "offset", "", "range", "Lcom/intellij/openapi/util/TextRange;", "makeAlienOriginalBlock", "language", "Lcom/intellij/lang/Language;", "element", "Lcom/intellij/psi/PsiElement;", "makeSameLanguageOriginalBlock", "node", "intellij.database.sql.impl"})
public final class SqlInjectedLanguageBlockBuilder
extends DefaultInjectedLanguageBlockBuilder {
    @NotNull
    private final SqlFormattingContext context;
    @NotNull
    private final SqlBlock hostBlock;

    public void addInjectedLanguageBlockWrapper(@NotNull List<? super Block> result, @NotNull ASTNode injectedNode, @Nullable Indent indent, int offset, @Nullable TextRange range) {
        block14: {
            Block original;
            Language childLanguage;
            block13: {
                block12: {
                    Block block;
                    PsiElement childElement;
                    Intrinsics.checkNotNullParameter(result, (String)"result");
                    Intrinsics.checkNotNullParameter((Object)injectedNode, (String)"injectedNode");
                    if (range != null) {
                        if (range.getLength() == 0) {
                            return;
                        }
                        String string = range.substring(injectedNode.getText());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"range.substring(injectedNode.getText())");
                        String subText = string;
                        if (StringsKt.isBlank((CharSequence)subText)) {
                            return;
                        }
                    }
                    PsiElement psiElement = childElement = injectedNode.getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"childElement");
                    Language language = psiElement.getLanguage();
                    Intrinsics.checkNotNullExpressionValue((Object)language, (String)"childElement.language");
                    childLanguage = language;
                    if (Intrinsics.areEqual((Object)childLanguage, (Object)this.context.getDialect())) {
                        block = this.makeSameLanguageOriginalBlock(injectedNode);
                    } else {
                        block = this.makeAlienOriginalBlock(childLanguage, childElement);
                        if (block == null) {
                            return;
                        }
                    }
                    original = block;
                    if (!original.isLeaf()) break block12;
                    String string = injectedNode.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"injectedNode.text");
                    String $this$trim$iv = string;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    CharSequence charSequence = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) break block13;
                }
                if (original.getSubBlocks().isEmpty()) break block14;
            }
            Block block = this.createInjectedBlock(injectedNode, original, indent, offset, range, childLanguage);
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"createInjectedBlock(inje\u2026et, range, childLanguage)");
            result.add((Block)block);
        }
    }

    private final SqlBlock makeSameLanguageOriginalBlock(ASTNode node) {
        PsiFile file;
        PsiElement psiElement = node.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"node.psi");
        PsiFile psiFile = file = psiElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file");
        String string = psiFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.text");
        CharSequence charSequence = string;
        CodeStyleSettings codeStyleSettings = this.context.getSettingsContainer();
        FormattingMode formattingMode = this.context.getMode();
        TextRange textRange = file.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"file.textRange");
        SqlFormattingModelMaker maker = new SqlFormattingModelMaker(charSequence, file, codeStyleSettings, formattingMode, textRange);
        return maker.makeDomesticSubModel(this.hostBlock, node);
    }

    private final Block makeAlienOriginalBlock(Language language, PsiElement element2) {
        FormattingModelBuilder formattingModelBuilder = LanguageFormatting.INSTANCE.forContext(language, element2);
        if (formattingModelBuilder == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)formattingModelBuilder, (String)"LanguageFormatting.INSTA\u2026, element) ?: return null");
        FormattingModelBuilder builder = formattingModelBuilder;
        FormattingModel formattingModel = builder.createModel(FormattingContext.create((PsiElement)element2, (CodeStyleSettings)this.getSettings()));
        Intrinsics.checkNotNullExpressionValue((Object)formattingModel, (String)"builder.createModel(Form\u2026reate(element, settings))");
        FormattingModel childModel = formattingModel;
        return childModel.getRootBlock();
    }

    @NotNull
    public final SqlFormattingContext getContext() {
        return this.context;
    }

    @NotNull
    public final SqlBlock getHostBlock() {
        return this.hostBlock;
    }

    public SqlInjectedLanguageBlockBuilder(@NotNull SqlFormattingContext context, @NotNull SqlBlock hostBlock) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)hostBlock, (String)"hostBlock");
        super(context.getSettingsContainer());
        this.context = context;
        this.hostBlock = hostBlock;
    }
}

