/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlCursorDefinitionBlock;
import com.intellij.sql.formatter.model.SqlDeclareSectionBlock$WhenMappings;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlVariableDefinitionBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\bH\u0014J\b\u0010\u0013\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/formatter/model/SqlDeclareSectionBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "countOfElements", "", "mustWrap", "", "adjustProducedNestedBlocks", "", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "makeBlock", "node", "Lcom/intellij/lang/ASTNode;", "tuneNestedNodesAfterAnalysis", "userRequiresExpand", "intellij.database.sql.impl"})
public final class SqlDeclareSectionBlock
extends SqlRangeBlock {
    private int countOfElements;
    private boolean mustWrap;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_VARIABLE_DEFINITION))) {
            void $this$withSetup$iv;
            SqlNodeBlock sqlNodeBlock = new SqlVariableDefinitionBlock();
            SqlBlock parent$iv = this;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_impl(parent$iv, node);
            sqlBlock = SqlBlockKt.withRole((SqlBlock)$this$withSetup$iv, BlockRole.ELEMENT);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_CURSOR_DEFINITION))) {
            void var3_4;
            SqlRangeBlock $this$withSetup$iv = new SqlCursorDefinitionBlock();
            SqlBlock parent$iv = this;
            boolean $i$f$withSetup = false;
            TextRange textRange = node.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"outerNode.textRange");
            $this$withSetup$iv.setup$intellij_database_sql_impl(parent$iv, textRange, SqlFormattingModelFunKt.listChildren(node));
            sqlBlock = SqlBlockKt.withRole((SqlBlock)var3_4, BlockRole.ELEMENT);
        } else {
            sqlBlock = super.makeBlock(node);
        }
        return sqlBlock;
    }

    @Override
    protected void adjustProducedNestedBlocks() {
        super.adjustProducedNestedBlocks();
        this.countOfElements = CollectionsKt.count((Iterable)((Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT)));
        SqlCodeStyleSettings s2 = this.getContext().getSql();
        this.mustWrap = s2.IMP_DECLARE_CONTENT_WRAP || s2.IMP_DECLARE_EL_WRAP == 0 && this.contains('\n') || s2.IMP_DECLARE_EL_WRAP == 1 && this.countOfElements >= 2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void tuneNestedNodesAfterAnalysis() {
        block5: {
            super.tuneNestedNodesAfterAnalysis();
            if (this.mustWrap) break block5;
            s = this.getContext().getSql();
            switch (SqlDeclareSectionBlock$WhenMappings.$EnumSwitchMapping$0[this.getShape().ordinal()]) {
                case 1: {
                    if (s.IMP_DECLARE_EL_WRAP != 2) break;
                    var2_2 = this.getNestedBlocks();
                    var8_3 = this;
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl13
                    v0 = false;
                    ** GOTO lbl20
lbl13:
                    // 2 sources

                    for (T element$iv : $this$any$iv) {
                        it = (SqlBlock)element$iv;
                        $i$a$-any-SqlDeclareSectionBlock$tuneNestedNodesAfterAnalysis$1 = false;
                        if (!(it.getRole() == BlockRole.ELEMENT && it.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS)) continue;
                        v0 = true;
                        ** GOTO lbl20
                    }
                    v0 = false;
lbl20:
                    // 3 sources

                    var8_3.mustWrap = var9_9 = v0;
                    break;
                }
                case 2: {
                    this.mustWrap = true;
                    break;
                }
            }
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        SqlCodeStyleSettings s2 = this.getContext().getSql();
        Wrap w1 = s2.IMP_DECLARE_CONTENT_WRAP ? SqlFlowBlock.makeWrap$default(this, WrapType.ALWAYS, false, 2, null) : null;
        boolean several = this.countOfElements >= 2;
        Wrap w2 = this.mustWrap ? SqlFlowBlock.makeWrap$intellij_database_sql_impl$default((SqlFlowBlock)this, w1, s2.IMP_DECLARE_EL_WRAP, false, 4, null) : null;
        Alignment a = several ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
        SqlBlock sqlBlock = SqlFormattingModelFunKt.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
        if (sqlBlock != null) {
            SqlBlock sqlBlock2 = sqlBlock;
            boolean bl = false;
            boolean bl2 = false;
            SqlBlock it2 = sqlBlock2;
            boolean bl3 = false;
            it2.setMyWrap(w1);
            it2.setMyAlign(a);
        }
        if (several) {
            JBIterable jBIterable = SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).skip(1);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"nestedBlocks.filter(ELEMENT).skip(1)");
            Iterable $this$forEach$iv = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlBlock it3 = (SqlBlock)element$iv;
                boolean bl = false;
                it3.setMyWrap(w2);
                it3.setMyAlign(a);
            }
            if (s2.IMP_DECLARE_ALIGN_TYPE || s2.IMP_DECLARE_ALIGN_EQ || s2.IMP_DECLARE_ALIGN_DEFAULT) {
                Alignment a1 = s2.IMP_DECLARE_ALIGN_TYPE ? SqlFormattingModelFunKt.makeRightAlignmentBS() : null;
                Alignment a2 = s2.IMP_DECLARE_ALIGN_TYPE ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
                Alignment a3 = s2.IMP_DECLARE_ALIGN_EQ ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
                Alignment a4 = s2.IMP_DECLARE_ALIGN_DEFAULT ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
                Iterable $this$forEach$iv2 = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    SqlBlock variable = (SqlBlock)element$iv;
                    boolean bl = false;
                    variable.grow();
                    for (SqlBlock b2 : variable.getNestedBlocks()) {
                        switch (SqlDeclareSectionBlock$WhenMappings.$EnumSwitchMapping$1[b2.getRole().ordinal()]) {
                            case 1: {
                                b2.setMyAlign(a1);
                                break;
                            }
                            case 2: {
                                b2.setMyAlign(a2);
                                break;
                            }
                            case 3: {
                                b2.setMyAlign(a3);
                                break;
                            }
                            case 4: {
                                b2.setMyAlign(a4);
                                break;
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        BlockRole r2 = block2.getRole();
        if (r2 == BlockRole.ELEMENT) {
            int elw = this.getContext().getSql().IMP_DECLARE_EL_WRAP;
            spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, elw == 0 || elw == 3 && block1.getRole() == BlockRole.DELIMITER, 1, null);
        } else {
            spacing = super.decideSpacing(block1, block2);
        }
        return spacing;
    }

    @Override
    public boolean userRequiresExpand() {
        return this.mustWrap;
    }
}

