/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.openapi.util.TextRange;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.SqlCommentBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlBlockCommentBlock;", "Lcom/intellij/sql/formatter/model/SqlCommentBlock;", "()V", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "incomplete", "", "intellij.database.sql.impl"})
public final class SqlBlockCommentBlock
extends SqlCommentBlock {
    @Override
    public boolean incomplete() {
        TextRange r = this.getRange();
        if (r.getLength() < 4) {
            return true;
        }
        int p2 = r.getEndOffset();
        if (p2 < 4) {
            return true;
        }
        char c1 = this.getContext().getText().charAt(p2 - 2);
        char c2 = this.getContext().getText().charAt(p2 - 1);
        return c1 != '*' || c2 != '/';
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        int b2;
        int p2;
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        TextRange r = this.getRange();
        if (r.getLength() < 4) {
            return null;
        }
        int n = r.getEndOffset() - 2;
        for (p2 = b2 = r.getStartOffset() + 2; p2 < n && CharsKt.isWhitespace((char)this.getContext().getText().charAt(p2)); ++p2) {
        }
        return SqlFormattingContext.currIndentOf$default(this.getContext(), p2, true, false, 4, null);
    }

    public SqlBlockCommentBlock() {
        super(null);
    }
}

