/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlExpressionBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlElementTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/formatter/model/SqlArrayAccessBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/SqlExpressionBlock;", "()V", "countOfElements", "", "countRole", "", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "determineRole", "node", "Lcom/intellij/lang/ASTNode;", "whetherToFlatten", "", "intellij.database.sql.impl"})
public final class SqlArrayAccessBlock
extends SqlNodeBlock
implements SqlExpressionBlock {
    private int countOfElements;

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement psiElement = node.getPsi();
        if (!(psiElement instanceof SqlBinaryExpression)) {
            psiElement = null;
        }
        SqlBinaryExpression sqlBinaryExpression = (SqlBinaryExpression)psiElement;
        return (sqlBinaryExpression != null ? sqlBinaryExpression.getOpSign() : null) == SqlElementTypes.SQL_COLON;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node) {
        BlockRole blockRole;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getElementType() == SqlElementTypes.SQL_ANY_CALLABLE_REFERENCE) {
            blockRole = BlockRole.BODY;
        } else {
            void what$iv;
            void $this$change$iv;
            BlockRole blockRole2 = super.determineRole(node);
            BlockRole blockRole3 = BlockRole.NOTHING;
            BlockRole with$iv = BlockRole.ELEMENT;
            boolean $i$f$change = false;
            blockRole = Intrinsics.areEqual((Object)$this$change$iv, (Object)what$iv) ? with$iv : blockRole2;
        }
        return blockRole;
    }

    @Override
    public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        if (role == BlockRole.ELEMENT) {
            int n = this.countOfElements;
            this.countOfElements = n + 1;
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        IElementType t1 = SqlFormattingModelFunKt.primaryElementType(block1);
        IElementType t2 = SqlFormattingModelFunKt.primaryElementType(block2);
        return t1 == SqlElementTypes.SQL_LEFT_BRACKET || t2 == SqlElementTypes.SQL_RIGHT_BRACKET ? SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null) : (t1 == SqlElementTypes.SQL_COLON || t2 == SqlElementTypes.SQL_COLON ? SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null) : (t2 == SqlElementTypes.SQL_LEFT_BRACKET ? SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null) : (t1 == SqlElementTypes.SQL_COMMA ? this.getContext().makeSpace(this.getContext().getSql().EXPR_CALL_SPACE_AFTER_COMMA) : (t2 == SqlElementTypes.SQL_COMMA ? this.getContext().makeSpace(this.getContext().getSql().EXPR_CALL_SPACE_BEFORE_COMMA) : super.decideSpacing(block1, block2)))));
    }
}

