/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SingletonPattern;
import com.intellij.sql.formatter.model.SqlAlterInnerElementBlock;
import com.intellij.sql.formatter.model.SqlAlterInstructionBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlLeafBlocksKt;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.UntilPattern;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlTokenType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0014J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/formatter/model/SqlAlterInstructionBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "countOfInnerEntries", "", "configureFormattingAttributes", "", "considerBlock", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "Companion", "intellij.database.sql.impl"})
public final class SqlAlterInstructionBlock
extends SqlNodeBlock {
    private int countOfInnerEntries;
    @NotNull
    private static final List<FlowPattern> patterns;
    public static final Companion Companion;

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        return patterns;
    }

    @Override
    protected void considerBlock(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        super.considerBlock(block);
        if (block instanceof SqlAlterInnerElementBlock) {
            int n = this.countOfInnerEntries;
            this.countOfInnerEntries = n + 1;
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        if (this.countOfInnerEntries >= 2) {
            Alignment a = SqlFormattingModelFunKt.makeLeftAlignment();
            Wrap w = this.makeWrap(WrapType.CHOP_DOWN_IF_LONG, false);
            Indent i2 = SqlFormattingFunKt.getNORMAL_INDENT();
            for (SqlBlock b2 : this.getNestedBlocks()) {
                if (!(b2 instanceof SqlAlterInnerElementBlock)) continue;
                SqlBlock this_$iv = b2;
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap(w);
                this_$iv.setMyIndent(i2);
                this_$iv.setMyAlign(a);
            }
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        return SqlLeafBlocksKt.isSymbol(block1, '(') ? this.getContext().makeNoSpace(true) : (SqlLeafBlocksKt.isSymbol(block2, ')') ? this.getContext().makeNoSpace(true) : (block2 instanceof SqlComma ? this.getContext().makeNoSpace(true) : super.decideSpacing(block1, block2)));
    }

    static {
        Companion = new Companion(null);
        Object[] objectArray = new FlowPattern[4];
        Byte by = 0;
        Byte by2 = 5;
        SqlTokenType sqlTokenType = SqlCommonTokens.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
        objectArray[0] = new SingletonPattern(by, by2, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
        Byte by3 = 5;
        Byte by4 = 5;
        SqlTokenType sqlTokenType2 = SqlCommonTokens.SQL_COMMA;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_COMMA");
        objectArray[1] = new SingletonPattern(by3, by4, NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
        Byte by5 = 5;
        Byte by6 = 5;
        IElementType[] iElementTypeArray = new IElementType[2];
        SqlTokenType sqlTokenType3 = SqlCommonTokens.SQL_COMMA;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_COMMA");
        iElementTypeArray[0] = (IElementType)sqlTokenType3;
        SqlTokenType sqlTokenType4 = SqlCommonTokens.SQL_RIGHT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_RIGHT_PAREN");
        iElementTypeArray[1] = (IElementType)sqlTokenType4;
        objectArray[2] = new UntilPattern(by5, by6, NodeMatcherKt.matchType(iElementTypeArray), false, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
        Byte by7 = 5;
        Byte by8 = 6;
        SqlTokenType sqlTokenType5 = SqlCommonTokens.SQL_RIGHT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType5, (String)"SQL_RIGHT_PAREN");
        objectArray[3] = new SingletonPattern(by7, by8, NodeMatcherKt.matchType((IElementType)sqlTokenType5), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
        patterns = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlAlterInstructionBlock$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.impl"})
    public static final class Companion {
        @NotNull
        public final List<FlowPattern> getPatterns() {
            return patterns;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

