/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.model.ModelFun;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.sql.formatter.Change;
import com.intellij.sql.formatter.SqlPreFormatHelper;
import com.intellij.sql.formatter.SqlQueryPreFormatter;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/formatter/SqlQueryPreFormatter;", "", "settings", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "changes", "", "Lcom/intellij/sql/formatter/Change;", "(Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;Ljava/util/Collection;)V", "AS", "", "comma1st", "", "commaLast", "commaPosition", "", "commaProcessing", "useAsWord", "processClauseAS", "", "queryElement", "Lcom/intellij/psi/PsiElement;", "asExpressionElement", "processQuery", "processQueryForCommas", "processQueryForKeywordAS", "intellij.database.sql.impl"})
public final class SqlQueryPreFormatter {
    private final int useAsWord;
    private final String AS;
    private final int commaPosition;
    private final boolean comma1st;
    private final boolean commaLast;
    private final boolean commaProcessing;
    private final Collection<Change> changes;

    public final void processQuery(@NotNull PsiElement queryElement) {
        Intrinsics.checkNotNullParameter((Object)queryElement, (String)"queryElement");
        if (this.useAsWord > 0) {
            this.processQueryForKeywordAS(queryElement);
        }
        if (this.commaProcessing) {
            this.processQueryForCommas(queryElement);
        }
    }

    private final void processQueryForKeywordAS(PsiElement queryElement) {
        for (PsiElement e = queryElement.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (PsiTreeUtilKt.getElementType((PsiElement)e) != SqlCompositeElementTypes.SQL_AS_EXPRESSION) continue;
            this.processClauseAS(queryElement, e);
        }
    }

    private final void processClauseAS(PsiElement queryElement, PsiElement asExpressionElement) {
        PsiElement psiElement = asExpressionElement.getFirstChild();
        if (psiElement == null) {
            return;
        }
        PsiElement firstChild = psiElement;
        switch (this.useAsWord) {
            case 1: {
                PsiElement[] s2 = SqlPreFormatHelper.findSubSequence(firstChild, processClauseAS.s.1.INSTANCE, processClauseAS.s.2.INSTANCE);
                if (s2 == null) break;
                boolean bl = s2.length == 2;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                String string = this.AS;
                if (string == null) {
                    string = ModelFun.choose(SqlPreFormatHelper.whetherKeywordsUpper(queryElement), "AS", "as");
                }
                String word = string;
                Change change = Change.Companion.insert(UtilsKt.getStartOffset((PsiElement)s2[1]), word + ' ');
                Collection<Change> collection = this.changes;
                boolean bl5 = false;
                collection.add(change);
                break;
            }
            case 2: {
                TextRange r;
                PsiElement[] s3 = SqlPreFormatHelper.findSubSequence(firstChild, processClauseAS.s.3.INSTANCE, processClauseAS.s.4.INSTANCE, processClauseAS.s.5.INSTANCE);
                if (s3 == null) break;
                boolean word = s3.length == 3;
                boolean change = false;
                boolean bl = false;
                if (_Assertions.ENABLED && !word) {
                    boolean bl6 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                TextRange textRange = r = s3[1].getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"r");
                Change change2 = Change.Companion.delete(textRange);
                Collection<Change> collection = this.changes;
                boolean bl7 = false;
                collection.add(change2);
                break;
            }
        }
    }

    private final void processQueryForCommas(PsiElement queryElement) {
        block6: {
            PsiElement[] s2;
            PsiElement begin;
            block5: {
                PsiElement[] s3;
                PsiElement psiElement = queryElement.getFirstChild();
                if (psiElement == null) {
                    return;
                }
                begin = psiElement;
                if (!this.comma1st) break block5;
                while ((s3 = SqlPreFormatHelper.findSubSequence(begin, processQueryForCommas.s.1.INSTANCE, processQueryForCommas.s.2.INSTANCE, processQueryForCommas.s.3.INSTANCE, processQueryForCommas.s.4.INSTANCE)) != null) {
                    boolean bl;
                    boolean bl2 = s3.length == 4;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    if (_Assertions.ENABLED && !bl2) {
                        bl = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    TextRange textRange = s3[1].getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"s[1].textRange");
                    Change ch1 = Change.Companion.delete(textRange);
                    TextRange textRange2 = s3[2].getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"s[2].textRange");
                    Change ch2 = Change.Companion.insertAfter(textRange2, "\n,");
                    Collection<Change> collection = this.changes;
                    bl = false;
                    collection.add(ch1);
                    collection = this.changes;
                    bl = false;
                    collection.add(ch2);
                    begin = s3[3];
                }
                break block6;
            }
            if (!this.commaLast) break block6;
            while ((s2 = SqlPreFormatHelper.findSubSequence(begin, processQueryForCommas.s.5.INSTANCE, processQueryForCommas.s.6.INSTANCE, processQueryForCommas.s.7.INSTANCE, processQueryForCommas.s.8.INSTANCE)) != null) {
                boolean bl;
                boolean ch1 = s2.length == 4;
                boolean ch2 = false;
                boolean bl5 = false;
                if (_Assertions.ENABLED && !ch1) {
                    bl = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                TextRange textRange = s2[1].getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"s[1].textRange");
                Change ch3 = Change.Companion.insertBefore(textRange, ", ");
                TextRange textRange3 = s2[2].getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"s[2].textRange");
                Change ch4 = Change.Companion.delete(textRange3);
                Collection<Change> collection = this.changes;
                bl = false;
                collection.add(ch3);
                collection = this.changes;
                bl = false;
                collection.add(ch4);
                begin = s2[3];
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public SqlQueryPreFormatter(@NotNull SqlCodeStyleSettings settings, @NotNull Collection<Change> changes) {
        void what$iv;
        void $this$change$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.changes = changes;
        this.useAsWord = settings.SELECT_USE_AS_WORD;
        switch (settings.KEYWORD_CASE) {
            case 1: {
                string = "as";
                break;
            }
            case 2: {
                string = "AS";
                break;
            }
            case 5: {
                string = "As";
                break;
            }
            default: {
                string = null;
            }
        }
        this.AS = string;
        int n = settings.SELECT_EL_COMMA;
        int n2 = -1;
        int with$iv = settings.QUERY_EL_COMMA;
        boolean $i$f$change = false;
        this.commaPosition = $this$change$iv == what$iv ? with$iv : n;
        this.comma1st = this.commaPosition == 1;
        this.commaLast = this.commaPosition == 2;
        this.commaProcessing = this.comma1st || this.commaLast;
    }
}

