/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQuoteHandler
extends SimpleTokenSetQuoteHandler
implements MultiCharQuoteHandler {
    public SqlQuoteHandler() {
        super(new IElementType[]{SqlTokens.SQL_STRING_TOKEN, SqlTokens.SQL_IDENT_DELIMITED, SqlTokens.SQL_UNCLOSED_TOKEN, SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN, SqlTokens.SQL_CUSTOM_LQUOTE});
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        char q;
        if (super.isOpeningQuote(iterator, offset)) {
            return true;
        }
        IElementType type = iterator.getTokenType();
        if (type == SqlTokens.SQL_CUSTOM_LQUOTE && offset == iterator.getEnd() - 1) {
            return true;
        }
        if (SqlTokens.SQL_UNCLOSED_TOKEN != type && SqlTokens.SQL_STRING_TOKEN != type) {
            return false;
        }
        int s2 = iterator.getStart();
        int e = Math.min(s2 + 4, offset + 1);
        CharSequence chars = iterator.getDocument().getCharsSequence();
        char c2 = q = e - 2 < s2 ? (char)'\u0000' : chars.charAt(e - 2);
        if (q == 'q' || q == 'Q') {
            return false;
        }
        return StringUtil.indexOf((CharSequence)chars, (char)'\'', (int)s2, (int)e) == offset;
    }

    protected boolean isNonClosedLiteral(HighlighterIterator iterator, CharSequence chars) {
        if (StringUtil.indexOf((CharSequence)chars.subSequence(iterator.getStart(), iterator.getEnd()), (char)'\n') > -1) {
            return true;
        }
        IElementType type = iterator.getTokenType();
        if (type == SqlTokens.SQL_CUSTOM_LQUOTE) {
            if (iterator.atEnd()) {
                return false;
            }
            iterator.advance();
            type = iterator.getTokenType();
            iterator.retreat();
            return type != SqlTokens.SQL_CUSTOM_RQUOTE && type != SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN;
        }
        return type == SqlTokens.SQL_UNCLOSED_TOKEN || super.isNonClosedLiteral(iterator, chars);
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        IElementType type;
        boolean move;
        if (iterator == null) {
            SqlQuoteHandler.$$$reportNull$$$0(0);
        }
        boolean bl = move = (type = iterator.getTokenType()) != SqlTokens.SQL_CUSTOM_LQUOTE;
        if (move) {
            if (iterator.getStart() == 0) {
                return null;
            }
            iterator.retreat();
            type = iterator.getTokenType();
        }
        int s2 = iterator.getStart();
        int e = iterator.getEnd();
        if (move) {
            iterator.advance();
        }
        if (type != SqlTokens.SQL_CUSTOM_LQUOTE || offset != e) {
            return null;
        }
        CharSequence seq = iterator.getDocument().getCharsSequence();
        if (seq.charAt(s2) == '$') {
            return seq.subSequence(s2, e);
        }
        if (e - 3 < s2) {
            return null;
        }
        char q = seq.charAt(e - 3);
        if (q != 'q' && q != 'Q') {
            return null;
        }
        q = seq.charAt(e - 2);
        if (q != '\'') {
            return null;
        }
        q = seq.charAt(e - 1);
        switch (q) {
            case '(': {
                q = ')';
                break;
            }
            case '<': {
                q = '>';
                break;
            }
            case '{': {
                q = '}';
                break;
            }
            case '[': {
                q = ']';
            }
        }
        return (char)q + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/sql/editor/SqlQuoteHandler", "getClosingQuote"));
    }

    public static class Plus
    extends Concat {
        @Override
        public String getStringConcatenationOperatorRepresentation() {
            return "+";
        }
    }

    public static class Concat
    extends SqlQuoteHandler
    implements JavaLikeQuoteHandler {
        private static final TokenSet CONCAT_SET = TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_STRING_TOKEN});

        @NotNull
        public TokenSet getConcatenatableStringTokenTypes() {
            TokenSet tokenSet = CONCAT_SET;
            if (tokenSet == null) {
                Concat.$$$reportNull$$$0(0);
            }
            return tokenSet;
        }

        public String getStringConcatenationOperatorRepresentation() {
            return "||";
        }

        public TokenSet getStringTokenTypes() {
            return null;
        }

        public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
            if (tokenType == null) {
                Concat.$$$reportNull$$$0(1);
            }
            return true;
        }

        public boolean needParenthesesAroundConcatenation(PsiElement element2) {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlQuoteHandler$Concat";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConcatenatableStringTokenTypes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlQuoteHandler$Concat";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAppropriateElementTypeForLiteral";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

