/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.dateTime;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.dateTime.psi.SqlDtCompositeElementType;
import com.intellij.sql.dialects.dateTime.psi.SqlDtReference;
import com.intellij.sql.dialects.dateTime.psi.SqlDtTemporalElement;
import com.intellij.sql.dialects.dateTime.psi.values.SqlTemporalValue;
import com.intellij.sql.dialects.dateTime.psi.values.SqlTemporalValueKt;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlTimeAndDateLiteralExpressionImpl;
import java.time.chrono.IsoChronology;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J,\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\b\b\u0002\u0010\u001d\u001a\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\nH\u0005J\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0017\u00a8\u0006 "}, d2={"Lcom/intellij/sql/dialects/dateTime/SqlDateTimeLanguageHelper;", "", "()V", "createLexer", "Lcom/intellij/lexer/FlexLexer;", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "createParser", "Lcom/intellij/lang/PsiParser;", "getMaxDayOfMonth", "", "dayPsi", "Lcom/intellij/sql/dialects/dateTime/psi/SqlDtTemporalElement;", "getRootElementType", "Lcom/intellij/sql/dialects/dateTime/psi/SqlDtCompositeElementType;", "inspectTemporalValue", "Lcom/intellij/codeInspection/ProblemDescriptor;", "temporal", "Lcom/intellij/sql/dialects/dateTime/psi/values/SqlTemporalValue;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "resolveReference", "Lcom/intellij/psi/PsiElement;", "ref", "Lcom/intellij/sql/dialects/dateTime/psi/SqlDtReference;", "validateInterval", "", "min", "max", "validateTemporalValue", "intellij.database.sql.impl"})
public abstract class SqlDateTimeLanguageHelper {
    @Nullable
    public SqlDtCompositeElementType getRootElementType(@NotNull PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiElement psiElement = host.getParent();
        if (!(psiElement instanceof SqlTimeAndDateLiteralExpressionImpl)) {
            psiElement = null;
        }
        SqlTimeAndDateLiteralExpressionImpl sqlTimeAndDateLiteralExpressionImpl = (SqlTimeAndDateLiteralExpressionImpl)psiElement;
        if (sqlTimeAndDateLiteralExpressionImpl == null) {
            return null;
        }
        SqlTimeAndDateLiteralExpressionImpl dateTimeLiteral = sqlTimeAndDateLiteralExpressionImpl;
        IElementType iElementType = dateTimeLiteral.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_DATE_LITERAL) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.ODBC_DATE) ? SqlDtCompositeElementType.Companion.getDATE() : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_TIME_LITERAL) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.ODBC_TIME) ? SqlDtCompositeElementType.Companion.getTIME() : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_TIMESTAMP_LITERAL) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.ODBC_TIMESTAMP) ? SqlDtCompositeElementType.Companion.getTIMESTAMP() : null));
    }

    @NotNull
    public abstract FlexLexer createLexer(@NotNull PsiLanguageInjectionHost var1);

    @NotNull
    public abstract PsiParser createParser(@NotNull PsiLanguageInjectionHost var1);

    @Nullable
    public PsiElement resolveReference(@NotNull SqlDtReference ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return null;
    }

    @InspectionMessage
    @Nullable
    protected final String validateInterval(@NotNull SqlTemporalValue<Integer> temporal, int min, int max) {
        Intrinsics.checkNotNullParameter(temporal, (String)"temporal");
        String string = temporal.getName();
        if (string == null) {
            return null;
        }
        String name = string;
        int n = min;
        IntRange intRange = new IntRange(n, max);
        Integer n2 = temporal.getValue();
        boolean bl = false;
        return n2 != null && intRange.contains(n2.intValue()) ? null : SqlBundle.message("inspection.message.field.must.be.between", StringUtil.toTitleCase((String)name), min, max);
    }

    public static /* synthetic */ String validateInterval$default(SqlDateTimeLanguageHelper sqlDateTimeLanguageHelper, SqlTemporalValue sqlTemporalValue, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: validateInterval");
        }
        if ((n3 & 2) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n3 & 4) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        return sqlDateTimeLanguageHelper.validateInterval(sqlTemporalValue, n, n2);
    }

    private final int getMaxDayOfMonth(SqlDtTemporalElement dayPsi) {
        int n;
        PsiElement psiElement = dayPsi.getParent();
        if (!(psiElement instanceof SqlDtTemporalElement)) {
            psiElement = null;
        }
        SqlDtTemporalElement sqlDtTemporalElement = (SqlDtTemporalElement)psiElement;
        if (sqlDtTemporalElement == null) {
            return 31;
        }
        SqlDtTemporalElement parent2 = sqlDtTemporalElement;
        SqlTemporalValue<?> sqlTemporalValue = parent2.evaluate();
        if (!(sqlTemporalValue instanceof SqlTemporalValue.Date)) {
            sqlTemporalValue = null;
        }
        SqlTemporalValue.Date date = (SqlTemporalValue.Date)sqlTemporalValue;
        if (date == null) {
            return 31;
        }
        SqlTemporalValue.Date date2 = date;
        Object object = date2.getYear();
        if (object == null || (object = ((SqlTemporalValue.Year)object).getValue()) == null) {
            return 31;
        }
        int year = (Integer)object;
        Object object2 = date2.getMonth();
        if (object2 == null || (object2 = ((SqlTemporalValue.Month)object2).getValue()) == null) {
            return 31;
        }
        int month = (Integer)object2;
        switch (month) {
            case 2: {
                if (IsoChronology.INSTANCE.isLeapYear(year)) {
                    n = 29;
                    break;
                }
                n = 28;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n = 30;
                break;
            }
            default: {
                n = 31;
            }
        }
        return n;
    }

    @Nullable
    public ProblemDescriptor inspectTemporalValue(@NotNull SqlTemporalValue<?> temporal, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter(temporal, (String)"temporal");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        String string = this.validateTemporalValue(temporal);
        if (string == null) {
            return null;
        }
        String message2 = string;
        return manager.createProblemDescriptor((PsiElement)temporal.getPsi(), SqlTemporalValueKt.getRangeInElement(temporal), message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]);
    }

    @InspectionMessage
    @Nullable
    public String validateTemporalValue(@NotNull SqlTemporalValue<?> temporal) {
        Intrinsics.checkNotNullParameter(temporal, (String)"temporal");
        SqlTemporalValue<Integer> sqlTemporalValue = temporal;
        return sqlTemporalValue instanceof SqlTemporalValue.Month ? this.validateInterval(temporal, 1, 12) : (sqlTemporalValue instanceof SqlTemporalValue.DayOfMonth ? this.validateInterval(temporal, 1, this.getMaxDayOfMonth(temporal.getPsi())) : (sqlTemporalValue instanceof SqlTemporalValue.Hour ? this.validateInterval(temporal, 0, 23) : (sqlTemporalValue instanceof SqlTemporalValue.Minute ? this.validateInterval(temporal, 0, 59) : (sqlTemporalValue instanceof SqlTemporalValue.Second ? this.validateInterval(temporal, 0, 59) : (sqlTemporalValue instanceof SqlTemporalValue.SecondFraction ? this.validateInterval(temporal, 0, 999999999) : (sqlTemporalValue instanceof SqlTemporalValue.Invalid ? ((SqlTemporalValue.Invalid)temporal).getError() : null))))));
    }
}

