/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.psi.SqlFile;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImportState {
    public final SqlImportState prevState;
    public final Shared shared;
    public final PsiElement element;
    public final TreePattern state;
    private static final TreePatternNode<?> FAKE_NODE = new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, TreePatternNode.NO_GROUPS);

    public SqlImportState(@Nullable PsiElement element2, @NotNull Shared shared, @NotNull TreePattern state, @Nullable SqlImportState prevState) {
        if (shared == null) {
            SqlImportState.$$$reportNull$$$0(0);
        }
        if (state == null) {
            SqlImportState.$$$reportNull$$$0(1);
        }
        this.element = element2;
        this.shared = shared;
        this.state = state;
        this.prevState = prevState;
    }

    public boolean isImported(@Nullable DasDataSource dataSource2, @Nullable DasObject obj) {
        return this.isImported(dataSource2 == null ? null : SqlImportUtil.getDataSourceName(dataSource2), (CasingProvider)(dataSource2 != null ? dataSource2.getModel() : this.shared.file), obj);
    }

    public boolean isImported(@Nullable ObjectName dsName, @NotNull CasingProvider casingProvider, @Nullable DasObject obj) {
        if (casingProvider == null) {
            SqlImportState.$$$reportNull$$$0(2);
        }
        return this.shared.overlay != null && SqlImportState.isImported(this.shared.overlay, dsName, obj, casingProvider) || SqlImportState.isImported(this.state, dsName, obj, casingProvider);
    }

    private static boolean isImported(@NotNull TreePattern state, @Nullable ObjectName dsName, @Nullable DasObject obj, @NotNull CasingProvider casingProvider) {
        if (state == null) {
            SqlImportState.$$$reportNull$$$0(3);
        }
        if (casingProvider == null) {
            SqlImportState.$$$reportNull$$$0(4);
        }
        if (dsName == null && obj == null) {
            return true;
        }
        HashSet nodes = new HashSet();
        state.root.matchedChildren(dsName, Casing.EXACT, SqlImportUtil.DATA_SOURCE, nodes);
        if (obj == null) {
            return !nodes.isEmpty();
        }
        if (dsName == null && nodes.isEmpty()) {
            nodes.add(FAKE_NODE);
        }
        return !SqlImportState.match(nodes, obj, casingProvider).isEmpty();
    }

    private static Set<TreePatternNode<?>> match(@NotNull Set<TreePatternNode<?>> roots, @NotNull DasObject obj, @NotNull CasingProvider casingProvider) {
        DasObject parent2;
        Set<TreePatternNode<?>> parentNodes;
        if (roots == null) {
            SqlImportState.$$$reportNull$$$0(5);
        }
        if (obj == null) {
            SqlImportState.$$$reportNull$$$0(6);
        }
        if (casingProvider == null) {
            SqlImportState.$$$reportNull$$$0(7);
        }
        Set<TreePatternNode<?>> set = parentNodes = (parent2 = obj.getDasParent()) == null || parent2.getKind() == ObjectKind.ROOT ? roots : SqlImportState.match(roots, parent2, casingProvider);
        if (parentNodes.isEmpty()) {
            return parentNodes;
        }
        HashSet res2 = new HashSet();
        ObjectKind kind = obj.getKind();
        if (kind == ObjectKind.EXTERNAL_SCHEMA) {
            kind = ObjectKind.SCHEMA;
        }
        Casing casing = casingProvider.getCasing(kind, obj);
        ObjectName name = ObjectName.create((String)obj.getName(), (boolean)DbSqlUtil.isQuoted(obj));
        if (name.name.isEmpty()) {
            name = null;
        }
        for (TreePatternNode<?> node : parentNodes) {
            node.matchedChildren(name, casing, kind, res2);
        }
        if (name == null && res2.isEmpty()) {
            res2.add(FAKE_NODE);
        }
        return res2;
    }

    public static void getPartialTrace(@Nullable SqlDialectImplUtil.ObjectTracer<?> tracer, @NotNull List<ObjectKind> kinds, @NotNull List names, @Nullable List<DasObject> contexts) {
        if (kinds == null) {
            SqlImportState.$$$reportNull$$$0(8);
        }
        if (names == null) {
            SqlImportState.$$$reportNull$$$0(9);
        }
        if (tracer != null) {
            SqlDialectImplUtil.ObjectTracer.ObjectTraceIt<?> it2 = tracer.trace();
            while (it2.hasNext()) {
                Object obj = it2.next();
                ObjectKind kind = it2.getKind();
                kinds.add(kind == ObjectKind.EXTERNAL_SCHEMA ? ObjectKind.SCHEMA : kind);
                names.add(new ObjectName(it2.getName(), it2.isQuoted()));
                if (contexts == null || !(obj instanceof DasObject)) continue;
                contexts.add((DasObject)obj);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/SqlImportState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isImported";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "match";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getPartialTrace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Shared {
        public final SqlFile file;
        public final TreePattern overlay;

        public Shared(@NotNull SqlFile file, @Nullable TreePattern overlay) {
            if (file == null) {
                Shared.$$$reportNull$$$0(0);
            }
            this.file = file;
            this.overlay = overlay;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/dialects/SqlImportState$Shared", "<init>"));
        }
    }
}

