/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlDialectImplUtil {
    public static final Logger LOG = Logger.getInstance(SqlDialectImplUtil.class);

    private SqlDialectImplUtil() {
    }

    @NotNull
    public static String getDialectHelpResource(Class<?> dialectClass, @NonNls String name) throws IOException {
        String text2;
        @NonNls String resourceName = null;
        InputStream zipIs = null;
        for (Class<?> c2 = dialectClass; c2 != null; c2 = c2.getSuperclass()) {
            String specificResourceName = "help/" + SqlDialectImplUtil.getSqlDialectName(c2) + "-help.zip";
            ClassLoader loader = c2.getClassLoader();
            zipIs = loader == null ? null : loader.getResourceAsStream(specificResourceName);
            String string = resourceName = zipIs != null || resourceName == null ? specificResourceName : resourceName;
            if (zipIs != null) break;
        }
        if (zipIs == null) {
            throw new IOException(SqlBundle.message("help.file.0.not.found", StringUtil.notNullize(resourceName)));
        }
        try {
            text2 = SqlDialectImplUtil.loadFileFromZip(zipIs, name);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new IOException(SqlBundle.message("help.file.0.not.found", name) + "\n" + e.getMessage(), e);
        }
        if (text2 == null) {
            throw new IOException(SqlBundle.message("help.file.0.not.found", resourceName + "!/" + name));
        }
        String string = text2;
        if (string == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String loadFileFromZip(InputStream stream, @NonNls String fileName) throws IOException {
        if (stream == null) {
            return null;
        }
        try (ZipInputStream zip = new ZipInputStream(stream);){
            ZipEntry zipEntry = zip.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equalsIgnoreCase(fileName)) {
                    String string = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader((InputStream)zip, StandardCharsets.UTF_8)));
                    return string;
                }
                zipEntry = zip.getNextEntry();
            }
        }
        return null;
    }

    public static Set<String> getAllKeywordsFromDefinition(Collection<SqlFunctionDefinition> definitions, Set<String> keywords) {
        for (SqlFunctionDefinition definition : definitions) {
            for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
                SqlDialectImplUtil.getAllKeywordsFromDefinition(prototype, keywords);
            }
        }
        return keywords;
    }

    public static void getAllKeywordsFromDefinition(SqlFunctionDefinition.ParameterBlock block, Set<String> keywords) {
        for (SqlFunctionDefinition.Parameter parameter : block.getParams()) {
            if (parameter instanceof SqlFunctionDefinition.Keyword) {
                keywords.add(((SqlFunctionDefinition.Keyword)parameter).getName());
                continue;
            }
            if (!(parameter instanceof SqlFunctionDefinition.ParameterBlock)) continue;
            SqlDialectImplUtil.getAllKeywordsFromDefinition((SqlFunctionDefinition.ParameterBlock)parameter, keywords);
        }
    }

    @NotNull
    private static String getSqlDialectName(@NotNull Class<?> dialectClass) {
        if (dialectClass == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(1);
        }
        String className = dialectClass.getName();
        int endIndex = className.indexOf("Dialect");
        String string = StringUtil.toLowerCase((String)className.substring(className.lastIndexOf(46) + 1, endIndex > -1 ? endIndex : className.length()));
        if (string == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static Map<String, ReservedEntity> buildEntities(@NotNull Dbms dbms, @NotNull ObjectKind kind, String ... names) {
        if (dbms == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(3);
        }
        if (kind == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(4);
        }
        LinkedHashMap<String, ReservedEntity> result = new LinkedHashMap<String, ReservedEntity>();
        for (String name : names) {
            result.put(name, new ReservedEntity(dbms, name, kind));
        }
        LinkedHashMap<String, ReservedEntity> linkedHashMap = result;
        if (linkedHashMap == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(5);
        }
        return linkedHashMap;
    }

    public static boolean checkImports(@NotNull SqlImportState checker, @Nullable DasDataSource dataSource2, DasObject object) {
        if (checker == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(6);
        }
        return checker.isImported(dataSource2, object);
    }

    @NotNull
    public static SqlImportState getImportCheckerAt(@NotNull SqlFile sqlFile, @Nullable PsiElement place) {
        if (sqlFile == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(7);
        }
        while (place != null) {
            PsiFile file = place.getContainingFile();
            if (file instanceof SqlFile) {
                sqlFile = (SqlFile)file;
            }
            if (file == sqlFile) break;
            place = file.getContext();
        }
        return SqlDialectImplUtil.getNearestImportState(place, SqlDialectImplUtil.buildImports(sqlFile));
    }

    @NotNull
    public static SqlImportState getNearestImportState(PsiElement place, SqlImportState state) {
        PsiElement p2;
        if (state.prevState == null) {
            SqlImportState sqlImportState = state;
            if (sqlImportState == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(8);
            }
            return sqlImportState;
        }
        for (p2 = place; p2 != null; p2 = p2.getContext()) {
            if (SqlPsiElementFactory.isROFile(p2)) continue;
            if (p2 instanceof StubBasedPsiElement && ((StubBasedPsiElement)p2).getStub() != null || p2 instanceof PsiFileWithStubSupport && ((PsiFileWithStubSupport)p2).getStubTree() != null) break;
            if (!(p2 instanceof PsiFile)) continue;
            p2 = null;
            break;
        }
        if (p2 == null) {
            p2 = place;
        }
        while (state.prevState != null) {
            if (p2 != null && SqlDialectImplUtil.placeBefore(state.element, p2)) {
                SqlImportState sqlImportState = state;
                if (sqlImportState == null) {
                    SqlDialectImplUtil.$$$reportNull$$$0(9);
                }
                return sqlImportState;
            }
            state = state.prevState;
        }
        SqlImportState sqlImportState = state;
        if (sqlImportState == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(10);
        }
        return sqlImportState;
    }

    public static boolean placeBefore(PsiElement p1, PsiElement p2) {
        if (p1 == null || p2 == null) {
            return true;
        }
        if (p1 instanceof StubBasedPsiElement && p2 instanceof StubBasedPsiElement) {
            StubElement s1 = ((StubBasedPsiElement)p1).getStub();
            StubElement s2 = ((StubBasedPsiElement)p2).getStub();
            if (s1 != null && s2 != null) {
                StubElement e;
                ArrayList<StubElement> parents1 = new ArrayList<StubElement>();
                for (e = s1; e != null; e = e.getParentStub()) {
                    parents1.add(e);
                }
                StubElement prevE = null;
                for (e = s2; e != null; e = e.getParentStub()) {
                    if (e == s1) {
                        return true;
                    }
                    int idx = parents1.indexOf(e);
                    if (idx != -1) {
                        if (idx == 0 || prevE == null) {
                            return true;
                        }
                        StubElement prev1 = (StubElement)parents1.get(idx - 1);
                        for (StubElement element2 : e.getChildrenStubs()) {
                            if (element2 == prev1) {
                                return true;
                            }
                            if (element2 != prevE) continue;
                            return false;
                        }
                        throw new AssertionError();
                    }
                    prevE = e;
                }
            }
        }
        TextRange r1 = p1.getTextRange();
        TextRange r2 = p2.getTextRange();
        return (r1 == null ? 0 : r1.getStartOffset()) < (r2 == null ? 0 : r2.getStartOffset());
    }

    @Nullable
    public static String getUserName(@Nullable RawConnectionConfig config) {
        LocalDataSource ds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)config);
        if (ds == null) {
            return null;
        }
        String username = StringUtil.nullize((String)ds.getUsername());
        if (username != null) {
            return username;
        }
        JdbcUrlParser parser2 = SqlDialectImplUtil.getParsed(config);
        return parser2 == null ? null : StringUtil.nullize((String)parser2.getParameter("user"));
    }

    @Nullable
    public static JdbcUrlParser getParsed(@Nullable RawConnectionConfig config) {
        if (config == null) {
            return null;
        }
        JdbcUrlParser stateful = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(config));
        if (stateful != null) {
            stateful.setUrlText(config.getUrl());
            return stateful;
        }
        return null;
    }

    @Nullable
    public static String getDatabaseName(@Nullable RawConnectionConfig config) {
        JdbcUrlParser stateful = SqlDialectImplUtil.getParsed(config);
        return stateful != null ? StringUtil.nullize((String)stateful.getParameter("database")) : null;
    }

    @NotNull
    public static SqlImportState buildImports(SqlFile sqlFile) {
        SqlImportState sqlImportState = (SqlImportState)CachedValuesManager.getCachedValue((PsiElement)sqlFile, () -> new CachedValueProvider.Result((Object)SqlDialectImplUtil.calcImports(sqlFile), new Object[]{sqlFile, DbPsiFacade.getInstance((Project)sqlFile.getProject())}));
        if (sqlImportState == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(11);
        }
        return sqlImportState;
    }

    @Nullable
    public static TreePattern buildOverlayPattern(SqlFile sqlFile) {
        return (TreePattern)CachedValuesManager.getCachedValue((PsiElement)sqlFile, () -> new CachedValueProvider.Result((Object)SqlDialectImplUtil.calcOverlayPattern(sqlFile), new Object[]{sqlFile, DbPsiFacade.getInstance((Project)sqlFile.getProject())}));
    }

    @Contract(value="null,null,null->null")
    public static TreePattern createObjectPattern(@Nullable ObjectName[] dsNames, @Nullable DasObject object, TreePatternNode.Group ... tail) {
        if (object == null && dsNames == null) {
            return null;
        }
        SmartList kinds = new SmartList();
        SmartList names = new SmartList();
        SqlImportState.getPartialTrace(SqlDialectImplUtil.trace(object), (List<ObjectKind>)kinds, (List)names, null);
        kinds.add(SqlImportUtil.DATA_SOURCE);
        names.add(dsNames);
        return SqlImportUtil.createPattern(names, (List<ObjectKind>)kinds, tail);
    }

    @Contract(value="null,_,null,null->null")
    public static TreePattern createObjectPattern(@Nullable ObjectName[] dsNames, @NotNull Dbms dbms, @Nullable ObjectPath object, TreePatternNode.Group ... tail) {
        List<ObjectKind> path;
        if (dbms == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(12);
        }
        if (object == null && dsNames == null) {
            return null;
        }
        SmartList kinds = new SmartList();
        SmartList names = new SmartList();
        if (object != null && (path = SqlImportUtil.getSingleRootPath(object.kind, dbms)) != null) {
            int e = path.size() - 1;
            for (int i2 = 0; i2 < e; ++i2) {
                kinds.add(path.get(i2));
                if (object != null) {
                    names.add(new ObjectName(object.name, object.isQuoted()));
                } else {
                    names.add(ObjectName.quoted((String)""));
                }
                object = object == null ? null : object.parent;
            }
        }
        kinds.add(SqlImportUtil.DATA_SOURCE);
        names.add(dsNames);
        return SqlImportUtil.createPattern(names, (List<ObjectKind>)kinds, tail);
    }

    protected static TreePattern calcOverlayPattern(SqlFile sqlFile) {
        PsiFile hostFile;
        SqlFile original = (SqlFile)ObjectUtils.tryCast((Object)sqlFile.getOriginalFile(), SqlFile.class);
        if (original != null && original != sqlFile) {
            return SqlDialectImplUtil.buildOverlayPattern(original);
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)sqlFile.getProject()).getInjectionHost((PsiElement)sqlFile);
        PsiFile psiFile = hostFile = host == null ? null : host.getContainingFile();
        if (hostFile instanceof SqlFile) {
            return SqlDialectImplUtil.calcOverlayPattern((SqlFile)hostFile);
        }
        if (DbSrcUtils.isDbSrcFile(sqlFile.getVirtualFile())) {
            return null;
        }
        SearchPath searchPath = DatabaseEditorHelper.getSearchPath((PsiFile)sqlFile);
        DbDataSource dataSource2 = DbImplUtil.getForcedDataSource((PsiFile)sqlFile);
        return ((SqlLanguageDialectEx)sqlFile.getSqlLanguage()).forcedContextPattern(dataSource2, searchPath);
    }

    @NotNull
    protected static SqlImportState calcImports(SqlFile sqlFile) {
        SqlImportState.Shared shared = new SqlImportState.Shared(sqlFile, SqlDialectImplUtil.buildOverlayPattern(sqlFile));
        SqlImportState current = new SqlImportState(null, shared, SqlDialectImplUtil.calcInitialImportState(sqlFile), null);
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        for (SqlUseDatabaseStatement statement : JBIterable.from((Iterable)sqlFile.getDdl()).filter(SqlUseDatabaseStatement.class)) {
            current = new SqlImportState((PsiElement)statement, shared, language.processImports(statement, current.state), current);
        }
        SqlImportState sqlImportState = current;
        if (sqlImportState == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(13);
        }
        return sqlImportState;
    }

    @NotNull
    private static TreePattern calcInitialImportState(@NotNull SqlFile sqlFile) {
        TreePattern resolvePattern;
        SqlFile hostFile;
        SqlFile orig;
        if (sqlFile == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(14);
        }
        if ((orig = (SqlFile)ObjectUtils.tryCast((Object)sqlFile.getOriginalFile(), SqlFile.class)) != null && orig != sqlFile) {
            return SqlDialectImplUtil.calcInitialImportState(orig);
        }
        VirtualFile vfile = sqlFile.getVirtualFile();
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)sqlFile.getProject()).getInjectionHost((PsiElement)sqlFile);
        if (host == null) {
            host = sqlFile.getContext();
        }
        SqlFile sqlFile2 = hostFile = host == null ? null : (SqlFile)ObjectUtils.tryCast((Object)host.getContainingFile(), SqlFile.class);
        if (hostFile != null && SqlImplUtil.getSqlDialectSafe((PsiElement)hostFile) == SqlImplUtil.getSqlDialectSafe((PsiElement)sqlFile)) {
            SqlImportState at = SqlDialectImplUtil.getImportCheckerAt(hostFile, (PsiElement)host);
            TreePattern treePattern = at.state;
            if (treePattern == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(15);
            }
            return treePattern;
        }
        if (DbSrcUtils.isDbSrcFile(vfile)) {
            SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
            String dataSourceId = DbSrcUtils.getDataSource(vfile);
            DbDataSource ds2 = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)sqlFile.getProject()).findDataSource(dataSourceId);
            SearchPath searchPath = DatabaseEditorHelper.dbSrcSearchPath(sqlFile.getProject(), vfile, true);
            TreePattern treePattern = searchPath != null ? language.srcFilePattern(ds2, searchPath) : TreePattern.EMPTY;
            if (treePattern == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(16);
            }
            return treePattern;
        }
        if (vfile instanceof DatabaseElementVirtualFileImpl) {
            SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
            DbElement o = ((DatabaseElementVirtualFileImpl)vfile).findElement(sqlFile.getProject());
            SearchPath searchPath = ObjectPaths.searchPathOf((DasObject)DbImplUtil.getSearchPathObject(language.getDatabaseDialect(), (DasObject)o));
            TreePattern treePattern = searchPath != null && o != null ? language.srcFilePattern(o.getDataSource(), searchPath) : TreePattern.EMPTY;
            if (treePattern == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(17);
            }
            return treePattern;
        }
        JdbcConsole console = JdbcConsoleProvider.getValidConsole(sqlFile.getProject(), vfile);
        TreePattern treePattern = resolvePattern = console == null ? SqlImportUtil.getResolveScopePattern(sqlFile) : null;
        if (resolvePattern == null || TreePatternUtils.isWildcard(resolvePattern.root.getGroup(SqlImportUtil.DATA_SOURCE))) {
            return SqlDialectImplUtil.getDefaultInitialPattern(sqlFile, null);
        }
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        JBIterable<DbDataSource> dataSources2 = SqlDialectImplUtil.getFilteredDataSources(sqlFile, resolvePattern);
        TreePattern defaultPattern = TreePatternUtils.union((Iterable<TreePattern>)dataSources2.transform(ds -> SqlImportUtil.createDefaultScopePattern(ds, language)));
        resolvePattern = TreePatternUtils.union(resolvePattern, new TreePattern(SqlImportUtil.createDataSources(null, new TreePatternNode.Group[0])));
        TreePattern pattern = SqlImportUtil.processResolveScopePattern(resolvePattern, defaultPattern);
        pattern = (TreePattern)dataSources2.reduce((Object)pattern, (p2, ds) -> language.applyImplicitImports(SqlImportUtil.getRealDsNames(ds), (TreePattern)p2));
        TreePattern treePattern2 = TreePatternUtils.union(pattern, SqlImportUtil.createDefaultScopePattern(null, language));
        if (treePattern2 == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(18);
        }
        return treePattern2;
    }

    @NotNull
    private static JBIterable<DbDataSource> getFilteredDataSources(@NotNull SqlFile sqlFile, @Nullable TreePattern filter2) {
        boolean all;
        if (sqlFile == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(19);
        }
        TreePatternNode.Group group = filter2 == null ? null : filter2.root.getGroup(SqlImportUtil.DATA_SOURCE);
        boolean bl = all = filter2 == null || TreePatternUtils.isWildcard(group);
        if (!all && group == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(20);
            }
            return jBIterable;
        }
        JBIterable res2 = JBIterable.from(SqlImplUtil.getDataSources((PsiElement)sqlFile));
        if (!all) {
            res2 = res2.filter(ds -> {
                SqlDataSource sql = (SqlDataSource)ObjectUtils.tryCast((Object)ds.getDelegate(), SqlDataSource.class);
                return sql != null && sql.containsFile(sqlFile.getVirtualFile()) || group.matchedChildren(SqlImportUtil.getDataSourceName((DasDataSource)ds), Casing.EXACT, null);
            });
        }
        JBIterable jBIterable = res2;
        if (jBIterable == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @NotNull
    public static TreePattern getDefaultInitialPattern(@NotNull SqlFile sqlFile) {
        if (sqlFile == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(22);
        }
        return SqlDialectImplUtil.getDefaultInitialPattern(sqlFile, SqlImportUtil.getResolveScopePattern(sqlFile));
    }

    @NotNull
    private static TreePattern getDefaultInitialPattern(@NotNull SqlFile sqlFile, @Nullable TreePattern filter2) {
        if (sqlFile == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(23);
        }
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        JBIterable<DbDataSource> dataSources2 = SqlDialectImplUtil.getFilteredDataSources(sqlFile, filter2);
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)dataSources2.transform(ds -> SqlImportUtil.createDefaultScopePattern(ds, language)).append((Object)SqlImportUtil.createDefaultScopePattern(null, language)));
        if (treePattern == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(24);
        }
        return treePattern;
    }

    public static Set<String> loadSystemVars(SqlLanguageDialect dialect) {
        return SqlDialectImplUtil.loadTokens(dialect, "systemVars.txt");
    }

    public static <T> JBIterable<T> staticFields(@NotNull Class<?> clazz, @NotNull Class<T> fieldC) {
        if (clazz == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(25);
        }
        if (fieldC == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(26);
        }
        return JBIterable.of((Object[])clazz.getFields()).filter(field -> Modifier.isStatic(field.getModifiers()) && fieldC.isAssignableFrom(field.getType())).transform(field -> {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }).filter(Conditions.notNull()).filter(fieldC);
    }

    public static List<ReservedEntity.Typed> loadEntities(SqlLanguageDialectEx dialect) {
        ArrayList<ReservedEntity.Typed> result = new ArrayList<ReservedEntity.Typed>();
        String invalid = null;
        THashMap kindMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (ObjectKind kind : SqlDialectImplUtil.staticFields(SqlDbElementType.class, ObjectKind.class)) {
            kindMap.put(kind.name(), kind);
        }
        THashMap typeMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            String tokens = SqlDialectImplUtil.loadDialectResource(((Object)((Object)dialect)).getClass(), "simpleEntities.txt");
            if (StringUtil.isNotEmpty((String)tokens)) {
                for (String typed : tokens.split("(?m)\\n")) {
                    String[] split = typed.split(":");
                    String name = split[0].trim();
                    ObjectKind objectType = (ObjectKind)kindMap.get(split[1].trim());
                    String typeName = split.length < 3 ? null : split[2].trim();
                    SqlType type = null;
                    if (typeName != null) {
                        type = (SqlType)typeMap.get(typeName);
                        if (type == null) {
                            type = SqlTypeFactory.of(DataTypeFactory.of(typeName), dialect);
                            typeMap.put(typeName, type);
                        }
                        if (split.length != 3 || objectType == null) {
                            if (invalid != null) continue;
                            invalid = typed;
                            continue;
                        }
                    }
                    result.add(new ReservedEntity.Typed(dialect.getDbms(), name, objectType, type));
                }
            }
            if (invalid != null) {
                LOG.error("Invalid entity: `" + invalid + "`");
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public static List<ReservedEntity> loadObjects(SqlLanguageDialect dialect, String fileName) {
        ArrayList<ReservedEntity> arrayList;
        InputStream stream = SqlDialectImplUtil.openDialectResource(dialect.getClass(), fileName);
        if (stream == null) {
            return Collections.emptyList();
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            ArrayList<ReservedEntity> res2 = new ArrayList<ReservedEntity>();
            String cur2 = r.readLine();
            while (cur2 != null) {
                if (StringUtil.isEmptyOrSpaces((String)cur2)) {
                    cur2 = r.readLine();
                    continue;
                }
                ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(cur2 = StringUtil.trimEnd((String)cur2, (String)":"));
                if (kind == null) {
                    kind = SqlDbElementType.ourSqlKinds.get(cur2);
                }
                if (kind == null) {
                    LOG.error("Unknown kind: " + cur2);
                }
                while ((cur2 = r.readLine()) != null && cur2.startsWith(" - ")) {
                    if (kind == null) continue;
                    cur2 = StringUtil.trimStart((String)cur2, (String)" - ");
                    res2.add(new ReservedEntity(dialect.getDbms(), cur2, kind));
                }
            }
            arrayList = res2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return Collections.emptyList();
            }
        }
        r.close();
        return arrayList;
    }

    public static Set<String> loadTokens(SqlLanguageDialect dialect, String fileName) {
        THashSet result = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            String tokens = SqlDialectImplUtil.loadDialectResource(dialect.getClass(), fileName);
            if (StringUtil.isNotEmpty((String)tokens)) {
                Collections.addAll(result, tokens.split("(?m)\\s+"));
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public static String loadDialectResource(Class<?> dialectClass, String name) throws IOException {
        InputStream xmlIs = SqlDialectImplUtil.openDialectResource(dialectClass, name);
        return xmlIs == null ? "" : FileUtil.loadTextAndClose((Reader)new InputStreamReader(xmlIs, StandardCharsets.UTF_8));
    }

    @Nullable
    public static InputStream openDialectResource(Class<?> dialectClass, String name) {
        String dialectName = dialectClass.getName();
        String packageName = dialectName.substring(0, dialectName.lastIndexOf(46) + 1).replace('.', '/');
        String xmlResource = packageName + name;
        return dialectClass.getClassLoader().getResourceAsStream(xmlResource);
    }

    public static TreePattern refPatternExpandedToSchema(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref, final @NotNull SqlLanguageDialectEx dialect) {
        if (prev == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(27);
        }
        if (ref == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(28);
        }
        if (dialect == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(29);
        }
        ObjectName refName = new ObjectName(ref.getName(), ref.isQuotedIdentifier());
        final SearchPath refPath = SearchPath.of((ObjectPath)ObjectPath.create((String)refName.name, (ObjectKind)ObjectKind.DATABASE, (boolean)refName.quoted, null, null));
        TreePatternNode.Group dsGroup = prev.root.getGroup(SqlImportUtil.DATA_SOURCE);
        if (dsGroup == null) {
            return dialect.forcedContextPattern(null, refPath);
        }
        NotNullLazyValue<TreePatternNode.Group[]> anyGroups = new NotNullLazyValue<TreePatternNode.Group[]>(){

            @NotNull
            protected TreePatternNode.Group[] compute() {
                TreePatternNode.Group d2 = dialect.forcedContextPattern(null, (SearchPath)refPath).root.getGroup(SqlImportUtil.DATA_SOURCE);
                TreePatternNode<TreePatternNode.NegativeNaming> dc = d2 == null ? null : d2.negativeChild;
                TreePatternNode.Group[] groupArray = dc == null ? TreePatternNode.NO_GROUPS : dc.groups;
                if (groupArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return groupArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil$1", "compute"));
            }
        };
        TreePattern n = null;
        if (dsGroup.negativeChild != null) {
            TreePatternNode.Group[] any = (TreePatternNode.Group[])anyGroups.getValue();
            n = any.length == 0 ? null : new TreePattern(new TreePatternNode.Group(SqlImportUtil.DATA_SOURCE, null, new TreePatternNode<TreePatternNode.NegativeNaming>((TreePatternNode.NegativeNaming)dsGroup.negativeChild.naming, any)));
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)ref.getProject());
        SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)ref.getContainingFile(), SqlFile.class);
        TreePattern scopePattern = file == null ? null : SqlImportUtil.getResolveScopePattern(file);
        ArrayList matched = new ArrayList();
        ArrayList matched2 = new ArrayList();
        Casing casing = dialect.getCasing(ObjectKind.DATABASE, null);
        return TreePatternUtils.union((Iterable<TreePattern>)JBIterable.of((Object[])dsGroup.positiveChildren).flatten(c2 -> JBIterable.of((Object[])((TreePatternNode.PositiveNaming)c2.naming).getNames())).filterMap(arg_0 -> SqlDialectImplUtil.lambda$refPatternExpandedToSchema$9(matched, scopePattern, matched2, refName, casing, facade, dialect, refPath, (NotNullLazyValue)anyGroups, arg_0)).append((Object)n).collect());
    }

    @NotNull
    public static TreePattern forcedContextExpandedToSchemas(@Nullable DbDataSource dataSource2, @NotNull Dbms dbms, @Nullable SearchPath searchPath, TreePatternNode.Group[] schemas, TreePatternNode.Group[] databases) {
        if (dbms == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(30);
        }
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource2);
        Function expandPath = n -> {
            TreePatternNode.Group[] tail = null;
            if (n == null || n.kind == ObjectKind.NONE) {
                tail = databases;
            } else if (n.kind == ObjectKind.DATABASE) {
                ObjectName[] currentSchemas = SqlDialectImplUtil.getCurrentSchemasFor(dataSource2, n);
                tail = currentSchemas == null ? schemas : SqlImportUtil.optAr(TreePatternUtils.create(currentSchemas, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            }
            return SqlDialectImplUtil.createObjectPattern(dsNames, dbms, n, tail);
        };
        List elements = SearchPath.getElements((SearchPath)searchPath);
        if (elements.isEmpty()) {
            TreePattern treePattern = dsNames == null ? TreePattern.EMPTY : (TreePattern)expandPath.fun(null);
            if (treePattern == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(31);
            }
            return treePattern;
        }
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from((Iterable)elements).transform(expandPath));
        if (treePattern == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(32);
        }
        return treePattern;
    }

    @Nullable
    private static ObjectName[] getCurrentSchemasFor(@Nullable DbDataSource dataSource2, @NotNull ObjectPath db) {
        if (db == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(33);
        }
        if (dataSource2 == null) {
            return null;
        }
        List names = DbSqlUtil.findObjects(dataSource2, db).filter(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).flatten(o -> o.getDasChildren(ObjectKind.SCHEMA).filter(BasicMateNamespace.class).filter(n -> n.isCurrent())).map(o -> new ObjectName(o.getName(), DbSqlUtil.isQuoted(o))).toList();
        return names.isEmpty() ? null : ObjectName.toArray((Iterable)names);
    }

    public static boolean isLabelOrRoutineQualification(@Nullable PsiElement element2, ObjectKind type, @Nullable PsiElement place, boolean isCompletion) {
        if (type == SqlDbElementType.LABEL || type == ObjectKind.ROUTINE) {
            if (place == null) {
                return false;
            }
            SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
            if (element2 != null) {
                PsiElement sc;
                PsiElement psiElement = sc = type == SqlDbElementType.LABEL ? element2.getParent() : element2;
                if (!SqlDialectImplUtil.isAncestorOrOriginalAncestor(sc, place)) {
                    ref = null;
                }
            }
            if (ref != null && (isCompletion || ref.getQualifierExpression() == null && ref.getParent() instanceof SqlReferenceExpression)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAncestorOrOriginalAncestor(@NotNull PsiElement ancestor, @NotNull PsiElement place) {
        if (ancestor == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(34);
        }
        if (place == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(35);
        }
        PsiFile placeFile = place.getContainingFile();
        PsiFile ancestorFile = ancestor.getContainingFile();
        if (ancestorFile == placeFile) {
            return PsiTreeUtil.isContextAncestor((PsiElement)ancestor, (PsiElement)place, (boolean)true);
        }
        if (placeFile != null && ancestorFile == placeFile.getOriginalFile()) {
            return ancestor.getTextRange().contains(place.getTextRange().getStartOffset());
        }
        return false;
    }

    public static SqlImplUtil.Column col(@NotNull PsiElement element2, @Nullable PsiElement object, @NotNull String name, @NotNull SqlType type) {
        if (element2 == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(36);
        }
        if (name == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(37);
        }
        if (type == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(38);
        }
        return SqlDialectImplUtil.col(element2, object, name, type, true);
    }

    public static SqlImplUtil.Column col(final @NotNull PsiElement element2, final @Nullable PsiElement object, @NotNull String name, @NotNull SqlType type, final boolean isQuoted) {
        if (element2 == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(39);
        }
        if (name == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(40);
        }
        if (type == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(41);
        }
        return new SqlImplUtil.Column(name, type, (PsiElement)new SqlFileImpl.FakeDefinition(element2, name){

            @Override
            @NotNull
            public Dbms getDbms() {
                Dbms dbms = SqlImplUtil.getSqlDialectDbms(element2);
                if (dbms == null) {
                    2.$$$reportNull$$$0(0);
                }
                return dbms;
            }

            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    2.$$$reportNull$$$0(1);
                }
                return objectKind;
            }

            @Override
            @Nullable
            public DasObject getDasParent() {
                return (DasObject)ObjectUtils.chooseNotNull((Object)((DasObject)ObjectUtils.tryCast((Object)object, DasObject.class)), (Object)((DasObject)ObjectUtils.tryCast((Object)element2, DasObject.class)));
            }

            public boolean isNameQuoted() {
                return isQuoted;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/dialects/SqlDialectImplUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDbms";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }, null);
    }

    @Nullable
    public static ObjectTracer<DasObject> trace(@Nullable DasObject element2) {
        return element2 == null || element2.getKind() == ObjectKind.NONE || element2.getKind() == ObjectKind.ROOT ? null : new DasObjectTracer(element2);
    }

    private static /* synthetic */ TreePattern lambda$refPatternExpandedToSchema$9(List matched, TreePattern scopePattern, List matched2, ObjectName refName, Casing casing, DbPsiFacade facade, SqlLanguageDialectEx dialect, SearchPath refPath, NotNullLazyValue anyGroups, ObjectName dsName) {
        matched.clear();
        if (scopePattern != null) {
            scopePattern.root.matchedChildren(dsName, Casing.EXACT, SqlImportUtil.DATA_SOURCE, matched);
        }
        matched2.clear();
        for (TreePatternNode node : matched) {
            node.matchedChildren(refName, casing, ObjectKind.DATABASE, matched2);
        }
        if (!matched2.isEmpty()) {
            TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(refName);
            return new TreePattern(TreePatternUtils.create(dsName, SqlImportUtil.DATA_SOURCE, TreePatternUtils.create(refName, ObjectKind.DATABASE, TreePatternUtils.UNION_PROCESSOR.mergeNodes(naming, ObjectKind.DATABASE, matched2))));
        }
        DbDataSource ds = facade.findDataSource(dsName.name);
        if (ds != null) {
            return dialect.forcedContextPattern(ds, refPath);
        }
        if (dsName != SqlImportUtil.NON_MATCHING_NAME) {
            return null;
        }
        TreePatternNode.Group[] any = (TreePatternNode.Group[])anyGroups.getValue();
        return any.length == 0 ? null : new TreePattern(TreePatternUtils.create(dsName, SqlImportUtil.DATA_SOURCE, any));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlDialectImplUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
            case 3: 
            case 12: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 7: 
            case 14: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldC";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "db";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectHelpResource";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlDialectImplUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEntities";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNearestImportState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildImports";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calcImports";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInitialImportState";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredDataSources";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultInitialPattern";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextExpandedToSchemas";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialectName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildEntities";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkImports";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImportCheckerAt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createObjectPattern";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calcInitialImportState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredDataSources";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultInitialPattern";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "staticFields";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "refPatternExpandedToSchema";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "forcedContextExpandedToSchemas";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentSchemasFor";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isAncestorOrOriginalAncestor";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "col";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DasObjectTracer
    extends ObjectTracer<DasObject> {
        private final DasObject myElement;

        DasObjectTracer(@NotNull DasObject element2) {
            if (element2 == null) {
                DasObjectTracer.$$$reportNull$$$0(0);
            }
            this.myElement = element2;
        }

        @Override
        public ObjectTracer.ObjectTraceIt<DasObject> trace() {
            return new ObjectTracer.ObjectTraceIt<DasObject>(DasUtil.dasParents((DasObject)this.myElement).filter(o -> o.getKind() != ObjectKind.ROOT).iterator()){
                private DasObject myCurrent;

                @Override
                public DasObject next() {
                    this.myCurrent = (DasObject)super.next();
                    return this.myCurrent;
                }

                @Override
                public ObjectKind getKind() {
                    return this.myCurrent.getKind();
                }

                @Override
                public String getName() {
                    return this.myCurrent.getName();
                }

                @Override
                public boolean isQuoted() {
                    return DbSqlUtil.isQuoted(this.myCurrent);
                }
            };
        }

        @Override
        public ObjectKind getKind() {
            return this.myElement.getKind();
        }

        @Override
        public String getName() {
            return this.myElement.getName();
        }

        @Override
        @Nullable
        public ObjectTracer<DasObject> getParent(int steps) {
            if (steps == 0) {
                return this;
            }
            DasObject parent2 = this.myElement;
            for (int i2 = 0; i2 < steps && parent2 != null; parent2 = parent2.getDasParent(), ++i2) {
            }
            return parent2 == null ? null : SqlDialectImplUtil.trace(parent2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/SqlDialectImplUtil$DasObjectTracer", "<init>"));
        }
    }

    public static abstract class ObjectTracer<T> {
        public abstract ObjectTraceIt<T> trace();

        public abstract ObjectKind getKind();

        public abstract String getName();

        @Nullable
        public abstract ObjectTracer<T> getParent(int var1);

        public static abstract class ObjectTraceIt<T>
        implements Iterator<T> {
            private final JBIterator<? extends T> myIt;

            public ObjectTraceIt(Iterator<? extends T> it2) {
                this.myIt = JBIterator.from(it2);
            }

            @Override
            public boolean hasNext() {
                return this.myIt.hasNext();
            }

            @Override
            public T next() {
                return (T)this.myIt.next();
            }

            @Override
            public void remove() {
                this.myIt.remove();
            }

            public abstract ObjectKind getKind();

            public abstract String getName();

            public abstract boolean isQuoted();
        }
    }
}

