/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlDataSourceMappings {
    private final Project myProject;

    public static SqlDataSourceMappings getInstance(Project project) {
        return (SqlDataSourceMappings)ServiceManager.getService((Project)project, SqlDataSourceMappings.class);
    }

    public SqlDataSourceMappings(@NotNull Project project) {
        if (project == null) {
            SqlDataSourceMappings.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public List<DbDataSource> getDataSources(@NotNull PsiFile file) {
        if (file == null) {
            SqlDataSourceMappings.$$$reportNull$$$0(1);
        }
        PsiFile sqlFile = file.getOriginalFile();
        DbDataSource element2 = DbImplUtil.getForcedDataSource(sqlFile);
        List<DbDataSource> dataSources2 = this.getDataSourcesForResolve(sqlFile);
        if (element2 != null) {
            VirtualFile vFile = SqlImplUtil.getTopLevelSqlFile(sqlFile).getVirtualFile();
            return JBIterable.from(dataSources2).filter(ds -> {
                SqlDataSource sqlDataSource = (SqlDataSource)ObjectUtils.tryCast((Object)ds.getDelegate(), SqlDataSource.class);
                return sqlDataSource != null && sqlDataSource.containsFile(vFile);
            }).append(element2.isValid() ? element2 : null).toList();
        }
        return dataSources2;
    }

    private List<DbDataSource> getDataSourcesForResolve(PsiFile sqlFile) {
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)this.myProject);
        return (List)CachedValuesManager.getCachedValue((PsiElement)sqlFile, () -> {
            List result = DbSqlUtil.getDataSourcesForResolve(sqlFile).toList();
            return new CachedValueProvider.Result((Object)result, new Object[]{dbPsiFacade});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/SqlDataSourceMappings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

