/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.database.SqlDataSourceUpdateQueue;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="SqlDataSourceStorage", storages={@Storage(value="sqlDataSources.xml")})
public final class SqlDataSourceStorage
implements PersistentStateComponent<State> {
    private final Project myProject;
    final SqlDataSourceUpdateQueue myQueue;
    private final List<SqlDataSourceImpl> myDataSources;

    public static SqlDataSourceStorage getInstance(@NotNull Project project) {
        if (project == null) {
            SqlDataSourceStorage.$$$reportNull$$$0(0);
        }
        return (SqlDataSourceStorage)project.getService(SqlDataSourceStorage.class);
    }

    public SqlDataSourceStorage(@NotNull Project project) {
        if (project == null) {
            SqlDataSourceStorage.$$$reportNull$$$0(1);
        }
        this.myDataSources = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        DataSourceStorage.getProjectStorage(project);
        this.myQueue = new SqlDataSourceUpdateQueue(project);
    }

    public State getState() {
        State state = new State();
        for (SqlDataSourceImpl dataSource2 : this.myDataSources) {
            state.dataSources.add(dataSource2.getState());
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            SqlDataSourceStorage.$$$reportNull$$$0(2);
        }
        this.myDataSources.clear();
        for (SqlDataSourceImpl.State dataSourceState : state.dataSources) {
            SqlDataSourceImpl dataSource2 = new SqlDataSourceImpl(DasUtil.NO_NAME, this.myProject, null);
            dataSource2.loadState(dataSourceState);
            this.addDataSource(dataSource2);
        }
    }

    public List<SqlDataSourceImpl> getDataSources() {
        return new ArrayList<SqlDataSourceImpl>(this.myDataSources);
    }

    public void removeDataSource(SqlDataSourceImpl dataSource2) {
        this.myDataSources.remove((Object)dataSource2);
        dataSource2.onRemovedFromStorage();
    }

    public void addDataSource(SqlDataSourceImpl dataSource2) {
        dataSource2.onAddedToStorage();
        this.myDataSources.add(dataSource2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/database/SqlDataSourceStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class State {
        public List<SqlDataSourceImpl.State> dataSources = new ArrayList<SqlDataSourceImpl.State>();
    }
}

