/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.options;

import com.intellij.DynamicBundle;
import com.intellij.database.model.NameBasedRelationProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.completion.options.FkRuleCheckerDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;

public class SqlCodeCompletionOptionPanel
implements Disposable {
    private JPanel myPanel;
    private JBCheckBox myUseAliasesInCompletionJBCheckBox;
    private JBCheckBox myAutoAliasTableJBCheckBox;
    private final JBTable myCustomAliasesJBTable;
    private final JBTable myForeignKeysJBTable;
    private JBCheckBox myInvertOrderOfOperandsInJoinOnJBCheckBox;
    private JBCheckBox mySupportNonStrictForeignKeysJBCheckBox;
    private JBCheckBox mySuggestTableAliasNamesJBCheckBox;
    private JPanel myAliasesTablePanel;
    private JPanel myForeignKeysTablePanel;

    public SqlCodeCompletionOptionPanel() {
        this.$$$setupUI$$$();
        this.myCustomAliasesJBTable = new JBTable(){

            @NotNull
            public StatusText getEmptyText() {
                StatusText emptyText = new StatusText(){

                    protected boolean isStatusVisible() {
                        return this.isEmpty();
                    }
                };
                emptyText.setText(SqlBundle.message("settings.no.custom.aliases", new Object[0]));
                emptyText.appendSecondaryText(SqlBundle.message("settings.add.alias", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, ev -> SqlCodeCompletionOptionPanel.this.addAlias());
                StatusText statusText = emptyText;
                if (statusText == null) {
                    1.$$$reportNull$$$0(0);
                }
                return statusText;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/options/SqlCodeCompletionOptionPanel$1", "getEmptyText"));
            }
        };
        SqlCodeCompletionOptionPanel.initTable(this.myCustomAliasesJBTable);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myCustomAliasesJBTable);
        decorator.setAddAction(e -> this.addAlias()).setAddActionName(SqlBundle.message("settings.add.alias", new Object[0]));
        decorator.setRemoveAction(e -> SqlCodeCompletionOptionPanel.doRemoveRows(this.myCustomAliasesJBTable, SqlAliasesTableModel::removeRow)).setRemoveActionName(SqlBundle.message("settings.remove.alias", new Object[0])).setRemoveActionUpdater(e -> !SqlCodeCompletionOptionPanel.isEditing(this.myCustomAliasesJBTable));
        this.myAliasesTablePanel.add((Component)decorator.createPanel(), "Center");
        this.myForeignKeysJBTable = new JBTable(){

            @NotNull
            public StatusText getEmptyText() {
                StatusText emptyText = new StatusText(){

                    protected boolean isStatusVisible() {
                        return this.isEmpty();
                    }
                };
                emptyText.setText(SqlBundle.message("settings.no.column.reference.rules", new Object[0]));
                emptyText.appendSecondaryText(SqlBundle.message("settings.add.rule", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, ev -> SqlCodeCompletionOptionPanel.this.addRule());
                StatusText statusText = emptyText;
                if (statusText == null) {
                    2.$$$reportNull$$$0(0);
                }
                return statusText;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/options/SqlCodeCompletionOptionPanel$2", "getEmptyText"));
            }
        };
        DefaultTableModel model = (DefaultTableModel)this.myForeignKeysJBTable.getModel();
        model.addColumn(SqlBundle.message("settings.column.pattern", new Object[0]));
        model.addColumn(SqlBundle.message("settings.target.column.pattern", new Object[0]));
        final Project project = DbImplUtil.getAnyProject();
        EditorTextFieldCellRenderer renderer = new EditorTextFieldCellRenderer(project, (Language)RegExpLanguage.INSTANCE, this){

            protected String getText(JTable table, Object value2, int row, int column2) {
                return value2 == null ? "" : value2.toString();
            }
        };
        AbstractTableCellEditor editor = new AbstractTableCellEditor(){
            final EditorTextField field;
            {
                this.field = new EditorTextField(project, (FileType)RegExpFileType.INSTANCE);
            }

            public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column2) {
                this.field.setText(value2 == null ? "" : value2.toString());
                return this.field;
            }

            public Object getCellEditorValue() {
                return StringUtil.nullize((String)this.field.getText());
            }
        };
        this.myForeignKeysJBTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)renderer);
        this.myForeignKeysJBTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)editor);
        SqlCodeCompletionOptionPanel.initTable(this.myForeignKeysJBTable);
        ToolbarDecorator decorator2 = ToolbarDecorator.createDecorator((JTable)this.myForeignKeysJBTable);
        decorator2.setAddAction(e -> this.addRule()).setAddActionName(SqlBundle.message("settings.add.rule", new Object[0]));
        decorator2.setRemoveAction(e -> SqlCodeCompletionOptionPanel.doRemoveRows(this.myForeignKeysJBTable, DefaultTableModel::removeRow)).setRemoveActionName(SqlBundle.message("settings.remove.rule", new Object[0])).setRemoveActionUpdater(e -> !SqlCodeCompletionOptionPanel.isEditing(this.myForeignKeysJBTable));
        decorator2.addExtraAction((AnActionButton)new DumbAwareActionButton(SqlBundle.messagePointer("settings.check", new Object[0]), SqlBundle.messagePointer("settings.test.rule", new Object[0]), AllIcons.RunConfigurations.TestState.Run){

            public void actionPerformed(@NotNull AnActionEvent e) {
                int row;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((row = SqlCodeCompletionOptionPanel.this.myForeignKeysJBTable.getSelectedRow()) == -1) {
                    return;
                }
                SqlCodeCompletionOptionPanel.this.checkRule(row);
            }

            public void updateButton(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                super.updateButton(e);
                e.getPresentation().setEnabled(SqlCodeCompletionOptionPanel.this.myForeignKeysJBTable.getSelectedRow() != -1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/sql/completion/options/SqlCodeCompletionOptionPanel$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateButton";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myForeignKeysTablePanel.add((Component)decorator2.createPanel(), "Center");
    }

    private void checkRule(int row) {
        TableModel m = this.myForeignKeysJBTable.getModel();
        NameBasedRelationProvider.Rule rule = new NameBasedRelationProvider.Rule(StringUtil.notNullize((String)((String)m.getValueAt(row, 0))), StringUtil.notNullize((String)((String)m.getValueAt(row, 1))));
        FkRuleCheckerDialog dialog2 = new FkRuleCheckerDialog(rule);
        if (dialog2.showAndGet()) {
            NameBasedRelationProvider.Rule newRule = dialog2.getCurrentRule();
            m.setValueAt(newRule.match, row, 0);
            m.setValueAt(newRule.replace, row, 1);
        }
    }

    public void dispose() {
    }

    private static void initTable(JBTable table) {
        table.setShowGrid(false);
        table.registerKeyboardAction(e -> {
            int row = table.getSelectedRow();
            int column2 = table.getSelectedColumn();
            if (row >= 0 && column2 >= 0) {
                table.editCellAt(row, column2);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
    }

    private static boolean isEditing(JBTable table) {
        return table.getEditingRow() != -1;
    }

    private void addAlias() {
        SqlCodeCompletionOptionPanel.doAddRow(SqlAliasesTableModel::addRow, this.myCustomAliasesJBTable);
    }

    private void addRule() {
        SqlCodeCompletionOptionPanel.doAddRow(m -> m.addRow((Object[])null), this.myForeignKeysJBTable);
    }

    public void setFkRules(Set<NameBasedRelationProvider.Rule> rules) {
        DefaultTableModel model = (DefaultTableModel)this.myForeignKeysJBTable.getModel();
        model.setNumRows(rules.size());
        int i2 = 0;
        for (NameBasedRelationProvider.Rule rule : rules) {
            model.setValueAt(rule.match, i2, 0);
            model.setValueAt(rule.replace, i2, 1);
            ++i2;
        }
    }

    public Set<NameBasedRelationProvider.Rule> getFkRules() {
        Vector<Vector> dataVector = ((DefaultTableModel)this.myForeignKeysJBTable.getModel()).getDataVector();
        return (Set)JBIterable.from(dataVector).map(r -> new NameBasedRelationProvider.Rule(StringUtil.notNullize((String)((String)r.get(0))), StringUtil.notNullize((String)((String)r.get(1))))).filter(r -> !r.match.isEmpty() || r.replace.isEmpty()).addAllTo(new TreeSet());
    }

    public void setCustomMappings(Map<String, String> customMappings) {
        this.myCustomAliasesJBTable.setModel((TableModel)new SqlAliasesTableModel(customMappings));
    }

    public Map<String, String> getCustomMappings() {
        return ((SqlAliasesTableModel)this.myCustomAliasesJBTable.getModel()).getMappings();
    }

    private static <M extends TableModel> void doAddRow(Consumer<M> addRow, JBTable table) {
        int count2 = table.getRowCount();
        addRow.consume((Object)table.getModel());
        table.revalidate();
        table.repaint();
        table.getSelectionModel().setSelectionInterval(count2, count2);
        table.scrollRectToVisible(table.getCellRect(count2, 0, true));
        table.editCellAt(count2, 0);
    }

    private static <M extends TableModel> void doRemoveRows(JBTable table, PairConsumer<M, Integer> removeRow) {
        if (SqlCodeCompletionOptionPanel.isEditing(table)) {
            return;
        }
        int[] rows = table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        for (int row : rows) {
            removeRow.consume((Object)table.getModel(), (Object)row);
        }
        table.revalidate();
        table.repaint();
        int min = ArrayUtil.min((int[])rows);
        if (min < 1) {
            ++min;
        }
        table.getSelectionModel().setSelectionInterval(min - 1, min - 1);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public JBCheckBox getUseAliasesInCompletionJBCheckBox() {
        return this.myUseAliasesInCompletionJBCheckBox;
    }

    public JBCheckBox getAutoAliasTableJBCheckBox() {
        return this.myAutoAliasTableJBCheckBox;
    }

    public JBCheckBox getInvertOrderOfOperandsInJoinOnJBCheckBox() {
        return this.myInvertOrderOfOperandsInJoinOnJBCheckBox;
    }

    public JBCheckBox getSupportNonStrictForeignKeysJBCheckBox() {
        return this.mySupportNonStrictForeignKeysJBCheckBox;
    }

    public JBCheckBox getSuggestTableAliasNamesJBCheckBox() {
        return this.mySuggestTableAliasNamesJBCheckBox;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JPanel jPanel2;
        JBCheckBox jBCheckBox5;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setMaximumSize(new Dimension(-1, -1));
        jPanel3.setPreferredSize(new Dimension(-1, -1));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.putClientProperty("html.disable", Boolean.FALSE);
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/SqlBundle", SqlCodeCompletionOptionPanel.class).getString("settings.sql.title"), (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(9, 0, 1, 2, 2, 1, 1, 7, null, null, null));
        this.myUseAliasesInCompletionJBCheckBox = jBCheckBox5 = new JBCheckBox();
        jBCheckBox5.setSelected(false);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/SqlBundle", SqlCodeCompletionOptionPanel.class).getString("settings.use.aliases.in.completion.for.join"));
        jPanel3.add((Component)jBCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myAliasesTablePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(9, 0, 1, 2, 0, 3, 3, 7, new Dimension(-1, 150), new Dimension(400, 150), null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/SqlBundle", SqlCodeCompletionOptionPanel.class).getString("settings.custom.aliases"));
        jPanel3.add((Component)jBLabel, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInvertOrderOfOperandsInJoinOnJBCheckBox = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/SqlBundle", SqlCodeCompletionOptionPanel.class).getString("settings.invert.order.of.operands.in.auto.generated.on.clause"));
        jPanel3.add((Component)jBCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySupportNonStrictForeignKeysJBCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/SqlBundle", SqlCodeCompletionOptionPanel.class).getString("settings.suggest.non.strict.foreign.keys.based.on.the.name.matching"));
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySuggestTableAliasNamesJBCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setActionCommand(ResourceBundle.getBundle("messages/SqlBundle").getString("suggest.alias.names.in.completion.after.table.names"));
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/SqlBundle", SqlCodeCompletionOptionPanel.class).getString("settings.suggest.alias.names.in.completion.after.table.names"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoAliasTableJBCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(false);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/SqlBundle", SqlCodeCompletionOptionPanel.class).getString("settings.automatically.add.aliases.when.completing.table.names"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/SqlBundle", SqlCodeCompletionOptionPanel.class).getString("settings.join.clauses"));
        jPanel3.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText(DynamicBundle.getBundle((String)"messages/SqlBundle", SqlCodeCompletionOptionPanel.class).getString("settings.table.aliases"));
        jPanel3.add((Component)titledSeparator2, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForeignKeysTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 7, new Dimension(-1, 150), new Dimension(400, 150), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class SqlAliasesTableModel
    extends AbstractTableModel {
        private final Map<String, String> myMappings;
        private final List<String> myKeys;

        Map<String, String> getMappings() {
            if (!this.myMappings.containsKey("")) {
                return this.myMappings;
            }
            HashMap<String, String> copy = new HashMap<String, String>(this.myMappings);
            copy.remove("");
            return copy;
        }

        SqlAliasesTableModel(Map<String, String> mappings) {
            this.myMappings = mappings;
            this.myKeys = new ArrayList<String>(this.myMappings.keySet());
        }

        @Override
        public int getRowCount() {
            return this.myKeys.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String key = this.myKeys.get(rowIndex);
            return columnIndex == 0 ? key : this.myMappings.get(key);
        }

        public void addRow() {
            this.myKeys.add("");
            this.myMappings.put("", "");
        }

        public void removeRow(int rowIndex) {
            this.myMappings.remove(this.myKeys.remove(rowIndex));
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            String valueToSet = (String)aValue;
            String key = this.myKeys.get(rowIndex);
            if (columnIndex == 1) {
                if (StringUtil.isEmptyOrSpaces((String)key) && StringUtil.isEmptyOrSpaces((String)valueToSet)) {
                    this.myMappings.remove(key);
                    this.myKeys.remove(key);
                } else {
                    this.myMappings.replace(key, valueToSet);
                }
                return;
            }
            String value2 = this.myMappings.get(key);
            this.myMappings.remove(key);
            if (!StringUtil.isEmptyOrSpaces((String)value2) || !StringUtil.isEmptyOrSpaces((String)valueToSet)) {
                this.myKeys.set(rowIndex, valueToSet);
                this.myMappings.put(valueToSet, value2);
            } else {
                this.myKeys.remove(rowIndex);
            }
        }

        @Override
        public String getColumnName(int column2) {
            return column2 == 0 ? SqlBundle.message("settings.column.name", new Object[0]) : SqlBundle.message("settings.column.alias", new Object[0]);
        }
    }
}

