/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlValuesParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<SqlExpressionList, SqlFunctionsUtil.ExpressionList, SqlExpression> {
    private static final Set<Class<?>> ourStopSearch = ContainerUtil.newHashSet((Object[])new Class[]{SqlStatement.class});
    private static final Set<Class<?>> ourAllowedParents = ContainerUtil.newHashSet((Object[])new Class[]{SqlParenthesizedExpression.class, SqlValuesExpression.class});

    public SqlExpressionList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        SqlExpressionList result;
        Object[] res2;
        if (context == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((res2 = SqlValuesParameterInfoHandler.getLists(result = SqlValuesParameterInfoHandler.findExpressions((ParameterInfoContext)context))) != null) {
            context.setItemsToShow(res2);
        }
        return result;
    }

    protected static SqlFunctionsUtil.ExpressionList @Nullable [] getLists(@Nullable SqlExpressionList result) {
        SqlDmlInstruction instruction2;
        if (result == null) {
            return null;
        }
        SqlValuesExpression values2 = (SqlValuesExpression)PsiTreeUtil.getParentOfType((PsiElement)result, SqlValuesExpression.class, (boolean)true);
        SqlDmlInstruction sqlDmlInstruction = instruction2 = values2 == null ? null : (SqlDmlInstruction)ObjectUtils.tryCast((Object)values2.getParent(), SqlDmlInstruction.class);
        if (instruction2 != null) {
            return SqlFunctionsUtil.getInsertVariants(instruction2, result);
        }
        SqlCreateStatement createStatement = (SqlCreateStatement)PsiTreeUtil.getParentOfType((PsiElement)result, SqlCreateStatement.class, (boolean)true);
        return createStatement != null ? SqlFunctionsUtil.getCreateTable(createStatement, result) : null;
    }

    public void showParameterInfo(@NotNull SqlExpressionList expression, @NotNull CreateParameterInfoContext context) {
        if (expression == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(2);
        }
        context.showHint((PsiElement)expression, expression.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public SqlExpressionList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return SqlValuesParameterInfoHandler.findExpressions((ParameterInfoContext)context);
    }

    public void updateParameterInfo(@NotNull SqlExpressionList element2, @NotNull UpdateParameterInfoContext context) {
        if (element2 == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(5);
        }
        int index2 = SqlValuesParameterInfoHandler.getCurrentParameterIndex(element2, context.getOffset());
        context.setCurrentParameter(index2);
    }

    public static int getCurrentParameterIndex(@NotNull SqlExpressionList element2, int offset) {
        if (element2 == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(6);
        }
        ASTNode node = element2.getNode();
        SyntaxTraverser s2 = (SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.astTraverser((ASTNode)node).expandAndSkip(Conditions.is((Object)node))).forceDisregard(Conditions.compose((Function)SyntaxTraverser.astApi().TO_TYPE, (Condition)Conditions.is((Object)SqlElementTypes.SQL_DUMMY_BLOCK)));
        return ParameterInfoUtils.getCurrentParameterIndex((SyntaxTraverser)s2, (int)offset, (IElementType)SqlTokens.SQL_COMMA);
    }

    public void updateUI(SqlFunctionsUtil.ExpressionList p2, @NotNull ParameterInfoUIContext context) {
        PsiElement element2;
        if (context == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(7);
        }
        if (!(element2 = context.getParameterOwner()).isValid() || !p2.isValid()) {
            context.setUIComponentEnabled(false);
            return;
        }
        StringBuilder sb = new StringBuilder();
        int[] highlight = new int[]{-1, -1};
        p2.buildText(sb, context.getCurrentParameterIndex(), highlight);
        if (sb.length() == 0) {
            sb.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        context.setupUIComponentPresentation(sb.toString(), highlight[0], highlight[1], false, false, false, context.getDefaultParameterColor());
    }

    public SqlExpression @NotNull [] getActualParameters(@NotNull SqlExpressionList o) {
        if (o == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(8);
        }
        List list = o.getExpressionList();
        SqlExpression[] sqlExpressionArray = list.toArray(new SqlExpression[0]);
        if (sqlExpressionArray == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(9);
        }
        return sqlExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        SqlTokenType sqlTokenType = SqlTokens.SQL_COMMA;
        if (sqlTokenType == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(10);
        }
        return sqlTokenType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        SqlTokenType sqlTokenType = SqlTokens.SQL_RIGHT_PAREN;
        if (sqlTokenType == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(11);
        }
        return sqlTokenType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        Set<Class<?>> set = ourAllowedParents;
        if (set == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        Set<Class<?>> set = ourStopSearch;
        if (set == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public Class<SqlExpressionList> getArgumentListClass() {
        return SqlExpressionList.class;
    }

    @Nullable
    private static SqlExpressionList findExpressions(ParameterInfoContext context) {
        PsiFile file = context.getFile();
        if (!(file instanceof SqlFile)) {
            return null;
        }
        int offset = context.getOffset();
        PsiElement at = file.findElementAt(offset);
        return SqlValuesParameterInfoHandler.findExpressions(at);
    }

    @Nullable
    public static SqlExpressionList findExpressions(@Nullable PsiElement at) {
        if (at == null || !at.isValid()) {
            return null;
        }
        if (!(at.getContainingFile() instanceof SqlFile)) {
            return null;
        }
        SqlValuesExpression valuesExpression = (SqlValuesExpression)PsiTreeUtil.getParentOfType((PsiElement)at, SqlValuesExpression.class);
        if (valuesExpression == null) {
            return null;
        }
        for (SqlExpression expression : valuesExpression.getExpressions()) {
            if (!expression.getTextRange().contains(at.getTextRange().getStartOffset())) continue;
            return expression instanceof SqlParenthesizedExpression ? (SqlParenthesizedExpression)expression : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlValuesParameterInfoHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlValuesParameterInfoHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentParameterIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

