/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.Case;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.options.SqlCodeCompletionSettings;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlNamesGenerator {
    private static final int MAX_WORDS_FROM_SELECT = 3;

    @NotNull
    public static String suggestAliasName(@NotNull PsiElement element2, @NotNull Collection<String> existingNames, @NotNull String words) {
        if (element2 == null) {
            SqlNamesGenerator.$$$reportNull$$$0(0);
        }
        if (existingNames == null) {
            SqlNamesGenerator.$$$reportNull$$$0(1);
        }
        if (words == null) {
            SqlNamesGenerator.$$$reportNull$$$0(2);
        }
        String string = SqlNamesGenerator.chooseBestName(SqlNamesGenerator.suggestAliasNames(element2, existingNames, words), existingNames);
        if (string == null) {
            SqlNamesGenerator.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String suggestAliasName(@NotNull String tableName, @NotNull PsiElement context) {
        if (tableName == null) {
            SqlNamesGenerator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SqlNamesGenerator.$$$reportNull$$$0(5);
        }
        Collection<String> names = SqlNamesGenerator.collectExistingNamesForContainingStatement(context);
        String string = SqlNamesGenerator.chooseBestName(SqlNamesGenerator.suggestAliasNames(context, names, tableName), names);
        if (string == null) {
            SqlNamesGenerator.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String suggestAliasName(@NotNull SqlExpression expression) {
        if (expression == null) {
            SqlNamesGenerator.$$$reportNull$$$0(7);
        }
        Collection<String> existingNames = SqlNamesGenerator.collectExistingNamesForContainingStatement((PsiElement)expression);
        String string = SqlNamesGenerator.chooseBestName(SqlNamesGenerator.suggestAliasNames((PsiElement)expression, existingNames, SqlNamesGenerator.getWords(expression)), existingNames);
        if (string == null) {
            SqlNamesGenerator.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static String chooseBestName(Collection<String> allNames, Collection<String> existingNames) {
        return allNames.stream().filter(n -> !n.isEmpty() && !Character.isDigit(n.charAt(n.length() - 1))).max(Comparator.comparingInt(String::length)).orElse(allNames.stream().max(Comparator.comparingInt(String::length)).orElse(SqlNamesGenerator.suggestAliasAlias(existingNames)));
    }

    @NotNull
    private static String suggestAliasAlias(Collection<String> existingNames) {
        Object name = "alias";
        int i2 = 1;
        while (existingNames.contains(name)) {
            name = (String)name + ++i2;
        }
        String string = name;
        if (string == null) {
            SqlNamesGenerator.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String suggestUniqueName(String base, Collection<String> existingNames) {
        Object name = base;
        int i2 = 1;
        while (existingNames.contains(name)) {
            name = base + i2;
            ++i2;
        }
        String string = name;
        if (string == null) {
            SqlNamesGenerator.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static Collection<String> suggestAliasNames(@NotNull SqlExpression expression) {
        if (expression == null) {
            SqlNamesGenerator.$$$reportNull$$$0(11);
        }
        return SqlNamesGenerator.suggestAliasNames((PsiElement)expression, SqlNamesGenerator.collectExistingNamesForContainingStatement((PsiElement)expression), SqlNamesGenerator.getWords(expression));
    }

    @NotNull
    public static Collection<String> suggestAliasNames(@NotNull PsiElement element2, @NotNull Collection<String> existingNames, @NotNull String words) {
        String customName;
        Map<String, String> customMappings;
        if (element2 == null) {
            SqlNamesGenerator.$$$reportNull$$$0(12);
        }
        if (existingNames == null) {
            SqlNamesGenerator.$$$reportNull$$$0(13);
        }
        if (words == null) {
            SqlNamesGenerator.$$$reportNull$$$0(14);
        }
        if ((customMappings = SqlCodeCompletionSettings.getInstance().getCustomMappings()).containsKey(words) && !StringUtil.isEmptyOrSpaces((String)(customName = customMappings.get(words)))) {
            List<String> list = Collections.singletonList(customName);
            if (list == null) {
                SqlNamesGenerator.$$$reportNull$$$0(15);
            }
            return list;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element2);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        NamesGenerator generator = new NamesGenerator(existingNames, SqlNamesGenerator.getKeywords(dialect));
        SqlNamesGenerator.appendSuggestions(result, words, generator);
        PsiFile containingFile = element2.getContainingFile();
        Case idCase = SqlNamesGenerator.getDefaultCase(SqlPsiMiscUtil.getAliasCase(containingFile));
        Case qidCase = SqlNamesGenerator.getDefaultCase(SqlPsiMiscUtil.getQuotedIdentifierCase(containingFile));
        SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(containingFile);
        boolean force = settings != null && settings.QUOTE_IDENTIFIER == 2;
        NamingService namingService = NamingServices.getNamingService(SqlImplUtil.getDbms(element2));
        List list = ContainerUtil.map(result, s2 -> SqlNamesGenerator.quoteAliasIdentifierIfNeeded(s2, namingService, idCase, qidCase, force, settings));
        if (list == null) {
            SqlNamesGenerator.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    private static Set<String> getKeywords(SqlLanguageDialectEx dialect) {
        THashSet result = new THashSet((Collection)dialect.getKeywords(), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        Set<String> definition = SqlDialectImplUtil.getAllKeywordsFromDefinition(dialect.getSupportedFunctions().forTokens(), (Set<String>)new THashSet());
        for (String s2 : definition) {
            result.remove(s2);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            SqlNamesGenerator.$$$reportNull$$$0(17);
        }
        return tHashSet;
    }

    @NotNull
    private static String getWords(@NotNull SqlExpression expression) {
        if (expression == null) {
            SqlNamesGenerator.$$$reportNull$$$0(18);
        }
        LinkedList<Object> stack = new LinkedList<Object>();
        StringBuilder sb = new StringBuilder();
        stack.push(expression);
        while (!stack.isEmpty()) {
            SqlExpression fromExpression;
            SqlExpression expr = (SqlExpression)stack.pop();
            if (expr instanceof SqlReferenceExpression) {
                String text2;
                SqlIdentifier identifier = ((SqlReferenceExpression)expr).getIdentifier();
                String string = text2 = identifier != null ? identifier.getName() : expr.getText();
                if (sb.length() > 0) {
                    sb.append("_");
                }
                sb.append(text2);
            }
            if (expr instanceof SqlAsExpression) {
                if (sb.length() > 0) {
                    sb.append("_");
                }
                sb.append(expr.getName());
                continue;
            }
            if (expr instanceof SqlParenthesizedExpression) {
                SqlExpression item = (SqlExpression)ContainerUtil.getFirstItem((List)((SqlParenthesizedExpression)expr).getExpressionList());
                if (item == null) continue;
                stack.push(item);
                continue;
            }
            if (expr instanceof SqlBinaryExpression) {
                SqlExpression l = ((SqlBinaryExpression)expr).getLOperand();
                SqlExpression r = ((SqlBinaryExpression)expr).getROperand();
                if (r != null) {
                    stack.push(r);
                }
                stack.push(l);
                continue;
            }
            if (expr instanceof SqlFunctionCallExpression) {
                SqlReferenceExpression nameElement = ((SqlFunctionCallExpression)expr).getNameElement();
                if (nameElement == null) continue;
                stack.push(nameElement);
                continue;
            }
            if (!(expr instanceof SqlQueryExpression)) continue;
            SqlQueryExpression query = (SqlQueryExpression)expr;
            SqlSelectClause selectClause = query.getSelectClause();
            SqlTableExpression tableExpression = query.getTableExpression();
            SqlFromClause fromClause = tableExpression == null ? null : tableExpression.getFromClause();
            ArrayList<SqlExpression> selectExpressions = new ArrayList<SqlExpression>(2);
            boolean includeSelectItems = true;
            if (selectClause != null) {
                List expressions2 = selectClause.getExpressions();
                ListIterator it2 = expressions2.listIterator(expressions2.size());
                while (it2.hasPrevious()) {
                    selectExpressions.add((SqlExpression)it2.previous());
                    if (selectExpressions.size() <= 3) continue;
                    includeSelectItems = false;
                    break;
                }
            }
            if (includeSelectItems) {
                for (SqlExpression selectExpression : selectExpressions) {
                    stack.push(selectExpression);
                }
            }
            if (includeSelectItems && selectExpressions.size() > 1 || (fromExpression = fromClause != null ? fromClause.getFromExpression() : null) == null) continue;
            stack.push(fromExpression);
        }
        String string = sb.toString();
        if (string == null) {
            SqlNamesGenerator.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static Case getDefaultCase(@NotNull Case c2) {
        if (c2 == null) {
            SqlNamesGenerator.$$$reportNull$$$0(20);
        }
        Case case_ = c2 == Case.EXACT ? Case.LOWER : c2;
        if (case_ == null) {
            SqlNamesGenerator.$$$reportNull$$$0(21);
        }
        return case_;
    }

    @NotNull
    private static String quoteAliasIdentifierIfNeeded(@NotNull String id, @NotNull NamingService namingService, @NotNull Case idCase, @NotNull Case qidCase, boolean force, @Nullable SqlCodeStyleSettings settings) {
        if (id == null) {
            SqlNamesGenerator.$$$reportNull$$$0(22);
        }
        if (namingService == null) {
            SqlNamesGenerator.$$$reportNull$$$0(23);
        }
        if (idCase == null) {
            SqlNamesGenerator.$$$reportNull$$$0(24);
        }
        if (qidCase == null) {
            SqlNamesGenerator.$$$reportNull$$$0(25);
        }
        if (!namingService.isQuoted(id)) {
            String quotes = settings == null ? null : settings.getQuotesPriority();
            id = force ? namingService.enquoteName(id, SqlDbElementType.LOCAL_ALIAS, quotes) : namingService.nameToScript(id, SqlDbElementType.LOCAL_ALIAS, true, quotes);
        }
        Case curCase = namingService.isQuoted(id) ? qidCase : idCase;
        String string = curCase.apply(id);
        if (string == null) {
            SqlNamesGenerator.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static Collection<String> collectExistingNamesForContainingStatement(@Nullable PsiElement expression) {
        SqlStatement statement = expression instanceof SqlStatement ? (SqlStatement)expression : (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)expression, SqlStatement.class);
        return SqlNamesGenerator.collectExistingNames((PsiElement)statement, null);
    }

    @NotNull
    public static Collection<String> collectExistingNames(@Nullable PsiElement expression, final @Nullable Condition<? super PsiElement> skip) {
        final Set strings = CollectionFactory.createCaseInsensitiveStringSet();
        if (expression == null) {
            Set set = strings;
            if (set == null) {
                SqlNamesGenerator.$$$reportNull$$$0(27);
            }
            return set;
        }
        expression.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2 instanceof PsiNamedElement) {
                    if (skip == null || !skip.value((Object)element2)) {
                        ContainerUtil.addIfNotNull((Collection)strings, (Object)((PsiNamedElement)element2).getName());
                    }
                    super.visitElement(element2);
                } else if (element2 instanceof SqlNameElement) {
                    if (skip == null || !skip.value((Object)element2)) {
                        ContainerUtil.addIfNotNull((Collection)strings, (Object)((SqlNameElement)element2).getName());
                    }
                } else {
                    super.visitElement(element2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlNamesGenerator$1", "visitElement"));
            }
        });
        Set set = strings;
        if (set == null) {
            SqlNamesGenerator.$$$reportNull$$$0(28);
        }
        return set;
    }

    @NotNull
    private static String trimPrefixIfNeeded(@NotNull String text2) {
        if (text2 == null) {
            SqlNamesGenerator.$$$reportNull$$$0(29);
        }
        if (text2.isEmpty()) {
            String string = text2;
            if (string == null) {
                SqlNamesGenerator.$$$reportNull$$$0(30);
            }
            return string;
        }
        switch (text2.charAt(0)) {
            case '#': 
            case '@': {
                String string = text2.substring(1);
                if (string == null) {
                    SqlNamesGenerator.$$$reportNull$$$0(31);
                }
                return string;
            }
        }
        String string = text2;
        if (string == null) {
            SqlNamesGenerator.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static void appendSuggestions(@NotNull Set<String> result, @NotNull String text2, @NotNull NamesGenerator generator) {
        String[] words;
        if (result == null) {
            SqlNamesGenerator.$$$reportNull$$$0(33);
        }
        if (text2 == null) {
            SqlNamesGenerator.$$$reportNull$$$0(34);
        }
        if (generator == null) {
            SqlNamesGenerator.$$$reportNull$$$0(35);
        }
        if ((words = NameUtil.splitNameIntoWords((String)SqlNamesGenerator.trimPrefixIfNeeded(text2))).length > 0) {
            result.add(generator.generate(words[0].substring(0, 1)));
            if (words.length > 1) {
                StringBuilder abbreviation = new StringBuilder();
                String lastWord = null;
                for (String word : words) {
                    int i2;
                    for (i2 = 1; i2 < word.length() && !Character.isLetter(word.charAt(i2 - 1)) && word.charAt(i2 - 1) != '.'; ++i2) {
                    }
                    abbreviation.append(word, 0, i2);
                    if (!Character.isLetter(word.charAt(0))) continue;
                    lastWord = word;
                }
                result.add(generator.generate(abbreviation.toString()));
                if (lastWord != null && lastWord != words[0]) {
                    result.add(generator.generate(lastWord.substring(0, 1)));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlNamesGenerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idCase";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qidCase";
                break;
            }
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlNamesGenerator";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestAliasName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestAliasAlias";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestUniqueName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestAliasNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getWords";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCase";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "quoteAliasIdentifierIfNeeded";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExistingNames";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "trimPrefixIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestAliasName";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "suggestAliasNames";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getWords";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultCase";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "quoteAliasIdentifierIfNeeded";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "trimPrefixIfNeeded";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "appendSuggestions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NamesGenerator {
        private final Collection<String> myExistingNames;
        private final Set<String> myKeywords;

        NamesGenerator(@NotNull Collection<String> existingNames, @NotNull Set<String> keywords) {
            if (existingNames == null) {
                NamesGenerator.$$$reportNull$$$0(0);
            }
            if (keywords == null) {
                NamesGenerator.$$$reportNull$$$0(1);
            }
            this.myExistingNames = new THashSet(existingNames, (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            this.myKeywords = keywords;
        }

        String generate(@NotNull String name) {
            if (name == null) {
                NamesGenerator.$$$reportNull$$$0(2);
            }
            String generated = UniqueNameGenerator.generateUniqueName((String)name, s2 -> !this.myExistingNames.contains(s2) && !this.myKeywords.contains(s2));
            ContainerUtil.addAllNotNull(this.myExistingNames, (Object[])new String[]{generated});
            return generated;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keywords";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/SqlNamesGenerator$NamesGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

