/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.symbols.DasSymbol;
import com.intellij.lang.Language;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.search.CodeReferenceSearcher;
import com.intellij.model.search.SearchRequest;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.symbols.DasSymbolUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/SqlCodeReferenceSearcher;", "Lcom/intellij/model/search/CodeReferenceSearcher;", "()V", "getReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "target", "Lcom/intellij/model/Symbol;", "scope", "Lcom/intellij/psi/PsiElement;", "element", "offsetInElement", "", "getReferencingLanguage", "Lcom/intellij/lang/Language;", "getSearchRequest", "Lcom/intellij/model/search/SearchRequest;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.sql.impl"})
public final class SqlCodeReferenceSearcher
implements CodeReferenceSearcher {
    @NotNull
    public Language getReferencingLanguage(@NotNull Symbol target) {
        Language language;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof DasSymbol) {
            SqlLanguageDialectEx sqlLanguageDialectEx = DasSymbolUtil.getSqlDialect((DasSymbol)target);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"DasSymbolUtil.getSqlDialect(target)");
            language = (Language)sqlLanguageDialectEx;
        } else {
            SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguage, (String)"SqlLanguage.INSTANCE");
            language = (Language)sqlLanguage;
        }
        return language;
    }

    @Nullable
    public SearchRequest getSearchRequest(@NotNull Project project, @NotNull Symbol target) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Symbol symbol = target;
        if (!(symbol instanceof DasSymbol)) {
            symbol = null;
        }
        DasSymbol dasSymbol = (DasSymbol)symbol;
        if (dasSymbol == null) {
            return null;
        }
        DasSymbol dasSymbol2 = dasSymbol;
        return SearchRequest.of((String)dasSymbol2.getName());
    }

    @NotNull
    public Collection<PsiSymbolReference> getReferences(@NotNull Symbol target, @NotNull PsiElement scope, @NotNull PsiElement element2, int offsetInElement) {
        SqlReferenceExpression refExpression;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2.getParent();
        if (!(psiElement instanceof SqlIdentifier)) {
            psiElement = null;
        }
        SqlIdentifier sqlIdentifier = (SqlIdentifier)psiElement;
        Object object = sqlIdentifier != null ? sqlIdentifier.getParent() : null;
        if (!(object instanceof SqlReferenceExpression)) {
            object = null;
        }
        return (refExpression = (SqlReferenceExpression)object) != null && Intrinsics.areEqual((Object)refExpression.resolveSymbol(), (Object)target) ? (Collection)CollectionsKt.listOf((Object)refExpression.getReference()) : (Collection)CollectionsKt.emptyList();
    }
}

