/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.run.actions.DumpAction;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.view.ui.DumpDataForm;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpDataDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(DumpDataDialog.class);
    private final DumpDataForm myForm;
    private final Project myProject;
    private final DumpSource<?> mySource;
    private CopyToClipboardAction myCopyToClipboardAction;
    private ComponentValidator myDirectoryPathValidator;

    public DumpDataDialog(@NotNull Project project, @NotNull DumpSource<?> source, @Nullable Component parentComponent) {
        if (project == null) {
            DumpDataDialog.$$$reportNull$$$0(0);
        }
        if (source == null) {
            DumpDataDialog.$$$reportNull$$$0(1);
        }
        super(project, parentComponent, true, DialogWrapper.IdeModalityType.IDE);
        this.myProject = project;
        this.mySource = source;
        this.myForm = new DumpDataForm(this, this.myProject, source);
        this.setTitle(DatabaseBundle.message((String)"settings.database.DumpDialog.title", (Object[])new Object[0]));
        this.setOKButtonText(DatabaseBundle.message((String)"settings.database.DumpDialog.DumpToFile", (Object[])new Object[]{DumpAction.getSize(this.mySource)}));
        this.myForm.getExtractorComboBox().addItemListener(e -> this.updateActions());
        this.init();
        this.updateCopyToClipboardButton();
        this.invokeLaterAfterDialogShown(() -> this.myForm.updatePreview());
        this.installValidators();
    }

    private void installValidators() {
        final JTextField outputDirectoryField = this.myForm.getOutputFileOrDirectoryField();
        Supplier<ValidationInfo> validator = () -> {
            String path = this.getDirPath();
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                return new ValidationInfo(DatabaseBundle.message((String)"settings.database.DumpDialog.Errors.DirPathEmpty", (Object[])new Object[0]), (JComponent)outputDirectoryField);
            }
            String message2 = this.myForm.getOutputPathManager().validatePath(path);
            return message2 == null ? null : new ValidationInfo(message2, (JComponent)outputDirectoryField);
        };
        this.myDirectoryPathValidator = new ComponentValidator(this.getDisposable()).withValidator(validator).installOn((JComponent)outputDirectoryField);
        outputDirectoryField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ComponentValidator.getInstance((JComponent)outputDirectoryField).ifPresent(ComponentValidator::revalidate);
                DumpDataDialog.this.updateActions();
            }
        });
        this.addDocumentListener(outputDirectoryField);
    }

    private String getDirPath() {
        return FileUtil.expandUserHome((String)this.myForm.getOutputFileOrDirectoryField().getText().trim());
    }

    private void addDocumentListener(final JTextComponent component) {
        component.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ComponentValidator.getInstance((JComponent)component).ifPresent(ComponentValidator::revalidate);
                DumpDataDialog.this.updateActions();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/DumpDataDialog$2", "textChanged"));
            }
        });
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.myDirectoryPathValidator.revalidate();
        return this.myDirectoryPathValidator.getValidationInfo();
    }

    private void invokeLaterAfterDialogShown(final @NotNull Runnable action2) {
        if (action2 == null) {
            DumpDataDialog.$$$reportNull$$$0(2);
        }
        final Application application = ApplicationManager.getApplication();
        this.getWindow().addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                Window window = e.getWindow();
                application.invokeLater(action2, ModalityState.stateForComponent((Component)window));
                window.removeWindowListener(this);
            }
        });
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray;
        if (DumpAction.getSize(this.mySource) > 1) {
            Action[] actionArray2 = new Action[3];
            actionArray2[0] = this.getOKAction();
            actionArray2[1] = this.getCancelAction();
            actionArray = actionArray2;
            actionArray2[2] = this.getHelpAction();
        } else {
            Action[] actionArray3 = new Action[4];
            actionArray3[0] = this.getOKAction();
            actionArray3[1] = this.getCancelAction();
            actionArray3[2] = this.myCopyToClipboardAction;
            actionArray = actionArray3;
            actionArray3[3] = this.getHelpAction();
        }
        if (actionArray == null) {
            DumpDataDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myCopyToClipboardAction = new CopyToClipboardAction();
    }

    @NotNull
    protected String getHelpId() {
        return "Export_data";
    }

    protected void doOKAction() {
        this.updateActions();
        if (!this.isOKActionEnabled()) {
            return;
        }
        if (!this.checkOverrideFile()) {
            return;
        }
        DataExtractorFactory factory = this.myForm.getFactory();
        if (factory == null) {
            return;
        }
        File file = this.getOutputFileOrDir();
        if (file.exists() && !this.checkFileWritable(file)) {
            super.doOKAction();
            return;
        }
        this.myForm.saveState();
        boolean exists = file.exists();
        if (DumpAction.getSize(this.mySource) == 1 && !file.exists()) {
            try {
                exists = file.createNewFile();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                this.showError(file);
            }
        }
        if (exists) {
            ApplicationManager.getApplication().invokeLater(() -> new DumpAction.ToFile(factory, this.myForm.getExtractorConfig(), file).actionPerformed(this.myProject, this.mySource));
        }
        super.doOKAction();
    }

    private boolean checkFileWritable(@NotNull File file) {
        if (file == null) {
            DumpDataDialog.$$$reportNull$$$0(4);
        }
        if (file.isDirectory()) {
            return true;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (virtualFile == null || !ReadonlyStatusHandler.ensureFilesWritable((Project)this.myProject, (VirtualFile[])new VirtualFile[]{virtualFile})) {
            this.showError(file);
            return false;
        }
        return true;
    }

    private void showError(@NotNull File file) {
        if (file == null) {
            DumpDataDialog.$$$reportNull$$$0(5);
        }
        String message2 = DatabaseBundle.message((String)"settings.database.DumpDialog.CannotWriteFile", (Object[])new Object[]{file.getPath()});
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(message2, MessageType.WARNING).notify(this.myProject);
    }

    @NotNull
    private File getOutputFileOrDir() {
        File file = Paths.get(this.getDirPath(), new String[0]).toFile();
        if (file == null) {
            DumpDataDialog.$$$reportNull$$$0(6);
        }
        return file;
    }

    private boolean checkOverrideFile() {
        if (DumpAction.getSize(this.mySource) > 1) {
            return true;
        }
        File file = this.getOutputFileOrDir();
        return !file.exists() || this.askToOverrideFiles(file.getName());
    }

    private boolean askToOverrideFiles(@NotNull String fileName) {
        int res2;
        if (fileName == null) {
            DumpDataDialog.$$$reportNull$$$0(7);
        }
        return (res2 = Messages.showYesNoDialog((Component)this.getRootPane(), (String)DatabaseBundle.message((String)"settings.database.DumpDialog.ConfirmReplace.message", (Object[])new Object[]{fileName}), (String)DatabaseBundle.message((String)"settings.database.DumpDialog.ConfirmReplace.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) == 0;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        ComboBox<DataExtractorFactory> comboBox = this.myForm.getExtractorComboBox();
        if (comboBox == null) {
            DumpDataDialog.$$$reportNull$$$0(8);
        }
        return comboBox;
    }

    public void doCancelAction() {
        this.myForm.saveState();
        super.doCancelAction();
    }

    private void updateActions() {
        this.updateCopyToClipboardButton();
        this.getOKAction().setEnabled(this.myDirectoryPathValidator.getValidationInfo() == null);
    }

    private void updateCopyToClipboardButton() {
        DataExtractorFactory extractorFactory = (DataExtractorFactory)ObjectUtils.tryCast((Object)this.myForm.getExtractorComboBox().getSelectedItem(), DataExtractorFactory.class);
        this.myCopyToClipboardAction.setEnabled(extractorFactory instanceof DataExtractorFactory.Text);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myForm.myPanel;
        if (jPanel == null) {
            DumpDataDialog.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DumpDataDialog";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DumpDataDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFileOrDir";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterAfterDialogShown";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFileWritable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "askToOverrideFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CopyToClipboardAction
    extends DialogWrapper.DialogWrapperAction {
        CopyToClipboardAction() {
            super((DialogWrapper)DumpDataDialog.this, DatabaseBundle.message((String)"settings.database.DumpDialog.CopyToClipboard", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            DumpDataDialog.this.myForm.saveState();
            DumpDataDialog.this.close(0);
            DataExtractorFactory factory = DumpDataDialog.this.myForm.getFactory();
            if (factory != null) {
                ApplicationManager.getApplication().invokeLater(() -> new DumpAction.ToClipboard(factory, DumpDataDialog.this.myForm.getExtractorConfig()).actionPerformed(DumpDataDialog.this.myProject, DumpDataDialog.this.mySource));
            }
        }
    }
}

