/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.database.view.ui.DbSchemasTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbSchemasSelector {
    protected final TreeEditor myTree;
    protected final JComponent myPanel;

    public DbSchemasSelector(@NotNull Project project) {
        if (project == null) {
            DbSchemasSelector.$$$reportNull$$$0(0);
        }
        this.myTree = this.createTree(project);
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setMinimumSize((Dimension)JBUI.size((int)200, (int)100));
        JComponent northPanel = this.createNorthPanel();
        northPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.myPanel.add((Component)northPanel, "North");
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree.getComponent(), (boolean)true), "Center");
    }

    @NotNull
    protected JComponent createNorthPanel() {
        this.myTree.installSimple();
        JPanel res2 = new JPanel(new BorderLayout());
        ActionToolbar actionsToolbar = ActionManager.getInstance().createActionToolbar("SqlResolveEditor", (ActionGroup)this.getTreeActions(), true);
        actionsToolbar.setTargetComponent((JComponent)this.getTree());
        actionsToolbar.setReservePlaceAutoPopupIcon(false);
        res2.add((Component)actionsToolbar.getComponent(), "East");
        JPanel jPanel = res2;
        if (jPanel == null) {
            DbSchemasSelector.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    protected void handleIntrospectionError(@NlsContexts.NotificationContent @Nullable String msg) {
        Component component = ((BorderLayout)this.myPanel.getLayout()).getLayoutComponent("South");
        if (component != null) {
            this.myPanel.remove(component);
        }
        if (msg != null) {
            ErrorNotificationPanel panel2 = ErrorNotificationPanel.create(msg, null, this.myPanel).addDetailsButton().addCloseButton(() -> this.handleIntrospectionError(null)).build();
            this.myPanel.add((Component)panel2, "South");
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    public boolean hasSpeedSearchActive() {
        return SpeedSearchSupply.getSupply((JComponent)this.getTree()) != null;
    }

    protected DbSchemasTree.MyNode getRoot() {
        return (DbSchemasTree.MyNode)this.myTree.getSearchModel().getRootObject();
    }

    @NotNull
    public Tree getTree() {
        DbSchemasTree dbSchemasTree = this.myTree.getTree();
        if (dbSchemasTree == null) {
            DbSchemasSelector.$$$reportNull$$$0(2);
        }
        return dbSchemasTree;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            DbSchemasSelector.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    protected DefaultActionGroup getTreeActions() {
        return new DefaultActionGroup(new AnAction[]{new RefreshAction(this.myTree), new ExpandAllAction((JTree)this.getTree()), new CollapseAllAction((JTree)this.getTree())});
    }

    @NotNull
    protected abstract TreeEditor createTree(@NotNull Project var1);

    public static boolean isSingleRoot(@NotNull DasDataSource dataSource2) {
        Dbms dbms;
        if (dataSource2 == null) {
            DbSchemasSelector.$$$reportNull$$$0(4);
        }
        return (dbms = dataSource2.getDbms()).isH2() || dbms.isHsqldb();
    }

    @Nullable
    public static String getNodeName(DbSchemasTree.MyNode n) {
        if (n.getObject() == "*") {
            return "*";
        }
        if (n.getObject() instanceof DasDataSource) {
            return ((DasDataSource)n.getObject()).getUniqueId();
        }
        return n.getName();
    }

    public static Map<String, DbSchemasTree.MyNode> fillNodesCache(Iterable<DbSchemasTree.MyNode> children2) {
        HashMap<String, DbSchemasTree.MyNode> oldCache = new HashMap<String, DbSchemasTree.MyNode>();
        for (DbSchemasTree.MyNode node : children2) {
            if (node.getObject() == "*") continue;
            oldCache.put(DbSchemasSelector.getNodeName(node), node);
        }
        return oldCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbSchemasSelector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbSchemasSelector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNorthPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSingleRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RefreshAction
    extends DumbAwareAction {
        private final TreeEditor myTreeEditor;

        public RefreshAction(TreeEditor treeEditor) {
            super(DatabaseBundle.messagePointer((String)"action.DbSchemasSelector.refresh.text", (Object[])new Object[0]), DatabaseBundle.messagePointer((String)"action.DbSchemasSelector.refresh.description", (Object[])new Object[0]), AllIcons.Actions.Refresh);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{ActionManager.getInstance().getKeyboardShortcut("Synchronize")}), (JComponent)((Object)treeEditor.getTree()));
            this.myTreeEditor = treeEditor;
        }

        public void update(@NotNull AnActionEvent e) {
            List dataSources2;
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(0);
            }
            boolean enabled = !(dataSources2 = JBIterable.of((Object[])((CheckedTreeNode[])this.myTreeEditor.getTree().getSelectedNodes(CheckedTreeNode.class, null))).transform(n -> RefreshAction.getDatabaseSystem((DbSchemasTree.MyNode)this.myTreeEditor.getUserObject((TreeNode)n))).filter(LocalDataSource.class).unique().toList()).isEmpty() && this.myTreeEditor.canReintrospect(dataSources2);
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription(DatabaseBundle.message((String)"action.DbSchemasSelector.refresh.schemas.list.description", (Object[])new Object[]{enabled ? 0 : 1}));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(1);
            }
            MultiMap objects2 = MultiMap.createLinked();
            JBIterable nodes = JBIterable.of((Object[])((CheckedTreeNode[])this.myTreeEditor.getTree().getSelectedNodes(CheckedTreeNode.class, null))).transform(arg_0 -> ((TreeEditor)this.myTreeEditor).getUserObject(arg_0)).filter(Conditions.notNull());
            for (DbSchemasTree.MyNode node : nodes) {
                LocalDataSource ds = (LocalDataSource)ObjectUtils.tryCast((Object)RefreshAction.getDatabaseSystem(node), LocalDataSource.class);
                if (ds == null) continue;
                ContainerUtil.addIfNotNull((Collection)objects2.getModifiable((Object)ds), (Object)((BasicNamespace)ObjectUtils.tryCast((Object)node.getObject(), BasicNamespace.class)));
            }
            this.myTreeEditor.reintrospect((MultiMap<LocalDataSource, BasicNamespace>)objects2);
        }

        @Nullable
        private static DasDataSource getDatabaseSystem(@Nullable DbSchemasTree.MyNode n) {
            return n == null ? null : (DasDataSource)JBIterable.generate((Object)n, DbCheckBoxTree.MyNode::getParent).transform(DbCheckBoxTree.MyNode::getObject).filter(DasDataSource.class).first();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/view/ui/DbSchemasSelector$RefreshAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public abstract class TreeEditor
    extends FilteringTree<CheckedTreeNode, DbSchemasTree.MyNode> {
        public TreeEditor(@NotNull Project project, @NotNull Tree tree, CheckedTreeNode root2) {
            if (project == null) {
                TreeEditor.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                TreeEditor.$$$reportNull$$$0(1);
            }
            if (root2 == null) {
                TreeEditor.$$$reportNull$$$0(2);
            }
            super(project, tree, (DefaultMutableTreeNode)root2);
        }

        protected Class<? extends CheckedTreeNode> getNodeClass() {
            return CheckedTreeNode.class;
        }

        @NotNull
        protected CheckedTreeNode createNode(@Nullable DbSchemasTree.MyNode obj) {
            CheckedTreeNode checkedTreeNode = DbSchemasTree.createNode(obj);
            if (checkedTreeNode == null) {
                TreeEditor.$$$reportNull$$$0(3);
            }
            return checkedTreeNode;
        }

        @NotNull
        protected Iterable<DbSchemasTree.MyNode> getChildren(@NotNull DbSchemasTree.MyNode obj) {
            if (obj == null) {
                TreeEditor.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = obj.getChildNodes();
            if (jBIterable == null) {
                TreeEditor.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @Nullable
        protected String getText(@Nullable DbSchemasTree.MyNode object) {
            return object == null ? null : object.getName();
        }

        @NotNull
        public DbSchemasTree getTree() {
            DbSchemasTree dbSchemasTree = (DbSchemasTree)super.getTree();
            if (dbSchemasTree == null) {
                TreeEditor.$$$reportNull$$$0(6);
            }
            return dbSchemasTree;
        }

        protected void rebuildTree() {
            DbSchemasTree.MyNode root2 = (DbSchemasTree.MyNode)this.getSearchModel().getRootObject();
            root2.setHasAll(this.hasAll(null));
            Map<String, DbSchemasTree.MyNode> cache = DbSchemasSelector.fillNodesCache(root2.getChildNodes());
            ArrayList<DbSchemasTree.MyNode> dataSources2 = new ArrayList<DbSchemasTree.MyNode>();
            List sorted = ContainerUtil.sorted(this.getDataSources(), (a, b2) -> StringUtil.naturalCompare((String)a.getName(), (String)b2.getName()));
            for (DasDataSource ds : sorted) {
                BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)ds.getModel(), BasicModel.class);
                DbSchemasTree.MyNode node = cache.remove(ds.getUniqueId());
                if (node == null || node.getObject() != ds) {
                    DbSchemasTree.MyNode newNode = new DbSchemasTree.MyNode(ds.getName(), (model == null ? DbImplUtil.getMetaModel((Dbms)Dbms.UNKNOWN) : model.getMetaModel()).root, ds);
                    if (node != null) {
                        newNode.setChecked(node.isChecked());
                        List children2 = node.getChildren();
                        node.setChildren(null);
                        newNode.setChildren(children2);
                        List shadows = node.getShadowChildren();
                        node.setShadowChildren(null);
                        newNode.setShadowChildren(shadows);
                    }
                    node = newNode;
                }
                dataSources2.add(node);
                this.addNodes(node, (Iterable<BasicNamespace>)(model == null ? JBIterable.empty() : this.sorted(model.getRoot().getNamespaces())), this.hasAll(ds));
            }
            root2.setChildren(dataSources2);
            root2.setShadowChildren(cache.values());
            cache.values().forEach(DbCheckBoxTree.MyNode::makeShadow);
            this.createShadowStructure(root2);
            this.getSearchModel().updateStructure();
        }

        protected boolean hasAll(@Nullable Object obj) {
            return false;
        }

        @NotNull
        protected ObjectKind getDsKind() {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                TreeEditor.$$$reportNull$$$0(7);
            }
            return objectKind;
        }

        @NotNull
        protected Iterable<? extends DasDataSource> getDataSources() {
            JBIterable jBIterable = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)this.getProject()).getDataSources()).transform(DbDataSource::getDelegate);
            if (jBIterable == null) {
                TreeEditor.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }

        private void addNodes(@NotNull DbSchemasTree.MyNode p2, @NotNull Iterable<BasicNamespace> objects2, boolean hasAll) {
            if (p2 == null) {
                TreeEditor.$$$reportNull$$$0(9);
            }
            if (objects2 == null) {
                TreeEditor.$$$reportNull$$$0(10);
            }
            Map<String, DbSchemasTree.MyNode> oldCache = DbSchemasSelector.fillNodesCache(p2.getChildNodes());
            ArrayList<DbSchemasTree.MyNode> children2 = new ArrayList<DbSchemasTree.MyNode>();
            for (BasicNamespace object : objects2) {
                DbSchemasTree.MyNode node = oldCache.remove(object.getName());
                if (node != null) {
                    node.setObject(object);
                } else {
                    node = new DbSchemasTree.MyNode(object.getName(), object.getMetaObject(), object);
                }
                children2.add(node);
                if (!this.shouldExpand(object)) continue;
                this.addNodes(node, this.sorted((Iterable<? extends BasicNamespace>)object.getChildren().filter(BasicNamespace.class)), this.hasAll(object));
            }
            oldCache.values().forEach(o -> o.setObject(o.getName()));
            p2.setHasAll(hasAll);
            p2.setChildren(children2);
            p2.setShadowChildren(oldCache.values());
        }

        protected boolean shouldExpand(BasicNamespace object) {
            ObjectKind kind = object.getKind();
            return kind == this.getDsKind() || kind == ObjectKind.DATABASE;
        }

        private Iterable<BasicNamespace> sorted(Iterable<? extends BasicNamespace> children2) {
            ArrayList namespaces = ContainerUtil.newArrayList(children2);
            namespaces.sort(DasObject.NATURAL_COMPARATOR);
            return namespaces;
        }

        protected abstract void createShadowStructure(@NotNull DbSchemasTree.MyNode var1);

        public boolean canReintrospect(@NotNull List<LocalDataSource> dataSources2) {
            if (dataSources2 == null) {
                TreeEditor.$$$reportNull$$$0(11);
            }
            for (LocalDataSource dataSource2 : dataSources2) {
                if (!this.canReintrospect(dataSource2)) continue;
                return true;
            }
            return false;
        }

        public boolean canReintrospect(@NotNull LocalDataSource dataSource2) {
            if (dataSource2 == null) {
                TreeEditor.$$$reportNull$$$0(12);
            }
            return DbImplUtil.canConnectTo(dataSource2) && DataSourceSyncManager.getInstance().isAbleToPerform(dataSource2);
        }

        public void reintrospect(@NotNull MultiMap<LocalDataSource, BasicNamespace> objects2) {
            if (objects2 == null) {
                TreeEditor.$$$reportNull$$$0(13);
            }
            while (objects2.size() != 0) {
                AsyncTask<DataSourceSyncManager.SyncResult> promise;
                LocalDataSource dataSource2 = (LocalDataSource)ContainerUtil.getFirstItem((Collection)objects2.keySet());
                Collection namespaces = objects2.remove((Object)dataSource2);
                if (dataSource2 == null || !this.canReintrospect(dataSource2)) continue;
                LoaderContext context = new LoaderContext(this.getProject(), dataSource2).setNamespacesOnly(true);
                if (namespaces != null) {
                    namespaces.forEach(context::include);
                }
                if ((promise = DataSourceSyncManager.getInstance().tryPerform(context, true, true)) == null) continue;
                promise.whenComplete(AsyncUtil.getEdtExecutor(), (res2, e) -> {
                    AsyncUtil.addUnhandledError(context.getErrorHandler(), e, context.getDataSource());
                    DbSchemasSelector.this.handleIntrospectionError(StringUtil.nullize((String)context.getErrorHandler().getSummary()));
                    if (res2 != null) {
                        this.update();
                    }
                    if (e == null) {
                        this.reintrospect(objects2);
                    }
                });
                break;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DbSchemasSelector$TreeEditor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DbSchemasSelector$TreeEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTree";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDsKind";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addNodes";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "canReintrospect";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "reintrospect";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

