/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.run.ui.DescriptionPopup;
import com.intellij.database.util.ClassInheritorsScanner;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DriverClasspathPanel;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.database.view.ui.StringRowTableModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverGeneralPanel {
    private final DatabaseDriverConfigurable myConfigurable;
    private final DatabaseDriver myTempDriver;
    private JPanel myRoot;
    private JComponent myTemplatesComponent;
    private JPanel myClasspathComponent;
    private JComboBox<String> myClassName;
    private TemplatesTable myTemplatesTable;
    private DriverClasspathPanel myClasspathPanel;
    private final Set<String> myExistingClasses;
    private final ClassInheritorsScanner myScanner;

    public DatabaseDriverGeneralPanel(@NotNull DatabaseDriverConfigurable configurable, @NotNull DatabaseDriver tempDriver) {
        if (configurable == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(0);
        }
        if (tempDriver == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(1);
        }
        this.myExistingClasses = new HashSet<String>();
        this.myConfigurable = configurable;
        this.myTempDriver = tempDriver;
        this.myScanner = new ClassInheritorsScanner(this.myConfigurable.getProject(), Driver.class);
        Disposer.register((Disposable)this.myConfigurable, (Disposable)this.myScanner);
        this.$$$setupUI$$$();
        this.myTemplatesComponent.add((Component)this.createUrlTemplatesPanel(), "Center");
        this.myClasspathComponent.add((Component)this.myClasspathPanel.createComponent(), "Center");
        this.setUrlTemplates((DatabaseDriverImpl)this.myTempDriver);
        this.myRoot.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
    }

    private JComponent createUrlTemplatesPanel() {
        this.myTemplatesTable = new TemplatesTable(new StringRowTableModel(new String[]{DatabaseBundle.message((String)"DatabaseDriverGeneralPanel.column.name.name", (Object[])new Object[0]), DatabaseBundle.message((String)"DatabaseDriverGeneralPanel.column.name.template", (Object[])new Object[0])}, true));
        this.myTemplatesTable.setTableHeader(null);
        this.myTemplatesTable.setVisibleRowCount(4);
        return ToolbarDecorator.createDecorator((JTable)((Object)this.myTemplatesTable)).createPanel();
    }

    private void createUIComponents() {
        this.myClassName = new ComboBox();
        this.myClassName.setEditable(false);
        this.myClassName.setRenderer((ListCellRenderer<String>)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList<? extends String> list, @Nls String value2, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.append(StringUtil.notNullize((String)value2), DatabaseDriverGeneralPanel.this.myExistingClasses.contains(value2) ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/view/ui/DatabaseDriverGeneralPanel$1", "customizeCellRenderer"));
            }
        });
        this.myClasspathPanel = new DriverClasspathPanel(this.myConfigurable.getProject(), this.myConfigurable, this.myTempDriver, null, this.myConfigurable.getController());
        Disposer.register((Disposable)this.myConfigurable, (Disposable)this.myClasspathPanel);
        this.myClasspathPanel.setOnUpdate(() -> {
            Set names = Collections.newSetFromMap(new ConcurrentHashMap());
            this.myScanner.scanClasses(SimpleClasspathElementFactory.convertToFiles(this.myClasspathPanel.getClasspathFull()), (Consumer<String>)((Consumer)names::add)).doWhenProcessed(() -> ApplicationManager.getApplication().invokeLater(() -> {
                String cls = this.myTempDriver.getDriverClass();
                this.myClassName.setModel((ComboBoxModel<String>)this.createModel(names, cls));
            }));
        });
        this.myClassName.setModel((ComboBoxModel<String>)this.createModel(Collections.emptyList(), this.myTempDriver.getDriverClass()));
    }

    public void focusDriverClassSelector() {
        UIUtil.requestFocus(this.myClassName);
    }

    @NotNull
    private CollectionComboBoxModel<String> createModel(@NotNull Collection<String> items2, @Nullable String item) {
        if (items2 == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(2);
        }
        this.myExistingClasses.clear();
        this.myExistingClasses.addAll(items2);
        ArrayList<String> res2 = new ArrayList<String>(items2);
        if (!items2.contains(item)) {
            res2.add(item);
        }
        ContainerUtil.sort(res2);
        return new CollectionComboBoxModel(res2, (Object)item);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRoot;
        if (jPanel == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @NotNull
    public String getDriverClass() {
        String string = String.valueOf(this.myClassName.getSelectedItem());
        if (string == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void reset(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(5);
        }
        this.myClassName.setModel((ComboBoxModel<String>)this.createModel(this.myExistingClasses, driver.getDriverClass()));
        this.setUrlTemplates(driver);
        ((DatabaseDriverImpl)this.myTempDriver).loadState(driver.getState(null), false, false, Integer.MAX_VALUE);
        this.myClasspathPanel.setDriver(driver);
    }

    private void setUrlTemplates(DatabaseDriverImpl driver) {
        ArrayList<String[]> templates = new ArrayList<String[]>();
        for (UrlTemplate t : driver.getUrlTemplates()) {
            templates.add(new String[]{t.getName(), t.getTemplate()});
        }
        this.myTemplatesTable.getModel().setRows(templates);
    }

    public void saveData(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(6);
        }
        driver.setDriverClass(this.getDriverClass());
        driver.setAdditionalClasspathElements(this.myClasspathPanel.getClasspath(false));
        driver.setNativeLibraryPaths(this.myClasspathPanel.getClasspath(true));
        driver.setArtifacts(this.myClasspathPanel.getArtifactRefs());
        ArrayList<UrlTemplate> templates = new ArrayList<UrlTemplate>(this.myTemplatesTable.getModel().getRowCount());
        for (String[] r : this.myTemplatesTable.getModel().getRows()) {
            if (StringUtil.isEmpty((String)r[0])) continue;
            templates.add(new UrlTemplate(r[0], r[1]));
        }
        driver.setURLTemplates(templates);
    }

    public void addNewUrlTemplate(@NotNull String template) {
        if (template == null) {
            DatabaseDriverGeneralPanel.$$$reportNull$$$0(7);
        }
        this.myTemplatesTable.getModel().addNewRow(new String[]{"new", template});
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myTemplatesTable), true));
        IdeFocusManager.findInstanceByComponent((Component)((Object)this.myTemplatesTable)).doWhenFocusSettlesDown(() -> this.myTemplatesTable.editCellAt(this.myTemplatesTable.getModel().getRowCount() - 1, this.myTemplatesTable.getModel().getColumnCount() - 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDriver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabaseDriverGeneralPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseDriverGeneralPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addNewUrlTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRoot = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverGeneralPanel.class).getString("DatabaseDriverGeneralPanel.label.class"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox<String> jComboBox = this.myClassName;
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverGeneralPanel.class).getString("DatabaseDriverGeneralPanel.label.url.templates"));
        jPanel3.add((Component)titledSeparator, "North");
        JPanel jPanel4 = new JPanel();
        this.myTemplatesComponent = jPanel4;
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, "Center");
        this.myClasspathComponent = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    static class MyUserActivityWrapper
    extends TransactionAction.PreferencesUserActivityWrapper {
        private final DescriptionPopup.TxPopup.TxSelector myDelegate;

        MyUserActivityWrapper(@NotNull JComponent component, @NotNull DescriptionPopup.TxPopup.TxSelector selector) {
            if (component == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(0);
            }
            if (selector == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(1);
            }
            super(component);
            this.myDelegate = selector;
        }

        @Override
        @NotNull
        protected DescriptionPopup.TxPopup.TxSelector getSelector() {
            DescriptionPopup.TxPopup.TxSelector txSelector = this.myDelegate;
            if (txSelector == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(2);
            }
            return txSelector;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DatabaseDriverGeneralPanel$MyUserActivityWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DatabaseDriverGeneralPanel$MyUserActivityWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DriverTxModeAction
    extends TransactionAction.PreferencesTxModeAction {
        private final DescriptionPopup.TxPopup.TxSelector mySelector;

        DriverTxModeAction(@NotNull DescriptionPopup.TxPopup.TxSelector selector) {
            if (selector == null) {
                DriverTxModeAction.$$$reportNull$$$0(0);
            }
            this.mySelector = selector;
        }

        @Override
        @NotNull
        public DescriptionPopup.TxPopup.TxSelector getSelector() {
            DescriptionPopup.TxPopup.TxSelector txSelector = this.mySelector;
            if (txSelector == null) {
                DriverTxModeAction.$$$reportNull$$$0(1);
            }
            return txSelector;
        }

        @Override
        @NotNull
        protected TransactionAction.PreferencesUserActivityWrapper createActivityWrapper(@NotNull JComponent component) {
            if (component == null) {
                DriverTxModeAction.$$$reportNull$$$0(2);
            }
            return new MyUserActivityWrapper(component, this.mySelector);
        }

        @Override
        @NotNull
        protected DescriptionPopup.TxPopup createPopup(@NotNull TransactionAction.PreferencesUserActivityWrapper activityWrapper) {
            if (activityWrapper == null) {
                DriverTxModeAction.$$$reportNull$$$0(3);
            }
            return new DescriptionPopup.TxPopup(activityWrapper);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DatabaseDriverGeneralPanel$DriverTxModeAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activityWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DatabaseDriverGeneralPanel$DriverTxModeAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createActivityWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createPopup";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTableCellEditor
    extends AbstractTableCellEditor {
        private final FieldPanel myEditor = new FieldPanel(null, DatabaseBundle.message((String)"DatabaseDriverGeneralPanel.dialog.title.edit.template", (Object[])new Object[0]), null, null);

        private MyTableCellEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column2) {
            this.myEditor.setText(StringUtil.notNullize((String)String.valueOf(value2)));
            this.myEditor.getTextField().setBorder(new LineBorder((Color)JBColor.BLACK));
            this.myEditor.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    myEditor.getTextField().requestFocusInWindow();
                }
            });
            return this.myEditor;
        }

        public Object getCellEditorValue() {
            return this.myEditor.getText();
        }
    }

    private static class TemplatesTable
    extends JBTable {
        TemplatesTable(@NotNull StringRowTableModel model) {
            if (model == null) {
                TemplatesTable.$$$reportNull$$$0(0);
            }
            super((TableModel)model);
            this.setRowHeight(new MyTableCellEditor().getTableCellEditorComponent((JTable)((Object)this), (Object)"", (boolean)true, (int)1, (int)1).getMinimumSize().height + this.getRowMargin());
            this.getColumnModel().getColumn(0).setMinWidth(100);
            this.getColumnModel().getColumn(1).setPreferredWidth(10000);
            this.setAutoResizeMode(3);
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            this.getInputMap(1).put(enter, "stopEditing");
            this.getActionMap().put("stopEditing", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableUtil.stopEditing((JTable)((Object)this));
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && this.rowAtPoint(e.getPoint()) == -1) {
                        TableUtil.stopEditing((JTable)((Object)this));
                        this.getModel().addRow();
                        int index2 = this.getModel().getRowCount() - 1;
                        this.setRowSelectionInterval(index2, index2);
                        this.setColumnSelectionInterval(0, 0);
                        this.editCellAt(index2, 0);
                    }
                }
            });
            this.getEmptyText().setText(DatabaseBundle.message((String)"status.text.no.url.templates", (Object[])new Object[0]));
        }

        @NotNull
        public StringRowTableModel getModel() {
            StringRowTableModel stringRowTableModel = (StringRowTableModel)super.getModel();
            if (stringRowTableModel == null) {
                TemplatesTable.$$$reportNull$$$0(1);
            }
            return stringRowTableModel;
        }

        public TableCellEditor getCellEditor(int row, int column2) {
            return column2 == 0 ? super.getCellEditor(row, column2) : new MyTableCellEditor();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DatabaseDriverGeneralPanel$TemplatesTable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DatabaseDriverGeneralPanel$TemplatesTable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

