/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.view.ui.AdvancedPropertiesPanel;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverGeneralPanel;
import com.intellij.database.view.ui.DatabaseDriverOptionsPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverConfigurable
extends AbstractDatabaseConfigurable<DatabaseDriverImpl> {
    private final DatabaseDriverImpl myDriver;
    private final DatabaseDriverImpl myTempDriver;
    private long myLastSaveStamp;
    private DatabaseNameComponent myNameComponent;
    private DatabaseDriverGeneralPanel myGeneralPanel;
    private DatabaseDriverOptionsPanel myOptionsPanel;
    private AdvancedPropertiesPanel myAdvancedPanel;
    private JBTabbedPane myTabbedPane;

    DatabaseDriverConfigurable(@NotNull Project project, @NotNull DatabaseDriverImpl driver, @NotNull DatabaseConfigEditor editorController) {
        if (project == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(0);
        }
        if (driver == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(1);
        }
        if (editorController == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(2);
        }
        super(project, driver);
        this.setController(editorController);
        this.myDriver = driver;
        this.myTempDriver = driver.copy(null, true);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    @Nls
    public String getDisplayName() {
        return this.myNameComponent == null ? this.myTempDriver.getName() : this.myNameComponent.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.tools.datasource.properties";
    }

    @Nullable
    public JComponent createComponent() {
        JPanel rootPanel = new JPanel(new BorderLayout(0, 5));
        this.myNameComponent = new DatabaseNameComponent(this, this.myController, false);
        this.myTabbedPane = new JBTabbedPane();
        this.myTabbedPane.setTabComponentInsets(null);
        rootPanel.add((Component)this.myNameComponent.getComponent(), "North");
        rootPanel.add((Component)this.myTabbedPane, "Center");
        this.myGeneralPanel = new DatabaseDriverGeneralPanel(this, this.myTempDriver);
        this.myOptionsPanel = new DatabaseDriverOptionsPanel(this);
        this.myAdvancedPanel = new AdvancedPropertiesPanel(this.myProject, this.myDriver.getDriverProperties(), this, this.myController);
        this.myTabbedPane.addTab(DatabaseBundle.message((String)"database.driver.settings.general.tab", (Object[])new Object[0]), (Component)this.myGeneralPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message((String)"database.driver.settings.options.tab", (Object[])new Object[0]), (Component)this.myOptionsPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message((String)"database.driver.settings.advanced.tab", (Object[])new Object[0]), (Component)this.myAdvancedPanel.getComponent());
        DataSourceConfigurable.initTabbedPane(this.myTabbedPane, this.myController);
        return rootPanel;
    }

    @Override
    public void beforeShowNotify() {
        super.beforeShowNotify();
        this.myTabbedPane.setSelectedIndex(DataSourceConfigurable.getDefaultTabIndex(this.myTabbedPane, this.myController));
    }

    @Override
    @NotNull
    public DatabaseDriverImpl getTempTarget() {
        long curStamp = this.myController.getModificationTracker().getModificationCount();
        if (curStamp != this.myLastSaveStamp) {
            this.myLastSaveStamp = curStamp;
            this.saveDriver(this.myTempDriver);
        }
        DatabaseDriverImpl databaseDriverImpl = this.myTempDriver;
        if (databaseDriverImpl == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(3);
        }
        return databaseDriverImpl;
    }

    @NotNull
    public DatabaseDriverImpl getTempDriver() {
        DatabaseDriverImpl databaseDriverImpl = this.getTempTarget();
        if (databaseDriverImpl == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(4);
        }
        return databaseDriverImpl;
    }

    private boolean isNewDriver() {
        return !DatabaseDriverManager.getInstance().getDrivers().contains(this.myDriver);
    }

    public void apply() throws ConfigurationException {
        this.saveDriver(this.myTempDriver);
        this.saveDriver(this.myDriver);
        DatabaseDriverManager.getInstance().updateDriver(this.myDriver);
    }

    private void saveDriver(DatabaseDriverImpl driver) {
        if (this.myNameComponent != null) {
            this.myNameComponent.save(driver);
        }
        if (this.myGeneralPanel != null) {
            this.myGeneralPanel.saveData(driver);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.saveData(driver);
        }
        if (this.myAdvancedPanel != null) {
            this.myAdvancedPanel.saveProperties(driver.getDriverProperties());
            driver.setJrePath(this.myAdvancedPanel.getJrePath());
            driver.setVmOptions(this.myAdvancedPanel.getVmOptions());
            driver.setVmEnv(this.myAdvancedPanel.getVmEnv());
        }
    }

    public void resetFromTemp() {
        ((SettingsEditor)this.myController).bulkUpdate(() -> this.reset(this.myTempDriver));
    }

    @Override
    public void reset(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(5);
        }
        if (this.myNameComponent != null) {
            this.myNameComponent.reset(driver, null);
        }
        if (this.myGeneralPanel != null) {
            this.myGeneralPanel.reset(driver);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.reset(driver);
        }
        if (this.myAdvancedPanel != null) {
            this.myAdvancedPanel.setProperties(driver.getDriverProperties());
            this.myAdvancedPanel.setVmOptions(driver.getVmOptions());
            this.myAdvancedPanel.setVmEnv(driver.getVmEnv());
            this.myAdvancedPanel.setJrePath(driver.getJrePath());
        }
    }

    public boolean isModified() {
        if (this.isNewDriver()) {
            return true;
        }
        return !this.getTempDriver().equalConfiguration(this.myDriver);
    }

    @NotNull
    public DatabaseDriverImpl getDriver() {
        DatabaseDriverImpl databaseDriverImpl = this.myDriver;
        if (databaseDriverImpl == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(6);
        }
        return databaseDriverImpl;
    }

    public void addNewUrlTemplate(@NotNull String template) {
        if (template == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(7);
        }
        if (this.myGeneralPanel != null && this.myTabbedPane != null) {
            this.myTabbedPane.setSelectedComponent((Component)this.myGeneralPanel.getComponent());
            this.myGeneralPanel.addNewUrlTemplate(template);
        }
    }

    public void focusDriverClassSelector() {
        if (this.myGeneralPanel != null) {
            this.myGeneralPanel.focusDriverClassSelector();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorController";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabaseDriverConfigurable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseDriverConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDriver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addNewUrlTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

