/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorConfigurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataSourceManagerDialog
extends SingleConfigurableEditor {
    DataSourceManagerDialog(@NotNull DbPsiFacade facade, @NotNull DatabaseConfigEditorImpl.DataSourceSettings settings) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(1);
        }
        super(facade.getProject(), (Configurable)new MyConfigurable(settings));
        this.setTitle(DatabaseBundle.message((String)"dialog.title.data.sources.drivers", (Object[])new Object[0]));
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(2);
        }
        return dialogStyle;
    }

    @NotNull
    public static List<DbDataSource> showDialog(@NotNull Project project, @Nullable Object selection, @Nullable DatabaseCredentials credentials) {
        if (project == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(3);
        }
        return DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance((Project)project), selection, credentials);
    }

    @NotNull
    public static List<DbDataSource> showDialog(@NotNull DbPsiFacade facade, @Nullable Object selection, @Nullable DatabaseCredentials credentials) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(4);
        }
        return DataSourceManagerDialog.showDialog(facade, selection, credentials, null);
    }

    @NotNull
    public static List<DbDataSource> showDialog(@NotNull DbPsiFacade facade, @Nullable Object selection, @Nullable DatabaseCredentials credentials, @Nullable Consumer<? super DatabaseConfigEditor> setUp) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(5);
        }
        DatabaseConfigEditorImpl.DataSourceSettings settings = new DatabaseConfigEditorImpl.DataSourceSettings(facade, credentials);
        JBIterable selectionIt = selection instanceof Iterable ? JBIterable.from((Iterable)((Iterable)selection)) : JBIterable.of((Object)selection);
        settings.selection = selectionIt.first();
        selectionIt.filter(DatabaseDriver.class).addAllTo(settings.newDrivers);
        selectionIt.filter(DbDataSource.class).filter(o -> !o.isValid()).addAllTo(settings.newDataSources);
        HashSet existing = new HashSet(settings.facade.getDataSources());
        DataSourceManagerDialog dialog2 = new DataSourceManagerDialog(facade, settings);
        if (setUp != null) {
            ApplicationManager.getApplication().invokeLater(() -> setUp.consume((Object)((MyConfigurable)dialog2.getConfigurable()).getEditor()), ModalityState.stateForComponent((Component)dialog2.getContentPanel()), ignored -> dialog2.isDisposed());
        }
        dialog2.show();
        ArrayList<DbDataSource> result = new ArrayList<DbDataSource>();
        if (ModalityState.current() == ModalityState.NON_MODAL) {
            for (DbDataSource element2 : settings.facade.getDataSources()) {
                if (existing.contains(element2)) continue;
                result.add(element2);
                if (!DbImplUtil.canConnectTo((DbElement)element2)) continue;
                DatabaseEditorHelper.openConsoleFile((DbElement)element2);
            }
        }
        DatabaseView.select(facade.getProject(), false, result);
        ArrayList<DbDataSource> arrayList = result;
        if (arrayList == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public static boolean showDialog(@NotNull DbPsiFacade facade, @NotNull DataSourceRegistry registry) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(7);
        }
        if (registry == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(8);
        }
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(facade.getProject());
        DatabaseConfigEditorImpl.DataSourceSettings settings = new DatabaseConfigEditorImpl.DataSourceSettings(facade, registry.getCredentialsStore());
        LocalDataSourceManager manager = LocalDataSourceManager.getInstance(facade.getProject());
        Map importedNames = JBIterable.from(storage.getDataSources()).filter(LocalDataSource.class).filter(LocalDataSource::isImported).toReverseMap(AbstractDataSource::getName);
        for (LocalDataSource o : registry.getDataSources()) {
            LocalDataSource existing = (LocalDataSource)importedNames.get(o.getName());
            if (existing != null) continue;
            DataSourceManagerDialog.addDataSource(o, settings, manager, facade);
        }
        DataSourceManagerDialog dialog2 = new DataSourceManagerDialog(facade, settings);
        DatabaseConfigEditorImpl editor = ((MyConfigurable)dialog2.getConfigurable()).getEditor();
        for (LocalDataSource o : registry.getDataSources()) {
            DataSourceConfigurable configurable;
            LocalDataSource existing = (LocalDataSource)importedNames.get(o.getName());
            if (existing == null || (configurable = editor.getConfigurable(existing, true, DataSourceConfigurable.class)) == null) continue;
            LocalDataSource temp = configurable.getTempDataSource();
            temp.setUrlSmart(o.getUrl());
            configurable.resetFromTemp();
        }
        editor.clearModifiedCache();
        boolean result = dialog2.showAndGet();
        DataSourceConfigUtil.runRegistryCallbacks(facade.getProject(), registry);
        return result;
    }

    private static void addDataSource(@NotNull LocalDataSource dataSource2, @NotNull DatabaseConfigEditorImpl.DataSourceSettings settings, @NotNull LocalDataSourceManager manager, @NotNull DbPsiFacade facade) {
        DatabaseDriver driver0;
        if (dataSource2 == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(10);
        }
        if (manager == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(11);
        }
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(12);
        }
        if ((driver0 = dataSource2.getDatabaseDriver()) == null) {
            String driverClass = dataSource2.getDriverClass();
            if (StringUtil.isEmpty((String)driverClass)) {
                return;
            }
            DatabaseDriver newDriver = null;
            for (DatabaseDriver driver : settings.newDrivers) {
                if (!driverClass.equals(driver.getDriverClass())) continue;
                newDriver = driver;
                break;
            }
            if (newDriver == null) {
                newDriver = DatabaseDriverManager.getInstance().createDriver(driverClass, driverClass, null);
                settings.newDrivers.add(newDriver);
            }
            dataSource2.setDatabaseDriver(newDriver);
        } else {
            JBIterable drivers = JBIterable.from(DatabaseDriverManager.getInstance().getDrivers()).filter(DatabaseDriver.class).append(settings.newDrivers);
            DatabaseDriver existingDriver = (DatabaseDriver)drivers.find(o -> ((DatabaseDriverImpl)o).equalConfiguration((DatabaseDriverImpl)driver0));
            if (existingDriver != null) {
                dataSource2.setDatabaseDriver(existingDriver);
            } else {
                settings.newDrivers.add(driver0);
            }
        }
        DbDataSource element2 = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dataSource2, manager);
        settings.newDataSources.add(element2);
        if (settings.newDataSources.size() == 1) {
            settings.selection = element2;
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.execution.impl.EditConfigurationsDialog";
    }

    protected void doOKAction() {
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DataSourceManagerDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DataSourceManagerDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "showDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyConfigurable
    extends SettingsEditorConfigurable<DatabaseConfigEditorImpl.DataSourceSettings> {
        MyConfigurable(@NotNull DatabaseConfigEditorImpl.DataSourceSettings settings) {
            if (settings == null) {
                MyConfigurable.$$$reportNull$$$0(0);
            }
            super((SettingsEditor)new DatabaseConfigEditorImpl(settings), (Object)settings);
        }

        public String getDisplayName() {
            return DatabaseBundle.message((String)"configurable.DataSourceManagerDialog.MyConfigurable.display.name", (Object[])new Object[0]);
        }

        public String getHelpTopic() {
            String topic = this.getEditor().getHelpTopic();
            if (topic == null) {
                topic = "Connecting_to_a_database";
            }
            return topic;
        }

        @NotNull
        public DatabaseConfigEditorImpl getEditor() {
            DatabaseConfigEditorImpl databaseConfigEditorImpl = (DatabaseConfigEditorImpl)super.getEditor();
            if (databaseConfigEditorImpl == null) {
                MyConfigurable.$$$reportNull$$$0(1);
            }
            return databaseConfigEditorImpl;
        }

        public boolean isModified() {
            return this.getEditor().isAnyEditorModified();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.getEditor().getPreferredFocusedComponent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourceManagerDialog$MyConfigurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourceManagerDialog$MyConfigurable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

